var tabs = mini.get("tabs");
var details = mini.get("details");
var flag = "";
var ruledata = getGrobrule("paymode");
// 改变按钮的状态
var _toolbar = mini.get("config_toolbar");

if (_toolbar) {
    _toolbar.changedStatus("S");
    if (_toolbar["btn_config_editPayData"]) {
        _toolbar["btn_config_editPayData"].on("click", editData);
    }

    if (_toolbar["btn_config_savePayData"]) {
        _toolbar["btn_config_savePayData"].on("click", saveData);
    }

    if (_toolbar["btn_config_addChildData"]) {
        _toolbar["btn_config_addChildData"].on("click", addChildData);
    }

    if (_toolbar["btn_config_addSelfData"]) {
        _toolbar["btn_config_addSelfData"].on("click", addSelfData);
    }

    if (_toolbar["btn_config_delPayData"]) {
        _toolbar["btn_config_delPayData"].on("click", delPayData);
    }
    setStatus(false);
    getTreeData();
}

function editData() {
    var node = tabs.getSelectedNode();// 获取选中的节点
    if (node.pmcode == "0") {
        mini.alert("付款方式节点不允许修正，请重新选择");
        return;
    }
    flag = "U";
    _toolbar.changedStatus("E");
    setStatus(true);
    mini.getbyName("pmcode").setEnabled(false);
}

function saveData() {
    var temp = getForm();

    if(ruledata.rulemode =="0"){//手动编码模式
        if (temp.pmcode == "") {
            mini.alert("请输入编码");
            return;
        }
        if(GetLength(temp.pmcode )> 6) {
            mini.alert("编码长度超过6码，请检查！")
            return ;
        }
    }

    if (temp.pmcname == "") {
        mini.alert("请输入中文名称");
        return;
    }

    if (temp.pmmode == "") {
        mini.alert("请先选择需要付款方式模式");
        return;
    }

    if (temp.pmtype == "") {
        mini.alert("请先选择需要付款方式类别");
        return;
    }

    if (temp.pmstatus == "") {
        mini.alert("请先选择需要状态");
        return;
    }

    if (temp.pmhl == "") {
        mini.alert("请先选择付款汇率");
        return;
    }

    if (temp.paychannel == "") {
        mini.alert("请先选择付款对象");
        return;
    }
    if (isNaN(Number(temp.pmhl))) {
        mini.alert("付款汇率数据不合法，请输入数字！");
        return;
    }
    if (isNaN(Number(temp.pmsupzkfd))) {
        mini.alert("供应商承担比例数据不合法，请输入数字！");
        return;
    }
    if (Number(temp.pmsupzkfd) > 1) {
        mini.alert("供应商承担比例应在0到1之间，请检查！");
        return;
    }
    if (isNaN(Number(temp.sswrjd))) {
        mini.alert("舍入精度数据不合法，请输入数字！");
        return;
    }
    if (!setSelecdNode(temp.pmcode, false)) {
        mini.alert("已经存在节点[" + temp.pmcode + "] ，请重新输入编码");
        return;
    }

    if (!setSelecdNode(temp.pmcname, false)) {
        mini.alert("已经存在节点[" + temp.pmcname + "] ，请重新输入中文名");
        return;
    }
    if (flag != "I") {
        temp.ph_key = mini.getbyName("ph_key").getValue() ? mini
            .getbyName("ph_key").getValue() : "";
    }
    temp.flag = flag;
    itemLoader.doRequest(OmdUrl.mall, "mall.work.pay.save", temp, null, null,
        function (data) {
            if (flag == "U") {
                mini.alert("修改成功!");
            } else if (flag == "I") {
                var node = tabs.getSelectedNode();//获取选中的节点
                if (node.pmcode != "0") {
                    var childDate = isChild(node.pmcode);
                    if (childDate.length > 0) {
                        node.pmflag = "N";
                        node.flag = "U";
                        node.ph_key = node.ph_key;
                        itemLoader.doRequest(OmdUrl.mall, "mall.work.pay.save", node, null, null,
                            function (data) {
                            }, null, null, false);
                    }
                }
                mini.alert("保存成功!");
            }
            temp.ph_key = data[0].ph_key;
            _toolbar.changedStatus("S");
            setStatus(false);
            setBillData(temp);
            flag = "";
            getTreeData();
            setSelecdNode(temp.pmcode, true);
        }, null, null, false);
};

function getForm() {
    var data = {};
    data.pmcode = mini.getbyName("pmcode").getValue() ? mini
        .getbyName("pmcode").getValue() : "";
    data.pmtype = mini.getbyName("pmtype").getValue() ? mini
        .getbyName("pmtype").getValue() : "";
    data.pmcname = mini.getbyName("pmcname").getValue() ? mini.getbyName(
        "pmcname").getValue() : "";
    data.pmstatus = mini.getbyName("pmstatus").getValue() ? mini.getbyName(
        "pmstatus").getValue() : "";
    data.pmpcode = mini.getbyName("pmpcode").getValue() ? mini.getbyName(
        "pmpcode").getValue() : "";
    data.pmclass = mini.getbyName("pmclass").getValue() ? mini.getbyName(
        "pmclass").getValue() : "";
    data.pmmode = mini.getbyName("pmmode").getValue() ? mini
        .getbyName("pmmode").getValue() : "";
    data.pmhl = mini.getbyName("pmhl").getValue() ? mini.getbyName("pmhl")
        .getValue() : "";
    data.pmbacktype = mini.getbyName("pmbacktype").getValue() ? mini.getbyName(
        "pmbacktype").getValue() : "";
    data.rtncode = mini.getbyName("rtncode").getValue() ? mini.getbyName(
        "rtncode").getValue() : "";
    data.setfl = mini.getbyName("setfl").getValue() ? mini.getbyName("setfl")
        .getValue() : "";
    data.itemcode = mini.getbyName("itemcode").getValue() ? mini.getbyName(
        "itemcode").getValue() : "";
    data.pmflag = mini.getbyName("pmflag").getValue() ? mini
        .getbyName("pmflag").getValue() : "";
    data.pmisyy = mini.getbyName("pmisyy").getValue() ? mini
        .getbyName("pmisyy").getValue() : "";
    data.pmiszl = mini.getbyName("pmiszl").getValue() ? mini
        .getbyName("pmiszl").getValue() : "";
    data.pmminje = mini.getbyName("pmminje").getValue() ? mini.getbyName(
        "pmminje").getValue() : "";
    data.pmmaxje = mini.getbyName("pmmaxje").getValue() ? mini.getbyName(
        "pmmaxje").getValue() : "";
    data.sswrfs = mini.getbyName("sswrfs").getValue() ? mini
        .getbyName("sswrfs").getValue() : "";
    data.sswrjd = mini.getbyName("sswrjd").getValue() ? mini
        .getbyName("sswrjd").getValue() : "";
    data.pmlx = mini.getbyName("pmlx").getValue() ? mini
        .getbyName("pmlx").getValue() : "";
    data.pmisjssr = mini.getbyName("pmisjssr").getValue() ? mini
        .getbyName("pmisjssr").getValue() : "";
    data.pmsupzkfd = mini.getbyName("pmsupzkfd").getValue() ? mini
        .getbyName("pmsupzkfd").getValue() : "";
    data.singmaxje = mini.getbyName("singmaxje").getValue() ? mini.getbyName(
        "singmaxje").getValue() : "";
    data.pmxykfl = mini.getbyName("pmxykfl").getValue() ? mini.getbyName("pmxykfl")
        .getValue() : "";
//是否开票
//	data.iskp = mini.getbyName("iskp").getValue() ? mini
//					.getbyName("iskp").getValue() : "";
    data.paychannel = mini.getbyName("paychannel").getValue() ? mini.getbyName("paychannel")
        .getValue() : "";
    return data;
}

function setStatus(flag) {
    var items = details.config.items;
    for (var i = 0; i < items.length; i++) {
        mini.getbyName(items[i].name).setEnabled(flag);
    }
    mini.getbyName("pmcode").setEnabled(false);
    mini.getbyName("pmpcode").setEnabled(false);
    mini.getbyName("pmclass").setEnabled(false);

}

function getTreeData() {

    itemLoader.doRequest(OmdUrl.mall, "mall.work.pay.search", {
        order_field: "pmpcode,pmcode",
        page_no: 1,
        page_size: 9999
    }, null, null, function (data) {
        var source = data.paymode;
        len = source.length;
        for (var i = 0; i < source.length; i++) {
            source[i].codename = "[" + source[i].pmcode + "]"
                + source[i].pmcname;
        }
        source.push({
            pmcode: "0",
            pmcname: "付款方式",
            codename: "付款方式",
            pmflag: "N",
            pmclass: 0,
            pmstatus: "Y",
        });
        tabs.loadList(source, "pmcode", "pmpcode");
        tabs.expandAll();
    }, null, null, false);
}

// 数据回填
tabs.on("nodeclick", function initData(e) {
    var node = tabs.getSelectedNode();// 获取选中的节点
    if (node.pmcode != "0") {
        setBillData(node);
    } else {
        clearfrom();
        setStatus(false);
        _toolbar.changedStatus("S");
    }
});

function setBillData(node) {
    var _details = mini.get("details");
    var _datas = {};
    _details.getResources({
        pmcode: node.pmcode,
        ph_key: node.ph_key,
    });
    _datas = _details.config.data;
    if (_datas && _datas != {}) {
        _toolbar.changedStatus("S");
    }


}


function clearfrom() {
    mini.getbyName("pmcode").setValue("");
    mini.getbyName("pmtype").setValue("");
    mini.getbyName("pmcname").setValue("");
    mini.getbyName("pmstatus").setValue("");
    mini.getbyName("pmpcode").setValue("");
    mini.getbyName("pmclass").setValue("");
    mini.getbyName("pmmode").setValue("");
    mini.getbyName("pmhl").setValue("");
    mini.getbyName("pmbacktype").setValue("");
    mini.getbyName("rtncode").setValue("");
    mini.getbyName("setfl").setValue("");
    mini.getbyName("itemcode").setValue("");
    mini.getbyName("pmflag").setValue("");
    mini.getbyName("pmisyy").setValue("");
    mini.getbyName("pmiszl").setValue("");
    mini.getbyName("pmminje").setValue("");
    mini.getbyName("pmmaxje").setValue("");
    mini.getbyName("sswrfs").setValue("");
    mini.getbyName("sswrjd").setValue("");
    mini.getbyName("pmlx").setValue("");
    mini.getbyName("pmisjssr").setValue("");
    mini.getbyName("pmsupzkfd").setValue("");
    mini.getbyName("singmaxje").setValue("");
    //mini.getbyName("iskp").setValue("");
    mini.getbyName("paychannel").setValue("");
}


function setNode(node) {
    clearfrom();
    var maxclass = parseInt(ruledata.rulemaxcls);
    if (node.temp == "1") {
        mini.getbyName("pmpcode").setValue(node.pmcode);
        var pmclass = Number(node.pmclass) + 1;
        mini.getbyName("pmclass").setValue(pmclass);
        //判断根据字典表判断是否末级
        if (maxclass == pmclass) {
            mini.getbyName("pmflag").setValue("Y");
        } else {
            mini.getbyName("pmflag").setValue("N");
        }

    } else if (node.temp == "2") {
        mini.getbyName("pmpcode").setValue(node.pmpcode);
        mini.getbyName("pmclass").setValue(node.pmclass);
        if (maxclass > node.pmclass) {
            mini.getbyName("pmflag").setValue("N");
        } else {
            mini.getbyName("pmflag").setValue("Y");
        }
    }
    mini.getbyName("ent_id").setValue("0");
    mini.getbyName("pmstatus").setValue("Y");
    mini.getbyName("pmisjssr").setValue("Y");
    mini.getbyName("paychannel").setValue("00");
    flag = "I";
}


function addSelfData() {
    var node = tabs.getSelectedNode();//获取选中的节点
    node.temp = "2";

    //1次级不能增加本级    2级不能增加本级
    if (node.pmcode == 0) {
        mini.alert("付款方式不能直接增加本项，请重新选择!");
        _toolbar.changedStatus("S");
        setStatus(false);
        return;
    }
    setNode(node);
    _toolbar.changedStatus("E");
    setStatus(true);
    if (ruledata.rulemode == "1") {
        mini.getbyName("pmcode").setEnabled(false);
    } else {
        mini.getbyName("pmcode").setEnabled(true);
    }
}

function addChildData() {
    var node = tabs.getSelectedNode();//获取选中的节点
    node.temp = "1";
    //1次级不能增加子级或末级不能增加子级
    if (node.pmflag == "Y") {
        mini.alert("末级不能增加子级，请重新选择!");
        _toolbar.changedStatus("S");
        setStatus(false);
        return;
    }

    setNode(node);

    _toolbar.changedStatus("E");
    setStatus(true);
    if (ruledata.rulemode == "1") {
        mini.getbyName("pmcode").setEnabled(false);
    } else {
        mini.getbyName("pmcode").setEnabled(true);
    }
}


function setSelecdNode(temp, tempfalg) {
    var data = tabs.getList();
    for (var i = 0; i < data.length; i++) {
        if (data[i].pmcode == temp || data[i].pmcname == temp) {
            if (tempfalg) {
                tabs.selectNode(data[i]);
                return;
            } else {
                if (flag == "I") {
                    return false;
                }
            }
        }
    }

    if (!tempfalg) {
        return true;
    }
}

//查询是否有子项
function isChild(pmcode) {
    var searchParam = {
        pmpcode: pmcode,
    };
    var _dicData = {};
    itemLoader.doRequest(OmdUrl.mall, "mall.work.pay.search",
        searchParam, null, null, function (data) {
            _dicData = data.paymode;
        }, null, null, false);
    return _dicData;
}

function delPayData() {
    var _date = getForm();

    if (_date.pmcode == "") {
        mini.alert("请先输入编码");
        return;
    }
    if (_date.pmcode == 0) {
        mini.alert("付款方式不允许删除，请最新选择!");
        return;
    }
    var childDate = isChild(_date.pmcode);
    if (childDate.length > 0) {
        mini.alert("还有子项，不能进行删除操作");
        return;
    }
    _date.flag = "D";
    _date.ph_key = mini.getbyName("ph_key").getValue() ? mini
        .getbyName("ph_key").getValue() : "";

    itemLoader.doRequest(OmdUrl.mall, "mall.work.pay.delete", _date, null, null, function (data) {
        mini.alert("删除成功!");
        clearfrom();
        _toolbar.changedStatus("S");
        flag = "";
        setStatus(false);
        getTreeData();
    }, null, null, false);
}

function onPmcodeChange(e) {
    var value = e.value;
    if (!Number(value)) {
        mini.alert("请输入数字");
        mini.getbyName("pmcode").setValue("");
        return;
    } else if (value.length > 4) {
        mini.alert("只能输入四位数字，请重新输入");
        mini.getbyName("pmcode").setValue("");
        return;
    }
}

function onPmjeChange(e) {
    var pmminje;
    if (e.sender.name == "pmminje") {
        pmminje = Number(e.value);
    } else {
        pmminje = Number(mini.getbyName("pmminje").getValue())
    }

    var pmmaxje;
    if (e.sender.name == "pmmaxje") {
        pmmaxje = Number(e.value);
    } else {
        pmmaxje = Number(mini.getbyName("pmmaxje").getValue())
    }
    if (pmminje > pmmaxje) {
        mini.alert("最小付款金额不能大于最大付款金额");
        if (e.sender.name == "pmminje") {
            mini.getbyName("pmminje").setValue(pmmaxje);
        } else {
            mini.getbyName("pmmaxje").setValue(pmminje);
        }
        return;
    }
}
function GetLength(str) {
    return str.replace(/[\u0391-\uFFE5]/g, "aa").length;  //先把中文替换成两个字节的英文，在计算长度
}
