<%@ page language="java" contentType="text/html; charset=utf-8"
         pageEncoding="utf-8" %>
<!DOCTYPE html />
<html>
<head>
    <title>报表打印配置</title>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div id="Layout_toolbar" class="ocm-systoolbar" config="toolbar"></div>
<div class="mini-fit">
    <div id="layout" class="mini-layout" style="width: 100%; height: 100%;">
        <div region="north" height="0" visible="false">
        </div>
        <div region="center">
            <div class="ocm-gridbox" config="gridbox1"></div>
        </div>
        <div region="south" visible="false">
        </div>
    </div>
</div>
<!-- 引用基类 -->
<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
<script src="/mall-business-ui/pages/common/method.js" type="text/javascript"></script>
<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

</body>

<script type="text/javascript">
    //字典数据初始化
    var dicData = [];
    dicData.moduletype = [{code: "1", name: "报表"}, {code: "2", name: "单据"},];
    dicData.predefined = [{code: "Y", name: "是"}, {code: "N", name: "否"},];
    dicData.modeidnew = getDictMdmBySelectKey("modeidnew", false, 999);

    var toolbar = {
        status: {
            'N': ['editData', 'searchData'],
            'E': ['saveData', 'addListData', 'delListData'],
        },
        items: [[{
            'text': '修改',
            'iconCls': 'icon-edit',
            'name': 'editData',
            "onclick": "editData",
        }, {
            'text': '保存',
            'iconCls': 'icon-save',
            'name': 'saveData',
            "onclick": "saveData",
        }], [{
            'text': '新增',
            'iconCls': 'icon-addnew',
            'name': 'addListData',
            "onclick": "addListRowData",
        }, {
            'text': '删除',
            'iconCls': 'icon-remove',
            'name': 'delListData',
            'onclick': 'delListRowData'
        }], [{
            'text': '查询',
            'iconCls': 'icon-search',
            'name': 'searchData',
            "onclick": "searchData",
        }]]
    };

    var gridbox1 = {
        "type": "gridbox",
        "resources": OmdUrl.mall,
        "method": "mall.work.reportconfig.search",
        "response": "reportconfig",
        "bindSearchParam": ["ph_key"], // 明细页面查询条件字段
        "canquery": true,
        "searchParam": {
            'order_field': "moduletype,predefined,moduleid",
            'order_direction': "asc"
        },
        "properties": {
            "id": "gridbox1",
            "multiSelect": true,
            "allowCellEdit": true,
            "allowCellSelect": true,
            "editNextOnEnterKey": true,
            "editNextRowCell": true,
            "allowSortColumn": false,
            "showColumnsMenu": true,
            "showSummaryRow": true,
            "oncellbeginedit": "OcmControl.checkboxEditor",
            "oncellendedit": 'OcmControl.datetimeFormate',
            "allowRowSelect": true,
            "showPager": false,
            "columns": [{
                field: "ph_key",
                header: "ph_key",
                visible: false,
            }, /* {
					type : "checkcolumn",
					headerAlign : "center",
					readOnly : true,
				}, */ {
                type: "indexcolumn",
                header: "行号",
                headerAlign: "center",
                readOnly: true,
            }, {
                field: "moduletype",
                header: "模块类型",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                data: dicData.moduletype,
                valueField: "code",
                textField: "name",
                width: 40,
                defaultValue: "1",
                readOnly: true,
            }, {
                field: "moduleid",
                name: "moduleid",
                header: "模块号",
                headerAlign: "center",
                allowSort: true,
                width: 110,
            }, {
                field: "predefined",
                displayField: "predefined",
                header: "是否系统缺省",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                data: dicData.predefined,
                valueField: "code",
                textField: "name",
                defaultValue: "N",
                width: 40,
                readOnly: true,
            }, {
                field: "billtype",
                header: "单据类型",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                headerAlign: "center",
                width: 40,
                textField: "billname",
                valueField: "billtype",
                renderer: "OcmControl.dictRendererWithCode",
                data: dicData.modeidnew,
                readOnly: true,
            }, {
                field: "prtfunc",
                header: "打印方法",
                headerAlign: "center",
                editor: OcmControl.newControl('TextBox'),
                width: 80,
            }, {
                field: "reportfile",
                header: "对应报表文件",
                headerAlign: "center",
                editor: OcmControl.newControl('TextBox'),
                width: 250,
            }]
        },
    };
</script>
<script src="reportconfig.js" type="text/javascript"></script>
</body>
</html>