<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<!DOCTYPE html />
<html>
<head>
<title>用户字典管理</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
    <div id="config_toolbar" class="ocm-systoolbar" config="toolbar"></div>
	<div class="mini-fit">
		<div id="layout1" class="mini-layout"
			style="width: 100%; height: 100%;"
			borderStyle="border:solid 1px #aaa;">
			<div title="字典列表" showProxyText="false" region="west" width="400"
				expanded="true" showSplitIcon="false">
				<div class="ocm-gridbox" config="dictypegrid"
					style="padding-top: 5px;"></div>
			</div>
			<div title="字典明细" region="center" showHeader="true"
				showCollapseButton="false">
				<div class="ocm-gridbox" config="dictdetailgrid"
					style="padding-top: 5px;"></div>
			</div>
		</div>
	</div>
</body>

<!-- 引用基类 -->
<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
<script src="/mall-business-ui/pages/common/method.js" type="text/javascript"></script>
<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

<script type="text/javascript">
	// 页面布局配置
	var booleans = [ {
		code : 'Y',
		name : '是'
	}, {
		code : 'N',
		name : '否'
	} ];

	var billmoduleid = getUrlParam("billmoduleid");
	if (billmoduleid == "" || billmoduleid == null) {
		billmoduleid = getUrlParam("modulecode");
	}


	var toolbar = {
		rule : {},
		status : {
			'N' : [ 'editData'],
			'S' : [ 'editData', 'delData' ],
			'E' : [ 'addData', 'saveData', 'delData' ],
		},
		items : [ [ {
			'text' : '修改',
			'iconCls' : 'icon-edit',
			'name' : 'editData',
			"onclick" : "editData",
		}, {
			'text' : '保存',
			'iconCls' : 'icon-save',
			'name' : 'saveData',
			"onclick" : "saveData",
		} ], [ {
			'text' : '新增明细',
			'iconCls' : 'icon-add',
			'name' : 'addData',
			"onclick" : "addData",
			visible : billmoduleid == '100101' ? true : false,
		}, {
			'text' : '删除明细',
			'iconCls' : 'icon-remove',
			'name' : 'delData',
			"onclick" : "delData",
			visible : billmoduleid == '100101' ? true : false,
		} ] ]
	};

	//单据列表
	var dictypegrid = {
		"type" : "gridbox",
		"resources" : OmdUrl.mall,
		"method" : "mall.work.dict.search",
		"response" : "dictype",
		"bindtype" : "list",
		"bindSearchParam" : [ "ph_key" ],
		"searchParam" : {
			"dictype" : billmoduleid == '100101' ? "CUT" : 'SYS',
			//"order_direction" : "desc",
			"order_field" : "code",
			"page_size" : "9999",
		},
		"properties" : {
			"id" : "dictypegrid",
			"allowCellEdit" : true,
			"allowCellSelect" : true,
			"editNextOnEnterKey" : true,
			"editNextRowCell" : true,
			"allowSortColumn" : false,
			"allowCellValid" : true,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"enabled" : false,
			"showPager" : false,
			"columns" : [ {
				type : "indexcolumn",
				headerAlign : "center",
				header : "行号",
				readOnly : true,
			}, {
				field : "code",
				type : "TextBox",
				headerAlign : "center",
				header : "编码",
				readOnly : true,
			}, {
				field : "name",
				type : "TextBox",
				headerAlign : "center",
				header : "名称",
				readOnly : true,
			}, {
				field : "diclen",
				type : "TextBox",
				headerAlign : "center",
				header : "代码长度",
				readOnly : true,
			} ]
		}
	};

	//单据列表
	var dictdetailgrid = {
		"type" : "gridbox",
		"properties" : {
			"id" : "dictdetailgrid",
			"allowCellEdit" : true,
			"allowCellSelect" : true,
			"editNextOnEnterKey" : true,
			"editNextRowCell" : true,
			"allowSortColumn" : false,
			"showReloadButton" : false,
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"enabled" : false,
			"columns" : [ {
				type : "indexcolumn",
				headerAlign : "center",
				header : "行号",
				readOnly : true,
				width : 40,
			}, {
				field : "dcode",
				type : "TextBox",
				headerAlign : "center",
				header : "编码",
				required : billmoduleid == '100101' ? true : false,
				readOnly : billmoduleid == '100107' ? true : false,
				width : 80,
			}, {
				field : "dname",
				type : "TextBox",
				headerAlign : "center",
				header : "中文名称",
				required : true,
				vtype : "required",
				width : 200,
			}, {
				field : "dename",
				type : "TextBox",
				headerAlign : "center",
				header : "英文名称",
				width : 120,
			}, {
				field : "dflag",
				name : "dflag",
				header : "状态",
				type : "comboboxcolumn",
				valueField : "code",
				textField : "name",
				editor : OcmControl.newControl('ComboBox'),
				renderer : "OcmControl.dictRendererWithCode",
				data : booleans,
				required : billmoduleid == '100101' ? true : false,
				readOnly : billmoduleid == '100107' ? true : false,
				width : 80,
			}, {
				field : "dmin",
				type : "TextBox",
				headerAlign : "center",
				header : "最小值",
				vtype : "float",
				width : 80,
			}, {
				field : "dmax",
				type : "TextBox",
				headerAlign : "center",
				header : "最大值",
				vtype : "float",
				width : 80,
			} ]
		}
	};

	//单据列表和单据明细
	var tabs1 = {
		properties : {
			"id" : "tabs1"
		},
		items : [ {
			"title" : "单据列表",
			"name" : "dictypegrid",
			"control" : dictypegrid,
		}, {
			"title" : "单据明细",
			"name" : "dictdetailgrid",
			"control" : dictdetailgrid,
		} ]
	};

	mini.parse();
</script>
<script src="sysdict.js" type="text/javascript"></script>

</html>