var tabs = mini.get("tabs");
var dictypegrid = mini.get("dictypegrid")
var dictdetailgrid = mini.get("dictdetailgrid");

// 改变按钮的状态
var _toolbar = mini.get("config_toolbar");

// 新增
function addData() {
 	var row = dictypegrid.getSelected();
	if(!row) {
		mini.alert("请选择字典分类");
		return;
	}
	var row ={};
	dictdetailgrid.addRow(row);
};

//v2版中修改,字典明细中判重
if (dictdetailgrid) {
	dictdetailgrid.on("cellcommitedit", onCellCommit);
}
function onCellCommit(e){
	var value = e.value;
	var field = e.field;
	var rows = dictdetailgrid.getData();
	if (field == "dcode") {
		for (var i = 0; i < rows.length;i++) {
			if (rows[i].dcode == value) {
				mini.alert("与第"+(i+1)+ "行字典明细编码重复，请检查");
				e.cancel = true;
				return;
			}
		}
	}
	if (field == "dname") {
		for (var i = 0; i < rows.length;i++) {
			if (rows[i].dcode == value) {
				mini.alert("与第"+(i+1)+ "行字典明细中文名称重复，请检查");
				e.cancel = true;
				return;
			}
		}
	}
}

//保存,修改了保存时报主键冲突问题
function saveData() {
	var postData = {};
	postData[dictypegrid.config.response] = [];
	var oldValue = dictdetailgrid.data;
	
	var dictdetails =dictdetailgrid.getChanges();
	
	var dictrow = jQuery.extend(true, {}, dictypegrid.getSelected());

	dictrow["dictdetail"] = [];
	
	for(var i=0;i<dictdetails.length;i++){
		
		
		if(dictdetails[i] != undefined && !dictdetails[i].dcode){
			mini.alert('编码必填!');
			return
		}
		if(dictdetails[i] != undefined && !dictdetails[i].dname){
			mini.alert('中文名称必填!');
			return
		}
		if(dictdetails[i] != undefined && !dictdetails[i].dflag){
			mini.alert('状态必填!');
			return
		}
		if(dictdetails[i] != undefined && !/^[0-9]*$/.test(dictdetails[i].dmin)){
			mini.alert('最小值请输入数字!');
			return
		}
		if(dictdetails[i] != undefined && !/^[0-9]*$/.test(dictdetails[i].dmax)){
			mini.alert('最大值请输入数字!');
			return
		}
		dictrow["dictdetail"].push(dictdetails[i]);
		dictrow["flag"] = "U";
		
	}
	if(dictdetails.length > 0){
		setGridData(dictrow["dictdetail"]);
		postData[dictypegrid.config.response].push(dictrow);
	}

	itemLoader.doRequest(OmdUrl.mall, "mall.work.dict.save", postData, null,
			null, function(data) {
				dictdetailgrid.setEnabled(false);
				mini.alert('保存成功');
				reloaddetail(dictrow["ph_key"]);
			}, null, null, false);
	
//	_toolbar.changedStatus("S");
}

// 修改
function editData() {
	_toolbar.changedStatus("E");
	dictdetailgrid.setEnabled(true);
}

// 删除
function delData() {
	var row = dictdetailgrid.getSelected();
	row["flag"] = "D";
	dictdetailgrid.removeRow(row, false);
}

if (dictypegrid) {
	dictypegrid.on("select", onselect);
};

//选中状态
function onselect(e) {
	if (e.record.ph_key) {
		var shoplevellist = [];
		itemLoader.doRequest(OmdUrl.mall, "mall.work.dict.get", {
			"ph_key" : e.record.ph_key,
		}, null, null, function(data) {
			var dataList = data.dictype.dictdetail;
			dictdetailgrid.set({
				data : dataList,
				totalCount : dataList.length
			});
		}, null, null, false);
	}
	_toolbar.changedStatus("N");
}


//刷新明细列表
function reloaddetail(ph_key) {
	if (ph_key) {
		var shoplevellist = [];
		itemLoader.doRequest(OmdUrl.mall, "mall.work.dict.get", {
			"ph_key" : ph_key,
		}, null, null, function(data) {
			var dataList = data.dictype.dictdetail;
			dictdetailgrid.set({
				data : dataList,
				totalCount : dataList.length
			});
		}, null, null, false);
	}
	_toolbar.changedStatus("N");
}