var tabs = mini.get("tabs");
var details = mini.get("details");
var flag = "";
var formdetail = mini.get("formheader1");
// 改变按钮的状态
var _toolbar = mini.get("config_toolbar");
var ruledata = getGrobrule("taxclass");
if (_toolbar) {
    _toolbar.changedStatus("S");
    if (_toolbar["btn_config_editPayData"]) {
        _toolbar["btn_config_editPayData"].on("click", editData);
    }

    if (_toolbar["btn_config_savePayData"]) {
        _toolbar["btn_config_savePayData"].on("click", saveData);
    }

    if (_toolbar["btn_config_addChildData"]) {
        _toolbar["btn_config_addChildData"].on("click", addChildData);
    }

    if (_toolbar["btn_config_addSelfData"]) {
        _toolbar["btn_config_addSelfData"].on("click", addSelfData);
    }

    if (_toolbar["btn_config_delPayData"]) {
        _toolbar["btn_config_delPayData"].on("click", delPayData);
    }
    setStatus(false);
    getTreeData();
}

//数据回填
tabs.on("nodeclick", function initData(e) {
    var node = tabs.getSelectedNode();// 获取选中的节点
    if (node.taxcode != "0") {
        setBillData(node);
    } else {
        details.form.clear();
        setStatus(false);
        _toolbar.changedStatus("S");
    }
});

function setBillData(node) {
    var _details = mini.get("details");
    var _datas = {};
    _details.getResources({
        mfcode: node.mfcode,
        ph_key: node.ph_key,
    });
    _datas = _details.config.data;
    if (_datas && _datas != {}) {
        _toolbar.changedStatus("S");
    }
}


function getTreeData() {
    var searchParam = {
        "order_field": "taxcode,taxpcode",
        "order_direction": "asc",
        "page_size": 9999
    };
    itemLoader.doRequest(OmdUrl.mall, "mall.work.taxclass.search", searchParam, null, null, function (data) {
        var source = data.taxclass;
        for (var i = 0; i < source.length; i++) {
            source[i].codename = "[" + source[i].taxcode + "]" + source[i].taxname;
        }
        source.push({
            taxcode: "0",
            taxname: "全国",
            codename: "全国",
            taxflag: "N",
            taxlevel: 0,
            taxstatus: "Y",
        });
        tabs.loadList(source, "taxcode", "taxpcode");
        tabs.expandAll();
    }, null, null, false);
}


function editData() {
    var node = tabs.getSelectedNode();// 获取选中的节点
    if (node.taxcode && node.taxcode == "0") {
        mini.alert("全国节点不允许修正，请重新选择");
        return;
    }
    flag = "U";
    _toolbar.changedStatus("E");
    setStatus(true);
    mini.getbyName("taxcode").setEnabled(false);
}


function setStatus(flag) {
    var items = details.config.items;
    for (var i = 0; i < items.length; i++) {
        mini.getbyName(items[i].name).setEnabled(flag);
    }
    mini.getbyName("taxstatus").setEnabled(false);
    mini.getbyName("taxflag").setEnabled(false);
    mini.getbyName("taxlevel").setEnabled(false);
    mini.getbyName("taxpcode").setEnabled(false);
}

function setNode(node) {
    details.form.clear();
    var taxlevel = Number(node.taxlevel);
    //1-子项  2-本项
    if (node.temp == "1") {
        mini.getbyName("taxpcode").setValue(node.taxcode);
        var taxlevel = taxlevel + 1;
        mini.getbyName("taxlevel").setValue(taxlevel);
        if (ruledata.rulemode == "1") {
            mini.getbyName("taxpcode").setValue(node.taxcode);
        }
    } else if (node.temp == "2") {
        mini.getbyName("taxpcode").setValue(node.taxpcode);
        mini.getbyName("taxlevel").setValue(taxlevel);
        if (ruledata.rulemode == "1") {
            mini.getbyName("taxpcode").setValue(node.taxpcode);
        }
    }
    if (ruledata.rulemaxcls == taxlevel) {
        mini.getbyName("taxflag").setValue("Y");
    } else {
        mini.getbyName("taxflag").setValue("N");
    }
    mini.getbyName("taxstatus").setValue("Y");
    flag = "I";
}


function addSelfData() {
    var node = tabs.getSelectedNode();//获取选中的节点
    node.temp = "2";
    if (node.taxcode == 0) {
        mini.alert("不能直接增加本级，请重新选择!");
        _toolbar.changedStatus("S");
        setStatus(false);
        return;
    }
    setNode(node);
    _toolbar.changedStatus("E");
    setStatus(true);
    if (ruledata.rulemode == "1") {
        mini.getbyName("taxcode").setEnabled(false);
    } else {
        mini.getbyName("taxcode").setEnabled(true);
    }
}

function addChildData() {
    var node = tabs.getSelectedNode();//获取选中的节点
    node.temp = "1";
    //末级不能增加子级
    if (node.taxflag == "Y") {
        mini.alert("末级不能增加子级，请重新选择!");
        _toolbar.changedStatus("S");
        setStatus(false);
        return;
    }
    setNode(node);
    _toolbar.changedStatus("E");
    setStatus(true);
    if (ruledata.rulemode == "1") {
        mini.getbyName("taxcode").setEnabled(false);
    } else {
        mini.getbyName("taxcode").setEnabled(true);
    }
}


function setSelecdNode(temp, tempfalg) {
    var data = tabs.getList();
    for (var i = 0; i < data.length; i++) {
        if (data[i].taxcode == temp || data[i].taxname == temp) {
            if (tempfalg) {
                tabs.selectNode(data[i]);
                return;
            } else {
                if (flag == "I") {
                    return false;
                }
            }
        }
    }
    if (!tempfalg) {
        return true;
    }
}

function setSelecdName(temp, tempfalg) {
    var data = tabs.getList();
    for (var i = 0; i < data.length; i++) {
        if (data[i].taxname == temp.taxname && data[i].taxpcode == temp.taxpcode) {
            if (tempfalg) {
                tabs.selectNode(data[i]);
                return;
            } else {
                if (flag == "I" || flag == "U") {
                    if (data[i].ph_key != temp.ph_key) {
                        return false;
                    }
                }
            }
        }


    }
    if (!tempfalg) {
        return true;
    }
}

function saveData() {
    var form = details.form;
    form.validate();
    if (form.isValid() == false) {
        mini.alert("请输入必填项！");
        return;
    }
    var temp = form.getData();
    var dataList = tabs.getList();
    // if (temp.taxcode == "") {
    //     mini.alert("请输入编码");
    //     return;
    // }
    if (temp.taxname == "") {
        mini.alert("请输入中文名称");
        return;
    }
    if (!setSelecdName(temp, false)) {
        mini.alert("已经存在节点[" + temp.taxname + "] ，请重新输入中文名");
        return;
    }
    if (!setSelecdNode(temp.taxcode, false)) {
        mini.alert("已经存在节点[" + temp.taxcode + "] ，请重新输入编码");
        return;
    }
    if (flag != "I") {
        temp.ph_key = mini.getbyName("ph_key").getValue() ? mini.getbyName("ph_key").getValue() : "";
    }
    temp.flag = flag;
    itemLoader.doRequest(OmdUrl.mall, "mall.work.taxclass.save", temp, null, null,
        function (data) {
            if (flag == "U") {
                mini.alert("修改成功!");
            } else if (flag == "I") {
                var node = tabs.getSelectedNode();//获取选中的节点
                if (node.taxcode != "0") {
                    var childDate = isChild(node.taxcode);
                    if (childDate.length > 0) {
                        node.taxflag = "N";
                        node.flag = "U";
                        node.ph_key = node.ph_key;
                        itemLoader.doRequest(OmdUrl.mall, "mall.work.taxclass.save", node, null, null,
                            function (data) {
                            }, null, null, false);
                    }
                }
                mini.alert("保存成功!");
            }
            temp.ph_key = data[0].ph_key;
            _toolbar.changedStatus("S");
            setStatus(false);
            setBillData(temp);
            flag = "";
            getTreeData();
            setSelecdNode(temp.taxcode, true);
        }, null, null, false);
};

function delPayData() {
    var _date = details.form.getData();
    var childDate = isChild(_date.taxcode);
    if (childDate.length > 0) {
        mini.alert("还有子项，不能进行删除操作");
        return;
    }
    _date.flag = "D";
    _date.ph_key = mini.getbyName("ph_key").getValue() ? mini
        .getbyName("ph_key").getValue() : "";

    itemLoader.doRequest(OmdUrl.mall, "mall.work.taxclass.delete", _date, null, null, function (data) {
        mini.alert("删除成功!");
        details.form.clear();
        _toolbar.changedStatus("S");
        flag = "";
        setStatus(false);
        getTreeData();
    }, null, null, false);
}

//查询是否有子项
function isChild(taxcode) {
    var searchParam = {
        taxpcode: taxcode,
    };
    var _dicData = {};
    itemLoader.doRequest(OmdUrl.mall, "mall.work.taxclass.search",
        searchParam, null, null, function (data) {
            _dicData = data.taxclass;
        }, null, null, false);
    return _dicData;
}

function onTaxmergecode(e) {
    var buttonEdit = e.sender;
    var value = buttonEdit.getValue();
    value = Number(value).toString();
    if ("NaN" == value) {
        mini.alert("请输入数字类型");
        buttonEdit.setValue("");
        return;
    }
    if (buttonEdit.maxLength > value.length) {
        value = value + getZeroByLength(buttonEdit.maxLength - value.length);
        buttonEdit.setValue(value);
    } else {
        value = value.substr(0, 18);
        buttonEdit.setValue(value);
    }
}

function getZeroByLength(length) {
    var zerostr = "";
    for (var i = 0; i < length; i++) {
        zerostr += "0";
    }
    return zerostr;
}