/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('ecmmeter.view');

	// 定义一个对象用来配置界面
	var bill = {};
	var billtype=getBilltype(app.modulecode);
	
	
	// 单据类型34，巡检方案定义，
	var billtypes = {
			dy: '81',
		}
	if(billtype==billtypes.fady){
		$("title").html("能源设备定义");
	}
	
	// 把定义对象放到命名空间下
	ns.bill = bill;

	utils.billtype=billtype;
	// 查询列表
	bill.ecmmeterlist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.work.ecmmeter.search",
		"response": "ecmmeter",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billmoduleid" : app.modulecode,
			"order_field": "muid_name,emno",
			"order_direction": "asc",
		},
		"properties": {
			"id": utils.createid('ecmmeterlist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
				visible:false,
			}, {
				field: "billtype",
				type: "TextBox",
				headerAlign: "center",
				header: "单据类型",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLTYPE',
				visible:false,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
				visible:false,
			}, {
				field: "emno",
				type: "TextBox",
				headerAlign: "center",
				header: "仪表编号",
			}, {
				field: "mname",
				type: "TextBox",
				headerAlign: "center",
				header: "仪表名称",
				width: 160,
			}, {
				field: "muid",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "muid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				enabledSearch : false,
				width: 180,
			}, {
				field: "mttypecode",
				type: "TextBox",
				headerAlign: "center",
				header: "仪表种类",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "mttypecode_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"mttypecode"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "mttypecode_name",
				type: "TextBox",
				headerAlign: "center",
				header: "仪表种类名称",
				enabledSearch : false,
				width: 180,
			}, {
				field : "emcstatus",
				header : "仪表状态",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'EMCSTATUS',
			}, {
				field : "emcmode",
				header : "抄表方式",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'EMCMODE',
			}, {
				field: "spid",
				type: "TextBox",
				headerAlign: "center",
				header: "商铺",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "spid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"spid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "spid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "商铺",
				enabledSearch : false,
				width: 180,
			}, {
				field: "sbid",
				type: "TextBox",
				headerAlign: "center",
				header: "商户",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "sbid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"sbid"},
				visible : false,
				enabledSearch : false,
			}, {
				field: "sbid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "商户",
				visible : false,
				enabledSearch : false,
				width: 180,
			}, {
				field: "mlastvalue",
				type: "NumButtonEdit",
				format:"n2",
				headerAlign: "center",
				header: "当前读数",
			}, {
				field : "mlastdate",
				type : "date",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "当前抄表日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field: "mprice",
				type: "NumButtonEdit",
				format:"n2",
				headerAlign: "center",
				header: "单价",
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 150,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "canceler",
				header : "取消人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "canceler_name",
				header : "取消人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "canceldate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "取消日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "bsimemo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				visible:false,
			}]
		}
	};
	
	// 单据主表
	bill.ecmmeter = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'ecmmeter',
		"method": "mss.work.ecmmeter.get",
		"response": "ecmmeter",
		"properties": {
			"id": utils.createid('ecmmeter')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
				"visible": false,
			}, {
				"lable": "billmoduleid",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": app.modulecode,
				"visible": false,
			}/*, col.line*/, {
				"label": "仪表编码：",
				"name": "emno",
				"type": "TextBox",
				"required": "true",
				"visible": true,
				onvaluechanged:"page.head_valuechanged",
			}, {
				"label": "仪表名称：",
				"name": "mname",
				"type": "TextBox",
				"required": "true",
				"visible": true,
				onvaluechanged:"page.head_valuechanged",
			}, {
				"label": "仪表所属：",
				"name": "emcstyle",
				"type": "ComboBox",
				dictkey: 'EMCSTYLE',
				"readOnly": true,
				"defaultValue": "3",
				visible: false
			}, {
				"label": "仪表状态：",
				"name": "emcstatus",
				"type": "ComboBox",
				dictkey: 'EMCSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, {
				"label": "门店：",
				"name": "muid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "muid",
				textName: "muid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_muid",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": "门店：",
				"name": "muid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label": "仪表种类：",
				"name": "mttypecode",
				"type": "fut_popselect",
				selectkey: "mttypecode",
				textName: "mttypecode_name",
				allowInput: true,
				required: true,
				beforefunc : "page.head_beforefunc_mttypecode",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": "商铺：",
				"name": "spid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "spid",
				textName: "spid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_spid",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": "商铺编码：",
				"name": "spid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label": "抄表方式：",
				"name": "emcmode",
				"type": "ComboBox",
				dictkey: 'EMCMODE',
				"required": "true",
			}, {
				"label": "量程：",
				"name": "mrange",
				"type": "NumButtonEdit",
				"required": "true",
				"defaultValue" : "0",
				"format":"n0",
			}, {
				"label": "倍率：",
				"name": "mrate",
				"type": "NumButtonEdit",
				"required": "true",
				"defaultValue" : "1",
				"format":"n2",
				onvaluechanged:"page.head_valuechanged",
			}, {
				"label": "初始读数：",
				"name": "minitvalue",
				"type": "NumButtonEdit",
				"required": "true",
				"defaultValue" : "0",
				"format":"n2",
				onvaluechanged:"page.head_valuechanged",
			}, {
				"label": "初始日期：",
				"name": "minitdate",
				"type": "DatePicker",
				"visible": true,
				"required": "true",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				onvaluechanged:"page.head_valuechanged",
				//"style" : "display:block;float:none",
			}, {
				"label": "单价：",
				"name": "mprice",
				"type" : "NumButtonEdit",
				//"required": "true",
				"defaultValue" : "0",
				"format":"c2",
				//"maxValue" : "100000000000",
			}, {
				"label": "商户：",
				"name": "sbid",
				"type": "fut_popselect",
				selectkey: "sbid",
				textName: "sbid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_sbid",
				itemchangedfunc:"page.head_itemchangedfunc",
				visible: false,
			}, {
				"label": "商户名称：",
				"name": "sbid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label": "公共表分摊方式：",
				"name": "msharetype",
				"type": "TextBox",
				"required": "true",
				"visible": true,
				"defaultValue": "0",
				"visible": false,
			}, {
				"label": "当前读数：",
				"name": "mlastvalue",
				"type": "NumButtonEdit",
				"required": "true",
				"defaultValue" : "0",
				"format":"n2",
				"readOnly": true,
			}, {
				"label": "当前抄表日期：",
				"name": "mlastdate",
				"type": "DatePicker",
				"visible": true,
				"required": "true",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"readOnly": true,
				"style" : "display:block;float:none",
			}, {
				"label": "仪表种类名称：",
				"name": "mttypecode_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
			}, {
				"label": "取消人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "取消日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}
		]
	}

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData,btn.cancelData,btn.separator,
			/*{'text': '变更','iconCls': 'icon-reload','name': 'reloadData',
		     billstatus: 'Y',ibediting: 'N',tabindex: '1'
			},btn.separator,*/btn.searchData
		]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.ecmmeter, // 单据主表
		//billdetail: [bill.bchkschemedet], // 单据明细表
		billquerylist: bill.ecmmeterlist, // 查询列表
		//dettabpages: [bill.bchkschemedet], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
