/**
 * 页面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('servicemaintenance.view');
	
	var viewdetail = getUrlParam("viewdetail");
	if (!viewdetail) {
		viewdetail = 'N';
	}
	 
	// 定义一个对象用来配置界面
	var bill = {};
	var billtype = getBilltype(app.modulecode);

	// 把定义对象放到命名空间下
	ns.bill = bill;

	utils.billtype = billtype;
	
	var billstatus = [{code:"P",name:"已派单"},{code:"S",name:"已收款"},{code:"F",name:"已完成"}]
	
	var temp = {"$in" : "P,F,S"};
	
	// 查询列表
	bill.servicemaintenancelist = {
		"type" : "gridbox",
		"resources" : OmdUrl.mall,
		"method" : "mss.work.serviceapphdmodify.search",
		"response" : "serviceapphd",
		"manualLoad" : false,
		"bindform" : "layouttabs",
		"bindSearchParam" : [ "billno" ], // 明细页面查询条件字段
		"searchParam" : {
			"billtype" : billtype,
			"billstatus" : temp,
			"order_field" : "billno",
			"order_direction" : "desc",
		},
		"properties" : {
			"id" : utils.createid('ownerpaymentlist'),
			"columns" : [ {
				type : "indexcolumn",
				headerAlign : "center",
				header : "行号",
				width : 60,
			}, {
				field : "billno",
				type : "TextBox",
				headerAlign : "center",
				header : "服务编号",
				width : 150,
			}, {
				field : "billtype",
				type : "TextBox",
				headerAlign : "center",
				header : "单据类型",
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'BILLTYPE',
				visible : false,
				enabledSearch : false,
				width : 150,
			}, {
				field : "billstatus",
				type : "TextBox",
				headerAlign : "center",
				header : "服务状态",
				renderer : "OcmControl.dictRendererWithCode",
				//dictkey : 'BILLSTATUS',
				data : billstatus,
			}, {
				field : "sahdate",
				type : "date",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				headerAlign : "center",
				header : "申请日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "muid",
				type : "TextBox",
				headerAlign : "center",
				header : "门店",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "muid"
				},
				visible : true,
				enabledSearch : true,
				width : 200,
			}, {
				field : "muid_name",
				type : "TextBox",
				headerAlign : "center",
				header : "门店",
				visible : false,
				enabledSearch : false,
			}, {
				field : "sbid",
				type : "TextBox",
				headerAlign : "center",
				header : "商户",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "sbid_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "sbid"
				},
				visible : true,
				enabledSearch : true,
				width : 200,
			}, {
				field : "sbid_name",
				type : "TextBox",
				headerAlign : "center",
				header : "商户名称",
				visible : false,
				enabledSearch : false,
			}, {
				field : "spid",
				type : "TextBox",
				headerAlign : "center",
				header : "商铺",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "spcode",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "spid"
				},
				visible : true,
				enabledSearch : true,
				width : 200,
			}, {
				field : "spcode",
				type : "TextBox",
				headerAlign : "center",
				header : "商铺名称",
				visible : false,
				enabledSearch : false,
			}, {
				field : "linkman",
				type : "TextBox",
				headerAlign : "center",
				header : "联系人",
				enabledSearch : true,
				width : 100,
			}, {
				field : "linkphone",
				type : "TextBox",
				headerAlign : "center",
				header : "联系电话",
				enabledSearch : true,
				width : 120,
			}, {
				field : "predate",
				type : "date",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				headerAlign : "center",
				header : "预计完成日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "servman",
				type : "TextBox",
				headerAlign : "center",
				header : "维修人",
				enabledSearch : true,
				width : 100,
			}, {
				field : "servdate",
				type : "date",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				headerAlign : "center",
				header : "维修日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "user"
				},
				visible : false,
				enabledSearch : true,
			}, {
				field : "inputer_name",
				header : "录入人",
				width : 200,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "shr",
				header : "维修审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "shr_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "user"
				},
				visible : false,
				enabledSearch : true,
			}, {
				field : "shr_name",
				header : "维修审核人",
				width : 200,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "shdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "维修审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "memo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				visible : false,
			} ]
		}
	};
    
	 if (viewdetail == "Y") {
		 bill.servicemaintenancelist.visible=false;
		 bill.servicemaintenancelist.manualLoad=true;
	 }
	// 单据主表
	bill.serviceapphd = {
		"type" : "formgrid",
		"initHeight" : 0.5,
		"resources" : OmdUrl.mall,
		"name" : 'serviceapphd',
		"method" : "mss.work.serviceapphdmodify.get",
		"response" : "serviceapphd",
		"properties" : {
			"id" : utils.createid('serviceapphd')
		},
		items : [ {
			"label" : "ph_key：",
			"name" : "ph_key",
			"type" : "TextBox",
			"visible" : false,
		}, {
			"label" : "服务编号：",
			"name" : "billno",
			"type" : "TextBox",
			"readOnly" : true,
			"visible" : true,
			"style" : "width:22.5%"
		}, {
			"lable" : "billmoduleid",
			"name" : "billmoduleid",
			"type" : "TextBox",
			"defaultValue" : app.modulecode,
			"visible" : false,
		}, {
			"label" : "服务状态：",
			"name" : "billstatus",
			"type" : "ComboBox",
			data : billstatus,
			"readOnly" : true,
			"style" : "width:22.5%"
		}, {
			"label" : "单据状态：",
			"name" : "billflag",
			"type" : "ComboBox",
			"readOnly" : true,
			"defaultValue" : "N",
			"visible" : false,
		}, {
			"label" : "申请日期：",
			"type" : "DatePicker",
			"name" : "sahdate",
			"format" : "yyyy-MM-dd",
			"readOnly" : "true",
			"style" : "width:22.5%"
		}, {
			"label" : "紧急程度：",
			"name" : "sahemelev",
			"type" : "ComboBox",
			dictkey : 'SAHEMELEV',
			"readOnly" : true,
			"style" : "width:22.5%"
		}, {
			"label" : "服务代码：",
			"name" : "sccode",
			"type" : "fut_popselect",
			selectkey : "servicecode",
			textName : "scid_name",
			allowInput : true,
			readOnly : true,
			"style" : "width:22.5%"
		}, {
			"label" : "服务名称：",
			"name" : "scid_name",
			"type" : "TextBox",
			readOnly : true,
			visible : false
		}, {
			"label" : "申请内容：",
			"name" : "sahcontent",
			"type" : "TextBox",
			readOnly : true,
			"visible" : true,
			"style" : "width:45%"
		}, {
			"label" : "服务金额：",
			"name" : "scje",
			"type" : "NumButtonEdit",
			"defaultValue" : "0",
			"format" : "c2",
			readOnly: true,
			"visible" : true,
			"style" : "width:22.5%"
		}, {
			"label" : "描述：",
			"name" : "sahmemo",
			"type" : "TextArea",
			readOnly : true,
			"visible" : true,
			"style" : "width:90%"
		}, {
			"label" : "门店：",
			"name" : "muid",
			"type" : "fut_popselect",
			selectkey : "muid",
			textName : "muid_name",
			allowInput : true,
			readOnly : true,
			"style" : "width:22.5%"
		}, {
			"label" : "门店：",
			"name" : "muid_name",
			"type" : "TextBox",
			readOnly : true,
			visible : false
		}, {
			"label" : "商铺：",
			"name" : "spid",
			"type" : "fut_popselect",
			selectkey : "spid",
			textName : "spcode",
			allowInput : true,
			readOnly : true,
			"style" : "width:22.5%"
		}, {
			"label" : "商铺名称：",
			"name" : "spcode",
			"type" : "TextBox",
			readOnly : true,
			visible : false
		}, {
			"label" : "商户：",
			"name" : "sbid",
			"type" : "fut_popselect",
			selectkey : "sbid",
			textName : "sbid_name",
			allowInput : true,
			readOnly : true,
			"style" : "width:22.5%"
		}, {
			"label" : "商户名称：",
			"name" : "sbid_name",
			"type" : "TextBox",
			readOnly : true,
			visible : false
		}, {
			"label" : "合同：",
			"name" : "contno",
			"type" : "TextBox",
			allowInput : true,
			readOnly : true,
			"style" : "width:22.5%"
		}, {
			"label" : "联系人：",
			"name" : "linkman",
			"type" : "TextBox",
			readOnly: true,
			"visible" : true,
			"style" : "width:22.5%"
		}, {
			"label" : "联系电话：",
			"name" : "linkphone",
			"type" : "TextBox",
			readOnly: true,
			"visible" : true,
			"style" : "width:22.5%"
		}, {
			"label" : "预计完成日期：",
			"type" : "DatePicker",
			"name" : "predate",
			"format" : "yyyy-MM-dd",
			"readOnly" : "true",
			"style" : "width:22.5%; display:block;float:none"
		}, {
			"label" : "维修人：",
			"name" : "servman",
			"type" : "TextBox",
			readOnly: true,
			"visible" : true,
			"style" : "width:22.5%"
		}, {
			"label" : "维修日期：",
			"type" : "DatePicker",
			"name" : "servdate",
			"format" : "yyyy-MM-dd",
			"readOnly" : "true",
			"style" : "width:22.5%"
		}, {
			"label" : "服务实收金额：",
			"name" : "scshje",
			"type" : "NumButtonEdit",
			"defaultValue" : "0",
			"format" : "c2",
			"required" : "true",
			readOnly: false,
			"visible" : true,
			"style" : "width:22.5%; display:block;float:none"
		}, {
			"label" : "维修内容：",
			"name" : "servcontent",
			"type" : "TextBox",
			"required" : "true",
			readOnly : false,
			"visible" : true,
			"style" : "width:67.5%"
		}, {
			"label" : "维修评价：",
			"name" : "servpj",
			"type" : "TextBox",
			"required" : "true",
			readOnly : false,
			"visible" : true,
			"style" : "width:22.5%"
		}, {
			"label" : "录入人：",
			"type" : "TextBox",
			"name" : "inputer_name",
			"readOnly" : "true",
			"style" : "width:22.5%"
		}, {
			"label" : "录入日期：",
			"type" : "DatePicker",
			"name" : "inputdate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
			"style" : "width:22.5%"
		}, {
			"label" : "维修审核人：",
			"type" : "TextBox",
			"name" : "shr_name",
			"readOnly" : "true",
			"style" : "width:22.5%"
		}, {
			"label" : "维修审核日期：",
			"type" : "DatePicker",
			"name" : "shdate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
			"style" : "width:22.5%"
		} ]
	}
	// 单据明细
	bill.serviceappdet = {
		title : '单据明细',
		"type" : "gridbox",
		name : 'serviceappdet',
		"properties" : {
			"id" : utils.createid('serviceappdet'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"sortMode" : "client",
			//"showPager" : true,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				name : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
			}, {
				type : "indexcolumn",
				name : "indexcolumn",
				header : "行号",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				field : "mbid",
				name : "mbid",
				header : "物料编码/名称",
				headerAlign : "center",
				allowSort : true,
				required: true,
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "mbid_name",
				width : "160",
				editorSet : {
					selectkey : 'mbid',
					beforefunc:"page.det_beforefunc",
                    itemchangedfunc:"page.det_itemchangedfunc",
				},
				readOnly : false,
			}, {
				field : "mbid_name",
				name : "mbid_name",
				header : "物料名称",
				headerAlign : "center",
				width : "150",
				visible : false
			}, {
				field : "mbsl",
				name : "mbsl",
				header : "数量",
				headerAlign : "center",
				allowSort : true,
				readOnly : false,
				width : 80,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "n2",
				},
				numberFormat : "n2",
				defaultValue : "1",
				align : "right",
			}, {
				field : "mbje",
				name : "mbje",
				header : "单价",
				headerAlign : "center",
				width : 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				readOnly : true
			}, {
				field : "rgf",
				name : "rgf",
				header : "人工费",
				headerAlign : "center",
				width : 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				readOnly : false
			}, {
				field : "totje",
				name : "totje",
				header : "合计",
				headerAlign : "center",
				width : 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				readOnly : true
			}, {
				field : "memo",
				name : "memo",
				header : "备注",
				headerAlign : "center",
				allowSort : true,
				readOnly : false,
				width : "180",
			} ]
		},
	};

	var btn = Future.default.btn;
	var items = [$.extend({},btn.editData,{billstatus: 'P'}), btn.saveData,
					btn.separator, $.extend({},btn.auditData,{billstatus: 'P'}), btn.separator];
	var item = [$.extend({},btn.delData,{billstatus: 'P'}),btn.searchData, btn.separator,
	            {'text': '收款','iconCls': 'icon-download','name': 'payData',billstatus: 'F',
			  ibediting: 'N',tabindex: '1'}];
	if (viewdetail == 'N') {
		for (var i = 0; i < item.length; i++) {
			items.push(item[i]);
		}
	}
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id : utils.createid('systoolbar'),
		items : items,
		nextpre : viewdetail == 'N'?'Y':'N',
	}
	
	// 单据配置
	bill.billconfig = {
		billhead : bill.serviceapphd, // 单据主表
		billdetail : [ bill.serviceappdet ], // 单据明细表
		billquerylist : bill.servicemaintenancelist, // 查询列表
		dettabpages : [ bill.serviceappdet ], // 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
