<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>盘点日设置管理</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-layout" config="config1" borderStyle="border:0px;"
		style="width: 100%; height: 100%;"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>
	<script type="text/javascript">
		var billmoduleid = getUrlParam("billmoduleid");
		if (billmoduleid == "" || billmoduleid == null) {
			billmoduleid = getUrlParam("modulecode");
		}
		// 字典数据初始化
		var dicData = OcmControl.getDict(
				"BILLSTATUS,billtype,billmoduleid,BILLSOURCE,STOCKMD",
				"code,name,ddvalue")
				|| {};
		dicData.BCTFINISHED = [{code : 'N', name : '未完成'},{code : 'Y', name : '已完成'}];
		dicData.BCTTYPE = [{code: "1",name: "大盘"},{code: "2",name: "小盘"}];
		dicData.BCTISCLR0 = [{code: 'N', name : '未盘商品库存保留'},{code: 'Y',name: '未盘商品库存清零'}];
		dicData.CHKSTOCKED = [{code: '0', name: '未生成帐存'}, {code: '1', name: '手工生成帐存'}, {code: '2',name: '日终自动生成帐存'}];
		dicData.CMFSTATUS = [{"code": "N","name": "未审核"},{"code": "P","name": "预审核"},{"code": "Y","name": "已审核"}];
		// 页面布局配置
		var toolbar1 = {
				rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消 ,S:提交
					'billstatus' : {
						'Y' : [ 'addData', 'searchData','printData','createData', 'finshData','cancelData','upTemplate','downTemplate','printDeductibleData'],
						'N' : [ 'addData', 'editData', 'auditData' , 'delData','copyData', 'searchData', 'printData','cancelData','firstData','billImport','recallData','upTemplate','downTemplate','printDeductibleData'],
						'C' : [ 'addData', 'copyData', 'searchData', 'printData','upTemplate','downTemplate'],
						'S' : [ 'addData','searchData', 'firstData','fallData','upTemplate','downTemplate'],
						'Q' : [ 'addData','searchData','upTemplate','downTemplate'],
						'D' : [ 'addData','searchData','upTemplate','downTemplate'],
						'A' : [ 'addData','searchData','recallData','auditData', 'createData' , 'finshData' , 'upTemplate','downTemplate'],
					}
				},
				status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
					'N' : [ 'addData', 'saveData', 'searchData', 'addPhoto','upPhoto','searchPhoto','delPhoto', 'checkPhoto','upTemplate','downTemplate' ],
					'V' : [ 'addData', 'editData', 'auditData', 'createData' , 'finshData' , 'delData', 'copyData', 'searchData', 'printData','upTemplate','downTemplate' ],
					'E' : [ 'addData', 'saveData', 'copyData', 'searchData', 'printData', 'addPhoto','billImport','searchPhoto','delPhoto', 'checkPhoto','upTemplate','downTemplate'],
					'S' : [ 'addData', 'editData', 'auditData', 'createData' , 'finshData' , 'delData', 'copyData', 'searchData', 'printData' ,'upTemplate','downTemplate'],
					'A' : [ 'addData', 'cancelData', 'copyData', 'searchData', 'printData', 'export','upTemplate','downTemplate','printDeductibleData' ],
					'C' : [ 'addData', 'copyData', 'searchData', 'printData', 'export','upTemplate','cancelData','downTemplate' ],
					'D' : [ 'addData', 'searchData', 'billImport','upTemplate','downTemplate' ],
				},
			items : [ [ {
				'text' : '新增',
				'iconCls' : 'icon-add',
				'name' : 'addData',
			}, {
				'text' : '修改',
				'iconCls' : 'icon-edit',
				'name' : 'editData',
			}, {
				'text' : '删除',
				'iconCls' : 'icon-remove',
				'name' : 'delData',
			}, {
				'text' : '保存',
				'iconCls' : 'icon-save',
				'name' : 'saveData',
			}], [{
				'text' : '审核',
				'iconCls' : 'icon-ok',
				'name' : 'auditData'
			}],[{
				'text' : '查询',
				'iconCls' : 'icon-search',
				'name' : 'searchData'
			}, {
				'text' : '生成',
				'iconCls' : 'icon-addfolder',
				'name' : 'createData',
				"onclick" : "createData",
			}, {
				'text' : '结束',
				'iconCls' : 'icon-addfolder',
				'name' : 'finshData',
				"onclick" : "finshData",
			} ] ]
		};
		//单据列表
		var gridbox2 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.stock.rockonsetdate.search",
			"response" : "dbusrmkt.bcheckdate",
			"bindform" : "tabs1", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
			"searchParam" : {
				"order_field" : "billno", //降序排列
				"order_direction" : "desc",
			},
			"properties" : {
				"id" : "gridbox2",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					width : 60,
				}, {
					field : "billno",
					headerAlign : "center",
					header : "单据编号",
					allowSort : true,
					width : 150,
				}, {
					field : "billstatus",
					headerAlign : "center",
					header : "单据状态",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.BILLSTATUS,
				}, {
					field : "bctfinished",
					headerAlign : "center",
					header : "是否完成",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.BCTFINISHED,
				}, {
					field : "billmoduleid",
					headerAlign : "center",
					header : "模块编号",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : billmoduleid,
					visible : false,
					enabledSearch : false,
				}, {
					field : "mktid",
					displayField : "mktname",
					header : "门店",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "muid",
						textName : "mktname"
					},
					readOnly : true,
					width : 180,
				}, {
					field : "bctdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "盘点日期",
					width : 150,
					allowSort : true,
				}, {
					field : "chkstockedtime",
					dataType : "date",
					dateFormat : "yyyy-MM-dd HH:mm:ss",
					header : "生成日期",
					width : 150,
					allowSort : true,
				}, {
					field : "bcttype",
					headerAlign : "center",
					header : "盘点类型",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.BCTTYPE,
				}, {
					field : "bctisclr0",
					headerAlign : "center",
					header : "是否清零",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.BCTISCLR0,
					width : 150,
				}, {
					field : "bcdseq",
					headerAlign : "center",
					header : "盘点序号",
					allowSort : true,
					width : 150,
				}, {
					field : "memo",
					headerAlign : "center",
					header : "备注",
					width : 160,
				},{
					field : "inputer",
					header : "录入人",
					headerAlign : "center",
					allowSort : true,
					width : 150,
					displayField : "inputer_name",//文本字段
					editor : OcmControl.newControl('fut_popselect'),
					editorSet : {
						selectkey : "investigator",//查询key
						beforefunc : "head_beforefunc",
					},
				}, {
					field : "inputer_name",
					headerAlign : "center",
					header : "录入人名称",
					allowSort : false,
					visible : false,
					enabledSearch : false,
				}, {
					field : "inputdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd HH:mm:ss",
					header : "录入日期",
					width : 150,
					allowSort : true,
				}, {
			        field: "auditor",
			        header: "审核人",
			        headerAlign : "center",
			        allowSort: true,
			        width: 150,
		          	displayField : "auditor_name",//文本字段
					editor:OcmControl.newControl('fut_popselect'),
					editorSet: {
					selectkey:"investigator",//查询key
					beforefunc:"head_beforefunc",
					},
				} ,{
					field : "auditor_name",
					headerAlign : "center",
					header : "审核人名称",
					allowSort : false,
					visible:false,
					enabledSearch: false,
		        }, {
		          	field: "auditdate",
		          	dataType: "date",
		          	dateFormat: "yyyy-MM-dd HH:mm:ss",
		          	header: "审核日期",
		          	width: 150,
		          	allowSort: true,
		        },{
			        field: "finishedperson",
			        header: "结束人",
			        headerAlign : "center",
			        allowSort: true,
			        width: 150,
		          	displayField : "finishedperson_name",//文本字段
					editor:OcmControl.newControl('fut_popselect'),
					editorSet: {
					selectkey:"investigator",//查询key
					beforefunc:"head_beforefunc",
					},
				} ,{
					field : "finishedperson_name",
					headerAlign : "center",
					header : "结束人名称",
					allowSort : false,
					visible:false,
					enabledSearch: false,
		        }, {
		          	field: "finisheddate",
		          	dataType: "date",
		          	dateFormat: "yyyy-MM-dd HH:mm:ss",
		          	header: "结束日期",
		          	width: 150,
		          	allowSort: true,
		        } ]
			},
		};
		//子库存
		var headform2 = [];
		for(var i = 0;i < dicData.STOCKMD.length;i++){
			var data = dicData.STOCKMD[i];
			var item = {
					"text": data.name,
					"type" : "CheckBox",
					"name" : data.code,
					"trueValue" : data.code,
					"falseValue" : "N",
					"defaultValue" : data.code == '1' ? "Y" : "N",
					"width" : "10%",
					"onvaluechanged" : "btcchanged",
			};
			headform2.push(item);
		}
		//单据头
		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [{
				"id" : "test",
				"label" : "基础信息",
				"type" : "fieldset",
				"items" : [ {
					"label" : "ph_key",
					"type" : "TextBox",
					"name" : "ph_key",
					"readOnly" : "true",
					"visible" : false,
				}, {
					"label" : "单据编号：",
					"type" : "TextBox",
					"id" : "billno",
					"name" : "billno",
					"readOnly" : true,
				}, {
					"label" : "单据类别：",
					"name" : "billmoduleid",
					"type" : "ComboBox",
					"data" : dicData.BILLMODULEID,
					"defaultValue" : billmoduleid,
					"readOnly" : true,
					"visible" : false,
				}, {
					"label" : "单据状态：",
					"name" : "billstatus",
					"type" : "ComboBox",
					"data" : dicData.BILLSTATUS,
					"defaultValue" : "N",
					"readOnly" : true,
				}, {
					"label" : "是否完成：",
					"name" : "bctfinished",
					"type" : "ComboBox",
					"data" : dicData.BCTFINISHED,
					"defaultValue" : "N",
					"readOnly" : true,
				}, {
					"label" : "盘点日期：",
					"name" : "bctdate",
					"required" : "true",
					"type" : "DatePicker",
					"format" : "yyyy-MM-dd",
					"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"onvaluechanged" : "bctdatechanged",
				}, {
					"label" : "门店：",
					"name" : "mktid",
					"required" : "true",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "muid",//弹框类型
					textName : "mktname", //文本显示字段
					beforefunc : "head_beforefunc_muid",
					itemchangedfunc : "head_itemchanged_muid",
				}, {
					"label" : "门店code",
					"type" : "TextBox",
					"name" : "mktcode",
					"readOnly" : "true",
					"visible" : false,
				}, {
					"label" : "门店名称",
					"type" : "TextBox",
					"name" : "mktname",
					"readOnly" : "true",
					"visible" : false,
				}, {
					"label" : "子库存",
					"type" : "TextBox",
					"name" : "bctv1",
					"readOnly" : "true",
					"visible" : false,
				}, {
					"label" : "盘点类型：",
					"name" : "bcttype",
					"type" : "ComboBox",
					"required" : "true",
					"data" : dicData.BCTTYPE,
					"onvaluechanged" : "bcttypechanged",
				},  {
					"label" : "是否生成帐存：",
					"name" : "chkstocked",
					"type" : "ComboBox",
					"required" : "true",
					"data" : dicData.CHKSTOCKED,
					"defaultValue" : "0",
					"readOnly" : true,
					"visible" : false,
				}, {
					"label" : "生成日期：",
					"name" : "chkstockedtime",
					"type" : "DatePicker",
					"format" : "yyyy-MM-dd HH:mm:ss",
					"readOnly" : "true",
				}, {
					"label" : "盘点序号：",
					"type" : "TextBox",
					"name" : "bcdseq",
					"readOnly" : "true",
				}, {
					"label" : "是否清零：",
					"name" : "bctisclr0",
					"type" : "ComboBox",
					"required" : "true",
					"data" : dicData.BCTISCLR0,
					"width" : "30%",
					"onvaluechanged" : "btcchanged",
				},{
					"label" : "备注：",
					"name" : "memo",
					"type" : "TextBox",
					"style" : "width:90%; display:block;float:none",
					"maxLength" : 60,
					"onvaluechanged" : "onOviewChanged",
				},{
					"label" : "录入人：",
					"name" : "inputer_name",
					"type" : "TextBox",
					"readOnly" : true,
					"defaultValue" : getUserName(),
				}, {
					"label" : "录入人",
					"name" : "inputer",
					"type" : "TextBox",
					"readOnly" : true,
					"visible" : false,
				}, {
					"label" : "审核人：",
					"name" : "auditor_name",
					"type" : "TextBox",
					"readOnly" : true,
				}, {
					"label" : "结束人：",
					"name" : "finishedperson_name",
					"type" : "TextBox",
					"readOnly" : true,
				}, {
					"label" : "录入日期：",
					"name" : "inputdate",
					"type" : "DatePicker",
					"readOnly" : true,
					"format" : "yyyy-MM-dd HH:mm:ss",
					"defaultValue" : new Date(),
				}, {
					"label" : "审核日期：",
					"name" : "auditdate",
					"type" : "DatePicker",
					"readOnly" : true,
					"format" : "yyyy-MM-dd HH:mm:ss",
				}, {
					"label" : "结束日期：",
					"name" : "finisheddate",
					"type" : "DatePicker",
					"readOnly" : true,
					"format" : "yyyy-MM-dd HH:mm:ss",
				} ]
			},{
				"id" : "test2",
	        	"label" : "子库存",
	        	"type" : "fieldset",
	        	"items" : headform2
			}]
		};
		//以下为单据明细的tab页面
		var chkmfid = {
			"type" : "gridbox",
			"properties" : {
				"id" : "chkmfid",
				"multiSelect" : "true",
				"allowCellEdit" : "true",
				"allowCellSelect" : "true",
				"editNextOnEnterKey" : "true",
				"editNextRowCell" : "true",
				"allowSortColumn" : "false",
				"allowCellValid" : true,
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"columns" : [ {
					type : "checkcolumn",
					headerAlign : "center",
					readOnly : true,
					width : 10,
				}, {
					type : "indexcolumn",
					headerAlign : "center",
					header : "行号",
					readOnly : true,
					width : 20,
				}, {
					field : "cmfdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "盘点日期",
					width : 150,
					allowSort : true,
					visible : false,
				},{
					field : "mmfid_name",
					name : "mmfid_name",
					header : "楼层",
					allowSort : true,
					headerAlign : "center",
					readOnly : true,
					width : 120,
				},{
					field : "cmfmfid",
					displayField : "cmfmfname",
					header : "柜组",
					required : true,
					headerAlign : "center",
					editor : OcmControl.newControl('fut_popselectgrid'),
					editorSet : {
						selectkey : "selfspid",
						textName : "cmfmfname",
						beforefunc : "det_beforefunc_selfspid",
						itemchangedfunc : "det_itemchanged_selfspid"
					},
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "selfspid"
					},
					width : 120,
				}, {
					field : "cmfmfcode",
					name : "cmfmfcode",
					header : "柜组code",
					allowSort : true,
					headerAlign : "center",
					readOnly : true,
					width : 60,
					visible : false,
				},{
					field : "cmfmfname",
					name : "cmfmfname",
					header : "柜组名称",
					allowSort : true,
					headerAlign : "center",
					readOnly : true,
					width : 60,
					visible : false,
				},{
					field : "cmfstatus",
					header : "盘点状态",
					headerAlign : "center",
					width : 60,
					allowSort : true,
					readOnly : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.CMFSTATUS,
					defaultValue : 'N'
				}, {
					field : "cmfflag",
					header : "标志",
					headerAlign : "center",
					width : 60,
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.BILLSTATUS,
					defaultValue : 'Y',
					visible : false,
				}, {
					field : "cmfseq",
					name : "cmfseq",
					header : "盘点序号",
					allowSort : true,
					headerAlign : "center",
					readOnly : true,
					width : 60,
				} ]
			},

		};
		//明细tab页
		var tabs2 = {
			properties : {
				id : "tabs2",
			},
			items : [ {
				"title" : "明细",
				"name" : "chkmfid",
				"control" : chkmfid
			} ]
		};
		//单据明细组成：单据头+单据明细tab
		var details1 = {
			"type" : "formgrid",
			"initHeight": 0.5,
			"resources" : OmdUrl.mss,
			"method" : "mss.stock.rockonsetdate.get",
			"response" : "dbusrmkt.bcheckdate",
			"properties" : {
				"id" : "details1",
			},
			"items" : formheader1.items,
			"tabs" : tabs2,
		};
		//单据列表和单据明细
		var tabs1 = {
			properties : {
				"id" : "tabs1"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "ListGrid",
				"control" : gridbox2,
			}, {
				"title" : "单据明细",
				"name" : "details1",
				"control" : details1,
			} ]
		};
		var config1 = {
			"properties" : {
				"id" : "config1",
			},
			"toolbar" : toolbar1,
			"tabs" : tabs1,
		};
	</script>
	<script src="rockonSetDay.js" type="text/javascript"></script>
</body>
</html>