<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>盘点单管理</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-layout" config="formlayout" beforeload="beforeload"
		borderStyle="border:0px;" style="width: 100%; height: 100%;"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>
	<script type="text/javascript">
		var billmoduleid = getUrlParam("billmoduleid");
		if (billmoduleid == "" || billmoduleid == null) {
			billmoduleid = getUrlParam("modulecode");
		}
		var billtype = getBilltype(billmoduleid);
		var sample = [ {
			code : 'N',
			name : '否'
		}, {
			code : 'Y',
			name : '是'
		} ];

		// 字典数据初始化
		var dicData = OcmControl.getDict(
				"BILLSTATUS,billtype,billmoduleid,BILLSOURCE,STOCKMD",
				"code,name,ddvalue")
				|| {};
		// 页面布局配置
		var toolbar1 = {
			rule : { // 按钮可用规则 Y:已审核, N:录入, T:已取消
				'billstatus' : {
					'Y' : [ 'addData', 'cancelData', 'searchData', 'printData',
							'exportgoods', 'downTemplate', 'updateData' ],
					'N' : [ 'addData', 'editData', 'doauditData', 'delData',
							'searchData', 'printData', 'importData', 'addFile',
							'uploadData', 'downTemplate' ],
					'T' : [ 'addData', 'searchData', 'printData',
							'exportgoods', 'doauditData', 'downTemplate' ]
				}
			},
			status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
				'N' : [ 'addData', 'saveData', 'searchData', 'downTemplate' ],
				'V' : [ 'addData', 'editData', 'doauditData', 'delData',
						'searchData', 'printData', 'importData' ],
				'E' : [ 'addData', 'saveData', 'searchData',
						'downTemplate' ],
				'S' : [ 'addData', 'editData', 'doauditData', 'delData',
						'searchData', 'printData', 'importData', 'downTemplate' ],
				'A' : [ 'addData', 'cancelData', 'searchData', 'printData',
						'exportgoods', 'downTemplate', 'updateData' ],
				'C' : [ 'addData', 'searchData', 'printData', 'exportgoods',
						'downTemplate' ],
				'D' : [ 'addData', 'searchData', ],
			},
			items : [ [ {
				'text' : '新增',
				'iconCls' : 'icon-add',
				'name' : 'addData'
			}, {
				'text' : '修改',
				'iconCls' : 'icon-edit',
				'name' : 'editData'
			}, {
				'text' : '保存',
				'iconCls' : 'icon-save',
				'name' : 'saveData'
			}],[ {
				'text' : '删除',
				'iconCls' : 'icon-remove',
				'name' : 'delData'
			},{
				'text' : '审核',
				'iconCls' : 'icon-ok',
				'name' : 'doauditData',
				"onclick" : "doauditData",
				'visible' :billtype=='129'?true:false
			},{
				'text' : '查询',
				'iconCls' : 'icon-search',
				'name' : 'searchData'
			} ], [ {
				'text' : '导入',
				'iconCls' : 'icon-upload',
				'name' : 'importData',
				"enabled" : true,
			}, {
				'text' : '下载导入模板',
				'iconCls' : 'icon-search',
				'name' : 'downTemplate',
			} ],]
		}
		//单据列表
		var mainList = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.base.bcheckhead.search",
			"response" : "dbusrmkt.bcheckhead",
			"bindform" : "layouttabs", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
			"searchParam" : {
				"billtype" : billtype,
				"order_field" : "billno", //降序排列
				"order_direction" : "desc",
			},
			"properties" : {
				"id" : "mainList",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					width : 60,
				}, {
					field : "billno",
					headerAlign : "center",
					header : "单据编号",
					allowSort : true,
					width : 150,
				}, {
					field : "billstatus",
					headerAlign : "center",
					header : "单据状态",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.BILLSTATUS,
				}, {
					field : "billmoduleid",
					headerAlign : "center",
					header : "模块编号",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : billmoduleid,
					visible : false,
					enabledSearch : false,
				}, {
					field : "bchmarket",
					displayField : "bchmarket_name",
					header : "门店",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "muid",
						textName : "bchmarket_name"
					},
					readOnly : true,
					width : 160,
				}, {
					field : "bchmfid",
					displayField : "bchmfid_name",
					header : "柜组",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "selfspid",
						textName : "bchmfid_name"
					},
					readOnly : true,
					width : 160,
				}, {
					field : "bchpddate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "盘点日期",
					width : 150,
					allowSort : true,
				}, {
					field : "seq",
					headerAlign : "center",
					header : "盘点序号",
					allowSort : true,
					width : 100,
				}, {
					field : "bchmd",
					headerAlign : "center",
					header : "子库存",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.STOCKMD,
				}, {
					field : "inputer",
					header : "录入人",
					headerAlign : "center",
					allowSort : true,
					width : 150,
					displayField : "inputer_name",//文本字段
					editor : OcmControl.newControl('fut_popselect'),
					editorSet : {
						selectkey : "investigator",//查询key
						beforefunc : "head_beforefunc",
					},
				}, {
					field : "inputer_name",
					headerAlign : "center",
					header : "录入人名称",
					allowSort : false,
					visible : false,
					enabledSearch : false,
				}, {
					field : "inputdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd HH:mm:ss",
					header : "录入日期",
					width : 150,
					allowSort : true,
				}, {
					field : "auditor",
					header : "审核人",
					headerAlign : "center",
					allowSort : true,
					width : 150,
					displayField : "auditor_name",//文本字段
					editor : OcmControl.newControl('fut_popselect'),
					editorSet : {
						selectkey : "investigator",//查询key
						beforefunc : "head_beforefunc",
					},
				}, {
					field : "auditor_name",
					headerAlign : "center",
					header : "审核人名称",
					allowSort : false,
					visible : false,
					enabledSearch : false,

				}, {
					field : "auditdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd HH:mm:ss",
					header : "审核日期",
					width : 150,
					allowSort : true,
				},{
				        field: "canceler",
				        header: "取消人",
				        headerAlign : "center",
				        allowSort: true,
				        width: 150,
			          	displayField : "canceler_name",//文本字段
						editor:OcmControl.newControl('fut_popselect'),
						editorSet: {
						selectkey:"investigator",//查询key
						beforefunc:"head_beforefunc",
						},
						visible : false,
					} ,{
						field : "canceler_name",
						headerAlign : "center",
						header : "取消人名称",
						allowSort : false,
						visible:false,
						enabledSearch: false,
					
			        }, {
			          	field: "canceldate",
			          	dataType: "date",
			          	dateFormat: "yyyy-MM-dd HH:mm:ss",
			          	header: "取消日期",
			          	width: 150,
			          	allowSort: true,
			          	visible : false,
			        }
				]
			},
		};
		//单据头
		var mainHead = {
			type : "formgrid",
			resources : OmdUrl.mss,
			method : "mss.base.bcheckhead.get",
			response : "dbusrmkt.bcheckhead",
			properties : {
				id : "mainHead",
			},
			items : [ {
				label : "ph_key",
				type : "TextBox",
				name : "ph_key",
				readOnly : "true",
				visible : false,
			}, {
				label : "单据编号：",
				type : "TextBox",
				id : "billno",
				name : "billno",
				readOnly : "true",
			}, {
				label : "单据状态：",
				type : "ComboBox",
				name : "billstatus",
				defaultValue : "N",
				readOnly : "true",
				data : dicData.BILLSTATUS,
			}, {
				label : "billtype：",
				type : "ComboBox",
				name : "billtype",
				defaultValue : billtype,
				readOnly : "true",
				visible : false,
			}, {
				label : "模块号：",
				type : "ComboBox",
				name : "billmoduleid",
				defaultValue : billmoduleid,
				readOnly : "true",
				data : billmoduleid,
				visible : false,
			}, {
				label : "门店：",
				name : "bchmarket",
				type : "ButtonEdit",
				required : "true",
				defaultValue : "",
				type : "fut_popselect",
				selectkey : "muid",
				textName : "bchmarket_name",
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				allowInput : true,
			}, {
				label : "盘点日期：",
				name : "bchpddate",
				type : "ButtonEdit",
				required : true,
				defaultValue : "",
				type : "fut_popselect",
				selectkey : "pddate",
				textName : "bchpddate_name",
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged_bchpddate",
				allowInput : true,
			}, {
				label : "盘点序号：",
				name : "seq",
				type : "TextBox",
				visible : "false",
				readOnly : true,
			},/*{
							        label : "盘点日期：",
							        type : "DatePicker",
							        name : "bchpddate",
							        format : "yyyy-MM-dd",
							        required : "true",
							        defaultValue : new Date(),
							    } ,*/{
				label : "柜组：",
				name : "bchmfid",
				type : "ButtonEdit",
				required : false,
				defaultValue : "",
				type : "fut_popselect",
				selectkey : "selfspid",
				textName : "bchmfid_name",
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				allowInput : true,
			}, {
				label : "子库存：",
				name : "bchmd",
				type : "ComboBox",
				required : true,
				data : dicData.STOCKMD,
				readOnly : false,
			}, {
				label : "供应商：",
				name : "bchsupid",
				type : "ButtonEdit",
				required : false,
				defaultValue : "",
				type : "fut_popselect",
				selectkey : "selfsbid",
				textName : "bchsupid_name",
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				allowInput : true,
				"visible" : false,
			}, {
				text : "结算：",
				type : "CheckBox",
				name : "isautosettle",
				trueValue : "Y",
				falseValue : "N",
				defaultValue : 'N',
				//readOnly : false,
				enabled : true,
				style : "width:9%",
			}, {
				label : "说明字段：",
				type : "TextBox",
				id : "text2",
				name : "text2",
				readOnly : "true",
			}, {
				label : "备注：",
				name : "bchmemo",
				type : "TextBox",
				style : "width:90%; display:block;float:none",
			}, {
				label : "录入人：",
				name : "inputer",
				type : "TextBox",
				visible : "false",
				readOnly : "true",
				type : "fut_popselect",
				selectkey : "investigator",
				textName : "inputer_name",
				allowSort : true,
			}, {
				label : "录入人：",
				name : "inputer_name",
				type : "TextBox",
				visible : "false",
				readOnly : "true",
				visible : false,
			}, {
	         	label: "审核人：",
	         	name: "auditor",
	         	type : "TextBox",
				visible : false,
				readOnly : "true",
				allowSort : true,
          }  ,{
			label : "审核人：",
			name : "auditor_name",
			type : "TextBox",
			visible : "false",
			readOnly : "true",
			"style": "display:block;float:none",
		} ,{
			"label" : "取消人：",
			"name" : "canceler",
			"type" : "TextBox",
			"visible" : false,
			"readOnly" : "true",
		}, {
			"label" : "取消人姓名：",
			"name" : "canceler_name",
			"type" : "TextBox",
			"visible" : false,
			"readOnly" : "true",
		} , {
				label : "录入日期：",
				type : "DatePicker",
				name : "inputdate",
				format : "yyyy-MM-dd HH:mm:ss",
				defaultValue : new Date(),
				readOnly : "true",
				visible : true,
			},{
	           label: "审核日期：",
	           type: "DatePicker",
	           name: "auditdate",
	           format: "yyyy-MM-dd HH:mm:ss",
	           readOnly: "true",
	           "style": "display:block;float:none",
	       },{
	           label: "取消日期：",
	           type: "DatePicker",
	           name: "canceldate",
	           format: "yyyy-MM-dd HH:mm:ss",
	           readOnly: "true",
	           visible : false,
	       },{
				label : "说明字段：",
				type : "TextBox",
				id : "text1",
				name : "text1",
				readOnly : "true",
			}, ]
		};
		//以下为单据明细的tab页面
		var bcheckdetail = {
			"type" : "gridbox",
			"properties" : {
				"id" : "bcheckdetail",
				"multiSelect" : true,
				//"allowUnselect": true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"allowCellValid" : true, //控制是否打开验证
				"onCellbeginedit" : "OcmControl.checkboxEditor",
				"columns" : [ {
					type : "checkcolumn",
					headerAlign : "center",
					readOnly : true,
				}, {
					type : "indexcolumn",
					headerAlign : "center",
					header : "行号",
					readOnly : true,
				}, {
					field : "rowno",
					headerAlign : "center",
					header : "行号",
					readOnly : true,
					visible : false,
				}, {
					field : "bcdpddate",
					name : "bchpddate",
					header : "盘点日期",
					format : "yyyy-MM-dd",
					allowSort : true,
					headerAlign : "center",
					width : 60,
					visible : false
				}, {
					field : "bcdmd",
					name : "bcdmd",
					header : "子库存",
					readOnly : true,
					width : 180,
					visible : false,
				}, {
					field: "bcdgdid",
					name: "bcdgdid",
					header : "商品编码",
					headerAlign : "center",				    
				    width : 110,
				    align : "left",
				    readOnly: true,
				}, {
					field : "bcdbarcode",
					name : "bcdbarcode",
					header : "商品条码",
					allowSort : true,
					required : true,
					headerAlign : "center",
					editor : OcmControl.newControl('fut_popselectgrid'),
					editorSet : {
						selectkey : 'selfgbasestock2',
						beforefunc : "det_beforefunc_bcdbarcode",
						itemchangedfunc : "det_itemchanged_bcdbarcode"
					},
					width : 150,
				}, {
					field : "bcdname",
					name : "bcdname",
					header : "商品名称",
					align : "left",
					required : false,
					readOnly : true,
					allowSort : true,
					width : 180,
				}, {
					field : "bcdmfid_name",
					name : "bcdmfid_name",
					header : "柜组",
					readOnly : true,
					width : 180,
				}, {
					field : "bcdshelfcode",
					name : "bcdshelfcode",
					header : "货位",
					readOnly : true,
					width : 180,
					visible : false,
				}, {
					field : "bcdsample",
					header : "样品",
					headerAlign : "center",
					type : "comboboxcolumn",
					valueField : "code",
					textField : "name",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : sample,
					required : false,
				//	readOnly : true,
					defaultValue : "N",
					width : 60,
				}, {
					field : "bcdspec",
					name : "bcdspec",
					header : "规格",
					readOnly : true,
					align : "left",
				//visible : true,
				}, {
					field : "bcdcatid",
					name : "bcdcatid",
					header : "商品类别",
					readOnly : true,
					visible : false,
				}, {
					field : "bcdcatid_name",
					name : "bcdcatid_name",
					header : "商品类别",
					readOnly : true,
					align : "left",
					visible : true,
				}, {
					field : "bcdppcode",
					name : "bcdppcode",
					header : "品牌",
					readOnly : true,
					visible : false,
				}, {
					field : "bcdppcode_name",
					name : "bcdppcode_name",
					header : "品牌",
					readOnly : true,
					align : "left",
					visible : true,
				}, {
					field : "bcdflag",
					name : "bcdflag",
					header : "标志",
					readOnly : true,
					visible : false,
				}, {
					field : "bcddjlb",
					name : "bcddjlb",
					header : "单据类别",
					readOnly : true,
					visible : false,
				}, {
					field : "bcdmanamode",
					name : "bcdmanamode",
					header : "管理方法",
					readOnly : true,
					visible : false,
				}, {
					field : "bcdmarket",
					name : "bcdmarket",
					header : "门店",
					readOnly : true,
					visible : false,
				}, {
					field : "bcdmfid",
					name : "bcdmfid",
					header : "柜组",
					readOnly : true,
					visible : false,
				}, {
					field : "bcdunit",
					name : "bcdunit",
					header : "单位",
					allowSort : false,
					readOnly : false,
					headerAlign : "center",
					editor : OcmControl.newControl('fut_popselectgrid'),
					editorSet : {
						selectkey : "units",
						multiSelect : false,
						beforefunc : "item_beforefunc",
						itemchangedfunc : "item_itemchanged",
					},
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "units"
					},
					width : 80,
				}, {
					field : "bcdhl",
					header : "含量",
					allowSort : false,
					readOnly : true,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					align : "right",
					width : 80,
				}, {
					field : "bcdjs",
					header : "件数",
					allowSort : false,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					align : "right",
					width : 80,
				}, {
					field : "bcdsl",
					header : "数量",
					allowSort : false,
					headerAlign : "center",
					readOnly : true,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					align : "right",
					width : 80,
				}, {
					field : "bcdsj",
					name : "bcdsj",
					header : "售价",
					required : false,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					//onValuechanged : "onGridValueChanged",
					},
					numberFormat : "c2",
					align : "right",
					width : 100,
					readOnly : true,
				}, {
					field : "bcdsjje",
					name : "bcdsjje",
					header : "售价金额",
					required : false,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					//onValuechanged : "onGridValueChanged",
					},
					numberFormat : "c2",
					align : "right",
					width : 100,
					readOnly : true,
				}, ]
			},

		};
		//明细tab页
		var detailtabs = {
			properties : {
				id : "detailtabs",
			},
			items : [ {
				"title" : "单据明细",
				"name" : "bcheckdetail",
				"control" : bcheckdetail
			} ]
		};
		//单据明细组成：单据头+单据明细tab
		var formDetail = {
			"type" : "formgrid",
			"initHeight": 0.35,
			"resources" : OmdUrl.mss,
			"method" : "mss.base.bcheckhead.get",
			"response" : "dbusrmkt.bcheckhead",
			"properties" : {
				"id" : "formDetail",
			},
			"items" : mainHead.items,
			"tabs" : detailtabs,
		};
		//单据列表和单据明细
		var tabs1 = {
			properties : {
				"id" : "layouttabs"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "ListGrid",
				"control" : mainList,
			}, {
				"title" : "单据明细",
				"name" : "formDetail",
				"control" : formDetail,
			} ]
		};
		var formlayout = {
			"properties" : {
				"id" : "formlayout",
			},
			"toolbar" : toolbar1,
			"tabs" : tabs1,
		};
	</script>
	<script src="rockonsheet.js" type="text/javascript"></script>
</body>
</html>