<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>周期性费用年增长规则</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height:100%;_margin:0px;_padding:0px;">
	<div class="ocm-layout" config="config1" borderStyle="border:0px;" style="width: 100%; height: 100%;"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/method.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	<script type="text/javascript">
	var billmoduleid = getUrlParam("billmoduleid");
	if (billmoduleid == "" || billmoduleid == null) {
		billmoduleid = getUrlParam("modulecode");
	}
	var dicData = getDict("SYSTEM_BILLSTATUS","dcode,dname,pro1,ddvalue");
	dicData.PERIODTYPE = [{code: '1', name: '按自然年'}, {code: '2', name: '按合同年'}];
	dicData.BASEON = [{code: '1', name: '上一年'}, {code: '2', name: '上一周期'}];
	dicData.INCRTYPE = [{code: '1', name: '比率'}, {code: '2', name: '金额'}];
	var billtype = getBilltype(billmoduleid);
	// 页面布局配置
	var toolbar1 = {
		rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消 ,S:提交
			'billstatus' : {
				'Y' : [ 'addData', 'searchData', 'printData', 'cancelData', 'invalid', 'upTemplate', 'downTemplate','pay' ],
				'N' : [ 'addData', 'editData', 'auditData', 'delData', 'copyData', 'searchData', 'printData',
						'cancelData', 'firstData', 'billImport', 'recallData', 'upTemplate', 'downTemplate' ],
				'C' : [ 'addData', 'copyData', 'searchData', 'printData', 'upTemplate', 'downTemplate' ],
				'S' : [ 'addData', 'searchData', 'firstData', 'fallData', 'upTemplate', 'downTemplate' ],
				'Q' : [ 'addData', 'searchData', 'upTemplate', 'downTemplate' ],
				'D' : [ 'addData', 'searchData', 'upTemplate', 'downTemplate' ],
				'A' : [ 'addData', 'editData','searchData', 'recallData', 'auditData', 'upTemplate', 'downTemplate' ],
			}
		},
		status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
			'N' : [ 'addData', 'saveData', 'searchData', 'addPhoto', 'upPhoto', 'searchPhoto', 'delPhoto', 'checkPhoto',
					'upTemplate', 'downTemplate' ],
			'V' : [ 'addData', 'editData', 'auditData', 'delData', 'copyData', 'searchData', 'printData', 'upTemplate','downTemplate' ],
			'E' : [ 'addData', 'saveData', 'delData', 'copyData', 'searchData', 'printData', 'addPhoto', 'billImport',
					'searchPhoto', 'delPhoto', 'checkPhoto', 'upTemplate', 'downTemplate' ],
			'S' : [ 'addData', 'editData', 'auditData', 'delData','copyData', 'searchData', 'printData', 'upTemplate','downTemplate' ],
			'A' : [ 'addData', 'cancelData', 'copyData', 'searchData', 'printData', 'export', 'upTemplate', 'downTemplate' ,'pay'],
			'C' : [ 'addData', 'copyData', 'searchData', 'printData', 'export', 'upTemplate', 'invalid', 'downTemplate' ],
			'D' : [ 'addData', 'searchData', 'billImport', 'upTemplate', 'downTemplate' ],
		},
		items : [ [ {
			'text' : '新增',
			'iconCls' : 'icon-add',
			'name' : 'addData'
		}, {
			'text' : '修改',
			'iconCls' : 'icon-edit',
			'name' : 'editData'
		}, {
			'text' : '保存',
			'iconCls' : 'icon-save',
			'name' : 'saveData'
		} ], [ {
			'text' : '审核',
			'iconCls' : 'icon-ok',
			'name' : 'auditData'
		}, ], [ {
			'text' : '删除',
			'iconCls' : 'icon-remove',
			'name' : 'delData'
		}, {
			'text' : '查询',
			'iconCls' : 'icon-search',
			'name' : 'searchData'
		} ] ]
	};

	//单据列表
	var gridbox2 = {
		"type" : "gridbox",
		"resources" : OmdUrl.mall,
		"method" : "mall.work.chargeincrule.search",
		"response" : "chargeincrulehd",
		"bindform" : "tabs1", // 绑定切换的TabsBox.name
		"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段 
		"searchParam" : {
			"billtype":billtype,
			"order_field" : "billno",
			"order_direction" : "desc",
		},
		"properties" : {
			"id" : "gridbox2",
			"columns" : [ {
				type : "indexcolumn",
				headerAlign : "center",
				header : "行号",
				width : 80,
			}, {
				field : "billno",
				headerAlign : "center",
				header : "规则编码",
				allowSort : true,
				width : 160,
			}, {
				field: "billtype",
				type: "TextBox",
				headerAlign: "center",
				header: "单据类型",
				width : 140,
				visible : false,
			}, {
				field : "billstatus",
				headerAlign : "center",
				header : "状态",
				width : 150,
				allowSort : true,
				renderer : "OcmControl.dictRendererWithCode",
				data : dicData.SYSTEM_BILLSTATUS,
			}, {
				field : "descript",
				header : "规则描述",
				headerAlign : "center",
				width : 250,
			}, {
	        	field : "inputer_name",
				headerAlign : "center",
				header : "录入人",
				width:150,
				allowSort : true,
			}, {
				field : "inputdate",
				dataType : "date",
				dateFormat : "yyyy-MM-dd HH:mm:ss",
				header : "录入日期",
				width : 150,
				allowSort : true,
			}, {
				field : "auditor_name",
				headerAlign : "center",
				header : "审核人",
				width:120,
				allowSort : true,
	        }, {
	        	field : "auditdate",
	        	dataType : "date",
	        	dateFormat : "yyyy-MM-dd HH:mm:ss",
	        	header : "审核日期",
	        	width : 150,
	        	allowSort : true,
	        } ],
		},
	};

	//单据头
	var formheader1 = {
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mall.work.chargeincrule.get",
		"response" : "chargeincrulehd",
		"properties" : {
			"id" : "chargeincrulehd",
		},
		items : [ {
			"label" : "ph_key：",
			"type" : "TextBox",
			"name" : "ph_key",
			"readOnly" : "true",
			"visible" : false,
		}, {
			"label" : "规则编码：",
			"id" : "billno",
			"name" : "billno",
			"type" : "TextBox",
			"readOnly" : true,
		}, {
			"label" : "单据类别：",
			"name" : "billmoduleid",
			"type" : "TextBox",
			"defaultValue" : billmoduleid,
			"readOnly" : true,
			"visible" : false,
		}, {
			"label" : "单据状态：",
			"name" : "billstatus",
			"type" : "ComboBox",
			"data" : dicData.SYSTEM_BILLSTATUS,
			"defaultValue" : "N",
			"readOnly" : true,
		}, {
			"label" : "单据类别：",
			"name" : "billtype",
			"type" : "TextBox",
			"defaultValue" : billtype,
			"visible" : false,
		}, {
			"label" : "期间描述：",
			"name" : "periodtype",
			"type" : "ComboBox",
			"data" : dicData.PERIODTYPE,
			"defaultValue" : '1',
			"enabled" : true,
			"renderer": "OcmControl.dictRendererWithCode",
			"visible" : false,
		}, {
			"label" : "规则描述：",
			"name" : "descript",
			"type" : "TextBox",
			"defaultValue" : "",
			"style" : "display:block;float:none;width:60%",
			"readOnly" : true,
		}, {
			"label" : "录入人：",
			"name" : "inputer_name",
			"type" : "TextBox",
			"readOnly" : true,
		}, {
			"label" : "录入人",
			"name" : "inputer",
			"type" : "TextBox",
			"readOnly" : true,
			"visible" : false,
		}, {
			"label" : "审核人：",
			"name" : "auditor_name",
			"type" : "TextBox",
			"readOnly" : true,
			"style" : "display:block;float:none",
		}, {
			"label" : "取消人：",
			"name" : "canceler_name",
			"type" : "TextBox",
			"readOnly" : true,
			"visible" : false,
		}, {
			"label" : "录入日期：",
			"name" : "inputdate",
			"type" : "DatePicker",
			"readOnly" : true,
			"format" : "yyyy-MM-dd HH:mm:ss",
		}, {
			"label" : "审核日期：",
			"name" : "auditdate",
			"type" : "DatePicker",
			"readOnly" : true,
			"format" : "yyyy-MM-dd HH:mm:ss",
		}, {
			"label" : "取消日期：",
			"name" : "canceldate",
			"type" : "DatePicker",
			"readOnly" : true,
			"format" : "yyyy-MM-dd HH:mm:ss",
			"visible" : false,
		} ]
	};

	//条件grid
	var chargeincruledet = {
		"type" : "gridbox",
		"properties" : {
			"id" : "chargeincruledet",
			"multiSelect" : true,
			"allowCellEdit" : true,
			"allowCellSelect" : true,
			"editNextOnEnterKey" : true,
			"editNextRowCell" : true,
			"allowSortColumn" : false,
			"showColumnsMenu" : true,
			"showSummaryRow" : true,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"oncellendedit" : 'OcmControl.datetimeFormate',
			"columns" : [ {
				"label" : "ph_key：",
				"type" : "TextBox",
				"name" : "ph_key",
				"readOnly" : "true",
				"visible" : false,
			}, {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
				"readOnly" : true,
			}, {
				field : "rowno",
				header : "行号",
				headerAlign : "center",
				visible : false,
			}, {
				field : "startyear",
				header : "起始年",
				width : 70,
				required : true,
				allowSort : true,
			  	headerAlign : "center",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n0",
				},
				numberFormat:"n0",
			    align: "center",
			}, {
				field : "endyear",
				header : "结束年",
				width : 70,
				readOnly : true,
				allowSort : true,
			  	headerAlign : "center",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n0",
				},
				numberFormat:"n0",
			    align: "center",
			    visible:false,
			}, {
				field : "baseon",
				header : "基准",
				required : true,
				type : "comboboxcolumn", // 样式属性必须加
				headerAlign : "center",
				editor : OcmControl.newControl('ComboBox'), // 下拉框，控制前缀、后缀、校检位
				width : 100,
				data : dicData.BASEON,
				align : "center",
				renderer : "OcmControl.dictRendererWithCode",
				value : "1",
			},{
				field : "incrtype",
				headerAlign : "center",
				required : true,
				header : "增长方式",
				type : "comboboxcolumn", // 样式属性必须加
				editor : OcmControl.newControl('ComboBox'), // 下拉框，控制前缀、后缀、校检位
				width : 100,
				data : dicData.INCRTYPE,
				align : "center",
				renderer : "OcmControl.dictRendererWithCode",
				value : "1",
			},{
				field : "increaseby",
				header : "增长幅度",
				width : 70,
				required : true,
				allowSort : true,
			  	headerAlign : "center",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n2",
				},
				numberFormat:"n2",
			    align: "right",
			},{
				field : "memo",
				header : "规则描述",
				width : 120,
			  	headerAlign : "center",
			    readOnly : true,
			} ]
		}
	};

	//单据明细
	var tabs2 = {
		properties : {
			id : "tabs2",
		},
		items : [ {
			"title" : "单据明细",
			"name" : "chargeincruledet",
			"control" : chargeincruledet
		} ]
	};

	//单据明细组成：单据头+单据明细tab
	var details1 = {
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mall.work.chargeincrule.get",
		"response" : "chargeincrulehd",
		"properties" : {
			"id" : "details1",
		},
		"items" : formheader1.items, //绑定到具体的项
		"tabs" : tabs2, //直接绑定tab

	};

	//单据列表和单据明细
	var tabs1 = {
		properties : {
			"id" : "tabs1"
		},
		items : [ {
			"title" : "单据列表",
			"name" : "ListGrid",
			"control" : gridbox2,
		}, {
			"title" : "单据明细",
			"name" : "details1",
			"control" : details1,
		} ]
	};

	var config1 = {
		"properties" : {
			"id" : "config1",
		},
		"toolbar" : toolbar1,
		"tabs" : tabs1,

	};
	</script>

	<script src="chargeincrule.js" type="text/javascript"></script>

</body>
</html>