/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('binvoice.view');

	// 定义一个对象用来配置界面
	var bill = {};
	var billtype=getBilltype(app.modulecode);
	
	var fpsource = [{code:"01",name:"费用发票生成(实收)"},{code:"02",name:"费用发票生成(应收)"},{code:"03",name:"结算单审核时自动生成"}];
	
	// 把定义对象放到命名空间下
	ns.bill = bill;
	
	utils.billtype = billtype;
	
	// 查询列表
	bill.binvoicelist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.work.binvoicehead.search",
		"response": "binvoicehead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billtype" : billtype,
			"order_field": "inputdate",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('binvoicelist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
			}, {
				field: "billtype",
				type: "TextBox",
				headerAlign: "center",
				header: "单据类型",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLTYPE',
				visible:false,
				enabledSearch : false,
				width: 150,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
			}, {
				field: "muid",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible:true,
				enabledSearch : true,
				width : 200,
			}, {
				field: "muid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				visible:false,
				enabledSearch : false,
			}, {
				field: "sbid",
				type: "TextBox",
				headerAlign: "center",
				header: "商户",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "sbid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"sbid"},
				visible:true,
				enabledSearch : true,
				width: 200,
			}, {
				field: "sbid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "商户",
				visible:false,
				enabledSearch : false,
			}, {
				field: "fpcode",
				type: "TextBox",
				headerAlign: "center",
				header: "发票代码",
				enabledSearch : false,
				width: 150,
			}, {
				field: "fpmin",
				type: "TextBox",
				headerAlign: "center",
				header: "发票开始序号",
				enabledSearch : false,
				width: 150,
			} , {
				field: "fpmax",
				type: "TextBox",
				headerAlign: "center",
				header: "发票结束序号",
				enabledSearch : false,
				width: 150,
			},{
				field : "fpsource",
				header : "单据来源",
				allowSort : true,
				headerAlign : "center",
				width : 120,
				renderer: "OcmControl.dictRendererWithCode",
				data :fpsource
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 200,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 200,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "canceler",
				header : "取消人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
			}, {
				field : "canceler_name",
				header : "取消人",
				width : 200,
				allowSort : true,
				headerAlign : "center",
			}, {
				field : "canceldate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "取消日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "bsimemo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				visible : false,
			}]
		}
	};
	
	// 单据主表
	bill.binvoicehead = {
		"type": "formgrid",
		"initHeight" : 0.5,
		"resources": OmdUrl.mall,
		"name": 'binvoicehead',
		"method": "mss.work.binvoicehead.get",
		"response": "binvoicehead",
		"properties": {
			"id": utils.createid('binvoicehead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "ComboBox",
				"defaultValue": billtype,
				dictkey: 'BILLTYPE',
				"visible": false,
				"readOnly": true,
			}, {
				"lable": "billmoduleid",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": app.modulecode,
				"visible": false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, {
				"label": "单据状态：",
				"name": "billflag",
				"type": "ComboBox",
				"readOnly": true,
				"defaultValue": "N",
				"visible": false,
			}, {
				"label": "门店：",
				"name": "muid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "muid",
				textName: "muid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_muid",
				itemchangedfunc:"page.head_itemchangedfunc",
				readOnly: true,
			}, {
				"label": "门店：",
				"name": "muid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label": "商户：",
				"name": "sbid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "sbid",
				textName: "sbid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_sbid",
				itemchangedfunc:"page.head_itemchangedfunc",
				readOnly: true,
			}, {
				"label": "商户名称：",
				"name": "sbid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label": "发票类型：",
				"name": "fptype",
				"type": "ComboBox",
				"dictkey" : "INVOICETYPE",
				readOnly: true,
				"visible": true,
			}/*, {
				"label": "税率：",
				"name": "hl",
				"type": "NumButtonEdit",
				"format":"p2",
				readOnly: true,
				"visible": true,
			}*/, {
				"label": "发票开始序号：",
				"name": "fpmin",
				"type": "TextBox",
				readOnly: true,
				"visible": true,
			}, {
				"label": "发票结束序号：",
				"name": "fpmax",
				"type": "TextBox",
				readOnly: true,
				"visible": true,
				/*style : "display:block;float:none",*/
			}, {
				"label" : "单据来源：",
				"type" : "ComboBox",
				"name" : "fpsource",
				"enabled" : true,
				"data" : fpsource,
				"readOnly": true,
			}, {
				"label": "不含税金额：",
				"name": "bibhsje",
				"type" : "NumButtonEdit",
				"defaultValue" : "0",
				"format":"c2",
				readOnly: true,
				"visible": true,
			}, {
				"label": "含税金额：",
				"name": "money",
				"type" : "NumButtonEdit",
				"defaultValue" : "0",
				"format":"c2",
				readOnly: true,
				"visible": true,
			}, {
				"label": "税额：",
				"name": "bise",
				"type" : "NumButtonEdit",
				"defaultValue" : "0",
				"format":"c2",
				readOnly: true,
				"visible": true,
			}, {
				"label": "发票代码：",
				"name": "fpcode",
				"type": "TextBox",
				"visible": true,
			}, {
				"label": "大写金额：",
				"name": "moneyupper",
				"type": "TextBox",
				readOnly: true,
				"visible": true,
				style : "width:60%; display:block;float:none",
			}, {
				"label": "发票抬头：",
				"name": "sbfptt",
				"type": "TextBox",
				/*readOnly: true,*/
				"visible": true,
			}, {
				"label": "发票地址：",
				"name": "sbfpadd",
				"type": "TextBox",
				/*readOnly: true,*/
				"visible": true,
				"style" : "width:60%; display:block;float:none",
			}, {
				"label": "备注：",
				"name": "fpmemo",
				"type": "TextBox",
				/*readOnly: true,*/
				"visible": true,
				"style" : "width:90%; display:block;float:none",
			}, {
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
			}, {
				"label": "取消人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "取消日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}
		]
	}
	// 单据明细
	bill.binvoicedetail= {
			title: '单据明细',
			"type": "gridbox",
			name: 'binvoicedetail',
			"properties": {
				"id": utils.createid('binvoicedetail'),
				"multiSelect": "true",
				"allowCellEdit": "true",
				"allowCellSelect": "true",
				"editNextOnEnterKey": "true",
				"editNextRowCell": "true",
				"allowSortColumn": "false",
				"allowCellValid": true,
				"sortMode": "client",
				//"showPager": true,
				//"showSummaryRow": true,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
				}, {
					type: "indexcolumn",
					name: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: 30,
				}/*, {
					field: "browno",
					headerAlign: "center",
					align: "center",
					header: "行号",
					dataType: "int",
					allowSort: true,
					readOnly: true,
					visible: false,
				}*/, {
					field : "kptype",
					headerAlign : "center",
					header : "开票科目",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					dictkey : 'FYKPTYPE',
					allowSort : false,
					readOnly: true,
					width : 120,
					renderer : "OcmControl.dictRendererWithCode",
				}/*, {
					field: "setbillno",
					name: "setbillno",
					header: "结算单号",
					headerAlign: "center",
					allowSort: true,
					readOnly:true,
					width: "160",
				}, {
					field: "contno",
					name: "contno",
					header: "合同号",
					headerAlign: "center",
					allowSort: true,
					readOnly:true,
					width: "120",
				}, {
					field: "itemcode",
					name: "itemcode",
					header: "费用项目",
					headerAlign: "center",
					allowSort: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "itemcode_name",
	                width: "160",
	                editorSet: {
	                    selectkey: 'cccode',
	                },
	                readOnly:true,
				}, {
					field: "itemcode_name",
					name: "itemcode_name",
					header: "费用项目名称",
					headerAlign: "center",
					width: "150",
					visible: false
				}, {
					field : "startdate",
					name: "startdate",
					header : "开始日期",
					width : 100,
					allowSort : true,
					headerAlign : "center",
					align : "center",
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					editorSet:{format:"yyyy-MM-dd",},
					readOnly:true,
				}, {
					field : "enddate",
					name: "enddate",
					header : "结束日期",
					width : 100,
					allowSort : true,
					headerAlign : "center",
					align : "center",
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					editorSet:{format:"yyyy-MM-dd",},
					readOnly:true,
				}*/, {
	                field: "hl",
	                name: "hl",
	                header: "税率",
	                headerAlign: "center",
					width: 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "p2",},
					numberFormat:"p2",
					defaultValue : "0",
					align : "right",
					readOnly:true
	            }, {
	                field: "ysamount",
	                name: "ysamount",
	                header: "不含税金额",
	                headerAlign: "center",
					width: 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly:true
	            }, {
	                field: "fsamount",
	                name: "fsamount",
	                header: "含税金额",
	                headerAlign: "center",
					width: 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly:true
	            }, {
	                field: "se",
	                name: "se",
	                header: "税额",
	                headerAlign: "center",
					width: 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly:true
	            } ]
			},
		};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [/*btn.addData, */btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData, btn.cancelData,
			btn.separator, btn.searchData
		]
	}
	
	
	// 单据配置
	bill.billconfig = {
		billhead: bill.binvoicehead, // 单据主表
		billdetail: [bill.binvoicedetail], // 单据明细表
		billquerylist: bill.binvoicelist, // 查询列表
		dettabpages: [bill.binvoicedetail], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
