/**
 * 返租合同
 */
(function() {
	// 合同录入命名空间
	/** @namespace Future.lbbcontract.ment */
	var ns = Future.ns('lbbcontract.ment');
	var utils = Future.ns('Future.utils');

	var lbbcontmain = mini.get("lb_bcontmain");
	var lbbcontmanaframe = mini.get("lb_bcontmanaframe");
	var lbbcontqs = mini.get("lb_bcontqs");
	var lbbcontsupcharge = mini.get("lb_bcontsupcharge");
	var lbbcontquerylist = mini.get("lbbcontquerylist");

	billtype = getBilltype(app.modulecode);
	// 单据类型124,返租合同申请单(租金池);单据类型125,返租合同变更单(租金池);模块号400207,返租合同查询;单据类型126,返租合同终止单(租金池)
	var billtypeormoduleid = {
			insert : '124',
			update : '125',
			search : '400207',
			isvoid : '126'
		}

	/**
	 * 返租合同新增
	 * 
	 * @constructor
	 */
	var LbbcontractPlan = function() {
		LbbcontractPlan.superclass.constructor.call(this);
		this.servicekey = 'mss';
		this.head_beforefunc = this.head_beforefunc.bind(this);
		this.head_itemchangedfunc = this.head_itemchangedfunc.bind(this);
		this.head_valuechanged = this.head_valuechanged.bind(this);
		this.onContnoChanged = this.onContnoChanged.bind(this);
		this.det_beforefunc = this.det_beforefunc.bind(this);
		this.det_itemchanged = this.det_itemchanged.bind(this);
	};

	ns.LbbcontractPlan = LbbcontractPlan;
	Future
			.extend(
					ns.LbbcontractPlan,
					Future.pub.Basebill,
					{
						initdict : function() {
							Future.Pub.DictSrv.data.SETTLEDAY = getSettleday();
							if (billtype == billtypeormoduleid.insert
									|| billtype == billtypeormoduleid.update) {
								var fitllbcmfzfsdata = [];
								var sptypedictdata = Future.Pub.DictSrv.data.LBCMFZFS;
								for (var i = 0; i < sptypedictdata.length; i++) {
									if (sptypedictdata[i].pro1 == "1") {
										fitllbcmfzfsdata
												.push(sptypedictdata[i]);
									}
								}
								Future.Pub.DictSrv.data.LBCMFZFS = fitllbcmfzfsdata;
							}
						},
						addDataBefore : function(data) {
							var flag = false;
							var that = this
							if (billtype == billtypeormoduleid.update) {
								var url = "/mall-business-ui/pages/leaseback/lbupdate-view.jsp?billmoduleid="
										+ app.modulecode
										+ "&inputer="
										+ getUserCode()
										+ "&inputer_name="
										+ getUserName();
								if (app.token && app.token != "")
								{
									url = url + "&token="+ app.token;
								}
								if (app.srvkey && app.srvkey != "")
								{
									url = url + "&srvkey="+ app.srvkey;
								}
								mini.open({
									url : encodeURI(url),
									title : "合同修订",
									width : 400,
									height : 120,
									onload : function() {
										var iframe = this.getIFrameEl();
									},
									ondestroy : function(ph_key) {
										if (ph_key != undefined && ph_key != ""
												&& ph_key != "close") {
											that.lb_bcontmain.getResources({
												ph_key : ph_key
											});
											flag = true;
											that.systab.setActiveIndex(1);
											that.editData();
											setTimeout(" ", 300);
										}
									}
								});
							}

							if (flag) {
								return {};
							} else {
								if (billtype == billtypeormoduleid.insert
										|| billtype == billtypeormoduleid.isvoid) {
									return {};
								} else {
									return;
								}
							}
						},
						saveDataBefore : function(data) {
							if (billtype == billtypeormoduleid.insert 
									|| billtype == billtypeormoduleid.update) {
								if (this.lb_bcontmanaframe.getData().length == 0) {
									mini.alert("返租明细不能为空！");
									return;
								} else {
									var lbtze = this.lb_bcontmain.form
									.getField('lbtze').value;
									var bcontmanaframe = this.lb_bcontmanaframe
											.getData();
									for (var i = 0; i < bcontmanaframe.length; i++) {
										var sdate = bcontmanaframe[i].sdate;
										var edate = bcontmanaframe[i].edate;
										var lbcmfzfs = bcontmanaframe[i].lbcmfzfs;
										var lbcmbdbl = bcontmanaframe[i].lbcmbdbl;
										var lbcmbdje = bcontmanaframe[i].lbcmbdje;
										var lbcmbdcebl = bcontmanaframe[i].lbcmbdcebl;
										var cbrate1 = bcontmanaframe[i].cbrate1;
										if (sdate == null || sdate == " ") {
											mini.alert("第" + (i + 1)
													+ "行返租明细【开始日期】为空，请检查");
											return;
										}
										if (edate == null || edate == " ") {
											mini.alert("第" + (i + 1)
													+ "行返租明细【结束日期】为空，请检查");
											return;
										}
										if (lbcmfzfs == null || lbcmfzfs == " ") {
											mini.alert("第" + (i + 1)
													+ "行返租明细【返租方式】为空，请检查");
											return;
										}
										if (lbcmfzfs == '01' || lbcmfzfs == '03' || lbcmfzfs == '04' || lbcmfzfs == '05') {
											if (parseInt(lbtze) == "0") {
												mini.alert("合同【投资额】请输入大于0的金额，请检查");
												return;
											}
										}
										if (lbcmbdbl && Number(lbcmbdbl) != 0) {
											if(isNaN(lbcmbdbl)){
												mini.alert("第" + (i + 1)
														+ "行返租明细【固定收益回报率】为空，请检查");
												return;
											}
										} else {
											if (Number(lbcmbdbl) != 0) {
												mini.alert("第" + (i + 1)
														+ "行返租明细【固定收益回报率】为空，请检查");
												return;
											}
										}
										if (lbcmbdje && Number(lbcmbdje) != 0) {
											if(isNaN(lbcmbdje)){
												mini.alert("第" + (i + 1)
														+ "行返租明细【固定收益年回报金额】为空，请检查");
												return;
											}
										} else {
											if (Number(lbcmbdje) != 0) {
												mini.alert("第" + (i + 1)
														+ "行返租明细【固定收益年回报金额】为空，请检查");
												return;
											}
										}
										if (lbcmbdcebl && Number(lbcmbdcebl) != 0) {
											if(isNaN(lbcmbdcebl)){
												mini.alert("第" + (i + 1)
														+ "行返租明细【分成比率】为空，请检查");
												return;
											}
										} else {
											if (Number(lbcmbdcebl) != 0) {
												mini.alert("第" + (i + 1)
														+ "行返租明细【分成比率】为空，请检查");
												return;
											}
										}
										if (cbrate1 && Number(cbrate1) != 0) {
											if(isNaN(cbrate1)){
												mini.alert("第" + (i + 1)
														+ "行返租明细【超额比例】为空，请检查");
												return;
											}
										} else {
											if (Number(cbrate1) != 0) {
												mini.alert("第" + (i + 1)
														+ "行返租明细【超额比例】为空，请检查");
												return;
											}
										}
									}
									var bcontqs = this.lb_bcontqs.getData();
									for (var i = 0; i < bcontqs.length; i++) {
										var sdate = bcontqs[i].sdate;
										var edate = bcontqs[i].edate;
										var lbcqsmode = bcontqs[i].lbcqsmode;
										var lbcmfzfs = bcontqs[i].lbcmfzfs;
										var lbcmbdbl = bcontqs[i].lbcmbdbl;
										var lbcmbdje = bcontqs[i].lbcmbdje;
										var lbcmbdcebl = bcontqs[i].lbcmbdcebl;
										var cbrate = bcontqs[i].cbrate;
										if (sdate == null || sdate == " ") {
											mini.alert("第" + (i + 1)
													+ "行清算条款【开始日期】为空，请检查");
											return;
										}
										if (edate == null || edate == " ") {
											mini.alert("第" + (i + 1)
													+ "行清算条款【结束日期】为空，请检查");
											return;
										}
										if (lbcqsmode == null
												|| lbcqsmode == " ") {
											mini.alert("第" + (i + 1)
													+ "行清算条款【清算模式】为空，请检查");
											return;
										}
										if (lbcmfzfs == null || lbcmfzfs == " ") {
											mini.alert("第" + (i + 1)
													+ "行清算条款【返租方式】为空，请检查");
											return;
										}
										if (lbcmfzfs == '01' || lbcmfzfs == '03' || lbcmfzfs == '04' || lbcmfzfs == '05') {
											if (parseInt(lbtze) == "0") {
												mini.alert("合同【投资额】请输入大于0的金额，请检查");
												return;
											}
										}
										if (lbcmbdbl && Number(lbcmbdbl) != 0) {
											if(isNaN(lbcmbdbl)){
												mini.alert("第" + (i + 1)
														+ "行清算条款【固定收益回报率】为空，请检查");
												return;
											}
										} else {
											if (Number(lbcmbdbl) != 0) {
												mini.alert("第" + (i + 1)
														+ "行清算条款【固定收益回报率】为空，请检查");
												return;
											}
										}
										if (lbcmbdje && Number(lbcmbdje) != 0) {
											if(isNaN(lbcmbdje)){
												mini.alert("第" + (i + 1)
														+ "行清算条款【固定收益回报金额】为空，请检查");
												return;
											}
										} else {
											if (Number(lbcmbdje) != 0) {
												mini.alert("第" + (i + 1)
														+ "行清算条款【固定收益回报金额】为空，请检查");
												return;
											}
										}
										if (lbcmbdcebl && Number(lbcmbdcebl) != 0) {
											if(isNaN(lbcmbdcebl)){
												mini.alert("第" + (i + 1)
														+ "行清算条款【分成比率】为空，请检查");
												return;
											}
										} else {
											if (Number(lbcmbdcebl) != 0) {
												mini.alert("第" + (i + 1)
														+ "行清算条款【分成比率】为空，请检查");
												return;
											}
										}
										if (cbrate && Number(cbrate) != 0) {
											if(isNaN(cbrate)){
												mini.alert("第" + (i + 1)
														+ "行清算条款【超额比例】为空，请检查");
												return;
											}
										} else {
											if (Number(cbrate) != 0) {
												mini.alert("第" + (i + 1)
														+ "行清算条款【超额比例】为空，请检查");
												return;
											}
										}
									}
									var bcontsupcharge = this.lb_bcontsupcharge
											.getData();
									for (var i = 0; i < bcontsupcharge.length; i++) {
										var cccode = bcontsupcharge[i].cccode;
										var sdate = bcontsupcharge[i].sdate;
										var edate = bcontsupcharge[i].edate;
										var lbcmismcjs = bcontsupcharge[i].lbcmismcjs;
										var lbjftype = bcontsupcharge[i].lbjftype;
										var lbcmvalue = bcontsupcharge[i].lbcmvalue;
										if (cccode == null || cccode == " ") {
											mini.alert("第" + (i + 1)
													+ "行合同费用【费用项目】为空，请检查");
											return;
										}
										if (sdate == null || sdate == " ") {
											mini.alert("第" + (i + 1)
													+ "行合同费用【开始日期】为空，请检查");
											return;
										}
										if (edate == null || edate == " ") {
											mini.alert("第" + (i + 1)
													+ "行合同费用【结束日期】为空，请检查");
											return;
										}
										if (lbjftype == null || lbjftype == " ") {
											mini.alert("第" + (i + 1)
													+ "行合同费用【费用提取方式】为空，请检查");
											return;
										}
										if (lbcmismcjs == null
												|| lbcmismcjs == " ") {
											mini.alert("第" + (i + 1)
													+ "行合同费用【收取方式】为空，请检查");
											return;
										}
										if (lbcmvalue && Number(lbcmvalue) != 0) {
											if(isNaN(lbcmvalue)){
												mini.alert("第" + (i + 1)
														+ "行合同费用【比例/金额】为空，请检查");
												return;
											}
										} else {
											if (Number(lbcmvalue) != 0) {
												mini.alert("第" + (i + 1)
														+ "行合同费用【比例/金额】为空，请检查");
												return;
											}
										}
									}
									if (!checkdetailSave(bcontmanaframe,
											"sdate", "edate",
											CONSTANT_GRID1_NAME)) {
										return;
									}
									if (!checkdetailSave(bcontqs, "sdate",
											"edate", CONSTANT_GRID2_NAME)) {
										return;
									}
									if (!checkdetailSave(bcontsupcharge,
											"sdate", "edate",
											CONSTANT_GRID3_NAME)) {
										return;
									}
									// 单头时间check
									var that = this;
									if (!saveCheck(that)) {
										return;
									}
									return {};
								}
							} else {
								return {};
							}
						},
						transformSaveData : function(data) { // transformSaveData
							var obj = {};

							if (this.lb_bcontmanaframe) {
								obj.lb_bcontmanaframe = this.lb_bcontmanaframe
										.getData();
								setGridData(obj.lb_bcontmanaframe);
							}

							if (this.lb_bcontqs) {
								obj.lb_bcontqs = this.lb_bcontqs.getData();
								setGridData(obj.lb_bcontqs);
							}

							if (this.lb_bcontsupcharge) {
								obj.lb_bcontsupcharge = this.lb_bcontsupcharge
										.getData();
								setGridData(obj.lb_bcontsupcharge);
							}

							var muid = this.lb_bcontmain.form.getField('muid').value;
							var contno = this.lb_bcontmain.form.getField('contno').value;
							// qz 如果需要前缀在里面新增，先设置问空
							/*var qz = "";*/
							var headdata = "";
							if (contno == undefined || contno == "") {
								/*contno = getContno(app.modulecode, qz);*/
								var contrule = getInfoRule(app.modulecode);
								if(contrule && contrule.length>0){
									  var that = this;
									  var head = that.lb_bcontmain;
									  headdata = head.getChangedData();
								}	
								  //合同号有重复时自动获取下一个合同号
								  var chkno = true;
								  while(chkno){
									  contno = getContno(app.modulecode,headdata); //获取合同号
									  if (GetLength(contno)>20) {
											mini.alert("生成的合同号("+contno+")，长度大于20，请重新设置规则！");
											return;
									  }
									  chkno = checkContno(contno,''); //检查合同号是否存在(自动编码和手工编码切换时可能产生重复号码)
								  }
								  if(contno == undefined || contno == ""){
									  mini.alert("合同号不能为空！");
									  return;
								  }else{
									  obj.contno = contno;
									  data.contno = contno;  
								  }
								// this.lb_bcontmain.form.getField('contno').setValue(contno);
							}

							if (obj.lb_bcontmanaframe != undefined
									&& obj.lb_bcontmanaframe.length > 0) {
								setMktContno(contno, muid,
										obj.lb_bcontmanaframe);
							}
							if (obj.lb_bcontqs != undefined
									&& obj.lb_bcontqs.length > 0) {
								setMktContno(contno, muid, obj.lb_bcontqs);
							}
							if (obj.lb_bcontsupcharge != undefined
									&& obj.lb_bcontsupcharge.length > 0) {
								setMktContno(contno, muid,
										obj.lb_bcontsupcharge);
							}

							return obj;
						},
						head_beforefunc : function(e) {
							var ownerid = this.lb_bcontmain.form.getField('ownerid').value;
							var muid = this.lb_bcontmain.form.getField('muid').value;
							if (!e.searchParam) {
								e.searchParam = {};
							}
							var buttonEdit = e.sender;

							if (e.value != "undefined" || e.value != "") {
								e.searchParam.code = e.value;
							}

							// console.log(e);
							// 判断明细是否有数据,如果有数据，必须先删除了，再才能修改
							if (e.sender.name == 'ownerid') {
								if (billtype == billtypeormoduleid.insert 
										|| billtype == billtypeormoduleid.update) {
									if (this.lb_bcontmanaframe.data.length > 0) {
										mini.alert("返租明细已存在数据,请先删除后再修改业主");
										e.cancel = true;
										return -1;
									}
								}
								if ((billtype == billtypeormoduleid.insert)&&(muid == "")) {
									mini.alert("请先选择门店");
									return -1;
								}
								if (muid != "") {
									e.searchParam.wherestr = "Ownermkt.Muid = '" + muid + "'";
								}
							}
							if (e.sender.name == 'muid') {
								if (billtype == billtypeormoduleid.insert 
										|| billtype == billtypeormoduleid.update) {
									if (this.lb_bcontmanaframe.data.length > 0) {
										mini.alert("返租明细已存在数据,请先删除后再修改门店");
										e.cancel = true;
										return -1;
									}
								}
							}
							if (e.sender.name == 'lbspid') {
								if (billtype == billtypeormoduleid.insert 
										|| billtype == billtypeormoduleid.update) {
									if (this.lb_bcontmanaframe.data.length > 0) {
										mini.alert("返租明细已存在数据,请先删除后再修改租金池");
										e.cancel = true;
										return -1;
									}
								}
								if (muid == "") {
									mini.alert("请先选择门店！");
									e.cancel = true;
									return -1;
								}
								e.searchParam.muid = muid;
							}
							if (e.sender.name == 'contno') {
								if (billtype == billtypeormoduleid.isvoid) {
									if (muid != "") {
										e.searchParam.wherestr = "a.Muid = '"
												+ muid
												+ "' And a.Contstatus In ('Y','S') and a.billmoduleid = '" + billtypeormoduleid.search + "' ";
									} else {
										e.searchParam.wherestr = "a.Contstatus In ('Y','S') and a.billmoduleid = '" + billtypeormoduleid.search + "' ";
									}
								}else{
									e.searchParam.wherestr = "a.billmoduleid = '" + billtypeormoduleid.search + "' ";
								}
							}
						},
						head_itemchangedfunc : function(e, data) {
							// 修改业主之后门店清空
							var colname = e.sender.name;
							if (colname == 'muid') {
								if(billtype != billtypeormoduleid.insert){
									this.lb_bcontmain.setValue('contno', "");
									this.lb_bcontmain.setText('contno', "");
								}								
								this.lb_bcontmain.setValue('ownerid', "");
								this.lb_bcontmain.setText('ownerid', "");
								this.lb_bcontmain.setValue('lbspid', "");
								this.lb_bcontmain.setText('lbspid', "");
								if (billtype == billtypeormoduleid.isvoid) {
									this.lb_bcontmain.setValue('lbctype', "");
									this.lb_bcontmain.setValue('lbfzmj', "");
									this.lb_bcontmain.setValue('lbtze', "");
									this.lb_bcontmain.setValue('lbbdbl', "");
									this.lb_bcontmain.setValue('lbbdje', "");
									this.lb_bcontmain.setValue('ceffdate', "");
									this.lb_bcontmain.setValue('clapdate', "");
								}
							}
							if (colname == 'ownerid') {

							}
							if (colname == 'lbspid') {
								/*
								 * if(data.length > 0){
								 * this.lb_bcontmain.setValue('lbfzmj',
								 * data[0].lbpjzarea); }
								 */
							}
							if (colname == 'contno') {
								if (data.length > 0) {
									this.lb_bcontmain.setValue('muid',
											data[0].muid);
									this.lb_bcontmain.setText('muid',
											data[0].muid_name);
									this.lb_bcontmain.setValue('lbctype',
											data[0].lbctype);
									this.lb_bcontmain.setValue('ownerid',
											data[0].ownerid);
									this.lb_bcontmain.setText('ownerid',
											data[0].ownerid_name);
									this.lb_bcontmain.setValue('lbspid',
											data[0].lbspid);
									this.lb_bcontmain.setText('lbspid',
											data[0].lbspid_name);
									this.lb_bcontmain.setValue('lbfzmj',
											data[0].lbfzmj);
									this.lb_bcontmain.setValue('lbtze',
											data[0].lbtze);
									this.lb_bcontmain.setValue('lbbdbl',
											data[0].lbbdbl);
									this.lb_bcontmain.setValue('lbbdje',
											data[0].lbbdje);
									this.lb_bcontmain.setValue('ceffdate',
											data[0].ceffdate);
									this.lb_bcontmain.setValue('clapdate',
											data[0].clapdate);
								}
							}
							return 1;
						},
						head_valuechanged : function(e, data) {
							var colname = e.sender.name;
							var colvalue = e.value;
							var oldcolvalue = e.sender.oldValue;
							var that = this;
							changeView(colname, colvalue, that, oldcolvalue);
						},
						onContnoChanged : function(e,data){
							//检查合同号是否重复
							var billno = this.lb_bcontmain.form.getField('billno').value;
							var contnovalue = e.value;
							if(contnovalue){
								if (checkContno(contnovalue,billno)) {
									  mini.alert("已经存在合同号["+contnovalue+"],请重新输入");
									  this.lb_bcontmain.form.getField("contno").setValue("");
								  } 
							}
						},
						det_beforefunc : function(e) {
							var muid = this.lb_bcontmain.form.getField('muid').value;
							if (!e.searchParam) {
								e.searchParam = {};
							}
							var buttonEdit = e.sender;

							if (e.value != "undefined" && e.value != "") {
								e.searchParam.code = e.value;
							}
							if (buttonEdit.name == "cccode") {
								if (!muid) {
									mini.alert("请先输入门店");
									return -1;
								}
								e.searchParam.wherestr = "Cctstatus = '1' And Ccdeftype != 'D'";
							}

							return 0;
						},
						det_itemchanged : function(e, data) {
							if (e.sender.name == 'cccode') {
								var that = this;
								var row = this.lb_bcontsupcharge.getSelected();
								if (data.length > 0) {
										var newrow = {
											lbjftype : data[0].ccdeftype,
											lbcmvalue : data[0].cctdefvalue,
										};
										this.lb_bcontsupcharge.updateRow(row,
												newrow);
								}
							}
							return 0;
						},
						initevent : function() {
							LbbcontractPlan.superclass.initevent.call(this);
							if (billtype == billtypeormoduleid.insert || billtype == billtypeormoduleid.update) {
								this.lb_bcontmanaframe.on('cellcommitedit',
										this.lbbcellcommitedit, this);
								this.lb_bcontqs.on('cellcommitedit',
										this.lbbcellcommitedit, this);
								this.lb_bcontsupcharge.on('cellcommitedit',
										this.lbbcellcommitedit, this);
								this.lb_bcontmanaframe.on('cellbeginedit',
										this.oncellbeginedit, this);
								this.lb_bcontqs.on('cellbeginedit',
										this.oncellbeginedit, this);

								this.lb_bcontmanaframe.addNewRowBefore = function() {
									var form = this.businessobj.lb_bcontmain.form;
									form.validate();
									if (form.isValid() == false) {
										mini.alert("请先输入表头必填项目");
										return;
									}
									var ceffdate = this.businessobj.lb_bcontmain.form
											.getField('ceffdate').value;
									var clapdate = this.businessobj.lb_bcontmain.form
											.getField('clapdate').value;
									var lbbdbl = this.businessobj.lb_bcontmain.form
											.getField('lbbdbl').value;
									var lbbdje = this.businessobj.lb_bcontmain.form
											.getField('lbbdje').value;
									var data = this.getData();
									var obj = {};
									obj.nrowid = getTmdd();
									obj.lbcmbdbl = lbbdbl;
									obj.lbcmbdje = lbbdje;
									obj.lbcmbdcebl = "0";
									obj.cbrate1 = "0";
									obj.sdate = mini.formatDate(ceffdate,
											"yyyy-MM-dd");
									obj.edate = mini.formatDate(clapdate,
											"yyyy-MM-dd");
									return obj
								}

								this.lb_bcontqs.addNewRowBefore = function() {
									var form = this.businessobj.lb_bcontmain.form;
									form.validate();
									if (form.isValid() == false) {
										mini.alert("请先输入表头必填项目");
										return;
									}
									var ceffdate = this.businessobj.lb_bcontmain.form
											.getField('ceffdate').value;
									var clapdate = this.businessobj.lb_bcontmain.form
											.getField('clapdate').value;
									var lbbdbl = this.businessobj.lb_bcontmain.form
											.getField('lbbdbl').value;
									var lbbdje = this.businessobj.lb_bcontmain.form
											.getField('lbbdje').value;
									var data = this.getData();
									var obj = {};
									obj.nrowid = getTmdd();
									obj.lbcqsmode = "1";
									obj.lbcmbdbl = lbbdbl;
									obj.lbcmbdje = lbbdje;
									obj.lbcmbdcebl = "0";
									obj.cbrate = "0";
									obj.sdate = mini.formatDate(ceffdate,
											"yyyy-MM-dd");
									obj.edate = mini.formatDate(clapdate,
											"yyyy-MM-dd");
									return obj
								}

								this.lb_bcontsupcharge.addNewRowBefore = function() {
									var form = this.businessobj.lb_bcontmain.form;
									form.validate();
									if (form.isValid() == false) {
										mini.alert("请先输入表头必填项目");
										return;
									}
									var ceffdate = this.businessobj.lb_bcontmain.form
											.getField('ceffdate').value;
									var clapdate = this.businessobj.lb_bcontmain.form
											.getField('clapdate').value;
									var data = this.getData();
									var obj = {};
									obj.nrowid = getTmdd();
									obj.lbcmismcjs = "0";
									obj.sdate = mini.formatDate(ceffdate,
											"yyyy-MM-dd");
									obj.edate = mini.formatDate(clapdate,
											"yyyy-MM-dd");
									return obj
								}
								
								this.lb_bcontmanaframe.deleteRow = function() {
									var rowsData = this.getData();
									var rows = this.getSelecteds();
									if (rows.length > 0) {
										for (var i = 0; i < rows.length; i++) {
											if (rows[i].lbcmstatus == "N") {
												var num = 0;
												for (var j = 0; j < rowsData.length; j++) {
													if (rows[i]._id == rowsData[j]._id) {
														num = j + 1;
														break;
													}
												}
												mini
														.alert("第"
																+ num
																+ "行的返租明细已经被正式合同使用,不能删除,请检查");
												return;
											}
										}
										this.removeRows(rows, false);
									}
								}
								
								this.lb_bcontqs.deleteRow = function() {
									var rowsData = this.getData();
									var rows = this.getSelecteds();
									if (rows.length > 0) {
										for (var i = 0; i < rows.length; i++) {
											if (rows[i].lbcmstatus == "N") {
												var num = 0;
												for (var j = 0; j < rowsData.length; j++) {
													if (rows[i]._id == rowsData[j]._id) {
														num = j + 1;
														break;
													}
												}
												mini
														.alert("第"
																+ num
																+ "行的清算条款已经被正式合同使用,不能删除,请检查");
												return;
											}
										}
										this.removeRows(rows, false);
									}
								}

								this.lb_bcontsupcharge.deleteRow = function() {
									var rowsData = this.getData();
									var rows = this.getSelecteds();
									if (rows.length > 0) {
										for (var i = 0; i < rows.length; i++) {
											if (rows[i].lbcmstatus == "N") {
												var num = 0;
												for (var j = 0; j < rowsData.length; j++) {
													if (rows[i]._id == rowsData[j]._id) {
														num = j + 1;
														break;
													}
												}
												mini
														.alert("第"
																+ num
																+ "行的合同费用已经被正式合同使用,不能删除,请检查");
												return;
											}
										}
										this.removeRows(rows, false);
									}
								}
							}

						},
						_systabChanged : function(e) {
							this.oldsdate = this.lb_bcontmain.form
									.getField('ceffdate').value;
							this.oldedate = this.lb_bcontmain.form
									.getField('clapdate').value;
							this._refreshSysbtnEnable();
						},
						/**
						 * 明细窗口修改 参数说明 cancel:false column:Object editor:ol1OO0
						 * field:"spcode" oldValue:undefined record:Object
						 * row:Object rowIndex:0 sender:OcmControl.GridBox
						 * source:OcmControl.GridBox text:""
						 * type:"cellcommitedit" value:"1221"
						 */
						lbbcellcommitedit : function(e) {

							var record = e.record;
							var value = e.value;
							var grid = e.sender;
							var lbtze = this.lb_bcontmain.form
									.getField('lbtze').value;
							var lbbdbl = this.lb_bcontmain.form
									.getField('lbbdbl').value;
							var lbbdje = this.lb_bcontmain.form
									.getField('lbbdje').value;
							var ceffdate = mini
									.formatDate(this.lb_bcontmain.form
											.getField('ceffdate').value,
											"yyyy-MM-dd");
							var clapdate = mini
									.formatDate(this.lb_bcontmain.form
											.getField('clapdate').value,
											"yyyy-MM-dd");
							if (!lbtze) {
								mini.alert("请先输入投资额");
								e.cancel = true;
								return;
							}
							/*if (!lbbdbl) {
								mini.alert("请先输入年回报率");
								e.cancel = true;
								return;
							}
							if (!lbbdje) {
								mini.alert("请先输入固定金额");
								e.cancel = true;
								return;
							}*/

							// 明细开始日期
							if (e.field == 'sdate') {
								if (e.value && e.row.edate) {
									if (e.row.edate < e.value) {
										if (grid.config.name == "lb_bcontmanaframe") {
											mini.alert("返租明细结束日期不能小于开始日期");
										} else if (grid.config.name == "lb_bcontqs") {
											mini.alert("清算条款结束日期不能小于开始日期");
										} else if (grid.config.name == "lb_bcontsupcharge") {
											mini.alert("合同费用结束日期不能小于开始日期");
										}
										e.cancel = true;
										return -1;
									}
									if (e.value < ceffdate) {
										if (grid.config.name == "lb_bcontmanaframe") {
											mini.alert("返租明细结束日期不能小于单头开始日期");
										} else if (grid.config.name == "lb_bcontqs") {
											mini.alert("清算条款结束日期不能小于单头开始日期");
										} else if (grid.config.name == "lb_bcontsupcharge") {
											mini.alert("合同费用结束日期不能小于单头开始日期");
										}
										e.cancel = true;
										return -1;
									}
									if (!checkdetaildata(grid, "sdate",
											"edate", value, "", record)) {
										e.cancel = true;
										return -1;
									}
								}
							}
							// 返租明细结束日期
							if (e.field == 'edate') {
								if (e.value && e.row.sdate) {
									if (e.row.sdate > e.value) {
										if (grid.config.name == "lb_bcontmanaframe") {
											mini.alert("返租明细结束日期不能小于开始日期");
										} else if (grid.config.name == "lb_bcontqs") {
											mini.alert("清算条款结束日期不能小于开始日期");
										} else if (grid.config.name == "lb_bcontsupcharge") {
											mini.alert("合同费用结束日期不能小于开始日期");
										}
										e.cancel = true;
										return -1;
									}
									if (e.value > clapdate) {
										if (grid.config.name == "lb_bcontmanaframe") {
											mini.alert("返租明细结束日期不能大于单头结束日期");
										} else if (grid.config.name == "lb_bcontqs") {
											mini.alert("清算条款结束日期不能大于单头结束日期");
										} else if (grid.config.name == "lb_bcontsupcharge") {
											mini.alert("合同费用结束日期不能大于单头结束日期");
										}
										e.cancel = true;
										return -1;
									}
									if (!checkdetaildata(grid, "sdate",
											"edate", "", value, record)) {
										e.cancel = true;
										return -1;
									}
								}
							}
							// 明细返租方式
							if (e.field == 'lbcmfzfs') {
								if (e.value) {
									if (e.value == '01' || e.value == '03' || e.value == '04' || e.value == '05') {
										e.row.lbcmbdbl = lbbdbl;
										e.row.lbcmbdje = lbbdje;
										e.row.lbcmbdcebl = Math.round(0 * 100) / 100;
										e.row.cbrate1 = Math.round(0 * 100) / 100;
										e.row.cbrate = Math.round(0 * 100) / 100;
									}
									if (e.value == '02') {
										e.row.lbcmbdbl = Math.round(0);
										e.row.lbcmbdcebl = Math.round(0 * 100) / 100;
										e.row.lbcmbdje = Math.round(0);
										e.row.cbrate1 = Math.round(0 * 100) / 100;
										e.row.cbrate = Math.round(0 * 100) / 100;
									}
								}
							}
							// 明细固定收益回报率
							if (e.field == 'lbcmbdbl') {
								if (lbtze && e.value) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0" || e.value > "1") {
										mini.alert("请输入0到1之间的回报率");
										e.cancel = true;
										return -1;
									}
									e.row.lbcmbdje = Math
											.round((lbtze * e.value) * 100) / 100;
								}
							}
							// 明细固定收益年回报金额
							if (e.field == 'lbcmbdje') {
								if (lbtze && e.value) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0") {
										mini.alert("请输大于0的回报金额");
										e.cancel = true;
										return -1;
									}
									var a = e.value / lbtze;
									e.row.lbcmbdbl = a.toFixed(4);
								}
							}
							// 明细分成比率
							if (e.field == 'lbcmbdcebl') {
								if (e.value) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0" || e.value > "1") {
										mini.alert("请输入0到1之间的分成比率");
										e.cancel = true;
										return -1;
									}
								}
							}
							// 明细收取方式
							if (e.field == 'lbcmismcjs') {
								if (e.value && e.row.lbjftype) {
									if (e.row.lbjftype == "B" && e.value != "0") {
										mini.alert("收取方式只能选择每次");
										e.cancel = true;
										return -1;
									}
								}
							}
							// 超额比例
							if (e.field == 'cbrate') {
								if (e.value && e.row.lbjftype) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0") {
										mini.alert("请输大于0的超额比例");
										e.cancel = true;
										return -1;
									}
									if (e.row.lbjftype == "B") {
										if (e.value > "1") {
											mini.alert("请输入0到1之间的指标");
											e.cancel = true;
											return -1;
										}
									}
								}
							}
							// 明细指标
							if (e.field == 'lbcmvalue') {
								if (e.value && e.row.lbjftype) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0") {
										mini.alert("请输大于零的指标");
										e.cancel = true;
										return -1;
									}
									if (e.row.lbjftype == "B") {
										if (e.value > "1") {
											mini.alert("请输入0到1之间的指标");
											e.cancel = true;
											return -1;
										}
									}
								}
							}
						},
						oncellbeginedit : function(e) {
							var record = e.record;
							var field = e.field;
							if (field == "lbcmbdbl") {
								if (record.lbcmfzfs != undefined
										|| record.lbcmfzfs != "") {
									if (record.lbcmfzfs == "02") {
										e.cancel = true;
									} else {
										e.cancel = false;
									}
								}
							}
							if (field == "lbcmbdje") {
								if (record.lbcmfzfs != undefined
										|| record.lbcmfzfs != "") {
									if (record.lbcmfzfs == "01"
											|| record.lbcmfzfs == "03"
											|| record.lbcmfzfs == "04"
											|| record.lbcmfzfs == "05") {
										e.cancel = false;
									} else {
										e.cancel = true;
									}
								}
							}
							if (field == "lbcmbdcebl") {
								if (record.lbcmfzfs != undefined
										|| record.lbcmfzfs != "") {
									if (record.lbcmfzfs == "02"
											|| record.lbcmfzfs == "03"
											|| record.lbcmfzfs == "04") {
										e.cancel = false;
									} else {
										e.cancel = true;
									}
								}
							}
							if (field == "lbcmismcjs") {
								if (record.cccode == undefined
										|| record.cccode == " ") {
									mini.alert("请先输入费用项目");
									e.cancel = true;
								}
							}
							if (field == "cbrate1") {
								if (record.lbcmfzfs != undefined
										|| record.lbcmfzfs != "") {
									if (record.lbcmfzfs == "05") {
										e.cancel = false;
									} else {
										e.cancel = true;
									}
								}
							}
							if (field == "cbrate") {
								if (record.lbcmfzfs != undefined
										|| record.lbcmfzfs != "") {
									if (record.lbcmfzfs == "05") {
										e.cancel = false;
									} else {
										e.cancel = true;
									}
								}
							}
						},
					});

})();