/**
 * 返租合同 --- 界面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');

	// 商铺修改命名空间
	var ns = Future.ns('lbbcontract.view');

	// 定义一个对象用来配置界面
	var bill = {};
	var wph_key = getUrlParam("ph_key");
	
	var moduleid = app.modulecode;
	
	var billtype = getBilltype(app.modulecode);
	
	//是否自动生成合同号
	 var contnoReadOnly = setContno(app.modulecode);
	 var isautono = true;
	 if (!contnoReadOnly){
		 isautono = true;
	 }else{
		 isautono = false;
	 }

	// 得到下一年减一天
	var snow = new Date();
	var enow = new Date();
	var jnow = new Date();
	enow.setFullYear(enow.getFullYear() + 1);
	enow.setDate(enow.getDate() - 1);
	jnow.setDate(jnow.getDate() - 1);
	var date1 = mini.formatDate(jnow, "yyyyMMdd");
	var month1 = date1.substr(6, 2);
	

	// 单据类型121，返租合同申请单(商铺);单据类型122，返租合同变更单(商铺);模块号400203，返租合同查询(商铺);单据类型123，返租合同终止单(商铺)
	var billtypeormoduleid = {
		insert : '121',
		update : '122',
		search : '400203',   //模块号
		isvoid : '123'
	}
	
//	getBillmoduleid (billtype)

	if (billtype == billtypeormoduleid.insert) {
		$("title").html("返租合同新增单");
	} else if (billtype == billtypeormoduleid.update) {
		$("title").html("返租合同修订单");
	} else if (moduleid == billtypeormoduleid.search) {
		$("title").html("返租合同查询单");
	} else if (billtype == billtypeormoduleid.isvoid) {
		$("title").html("返租合同终止单");
	}

	utils.billmoduleid = billtypeormoduleid;

	// 把定义对象放到命名空间下
	ns.bill = bill;
	// 表头 自定义名称
	if(moduleid == billtypeormoduleid.search){
		bill.lbbcontmain = {
				"title" : '单据详情',
				"name" : 'lb_bcontmain',
				"type" : "formgrid",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.lbcontract.get",
				"response" : "lb_contmain",
				"properties" : {
					"id" : utils.createid('lbbcontmain'),
				},
				items : [
						{
							"id" : "lb_bill",
							"label" : "单据信息",
							"type" : "fieldset",
							"visible" : false,
							"items" : [ {
										"label" : "ph_key：",
										"type" : "TextBox",
										"name" : "ph_key",
										"readOnly" : "true",
										"visible" : false,
									}, {
										"label" : "单据编号：",
										"name" : "billno",
										"type" : "TextBox",
										"required" : "true",
										"readOnly" : true,
									}, {
										"label" : "单据类型：",
										"name" : "billmoduleid",
										"type" : "ComboBox",
										"defaultValue" : app.modulecode,
										dictkey : 'BILLMODULEID',
										"readOnly" : true,
										"visible" : false,
									}, {
										"label" : "单据状态：",
										"name" : "billstatus",
										"type" : "ComboBox",
										dictkey : 'BILLSTATUS',
										"defaultValue" : "N",
										"readOnly" : true,
									}, {
										"label" : "录入人：",
										"name" : "inputer_name",
										"type" : "TextBox",
										"readOnly" : true,
										"defaultValue" : app.username,
									}, {
										"label" : "审核人：",
										"name" : "auditor_name",
										"type" : "TextBox",
										"readOnly" : true,
									}, {
										"label" : "取消人：",
										"name" : "canceler_name",
										"type" : "TextBox",
										"readOnly" : true,
										"visible" : false,
									}, {
										"label" : "手工编号：",
										"name" : "billsgno",
										"type" : "TextBox",
										"readOnly" : false,
										"visible" : true,
									}, {
										"label" : "录入日期：",
										"name" : "inputdate",
										"type" : "DatePicker",
										"readOnly" : true,
										"format" : "yyyy-MM-dd HH:mm:ss",
										"defaultValue" : new Date(),
									}, {
										"label" : "审核日期：",
										"name" : "auditdate",
										"type" : "DatePicker",
										"readOnly" : true,
										"format" : "yyyy-MM-dd HH:mm:ss",
									}, {
										"label" : "取消日期：",
										"name" : "canceldate",
										"type" : "DatePicker",
										"readOnly" : true,
										"format" : "yyyy-MM-dd HH:mm:ss",
										"visible" : false,
									} ]
						},
						{
							"id" : "lb_bcontmain",
							"label" : "返租信息",
							"type" : "fieldset",
							"items" : [ {
										"label" : "合同号：",
										"name" : "contno",
										type : "fut_popselect",
										selectkey : "lbcontnoshop",
										textName : "contno",
										"required" : "true",
										beforefunc : "page.head_beforefunc",
										itemchangedfunc : "page.head_itemchangedfunc",
										"allowInput" : true,
										"readOnly" : true,
										/*"visible" : moduleid === billmoduleid.isvoid ? true
												: false,*/
									}, {
										"label" : "合同类型：",
										"name" : "lbctype",
										"type" : "ComboBox",
										dictkey : 'LBCTYPE',
										// "data" : dictData.SPMODE,
										"defaultValue" : 1,
										"required" : true,
										"readOnly" : false,
									}, {
										"label" : "门店：",
										"name" : "muid",
										type : "fut_popselect",
										selectkey : "muid",
										textName : "muid_name",
										"required" : "true",
										beforefunc : "page.head_beforefunc",
										itemchangedfunc : "page.head_itemchangedfunc",
										allowInput : true,
										"readOnly" : false,
										// "style" : "display:block;float:none",
									}, {
										"label" : "门店名称：",
										"name" : "muid_name",
										"type" : "TextBox",
										"required" : "true",
										"defaultValue" : "",
										visible : false,
									}, {
										"label" : "<a class='New_Button' href='javascript:page.onOwneridShow(2)'><u>业主：</u></a>",
										//"label" : "业主：",
										"name" : "ownerid",
										type : "fut_popselect",
										selectkey : "owner",
										textName : "ownerid_name",
										"required" : "true",
										beforefunc : "page.head_beforefunc",
										itemchangedfunc : "page.head_itemchangedfunc",
										"allowInput" : true,
										"readOnly" : false,
									}, {
										"label" : "业主名称：",
										"name" : "ownerid_name",
										"type" : "TextBox",
										"required" : "true",
										"defaultValue" : "",
										visible : false,
									}, {
										"label" : "投资额：",
										"name" : "lbtze",
										"required" : "true",
										"type" : "NumButtonEdit",
										"defaultValue" : "0",
										"format" : "c2",
										allowInput : true,
										onvaluechanged : "page.head_valuechanged",
										"readOnly" : false,
									}, {
										"label" : "年回报率：",
										"name" : "lbbdbl",
										//"required" : "true",
										"type" : "NumButtonEdit",
										"defaultValue" : "0",
										"format" : "p2",
										// "increment" : "0.01",
										"readOnly" : false,
										onvaluechanged : "page.head_valuechanged",
										"readOnly" : false,
									}, {
										"label" : "固定金额：",
										"name" : "lbbdje",
										//"required" : "true",
										"type" : "NumButtonEdit",
										"defaultValue" : "0",
										"format" : "c2",
										allowInput : true,
										"readOnly" : true,
										"visible" : false,
										// 暂时没用
									}, {
										"label" : "合同开始日期：",
										"name" : "ceffdate",
										"type" : "DatePicker",
										"format" : "yyyy-MM-dd",
										"value" : "",
										"defaultValue" : "",
										onvaluechanged : "page.head_valuechanged",
										"required" : "true",
										"readOnly" : false,
									}, {
										"label" : "合同结束日期：",
										"name" : "clapdate",
										"type" : "DatePicker",
										"format" : "yyyy-MM-dd",
										"value" : "",
										"defaultValue" : "",
										onvaluechanged : "page.head_valuechanged",
										"readOnly" : false,
										"required" : "true",
										"style"    : "display:block;float:none"
									}, {
										"label" : "账单日：",
										"type" : "ComboBox",
										"name" : "settleday",
										dictkey : 'SETTLEDAY',
										"required" : true,
										"defaultValue" : "31",
										"readOnly" : true,
										"visible" : false,
									}, {
										"label" : "合同终止原因：",
										"name" : "ccreason",
										"type" : "ComboBox",
										dictkey : 'CCREASON',
										"defaultValue" : "",
										"required" : true,
										"visible" : true,
									}, {
										"label" : "合同终止日期：",
										"name" : "lbcsigndate",
										"type" : "DatePicker",
										"format" : "yyyy-MM-dd",
										"required" : true,
										"readOnly" : false,
										"visible" : true,
										onvaluechanged : "page.head_valuechanged",
									}, {
										"label" : "合同状态：",
										"name" : "contstatus",
										"type" : "ComboBox",
										dictkey : 'CONTSTATUS',
										// "data" : dictData.SPMODE,
										"defaultValue" : "",
										"required" : true,
										"visible" : true,
										"style" : "display:block;float:none",
									}, {
										"label" : "备注：",
										"name" : "lbcmemo",
										"type" : "TextArea",
										"defaultValue" : "",
										"readOnly" : false,
										"visible" : true,
										"style" : "width:90%",
									} ]
						}

				]
			};
	}else if (billtype == billtypeormoduleid.insert) {
		bill.lbbcontmain = {
				"title" : '单据详情',
				"name" : 'lb_bcontmain',
				"type" : "formgrid",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.lbbcontract.get",
				"response" : "lb_bcontmain",
				"properties" : {
					"id" : utils.createid('lbbcontmain'),
				},
				items : [
						{
							"id" : "lb_bill",
							"label" : "单据信息",
							"type" : "fieldset",
							"visible" : true,
							"items" : [ {
										"label" : "ph_key：",
										"type" : "TextBox",
										"name" : "ph_key",
										"readOnly" : "true",
										"visible" : false,
									}, {
										"label" : "单据编号：",
										"name" : "billno",
										"type" : "TextBox",
										"required" : "true",
										"readOnly" : true,
									}, {
										"label" : "单据类型：",
										"name" : "billtype",
										"type" : "TextBox",
										"defaultValue" : billtype,
										"readOnly" : true,
										"visible" : false,
									}, {
										"label" : "单据类型：",
										"name" : "billmoduleid",
										"type" : "ComboBox",
										"defaultValue" : app.modulecode,
										dictkey : 'BILLMODULEID',
										"readOnly" : true,
										"visible" : false,
									}, {
										"label" : "单据状态：",
										"name" : "billstatus",
										"type" : "ComboBox",
										dictkey : 'BILLSTATUS',
										"defaultValue" : "N",
										"readOnly" : true,
									}, {
										"label" : "录入人：",
										"name" : "inputer_name",
										"type" : "TextBox",
										"readOnly" : true,
										"defaultValue" : app.username,
									}, {
										"label" : "审核人：",
										"name" : "auditor_name",
										"type" : "TextBox",
										"readOnly" : true,
									}, {
										"label" : "取消人：",
										"name" : "canceler_name",
										"type" : "TextBox",
										"readOnly" : true,
										"visible" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "手工编号：",
										"name" : "billsgno",
										"type" : "TextBox",
										"readOnly" : false,
										"visible" : billtype === billtypeormoduleid.isvoid ? false
												: true,
									}, {
										"label" : "录入日期：",
										"name" : "inputdate",
										"type" : "DatePicker",
										"readOnly" : true,
										"format" : "yyyy-MM-dd HH:mm:ss",
										"defaultValue" : new Date(),
									}, {
										"label" : "审核日期：",
										"name" : "auditdate",
										"type" : "DatePicker",
										"readOnly" : true,
										"format" : "yyyy-MM-dd HH:mm:ss",
									}, {
										"label" : "取消日期：",
										"name" : "canceldate",
										"type" : "DatePicker",
										"readOnly" : true,
										"format" : "yyyy-MM-dd HH:mm:ss",
										"visible" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									} ]
						},
						{
							"id" : "lb_bcontmain",
							"label" : "返租信息",
							"type" : "fieldset",
							"items" : [ {
										"label" : "合同号：",
										"name" : "contno",
										"type" : "TextBox",
										"readOnly" : isautono === true ? true : false, 
										"required" : true,
										"onvaluechanged":"page.onContnoChanged",
									}, {
										"label" : "合同类型：",
										"name" : "lbctype",
										"type" : "ComboBox",
										dictkey : 'LBCTYPE',
										// "data" : dictData.SPMODE,
										"defaultValue" : 1,
										"required" : true,
										"readOnly" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "门店：",
										"name" : "muid",
										type : "fut_popselect",
										selectkey : "muid",
										textName : "muid_name",
										"required" : "true",
										beforefunc : "page.head_beforefunc",
										itemchangedfunc : "page.head_itemchangedfunc",
										allowInput : true,
										"readOnly" : billtype === billtypeormoduleid.update ? true
												: false,
										// "style" : "display:block;float:none",
									}, {
										"label" : "门店名称：",
										"name" : "muid_name",
										"type" : "TextBox",
										"required" : "true",
										"defaultValue" : "",
										visible : false,
									}, {
										"label" : "<a class='New_Button' href='javascript:page.onOwneridShow(2)'><u>业主：</u></a>",
										//"label" : "业主：",
										"name" : "ownerid",
										type : "fut_popselect",
										selectkey : "owner",
										textName : "ownerid_name",
										"required" : "true",
										beforefunc : "page.head_beforefunc",
										itemchangedfunc : "page.head_itemchangedfunc",
										"allowInput" : true,
										"readOnly" : billtype === billtypeormoduleid.update || billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "业主名称：",
										"name" : "ownerid_name",
										"type" : "TextBox",
										"required" : "true",
										"defaultValue" : "",
										visible : false,
									}, {
										"label" : "投资额：",
										"name" : "lbtze",
										"required" : "true",
										"type" : "NumButtonEdit",
										"defaultValue" : "0",
										"format" : "c2",
										allowInput : true,
										onvaluechanged : "page.head_valuechanged",
										"readOnly" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "年回报率：",
										"name" : "lbbdbl",
										//"required" : "true",
										"type" : "NumButtonEdit",
										"defaultValue" : "0",
										"format" : "p2",
										// "increment" : "0.01",
										"readOnly" : false,
										onvaluechanged : "page.head_valuechanged",
										"readOnly" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "固定金额：",
										"name" : "lbbdje",
										//"required" : "true",
										"type" : "NumButtonEdit",
										"defaultValue" : "0",
										"format" : "c2",
										allowInput : true,
										"readOnly" : true,
										"visible" : false,
										// 暂时没用
									}, {
										"label" : "合同开始日期：",
										"name" : "ceffdate",
										"type" : "DatePicker",
										"format" : "yyyy-MM-dd",
										"value" : "",
										"defaultValue" : "",
										onvaluechanged : "page.head_valuechanged",
										"required" : "true",
										"readOnly" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "合同结束日期：",
										"name" : "clapdate",
										"type" : "DatePicker",
										"format" : "yyyy-MM-dd",
										"value" : "",
										"defaultValue" : "",
										onvaluechanged : "page.head_valuechanged",
										"readOnly" : billtype === billtypeormoduleid.isvoid ? true
												: false,
										"required" : "true",
										"style"    : "display:block;float:none"
									}, {
										"label" : "账单日：",
										"type" : "ComboBox",
										"name" : "settleday",
										dictkey : 'SETTLEDAY',
										"required" : true,
										"defaultValue" : "31",
										"readOnly" : true,
										"visible" : false,
									}, {
										"label" : "合同终止原因：",
										"name" : "ccreason",
										"type" : "ComboBox",
										dictkey : 'CCREASON',
										"defaultValue" : "",
										"required" : true,
										"visible" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "合同终止日期：",
										"name" : "lbcsigndate",
										"type" : "DatePicker",
										"format" : "yyyy-MM-dd",
										"required" : true,
										"readOnly" : false,
										"visible" : billtype === billtypeormoduleid.isvoid ? true
										: false,
										onvaluechanged : "page.head_valuechanged",
									}, {
										"label" : "合同状态：",
										"name" : "contstatus",
										"type" : "ComboBox",
										dictkey : 'CONTSTATUS',
										// "data" : dictData.SPMODE,
										"defaultValue" : "",
										"required" : true,
										"visible" : false,
										"style" : "",
									}, {
										"label" : "备注：",
										"name" : "lbcmemo",
										"type" : "TextArea",
										"defaultValue" : "",
										"readOnly" : false,
										"visible" : billtype === billtypeormoduleid.isvoid ? false
												: true,
										"style" : "width:90%",
									} ]
						}
	
				]
			};
	}else{
		bill.lbbcontmain = {
				"title" : '单据详情',
				"name" : 'lb_bcontmain',
				"type" : "formgrid",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.lbbcontract.get",
				"response" : "lb_bcontmain",
				"properties" : {
					"id" : utils.createid('lbbcontmain'),
				},
				items : [
						{
							"id" : "lb_bill",
							"label" : "单据信息",
							"type" : "fieldset",
							"visible" : true,
							"items" : [ {
										"label" : "ph_key：",
										"type" : "TextBox",
										"name" : "ph_key",
										"readOnly" : "true",
										"visible" : false,
									}, {
										"label" : "单据编号：",
										"name" : "billno",
										"type" : "TextBox",
										"required" : "true",
										"readOnly" : true,
									}, {
										"label" : "单据类型：",
										"name" : "billtype",
										"type" : "TextBox",
										"defaultValue" : billtype,
										"readOnly" : true,
										"visible" : false,
									}, {
										"label" : "单据类型：",
										"name" : "billmoduleid",
										"type" : "ComboBox",
										"defaultValue" : app.modulecode,
										dictkey : 'BILLMODULEID',
										"readOnly" : true,
										"visible" : false,
									}, {
										"label" : "单据状态：",
										"name" : "billstatus",
										"type" : "ComboBox",
										dictkey : 'BILLSTATUS',
										"defaultValue" : "N",
										"readOnly" : true,
									}, {
										"label" : "录入人：",
										"name" : "inputer_name",
										"type" : "TextBox",
										"readOnly" : true,
										"defaultValue" : app.username,
									}, {
										"label" : "审核人：",
										"name" : "auditor_name",
										"type" : "TextBox",
										"readOnly" : true,
									}, {
										"label" : "取消人：",
										"name" : "canceler_name",
										"type" : "TextBox",
										"readOnly" : true,
										"visible" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "手工编号：",
										"name" : "billsgno",
										"type" : "TextBox",
										"readOnly" : false,
										"visible" : billtype === billtypeormoduleid.isvoid ? false
												: true,
									}, {
										"label" : "录入日期：",
										"name" : "inputdate",
										"type" : "DatePicker",
										"readOnly" : true,
										"format" : "yyyy-MM-dd HH:mm:ss",
										"defaultValue" : new Date(),
									}, {
										"label" : "审核日期：",
										"name" : "auditdate",
										"type" : "DatePicker",
										"readOnly" : true,
										"format" : "yyyy-MM-dd HH:mm:ss",
									}, {
										"label" : "取消日期：",
										"name" : "canceldate",
										"type" : "DatePicker",
										"readOnly" : true,
										"format" : "yyyy-MM-dd HH:mm:ss",
										"visible" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									} ]
						},
						{
							"id" : "lb_bcontmain",
							"label" : "返租信息",
							"type" : "fieldset",
							"items" : [ {
										"label" : "合同号：",
										"name" : "contno",
										type : "fut_popselect",
										selectkey : "lbcontnoshop",
										textName : "contno",
										"required" : "true",
										beforefunc : "page.head_beforefunc",
										itemchangedfunc : "page.head_itemchangedfunc",
										"allowInput" : true,
										"readOnly" : billtype === billtypeormoduleid.isvoid ? false
												: true,
										/*"visible" : moduleid === billmoduleid.isvoid ? true
												: false,*/
									}, {
										"label" : "合同类型：",
										"name" : "lbctype",
										"type" : "ComboBox",
										dictkey : 'LBCTYPE',
										// "data" : dictData.SPMODE,
										"defaultValue" : 1,
										"required" : true,
										"readOnly" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "门店：",
										"name" : "muid",
										type : "fut_popselect",
										selectkey : "muid",
										textName : "muid_name",
										"required" : "true",
										beforefunc : "page.head_beforefunc",
										itemchangedfunc : "page.head_itemchangedfunc",
										allowInput : true,
										"readOnly" : billtype === billtypeormoduleid.update ? true
												: false,
										// "style" : "display:block;float:none",
									}, {
										"label" : "门店名称：",
										"name" : "muid_name",
										"type" : "TextBox",
										"required" : "true",
										"defaultValue" : "",
										visible : false,
									}, {
										"label" : "<a class='New_Button' href='javascript:page.onOwneridShow(2)'><u>业主：</u></a>",
										//"label" : "业主：",
										"name" : "ownerid",
										type : "fut_popselect",
										selectkey : "owner",
										textName : "ownerid_name",
										"required" : "true",
										beforefunc : "page.head_beforefunc",
										itemchangedfunc : "page.head_itemchangedfunc",
										"allowInput" : true,
										"readOnly" : billtype === billtypeormoduleid.update || billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "业主名称：",
										"name" : "ownerid_name",
										"type" : "TextBox",
										"required" : "true",
										"defaultValue" : "",
										visible : false,
									}, {
										"label" : "投资额：",
										"name" : "lbtze",
										"required" : "true",
										"type" : "NumButtonEdit",
										"defaultValue" : "0",
										"format" : "c2",
										allowInput : true,
										onvaluechanged : "page.head_valuechanged",
										"readOnly" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "年回报率：",
										"name" : "lbbdbl",
										//"required" : "true",
										"type" : "NumButtonEdit",
										"defaultValue" : "0",
										"format" : "p2",
										// "increment" : "0.01",
										"readOnly" : false,
										onvaluechanged : "page.head_valuechanged",
										"readOnly" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "固定金额：",
										"name" : "lbbdje",
										//"required" : "true",
										"type" : "NumButtonEdit",
										"defaultValue" : "0",
										"format" : "c2",
										allowInput : true,
										"readOnly" : true,
										"visible" : false,
										// 暂时没用
									}, {
										"label" : "合同开始日期：",
										"name" : "ceffdate",
										"type" : "DatePicker",
										"format" : "yyyy-MM-dd",
										"value" : "",
										"defaultValue" : "",
										onvaluechanged : "page.head_valuechanged",
										"required" : "true",
										"readOnly" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "合同结束日期：",
										"name" : "clapdate",
										"type" : "DatePicker",
										"format" : "yyyy-MM-dd",
										"value" : "",
										"defaultValue" : "",
										onvaluechanged : "page.head_valuechanged",
										"readOnly" : billtype === billtypeormoduleid.isvoid ? true
												: false,
										"required" : "true",
										"style"    : "display:block;float:none"
									}, {
										"label" : "账单日：",
										"type" : "ComboBox",
										"name" : "settleday",
										dictkey : 'SETTLEDAY',
										"required" : true,
										"defaultValue" : "31",
										"readOnly" : true,
										"visible" : false,
									}, {
										"label" : "合同终止原因：",
										"name" : "ccreason",
										"type" : "ComboBox",
										dictkey : 'CCREASON',
										"defaultValue" : "",
										"required" : true,
										"visible" : billtype === billtypeormoduleid.isvoid ? true
												: false,
									}, {
										"label" : "合同终止日期：",
										"name" : "lbcsigndate",
										"type" : "DatePicker",
										"format" : "yyyy-MM-dd",
										"required" : true,
										"readOnly" : false,
										"visible" : billtype === billtypeormoduleid.isvoid ? true
										: false,
										onvaluechanged : "page.head_valuechanged",
									}, {
										"label" : "合同状态：",
										"name" : "contstatus",
										"type" : "ComboBox",
										dictkey : 'CONTSTATUS',
										// "data" : dictData.SPMODE,
										"defaultValue" : "",
										"required" : true,
										"visible" : false,
										"style" : "",
									}, {
										"label" : "备注：",
										"name" : "lbcmemo",
										"type" : "TextArea",
										"defaultValue" : "",
										"readOnly" : false,
										"visible" : billtype === billtypeormoduleid.isvoid ? false
												: true,
										"style" : "width:90%",
									} ]
						}

				]
			};
	}
	
	// 明细 商铺明细
	bill.lbbcontshoplist = {
		"title" : '商铺信息',// tab页面标题
		"name" : moduleid === billtypeormoduleid.search ? 'lb_contshoplist' : 'lb_bcontshoplist',// 名称
		// 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('lbbcontshoplist'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
				field : "nrowid",
				header : "行主键",
				width : 80,
				allowSort : true,
				headerAlign : "center",
				visible : false
			}, {
				field : "spid",
				name : "spid",
				headerAlign : "center",
				header : "商铺",
				width : 120,
				required : true,
				allowSort : true,
				displayField : "spid_name",
				editor : OcmControl.newControl('fut_popselectgrid'),
				editorSet : {
					selectkey : "spid",
					beforefunc : "page.det_beforefunc",
					itemchangedfunc : "page.det_itemchanged"
				},
			}, {
				field : "spid_name",
				headerAlign : "center",
				header : "商铺名称",
				width : 120,
				visible : false,
			}, {
				field : "spbuildarea",
				name : "lbcmbdbl",
				headerAlign : "center",
				header : "建筑面积",
				allowSort : false,
				visible : true,
				readOnly : true,
				required : true,
				vtype : "double",
				width : 100,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n2",
				},
				numberFormat:"n2",
			    align: "right",
			}, {
				field : "splettarea",
				name : "splettarea",
				headerAlign : "center",
				header : "使用面积",
				allowSort : false,
				readOnly : true,
				required : true,
				vtype : "double",
				width : 100,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n2",
				},
				numberFormat:"n2",
			    align: "right",
			}, {
				field : "lbcmmemo",
				header : "备注",
				width : 180,
				allowSort : true,
				headerAlign : "center",
			} ]
		}
	};

	// 明细 自定义名称
	bill.lbbcontmanaframe = {
		"title" : '返租明细',// tab页面标题
		"name" : moduleid === billtypeormoduleid.search ? 'lb_contmanaframe'
				: 'lb_bcontmanaframe',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('lbbcontmanaframe'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
				field : "nrowid",
				header : "行主键",
				width : 80,
				allowSort : true,
				headerAlign : "center",
				visible : false
			}, {
				field : "sdate", // 免租期开始日期
				header : "开始日期",
				headerAlign : "center",
				align : "center",
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				required : true,
				dateFormat : "yyyy-MM-dd",
				width : 120,
			}, {
				field : "edate", // 免租期结束日期
				header : "结束日期",
				headerAlign : "center",
				align : "center",
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				required : true,
				dateFormat : "yyyy-MM-dd",
				width : 120,
			}, {
				field : "lbcmfzfs",
				name : "lbcmfzfs",
				headerAlign : "center",
				header : "返租方式",
				vtype : "required:true",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				dictkey : 'LBCMFZFS',
				allowSort : false,
				required : true,
				width : 160,
				renderer : "OcmControl.dictRendererWithCode",
			// editorSet:{onValuechanged : "page.onsptypechange"}
			}, {
				field : "lbcmbdbl",
				name : "lbcmbdbl",
				headerAlign : "center",
				header : "固定收益年回报率",
				allowSort : false,
				visible : true,
				//required : true,
				vtype : "double",
				width : 160,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "p2",
				},
				numberFormat:"p2",
			    align: "right",
			}, {
				field : "lbcmbdje",
				name : "lbcmbdje",
				headerAlign : "center",
				header : "固定收益年回报金额",
				allowSort : false,
				//required : true,
				vtype : "double",
				width : 160,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n2",
				},
				numberFormat:"n2",
			    align: "right",
			}, {
				field : "lbcmbdcebl",
				name : "lbcmbdcebl",
				headerAlign : "center",
				header : "分成比率",
				allowSort : false,
				visible : true,
				//required : true,
				vtype : "double",
				width : 100,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "p2",
				},
				numberFormat:"p2",
			    align: "right",
			}, {
				field : "cbsum1",
				name : "cbsum1",
				headerAlign : "center",
				header : "年超额收入1",
				allowSort : false,
				vtype : "double",
				"defaultValue" : "0",
				width : 100,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n2",
				},
				numberFormat:"n2",
			    align: "right",
			}, {
				field : "cbrate1",
				name : "cbrate1",
				headerAlign : "center",
				header : "超额比例1",
				allowSort : false,
				visible : true,
				vtype : "double",
				"defaultValue" : "0",
				width : 100,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "p2",
				},
				numberFormat:"p2",
			    align: "right",
			}, {
				field : "cbsum2",
				name : "cbsum2",
				headerAlign : "center",
				header : "年超额收入2",
				allowSort : false,
				vtype : "double",
				"defaultValue" : "0",
				width : 100,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n2",
				},
				numberFormat:"n2",
			    align: "right",
			}, {
				field : "cbrate2",
				name : "cbrate2",
				headerAlign : "center",
				header : "超额比例2",
				allowSort : false,
				visible : true,
				vtype : "double",
				"defaultValue" : "0",
				width : 100,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "p2",
				},
				numberFormat:"p2",
			    align: "right",
			}, {
				field : "cbsum3",
				name : "cbsum3",
				headerAlign : "center",
				header : "年超额收入3",
				allowSort : false,
				vtype : "double",
				"defaultValue" : "0",
				width : 100,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n2",
				},
				numberFormat:"n2",
			    align: "right",
			}, {
				field : "cbrate3",
				name : "cbrate3",
				headerAlign : "center",
				header : "超额比例3",
				allowSort : false,
				visible : true,
				vtype : "double",
				"defaultValue" : "0",
				width : 100,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "p2",
				},
				numberFormat:"p2",
			    align: "right",
			}, {
				field : "lbcmmemo",
				header : "备注",
				width : 180,
				allowSort : true,
				headerAlign : "center",
			} ]
		}
	};

	

	// 明细 自定义名称
	bill.lbbcontsupcharge = {
		"title" : '合同费用',// tab页面标题
		"name" : moduleid === billtypeormoduleid.search ? 'lb_contsupcharge'
				: 'lb_bcontsupcharge',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('lbbcontsupcharge'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
				field : "nrowid",
				header : "行主键",
				width : 80,
				allowSort : true,
				headerAlign : "center",
				visible : false
			}, {
				field : "cccode",
				name : "cccode",
				headerAlign : "center",
				header : "费用项目",
				width : 120,
				required : true,
				allowSort : true,
				displayField : "cccode_name",
				editor : OcmControl.newControl('fut_popselectgrid'),
				editorSet : {
					selectkey : "lbcccode",
					beforefunc : "page.det_beforefunc",
					itemchangedfunc : "page.det_itemchanged"
				},
			}, {
				field : "cccode_name",
				headerAlign : "center",
				header : "费用项目名称",
				width : 120,
				visible : false,
			}, {
				field : "sdate", // 免租期开始日期
				header : "开始日期",
				headerAlign : "center",
				align : "center",
				required : true,
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width : 120,
			}, {
				field : "edate", // 免租期结束日期
				header : "结束日期",
				headerAlign : "center",
				align : "center",
				required : true,
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width : 120,
			}, {
				field : "lbjftype",
				name : "lbjftype",
				headerAlign : "center",
				header : "费用提取方式",
				vtype : "required:true",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				dictkey : 'CCDEFTYPE',
				allowSort : false,
				readOnly : true,
				width : 120,
				renderer : "OcmControl.dictRendererWithCode",
			}, {
				field : "lbcmismcjs",
				name : "lbcmismcjs",
				headerAlign : "center",
				header : "收取方式",
				vtype : "required:true",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				dictkey : 'LBCMISMCJS',
				defaultValue : "0",
				allowSort : false,
				required : true,
				width : 120,
				renderer : "OcmControl.dictRendererWithCode",
			}, {
				field : "lbcmvalue",
				name : "lbcmvalue",
				headerAlign : "center",
				header : "比例/金额",
				allowSort : false,
				required : true,
				vtype : "required:true,double",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n4",
				},
				//numberFormat:"c2",
				width : 100,
				renderer:"onCcamount",
			    align: "right",
			}, {
				field : "lbcmmemo",
				header : "备注",
				width : 180,
				allowSort : true,
				headerAlign : "center",
			} ]
		}
	};

	// 查询 自定义名称
	if(moduleid == billtypeormoduleid.search){
		bill.lbbcontquerylist = {
				"title" : '单据列表',
				"name" : 'lbbcontquerylist',
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.lbcontract.search",
				"response" : "lb_contmain",
				"canquery" : true,
				/* "manualLoad" : true, */
				"bindform" : "layouttabs", // 绑定切换的TabsBox.name
				"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
				"searchParam" : {
					"billmoduleid" : app.modulecode,
					"order_field" : "contno",
					"order_direction" : "desc"
				},
				"properties" : {
					"id" : utils.createid('lbbcontquerylist'),
					"columns" : [
							{
								type : "indexcolumn",
								header : "行号",
								headerAlign : "center",
							}, {
								field : "billno",
								header : "单据编号",
								allowSort : true,
								headerAlign : "center",
								width : 140,
								enabledSearch : false,
								visible : false
							}, {
								field : "billstatus",
								header : "单据状态",
								allowSort : true,
								headerAlign : "center",
								renderer : "OcmControl.dictRendererWithCode",
								dictkey : 'BILLFLAG',
								width : 120,
								enabledSearch : false,
								visible : false
							}, {
								field : "contno",
								header : "合同号",
								allowSort : true,
								headerAlign : "center",
								width : 120,
								visible : true
							}, {
								field : "contstatus",
								header : "合同状态",
								width : 120,
								allowSort : true,
								headerAlign : "center",
								renderer : "OcmControl.dictRendererWithCode",
								dictkey : 'CONTSTATUS',
								enabledSearch : true,
								visible : true
							}, {
								field : "lbctype",
								header : "合同类型",
								width : 120,
								allowSort : true,
								headerAlign : "center",
								renderer : "OcmControl.dictRendererWithCode",
								dictkey : 'LBCTYPE',
							}, {
								field : "muid",
								type : "TextBox",
								headerAlign : "center",
								header : "门店",
								editor : OcmControl.newControl('fut_popselectgrid'),
								displayField : "muid_name",
								cdEdtCfg : {
									compnentType : 'fut_popselect',
									selectkey : "muid"
								},
								visible : false,
								enabledSearch : true,
								width : 200,
							}, {
								field : "muid_name",
								type : "TextBox",
								headerAlign : "center",
								header : "门店",
								enabledSearch : false,
								width : 200,
							}, {
								field : "ownerid",
								type : "TextBox",
								headerAlign : "center",
								header : "业主",
								editor : OcmControl.newControl('fut_popselectgrid'),
								displayField : "ownerid_name",
								cdEdtCfg : {
									compnentType : 'fut_popselect',
									selectkey : "owner"
								},
								visible : false,
								enabledSearch : true,
								width : 200,
							}, {
								field : "ownerid_name",
								type : "TextBox",
								headerAlign : "center",
								header : "业主",
								enabledSearch : false,
								renderer : "onOwneridListShow",
								width : 200,
							}, {
								field : "lbspid",
								type : "TextBox",
								headerAlign : "center",
								header : "租金池",
								editor : OcmControl.newControl('fut_popselectgrid'),
								displayField : "lbspid_name",
								cdEdtCfg : {
									compnentType : 'fut_popselect',
									selectkey : "lbspid"
								},
								visible : false,
								enabledSearch : false,
								width : 200,
							}, {
								field : "lbspid_name",
								type : "TextBox",
								headerAlign : "center",
								header : "租金池",
								visible : false,
								enabledSearch : false,
								width : 200,
							}, {
								field : "ceffdate",
								header : "合同开始日期",
								type : "date",
								width : 100,
								allowSort : true,
								headerAlign : "center",
								align : "center",
								dataType : "date",
								dateFormat : "yyyy-MM-dd",
							}, {
								field : "clapdate",
								header : "合同结束日期",
								type : "date",
								width : 100,
								allowSort : true,
								headerAlign : "center",
								align : "center",
								dataType : "date",
								dateFormat : "yyyy-MM-dd",
							}, {
								field : "lbcsigndate",
								header : "合同终止日期",
								type : "date",
								width : 100,
								allowSort : true,
								headerAlign : "center",
								align : "center",
								dataType : "date",
								dateFormat : "yyyy-MM-dd",
								visible : true,
								enabledSearch : true,
							},{
								field : "inputer",
								header : "录入人",
								width : 160,
								allowSort : true,
								headerAlign : "center",	
								editor:OcmControl.newControl('fut_popselectgrid'),
								displayField : "inputer_name",
								cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
								visible : false,
								enabledSearch : false,
							},{
								field : "inputer_name",
								header : "录入人",
								width : 160,
								allowSort : true,
								headerAlign : "center",	
								visible : false,
								enabledSearch : false,
							}, {
								field : "inputdate",
								type : "date",
								dataType : "date",
								format : "yyyy-MM-dd",
								header : "录入日期",
								width : 160,
								allowSort : true,
								headerAlign : "center",
								align : "center",
								visible : false,
								enabledSearch : false,
							}, {
								field : "auditor",
								header : "审核人",
								width : 160,
								allowSort : true,
								headerAlign : "center",
								editor:OcmControl.newControl('fut_popselectgrid'),
								displayField : "auditor_name",
								cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
								visible : false,
								enabledSearch : false,
							}, {
								field : "auditor_name",
								header : "审核人",
								width : 160,
								allowSort : true,
								headerAlign : "center",
								visible : false,
								enabledSearch : false,
							}, {
								field : "auditdate",
								type : "date",
								format : "yyyy-MM-dd",
								header : "审核日期",
								width : 160,
								dataType : "date",
								allowSort : true,
								headerAlign : "center",
								align : "center",
								visible : false,
								enabledSearch : false,
							} ]
				}
			};
	}else{
		bill.lbbcontquerylist = {
				"title" : '单据列表',
				"name" : 'lbbcontquerylist',
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.lbbcontract.search",
				"response" : "lb_bcontmain",
				"canquery" : true,
				/* "manualLoad" : true, */
				"bindform" : "layouttabs", // 绑定切换的TabsBox.name
				"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
				"searchParam" : {
					"billtype" : billtype,
					"order_field" : "billno",
					"order_direction" : "desc"
				},
				"properties" : {
					"id" : utils.createid('lbbcontquerylist'),
					"columns" : [
							{
								type : "indexcolumn",
								header : "行号",
								headerAlign : "center",
							}, {
								field : "billno",
								header : "单据编号",
								allowSort : true,
								headerAlign : "center",
								width : 140,
								enabledSearch : true,
								visible : true
							}, {
								field : "billstatus",
								header : "单据状态",
								allowSort : true,
								headerAlign : "center",
								renderer : "OcmControl.dictRendererWithCode",
								dictkey : 'BILLFLAG',
								width : 120,
								enabledSearch : true,
								visible : true
							}, {
								field : "contno",
								header : "合同号",
								allowSort : true,
								headerAlign : "center",
								width : 120,
								visible : true
							}, {
								field : "contstatus",
								header : "合同状态",
								width : 120,
								allowSort : true,
								headerAlign : "center",
								renderer : "OcmControl.dictRendererWithCode",
								dictkey : 'CONTSTATUS',
								enabledSearch : false,
								visible : false
							}, {
								field : "lbctype",
								header : "合同类型",
								width : 120,
								allowSort : true,
								headerAlign : "center",
								renderer : "OcmControl.dictRendererWithCode",
								dictkey : 'LBCTYPE',
							}, {
								field : "muid",
								type : "TextBox",
								headerAlign : "center",
								header : "门店",
								editor : OcmControl.newControl('fut_popselectgrid'),
								displayField : "muid_name",
								cdEdtCfg : {
									compnentType : 'fut_popselect',
									selectkey : "muid"
								},
								visible : false,
								enabledSearch : true,
								width : 200,
							}, {
								field : "muid_name",
								type : "TextBox",
								headerAlign : "center",
								header : "门店",
								enabledSearch : false,
								width : 200,
							}, {
								field : "ownerid",
								type : "TextBox",
								headerAlign : "center",
								header : "业主",
								editor : OcmControl.newControl('fut_popselectgrid'),
								displayField : "ownerid_name",
								cdEdtCfg : {
									compnentType : 'fut_popselect',
									selectkey : "owner"
								},
								visible : false,
								enabledSearch : true,
								width : 200,
							}, {
								field : "ownerid_name",
								type : "TextBox",
								headerAlign : "center",
								header : "业主",
								enabledSearch : false,
								renderer : "onOwneridListShow",
								width : 200,
							}, {
								field : "lbspid",
								type : "TextBox",
								headerAlign : "center",
								header : "租金池",
								editor : OcmControl.newControl('fut_popselectgrid'),
								displayField : "lbspid_name",
								cdEdtCfg : {
									compnentType : 'fut_popselect',
									selectkey : "lbspid"
								},
								visible : false,
								enabledSearch : false,
								width : 200,
							}, {
								field : "lbspid_name",
								type : "TextBox",
								headerAlign : "center",
								header : "租金池",
								visible : false,
								enabledSearch : false,
								width : 200,
							}, {
								field : "ceffdate",
								header : "合同开始日期",
								type : "date",
								width : 100,
								allowSort : true,
								headerAlign : "center",
								align : "center",
								dataType : "date",
								dateFormat : "yyyy-MM-dd",
							}, {
								field : "clapdate",
								header : "合同结束日期",
								type : "date",
								width : 100,
								allowSort : true,
								headerAlign : "center",
								align : "center",
								dataType : "date",
								dateFormat : "yyyy-MM-dd",
							}, {
								field : "lbcsigndate",
								header : "合同终止日期",
								type : "date",
								width : 100,
								allowSort : true,
								headerAlign : "center",
								align : "center",
								dataType : "date",
								dateFormat : "yyyy-MM-dd",
								visible : billtype === billtypeormoduleid.isvoid ? true
										: false,
								enabledSearch : billtype === billtypeormoduleid.isvoid ? true
										: false,
							},{
								field : "inputer",
								header : "录入人",
								width : 160,
								allowSort : true,
								headerAlign : "center",	
								editor:OcmControl.newControl('fut_popselectgrid'),
								displayField : "inputer_name",
								cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
								visible : true,
								enabledSearch : true,
							},{
								field : "inputer_name",
								header : "录入人",
								width : 160,
								allowSort : true,
								headerAlign : "center",	
								visible : false,
								enabledSearch : false,
							}, {
								field : "inputdate",
								type : "date",
								dataType : "date",
								format : "yyyy-MM-dd",
								header : "录入日期",
								width : 160,
								allowSort : true,
								headerAlign : "center",
								align : "center",
								visible : true,
								enabledSearch : true,
							}, {
								field : "auditor",
								header : "审核人",
								width : 160,
								allowSort : true,
								headerAlign : "center",
								editor:OcmControl.newControl('fut_popselectgrid'),
								displayField : "auditor_name",
								cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
								visible : true,
								enabledSearch : true,
							}, {
								field : "auditor_name",
								header : "审核人",
								width : 160,
								allowSort : true,
								headerAlign : "center",
								visible : false,
								enabledSearch : false,
							}, {
								field : "auditdate",
								type : "date",
								format : "yyyy-MM-dd",
								header : "审核日期",
								width : 160,
								dataType : "date",
								allowSort : true,
								headerAlign : "center",
								align : "center",
								visible : true,
								enabledSearch : true,
							} ]
				}
			};
	}
	
	var btn = Future.default.btn;
	
	if (wph_key) {
		btn.addData.visible = false
		btn.searchData.visible = false
	}
	
	// 按钮配置 - 固定名称
	var itemto = [ btn.addData, btn.editData, btn.delData, btn.saveData,
			btn.separator, btn.auditData, btn.cancelData, btn.separator, btn.searchData ];
	
	
	var item2 = {'text': '变更合同','iconCls': 'icon-save','name': 'updateData'};
	var itemtosearch = [ btn.searchData ,item2];
	bill.toolbarconfig = {
		id : utils.createid('systoolbar'),
		// items : Future.pub.Basebill.default_toolsbar
		items : moduleid === billtypeormoduleid.search ? itemtosearch : itemto
	}
	
	if (billtype === billtypeormoduleid.insert || billtype === billtypeormoduleid.update) {
		bill.toolbarconfig.items.remove(btn.cancelData);
	}

	var termination = [ bill.lbbcontshoplist, bill.lbbcontmanaframe,
			bill.lbbcontsupcharge ];

	// 单据配置
	bill.billconfig = {
		billhead : bill.lbbcontmain, // 单据主表
		billdetail : billtype === billtypeormoduleid.isvoid ? null : termination, // 单据明细表
		billquerylist : bill.lbbcontquerylist,// 查询列表
		dettabpages : billtype === billtypeormoduleid.isvoid ? null : termination,// 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode,// 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);
	
	

})();
