/**
 * 返租合同
 */
(function() {
	// 合同录入命名空间
	/** @namespace Future.lbbcontract.ment */
	var ns = Future.ns('lbbcontract.ment');
	var utils = Future.ns('Future.utils');

	var lbbcontmain = mini.get("lb_bcontmain");
	var lbbcontshoplist = mini.get("lb_bcontshoplist");
	var lbbcontmanaframe = mini.get("lb_bcontmanaframe");
	var lbbcontqs = mini.get("lb_bcontqs");
	var lbbcontsupcharge = mini.get("lb_bcontsupcharge");
	var lbbcontquerylist = mini.get("lbbcontquerylist");

	billtype = getBilltype(app.modulecode);
	// 单据类型121，返租合同申请单(商铺);单据类型122，返租合同变更单(商铺);模块号400203，返租合同查询(商铺);单据类型123，返租合同终止单(商铺)
	var billtypeormoduleid = {
		insert : '121',
		update : '122',
		search : '400203',   //模块号
		isvoid : '123'
	}
	var token = getUrlParam("token");// token值

	/**
	 * 返租合同新增
	 * 
	 * @constructor
	 */
	var LbbcontractPlan = function() {
		LbbcontractPlan.superclass.constructor.call(this);
		this.servicekey = 'mss';
		this.head_beforefunc = this.head_beforefunc.bind(this);
		this.head_itemchangedfunc = this.head_itemchangedfunc.bind(this);
		this.head_valuechanged = this.head_valuechanged.bind(this);
		this.onContnoChanged = this.onContnoChanged.bind(this);
		this.det_beforefunc = this.det_beforefunc.bind(this);
		this.det_itemchanged = this.det_itemchanged.bind(this);
		this.onOwneridShow = this.onOwneridShow.bind(this);
		this.selectUpdate = this.selectUpdate.bind(this);
		this.selectUpdatecallback = this.selectUpdatecallback.bind(this);
		this.updateData = this.updateData.bind(this);
	};

	ns.LbbcontractPlan = LbbcontractPlan;
	Future
			.extend(
					ns.LbbcontractPlan,
					Future.pub.Basebill,
					{
						initdict : function() {
							Future.Pub.DictSrv.data.SETTLEDAY = getSettleday();
							if (billtype == billtypeormoduleid.insert
									|| billtype == billtypeormoduleid.update) {
								var fitllbcmfzfsdata = [];
								var sptypedictdata = Future.Pub.DictSrv.data.LBCMFZFS;
								for (var i = 0; i < sptypedictdata.length; i++) {
									if (sptypedictdata[i].pro1 == "2") {
										fitllbcmfzfsdata
												.push(sptypedictdata[i]);
									}
								}
								Future.Pub.DictSrv.data.LBCMFZFS = fitllbcmfzfsdata;
							}
						},
						addDataBefore : function(data) {
							var flag = false;
							var that = this
							if (billtype == billtypeormoduleid.update) {
								/*var url = "/mall-business-ui/pages/leaseback/lbupdate-view.jsp?billmoduleid="
										+ app.modulecode
										+ "&inputer="
										+ getUserCode()
										+ "&inputer_name="
										+ getUserName();
								mini.open({
									url : url,
									title : "合同修订",
									width : 400,
									height : 120,
									onload : function() {
										var iframe = this.getIFrameEl();
									},
									ondestroy : function(ph_key) {
										if (ph_key != undefined && ph_key != ""
												&& ph_key != "close") {
											that.lb_bcontmain.getResources({
												ph_key : ph_key
											});
											flag = true;
											that.systab.setActiveIndex(1);
											that.editData();
											setTimeout(" ", 300);
										}
									}
								});*/
								this.selectUpdate()
							}

							if (flag) {
								return {};
							} else {
								if (billtype == billtypeormoduleid.insert
										|| billtype == billtypeormoduleid.isvoid) {
									return {};
								} else {
									return;
								}
							}
							
						},
						saveDataBefore : function(data) {
							if (billtype == billtypeormoduleid.insert
									|| billtype == billtypeormoduleid.update) {
								if (this.lb_bcontshoplist.getData().length == 0
										|| this.lb_bcontmanaframe.getData().length == 0) {
									mini.alert("商铺信息和返租明细不能为空！");
									return;
								} else {
									var lbtze = this.lb_bcontmain.form
											.getField('lbtze').value;
									/*
									 * if (parseInt(lbtze) == "0") {
									 * mini.alert("合同【投资额】请输入大于0的金额，请检查");
									 * return; }
									 */
									var bcontshoplist = this.lb_bcontshoplist
											.getData();
									for (var i = 0; i < bcontshoplist.length; i++) {
										var spid = bcontshoplist[i].spid;
										var spbuildarea = bcontshoplist[i].spbuildarea;
										var splettarea = bcontshoplist[i].splettarea;
										if (spid == null || spid == " ") {
											mini.alert("第" + (i + 1)
													+ "行商铺明细【商铺】为空，请检查");
											return;
										}else{
											var sdate = mini.formatDate(this.lb_bcontmain.getValue('ceffdate'),"yyyy-MM-dd");
											var edate = mini.formatDate(this.lb_bcontmain.getValue('clapdate'),"yyyy-MM-dd");
											var ccdate = mini.formatDate(this.lb_bcontmain.getValue('lbcsigndate'),"yyyy-MM-dd");
											var contno = this.lb_bcontmain.getValue('contno');
											var muid = this.lb_bcontmain.getValue('muid');
											if (!checkSpid(spid,sdate,edate,ccdate,contno,muid)) {
												return;
											  }
										}
										if (spbuildarea == null
												|| spbuildarea == " ") {
											mini.alert("第" + (i + 1)
													+ "行商铺明细【建筑面积】为空，请检查");
											return;
										}
										if (splettarea == null
												|| splettarea == " ") {
											mini.alert("第" + (i + 1)
													+ "行商铺明细【使用面积】为空，请检查");
											return;
										}
									}
									var bcontmanaframe = this.lb_bcontmanaframe
											.getData();
									for (var i = 0; i < bcontmanaframe.length; i++) {
										var sdate = bcontmanaframe[i].sdate;
										var edate = bcontmanaframe[i].edate;
										var lbcmfzfs = bcontmanaframe[i].lbcmfzfs;
										var lbcmbdbl = bcontmanaframe[i].lbcmbdbl;
										var lbcmbdje = bcontmanaframe[i].lbcmbdje;
										var lbcmbdcebl = bcontmanaframe[i].lbcmbdcebl;
										if (sdate == null || sdate == " ") {
											mini.alert("第" + (i + 1)
													+ "行返租明细【开始日期】为空，请检查");
											return;
										}
										if (edate == null || edate == " ") {
											mini.alert("第" + (i + 1)
													+ "行返租明细【结束日期】为空，请检查");
											return;
										}
										if (lbcmfzfs == null || lbcmfzfs == " ") {
											mini.alert("第" + (i + 1)
													+ "行返租明细【返租方式】为空，请检查");
											return;
										}
										if (lbcmfzfs == '11'
												|| lbcmfzfs == '12'
												|| lbcmfzfs == '15') {
											if (lbcmbdje && Number(lbcmbdje) != 0) {
												if(isNaN(lbcmbdje)){
													mini.alert("第" + (i + 1)
															+ "行返租明细【固定收益年回报金额】为空，请检查");
													return;
												}
											} else {
												if (Number(lbcmbdje) != 0) {
													mini.alert("第" + (i + 1)
															+ "行返租明细【固定收益年回报金额】为空，请检查");
													return;
												}
											}
										} else if (lbcmfzfs == '13') {
											if (lbcmbdcebl && Number(lbcmbdcebl) != 0) {
												if(isNaN(lbcmbdcebl)){
													mini.alert("第" + (i + 1)
															+ "行返租明细【分成比例】为空，请检查");
													return;
												}
											} else {
												if (Number(lbcmbdcebl) != 0) {
													mini.alert("第" + (i + 1)
															+ "行返租明细【分成比例】为空，请检查");
													return;
												}
											}
										} else if (lbcmfzfs == '14') {
											if (parseInt(lbtze) == "0") {
												mini
														.alert("合同【投资额】请输入大于0的金额，请检查");
												return;
											}
											if (lbcmbdbl && Number(lbcmbdbl) != 0) {
												if(isNaN(lbcmbdbl)){
													mini.alert("第" + (i + 1)
															+ "行返租明细【固定收益回报率】为空，请检查");
													return;
												}
											} else {
												if (Number(lbcmbdbl) != 0) {
													mini.alert("第" + (i + 1)
															+ "行返租明细【固定收益回报率】为空，请检查");
													return;
												}
											}
										}

									}
									var bcontsupcharge = this.lb_bcontsupcharge
											.getData();
									for (var i = 0; i < bcontsupcharge.length; i++) {
										var cccode = bcontsupcharge[i].cccode;
										var sdate = bcontsupcharge[i].sdate;
										var edate = bcontsupcharge[i].edate;
										var lbcmismcjs = bcontsupcharge[i].lbcmismcjs;
										var lbjftype = bcontsupcharge[i].lbjftype;
										var lbcmvalue = bcontsupcharge[i].lbcmvalue;
										if (cccode == null || cccode == " ") {
											mini.alert("第" + (i + 1)
													+ "行合同费用【费用项目】为空，请检查");
											return;
										}
										if (sdate == null || sdate == " ") {
											mini.alert("第" + (i + 1)
													+ "行合同费用【开始日期】为空，请检查");
											return;
										}
										if (edate == null || edate == " ") {
											mini.alert("第" + (i + 1)
													+ "行合同费用【结束日期】为空，请检查");
											return;
										}
										if (lbjftype == null || lbjftype == " ") {
											mini.alert("第" + (i + 1)
													+ "行合同费用【费用提取方式】为空，请检查");
											return;
										}
										if (lbcmismcjs == null
												|| lbcmismcjs == " ") {
											mini.alert("第" + (i + 1)
													+ "行合同费用【收取方式】为空，请检查");
											return;
										}
										if (lbcmvalue && Number(lbcmvalue) != 0) {
											if(isNaN(lbcmvalue)){
												mini.alert("第" + (i + 1)
														+ "行合同费用【比例/金额】为空，请检查");
												return;
											}
										} else {
											if (Number(lbcmvalue) != 0) {
												mini.alert("第" + (i + 1)
														+ "行合同费用【比例/金额】为空，请检查");
												return;
											}
										}
											
									}
									if (!checkdetailSave(bcontmanaframe,
											"sdate", "edate",
											CONSTANT_GRID1_NAME)) {
										return;
									}
									if (!checkdetailSave(bcontsupcharge,
											"sdate", "edate",
											CONSTANT_GRID3_NAME)) {
										return;
									}
									// 单头时间check
									var that = this;
									if (!saveCheck(that)) {
										return;
									}
									return {};
								}
							} else {
								return {};
							}
						},
						transformSaveData : function(data) { // transformSaveData
							var obj = {};

							if (this.lb_bcontshoplist) {
								obj.lb_bcontshoplist = this.lb_bcontshoplist
										.getData();
								setGridData(obj.lb_bcontshoplist);
							}

							if (this.lb_bcontmanaframe) {
								obj.lb_bcontmanaframe = this.lb_bcontmanaframe
										.getData();
								setGridData(obj.lb_bcontmanaframe);
							}

							if (this.lb_bcontsupcharge) {
								obj.lb_bcontsupcharge = this.lb_bcontsupcharge
										.getData();
								setGridData(obj.lb_bcontsupcharge);
							}

							var muid = this.lb_bcontmain.form.getField('muid').value;
							var contno = this.lb_bcontmain.form.getField('contno').value;
							// qz 如果需要前缀在里面新增，先设置问空
							/*var qz = "";*/
							var headdata = "";
							if (contno == undefined || contno == "") {
								/*contno = getContno(app.modulecode, qz);*/
								var contrule = getInfoRule(app.modulecode);
								if(contrule && contrule.length>0){
									  var that = this;
									  var head = that.lb_bcontmain;
									  headdata = head.getChangedData();
								}	
								  //合同号有重复时自动获取下一个合同号
								  var chkno = true;
								  while(chkno){
									  contno = getContno(app.modulecode,headdata); //获取合同号
									  if (GetLength(contno)>20) {
											mini.alert("生成的合同号("+contno+")，长度大于20，请重新设置规则！");
											return;
									  }
									  chkno = checkContno(contno,''); //检查合同号是否存在(自动编码和手工编码切换时可能产生重复号码)
								  }
								  if(contno == undefined || contno == ""){
									  mini.alert("合同号不能为空！");
									  return;
								  }else{
									  obj.contno = contno;
									  data.contno = contno;  
								  }								
								// this.lb_bcontmain.form.getField('contno').setValue(contno);
							}
							if (obj.lb_bcontshoplist != undefined
									&& obj.lb_bcontshoplist.length > 0) {
								setMktContno(contno, muid, obj.lb_bcontshoplist);
							}
							if (obj.lb_bcontmanaframe != undefined
									&& obj.lb_bcontmanaframe.length > 0) {
								setMktContno(contno, muid,
										obj.lb_bcontmanaframe);
							}
							if (obj.lb_bcontsupcharge != undefined
									&& obj.lb_bcontsupcharge.length > 0) {
								setMktContno(contno, muid,
										obj.lb_bcontsupcharge);
							}

							return obj;
						},
						head_beforefunc : function(e) {
							var ownerid = this.lb_bcontmain.form.getField('ownerid').value;
							var muid = this.lb_bcontmain.form.getField('muid').value;
							if (!e.searchParam) {
								e.searchParam = {};
							}
							var buttonEdit = e.sender;

							if (e.value != "undefined" || e.value != "") {
								e.searchParam.code = e.value;
							}

							// console.log(e);
							// 判断明细是否有数据,如果有数据，必须先删除了，再才能修改
							if (e.sender.name == 'ownerid') {
								if (billtype == billtypeormoduleid.insert
										|| billtype == billtypeormoduleid.update) {
									if (this.lb_bcontshoplist.data.length > 0) {
										mini.alert("商铺信息已存在数据,请先删除后再修改业主");
										e.cancel = true;
										return -1;
									}
									if (this.lb_bcontmanaframe.data.length > 0) {
										mini.alert("返租明细已存在数据,请先删除后再修改业主");
										e.cancel = true;
										return -1;
									}
								}
								if ((billtype == billtypeormoduleid.insert)&&(muid == "")) {
									mini.alert("请先选择门店");
									return -1;
								}
								if (muid != "") {
									e.searchParam.wherestr = "Ownermkt.Muid = '" + muid + "'";
								}
							}
							if (e.sender.name == 'muid') {
								if (billtype == billtypeormoduleid.insert
										|| billtype == billtypeormoduleid.update) {
									if (this.lb_bcontshoplist.data.length > 0) {
										mini.alert("商铺信息已存在数据,请先删除后再修改门店");
										e.cancel = true;
										return -1;
									}
									if (this.lb_bcontmanaframe.data.length > 0) {
										mini.alert("返租明细已存在数据,请先删除后再修改门店");
										e.cancel = true;
										return -1;
									}
								}
							}
							if (e.sender.name == 'lbspid') {
								if (billtype == billtypeormoduleid.insert
										|| billtype == billtypeormoduleid.update) {
									if (this.lb_bcontshoplist.data.length > 0) {
										mini.alert("商铺信息已存在数据,请先删除后再修改租金池");
										e.cancel = true;
										return -1;
									}
									if (this.lb_bcontmanaframe.data.length > 0) {
										mini.alert("返租明细已存在数据,请先删除后再修改租金池");
										e.cancel = true;
										return -1;
									}
								}
								if (muid == "") {
									mini.alert("请先选择门店！");
									e.cancel = true;
									return -1;
								}
								e.searchParam.muid = muid;
							}
							if (e.sender.name == 'contno') {
								if (billtype == billtypeormoduleid.isvoid) {
									if (muid != "") {
										e.searchParam.wherestr = "a.Muid = '"
												+ muid
												+ "' And a.Contstatus In ('Y','S') and a.billmoduleid = '" + billtypeormoduleid.search + "' ";
									} else {
										e.searchParam.wherestr = "a.Contstatus In ('Y','S') and a.billmoduleid = '" + billtypeormoduleid.search + "' ";
									}
								}else{
									e.searchParam.wherestr = "a.billmoduleid = '" + billtypeormoduleid.search + "' ";
								}
							}
						},
						head_itemchangedfunc : function(e, data) {
							// 修改业主之后门店清空
							var colname = e.sender.name;
							if (colname == 'muid') {								
								if (billtype != billtypeormoduleid.insert){
									this.lb_bcontmain.setValue('contno', "");
									this.lb_bcontmain.setText('contno', "");
								}							
								this.lb_bcontmain.setValue('ownerid', "");
								this.lb_bcontmain.setText('ownerid', "");
								if (billtype == billtypeormoduleid.isvoid) {
									this.lb_bcontmain.setValue('lbctype', "");
									this.lb_bcontmain.setValue('lbtze', "");
									this.lb_bcontmain.setValue('lbbdbl', "");
									this.lb_bcontmain.setValue('ceffdate', "");
									this.lb_bcontmain.setValue('clapdate', "");
									this.lb_bcontmain.setValue('settleday', "");
								}
							}
							if (colname == 'ownerid') {

							}
							if (colname == 'lbspid') {
								/*
								 * if(data.length > 0){
								 * this.lb_bcontmain.setValue('lbfzmj',
								 * data[0].lbpjzarea); }
								 */
							}
							if (colname == 'contno') {
								var flag = false;
								var contno = data[0].contno;
								if (check(contno)) {
									mini.alert("合同号[" + contno
											+ "] 存在未结算的结算单 [" + jsbillno
											+ "]，请重新输入合同号");
									return -1;
								}
								if (check2(contno)) {
									mini.alert("合同号[" + contno
											+ "] 存在已审核的撤场单，请重新输入合同号");
									return -1;
								}

								if (check3(contno)) {
									mini.alert("合同号[" + contno
											+ "] 存在未审核的修改单，请重新输入合同号");
									return -1;
								}
								if (data.length > 0) {
									this.lb_bcontmain.setValue('muid',
											data[0].muid);
									this.lb_bcontmain.setText('muid',
											data[0].muid_name);
									this.lb_bcontmain.setValue('lbctype',
											data[0].lbctype);
									this.lb_bcontmain.setValue('ownerid',
											data[0].ownerid);
									this.lb_bcontmain.setText('ownerid',
											data[0].ownerid_name);
									this.lb_bcontmain.setValue('lbtze',
											data[0].lbtze);
									this.lb_bcontmain.setValue('lbbdbl',
											data[0].lbbdbl);
									this.lb_bcontmain.setValue('ceffdate',
											data[0].ceffdate);
									this.lb_bcontmain.setValue('clapdate',
											data[0].clapdate);
									this.lb_bcontmain.setValue('settleday',
											data[0].settleday);
								}
							}
							return 1;
						},
						head_valuechanged : function(e, data) {
							var colname = e.sender.name;
							var colvalue = e.value;
							var oldcolvalue = e.sender.oldValue;
							var that = this;
							changeView(colname, colvalue, that, oldcolvalue);
						},
						onContnoChanged : function(e,data){
							//检查合同号是否重复
							var billno = this.lb_bcontmain.form.getField('billno').value;
							var contnovalue = e.value;
							if(contnovalue){
								if (checkContno(contnovalue,billno)) {
									  mini.alert("已经存在合同号["+contnovalue+"],请重新输入");
									  this.lb_bcontmain.form.getField("contno").setValue("");
								  } 
							}
						},
						det_beforefunc : function(e) {
							var muid = this.lb_bcontmain.form.getField('muid').value;
							var ownerid = this.lb_bcontmain.form
									.getField('ownerid').value;
							var ceffdate = mini.formatDate(this.lb_bcontmain.form
									.getField('ceffdate').value,"yyyy-MM-dd");
							if (!e.searchParam) {
								e.searchParam = {};
							}
							var buttonEdit = e.sender;

							if (e.value != "undefined" && e.value != "") {
								e.searchParam.code = e.value;
							}
							if (buttonEdit.name == "cccode") {
								if (!muid) {
									mini.alert("请先输入门店");
									return -1;
								}
								e.searchParam.wherestr = "Cctstatus = '1' And Ccdeftype != 'D'";
							}
							if (buttonEdit.name == "spid") {
								if (!muid) {
									mini.alert("请先输入门店");
									return -1;
								}
								e.searchParam.wherestr = "Spstatus In ('E','Y') And Spmode = '1' And Sptype in (Select Dcode From Dicdetail Where Dictype = 'SPTYPE' And Pro1 = 'Y') And Muid ='"
										+ muid
										+ "'"
										+ "And Ownerid = '"
										+ ownerid
										+ "' And Spstartdate <= to_date('"
										+ ceffdate + "','yyyy-MM-dd')";
							}

							return 0;
						},
						det_itemchanged : function(e, data) {
							if (e.sender.name == 'cccode') {
								var that = this;
								var row = this.lb_bcontsupcharge.getSelected();
								if (data.length > 0) {
										var newrow = {
											lbjftype : data[0].ccdeftype,
											lbcmvalue : data[0].cctdefvalue,
										};
										this.lb_bcontsupcharge.updateRow(row,
												newrow);
								}
							}
							if (e.sender.name == 'spid') {
								var that = this;								
								var sdate = mini.formatDate(that.lb_bcontmain.getValue('ceffdate'),"yyyy-MM-dd");
			                    var edate = mini.formatDate(that.lb_bcontmain.getValue('clapdate'),"yyyy-MM-dd");
			                    var ccdate = mini.formatDate(that.lb_bcontmain.getValue('lbcsigndate'),"yyyy-MM-dd");
			                    var contno = that.lb_bcontmain.getValue('contno');
			                    var muid = that.lb_bcontmain.getValue('muid');
			                    
								var row = this.lb_bcontshoplist.getSelected();
								if (data.length > 0) {
									var lbspid=data[0].oid
									if (!checkSpid(lbspid,sdate,edate,ccdate,contno,muid)) {
				                        return;
				                    }
									// 不允许添加重复费用项目
									var boolean = false;
									var exitGood = "";
									var maxrow = 1;
									var exitDatas = this.lb_bcontshoplist
											.getData();
									for (var i = 0; i < exitDatas.length; i++) {										
										if (exitDatas[i].spid == data[0].oid) {
											exitGood = exitGood + "["
													+ data[0].code + "],";
											boolean = true;
											break;
										}
									}
									if (!boolean) {
										var newrow = {
											spbuildarea : data[0].spbuildarea,
											splettarea : data[0].splettarea,
										};
										this.lb_bcontshoplist.updateRow(row,
												newrow);
									} else {
										var delrow = {
											flag : "D",
										};
										this.lb_bcontshoplist.updateRow(row,
												delrow);
										this.lb_bcontshoplist.rejectRecord(row);
										this.lb_bcontshoplist.removeRow(row);
										boolean = false;
									}

									if (exitGood != "" && exitGood.length > 1) {
										mini.alert("已经过滤重复的商铺:"
												+ exitGood.substring(0,
														exitGood.length - 1));
										return -1;
										;
									}
								}
							}
							return 0;
						},
						onOwneridShow : function(e, data) {
							var ownerid = "";
							if (e == "1") {
								var row = this.lbbcontquerylist.getSelected();
								ownerid = row.ownerid;
							} else {
								var that = this;
								ownerid = that.lb_bcontmain.getValue('ownerid');
							}
							if (ownerid == undefined || ownerid == "")
								return;
							this.openOwnerid(ownerid);
						},
						openOwnerid : function(ownerid) {
							var ph_key = getOwneridPhkey(ownerid);
							if (ownerid == "") {
								mini.alert("业主不存在，请重新输入");
							}
							mini
									.open({
										url : encodeURI("/mall-business-ui/pages/dict/ownerinfo-view.jsp?viewdetail=Y&ph_key="
												+ ph_key
												+ "&billmoduleid="+moduleid+"&token="
												+ token),
										title : "业主信息",
										width : $(window).width(),
										height : $(window).height(),
										onload : function() {
										}
									});
						},
						initevent : function() {
							LbbcontractPlan.superclass.initevent.call(this);
							if (billtype == billtypeormoduleid.insert || billtype == billtypeormoduleid.update) {
								this.lb_bcontshoplist.on('cellcommitedit',
										this.lbbcellcommitedit, this);
								this.lb_bcontmanaframe.on('cellcommitedit',
										this.lbbcellcommitedit, this);
								this.lb_bcontsupcharge.on('cellcommitedit',
										this.lbbcellcommitedit, this);
								this.lb_bcontmanaframe.on('cellbeginedit',
										this.oncellbeginedit, this);
								this.lb_bcontsupcharge.on('cellbeginedit',
										this.oncellbeginedit, this);

								this.lb_bcontshoplist.addNewRowBefore = function() {
									var form = this.businessobj.lb_bcontmain.form;
									form.validate();
									if (form.isValid() == false) {
										mini.alert("请先输入表头必填项目");
										return;
									}
									var data = this.getData();
									var obj = {};
									obj.nrowid = getTmdd();
									obj.lbcmstatus = "I";
									return obj
								}

								this.lb_bcontmanaframe.addNewRowBefore = function() {
									var form = this.businessobj.lb_bcontmain.form;
									form.validate();
									if (form.isValid() == false) {
										mini.alert("请先输入表头必填项目");
										return;
									}
									var ceffdate = this.businessobj.lb_bcontmain.form
											.getField('ceffdate').value;
									var clapdate = this.businessobj.lb_bcontmain.form
											.getField('clapdate').value;
									var lbbdbl = this.businessobj.lb_bcontmain.form
											.getField('lbbdbl').value;
									var data = this.getData();
									var obj = {};
									obj.nrowid = getTmdd();
									obj.sdate = mini.formatDate(ceffdate,
											"yyyy-MM-dd");
									obj.edate = mini.formatDate(clapdate,
											"yyyy-MM-dd");
									obj.lbcmbdbl = lbbdbl;
									obj.lbcmbdcebl = "0";
									obj.lbcmbdje = "0";
									obj.cbsum1 = "0";
									obj.cbrate1 = "0";
									obj.cbsum2 = "0";
									obj.cbrate2 = "0";
									obj.cbsum3 = "0";
									obj.cbrate3 = "0";
									obj.lbcmstatus = "I";
									return obj
								}

								this.lb_bcontsupcharge.addNewRowBefore = function() {
									var form = this.businessobj.lb_bcontmain.form;
									form.validate();
									if (form.isValid() == false) {
										mini.alert("请先输入表头必填项目");
										return;
									}
									var ceffdate = this.businessobj.lb_bcontmain.form
											.getField('ceffdate').value;
									var clapdate = this.businessobj.lb_bcontmain.form
											.getField('clapdate').value;
									var data = this.getData();
									var obj = {};
									obj.nrowid = getTmdd();
									obj.lbcmismcjs = "0";
									obj.sdate = mini.formatDate(ceffdate,
											"yyyy-MM-dd");
									obj.edate = mini.formatDate(clapdate,
											"yyyy-MM-dd");
									obj.lbcmstatus = "I";
									return obj
								}

								this.lb_bcontshoplist.deleteRow = function() {
									var rowsData = this.getData();
									var rows = this.getSelecteds();
									if (rows.length > 0) {
										for (var i = 0; i < rows.length; i++) {
											if (rows[i].lbcmstatus == "N") {
												var num = 0;
												for (var j = 0; j < rowsData.length; j++) {
													if (rows[i]._id == rowsData[j]._id) {
														num = j + 1;
														break;
													}
												}
												mini
														.alert("第"
																+ num
																+ "行的商铺已经被正式合同使用,不能删除,请检查");
												return;
											}
										}
										this.removeRows(rows, false);
									}
								}

								this.lb_bcontmanaframe.deleteRow = function() {
									var rowsData = this.getData();
									var rows = this.getSelecteds();
									if (rows.length > 0) {
										for (var i = 0; i < rows.length; i++) {
											if (rows[i].lbcmstatus == "N") {
												var num = 0;
												for (var j = 0; j < rowsData.length; j++) {
													if (rows[i]._id == rowsData[j]._id) {
														num = j + 1;
														break;
													}
												}
												mini
														.alert("第"
																+ num
																+ "行的返租明细已经被正式合同使用,不能删除,请检查");
												return;
											}
										}
										this.removeRows(rows, false);
									}
								}

								this.lb_bcontsupcharge.deleteRow = function() {
									var rowsData = this.getData();
									var rows = this.getSelecteds();
									if (rows.length > 0) {
										for (var i = 0; i < rows.length; i++) {
											if (rows[i].lbcmstatus == "N") {
												var num = 0;
												for (var j = 0; j < rowsData.length; j++) {
													if (rows[i]._id == rowsData[j]._id) {
														num = j + 1;
														break;
													}
												}
												mini
														.alert("第"
																+ num
																+ "行的合同费用已经被正式合同使用,不能删除,请检查");
												return;
											}
										}
										this.removeRows(rows, false);
									}
								}
							}
							
							var wph_key = getUrlParam("ph_key") 
							if (wph_key) {
								this.lb_bcontmain.getResources({
									ph_key : wph_key
								});
								this.systab.setActiveIndex(1);
								this.systab.lbbcontquerylist.hidden=true;
								//this.systoolbar.changedStatus("E");
								this.editData();
								setTimeout(" ", 300);
							}

						},
						_systabChanged : function(e) {
							this.oldsdate = this.lb_bcontmain.form
									.getField('ceffdate').value;
							this.oldedate = this.lb_bcontmain.form
									.getField('clapdate').value;
							this._refreshSysbtnEnable();
						},
						/**
						 * 明细窗口修改 参数说明 cancel:false column:Object editor:ol1OO0
						 * field:"spcode" oldValue:undefined record:Object
						 * row:Object rowIndex:0 sender:OcmControl.GridBox
						 * source:OcmControl.GridBox text:""
						 * type:"cellcommitedit" value:"1221"
						 */
						lbbcellcommitedit : function(e) {

							var record = e.record;
							var value = e.value;
							var grid = e.sender;
							var lbtze = this.lb_bcontmain.form
									.getField('lbtze').value;
							var lbbdbl = this.lb_bcontmain.form
									.getField('lbbdbl').value;
							var ceffdate = mini
									.formatDate(this.lb_bcontmain.form
											.getField('ceffdate').value,
											"yyyy-MM-dd");
							var clapdate = mini
									.formatDate(this.lb_bcontmain.form
											.getField('clapdate').value,
											"yyyy-MM-dd");
							/*
							 * if (!lbtze) { mini.alert("请先输入投资额"); e.cancel =
							 * true; return -1; } /*if (!lbbdbl) {
							 * mini.alert("请先输入年回报率"); e.cancel = true; return; }
							 * if (!lbbdje) { mini.alert("请先输入固定金额"); e.cancel =
							 * true; return; }
							 */
							// 明细开始日期
							if (e.field == 'sdate') {
								if (e.value && e.row.edate) {
									if (e.row.edate < e.value) {
										if (grid.config.name == "lb_bcontmanaframe") {
											mini.alert("返租明细结束日期不能小于开始日期");
										} else if (grid.config.name == "lb_bcontqs") {
											mini.alert("清算条款结束日期不能小于开始日期");
										} else if (grid.config.name == "lb_bcontsupcharge") {
											mini.alert("合同费用结束日期不能小于开始日期");
										}
										e.cancel = true;
										return -1;
									}
									if (e.value < ceffdate) {
										if (grid.config.name == "lb_bcontmanaframe") {
											mini.alert("返租明细结束日期不能小于合同开始日期");
										} else if (grid.config.name == "lb_bcontqs") {
											mini.alert("清算条款结束日期不能小于合同开始日期");
										} else if (grid.config.name == "lb_bcontsupcharge") {
											mini.alert("合同费用结束日期不能小于合同开始日期");
										}
										e.cancel = true;
										return -1;
									}
									if (!checkdetaildata(grid, "sdate",
											"edate", value, "", record)) {
										e.cancel = true;
										return -1;
									}
								}
							}
							// 返租明细结束日期
							if (e.field == 'edate') {
								if (e.value && e.row.sdate) {
									if (e.row.sdate > e.value) {
										if (grid.config.name == "lb_bcontmanaframe") {
											mini.alert("返租明细结束日期不能小于开始日期");
										} else if (grid.config.name == "lb_bcontqs") {
											mini.alert("清算条款结束日期不能小于开始日期");
										} else if (grid.config.name == "lb_bcontsupcharge") {
											mini.alert("合同费用结束日期不能小于开始日期");
										}
										e.cancel = true;
										return -1;
									}
									if (e.value > clapdate) {
										if (grid.config.name == "lb_bcontmanaframe") {
											mini.alert("返租明细结束日期不能大于合同结束日期");
										} else if (grid.config.name == "lb_bcontqs") {
											mini.alert("清算条款结束日期不能大于合同结束日期");
										} else if (grid.config.name == "lb_bcontsupcharge") {
											mini.alert("合同费用结束日期不能大于合同结束日期");
										}
										e.cancel = true;
										return -1;
									}
									if (!checkdetaildata(grid, "sdate",
											"edate", "", value, record)) {
										e.cancel = true;
										return -1;
									}
								}
							}
							// 明细返租方式
							if (e.field == 'lbcmfzfs') {
								if (e.value) {
									if (e.value == '14') {
										e.row.lbcmbdbl = lbbdbl;
										e.row.lbcmbdje = Math
												.round((lbtze * e.row.lbcmbdbl) * 100) / 100;
										e.row.lbcmbdcebl = Math.round(0 * 100) / 100;
									}
									if (e.value == '11' || e.value == '12'
											|| e.value == '15') {
										e.row.lbcmbdbl = Math.round(0);
										e.row.lbcmbdje = Math.round(0 * 100) / 100;
										e.row.lbcmbdcebl = Math.round(0 * 100) / 100;
									}
									if (e.value == '13') {
										e.row.lbcmbdbl = Math.round(0);
										e.row.lbcmbdcebl = Math.round(0 * 100) / 100;
										e.row.lbcmbdje = Math.round(0);
										e.row.cbsum1 = Math.round(0 * 100) / 100;
										e.row.cbrate1 = Math.round(0 * 100) / 100;
										e.row.cbsum2 = Math.round(0 * 100) / 100;
										e.row.cbrate2 = Math.round(0 * 100) / 100;
										e.row.cbsum3 = Math.round(0 * 100) / 100;
										e.row.cbrate3 = Math.round(0 * 100) / 100;
									}
								}
							}
							// 明细固定收益回报率
							if (e.field == 'lbcmbdbl') {
								if (lbtze && e.value) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0" || e.value > "1") {
										mini.alert("请输入0到1之间的回报率");
										e.cancel = true;
										return -1;
									}
									e.row.lbcmbdje = Math
											.round((lbtze * e.value) * 100) / 100;
								}
							}
							// 明细固定收益回报率
							if (e.field == 'lbcmbdcebl') {
								if (e.value) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0" || e.value > "1") {
										mini.alert("请输入0到1之间的分成比率");
										e.cancel = true;
										return -1;
									}
								}
							}
							// 明细计费频率
							if (e.field == 'lbcmismcjs') {
								if (e.value && e.row.lbjftype) {
									if (e.row.lbjftype == "B" && e.value != "0") {
										mini.alert("费用提取方式只能选择每次");
										e.cancel = true;
										return -1;
									}
								}
							}
							// 明细指标
							if (e.field == 'lbcmvalue') {
								if (e.value && e.row.lbjftype) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0") {
										mini.alert("请输大于0的比例");
										e.cancel = true;
										return -1;
									}
									if (e.row.lbjftype == "B") {
										if (e.value > "1") {
											mini.alert("请输入0到1之间的比例");
											e.cancel = true;
											return -1;
										}
									}
								}
							}
							// 明细超额比例1
							if (e.field == 'cbrate1') {
								if (e.value) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0" || e.value > "1") {
										mini.alert("请输入0到1之间的年超额收入1");
										e.cancel = true;
										return -1;
									}
								}
							}
							// 明细超额比例2
							if (e.field == 'cbrate2') {
								if (e.value) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0" || e.value > "1") {
										mini.alert("请输入0到1之间的年超额收入2");
										e.cancel = true;
										return -1;
									}
								}
							}
							// 明细超额比例3
							if (e.field == 'cbrate3') {
								if (e.value) {
									if (parseInt(e.value) != "0") {
										if (!Number(e.value)) {
											mini.alert("请输入数字");
											e.cancel = true;
											return -1;
										}
									}
									if (e.value < "0" || e.value > "1") {
										mini.alert("请输入0到1之间的年超额收入3");
										e.cancel = true;
										return -1;
									}
								}
							}
							if (e.field == "cbsum1" || e.field == "cbsum2"
									|| e.field == "cbsum3") {
								if (!checkCbsum(e.field, record, Number(value))) {
									e.cancel = true;
								}
							}
						},
						oncellbeginedit : function(e) {
							var record = e.record;
							var field = e.field;
							if (field == "lbcmbdje") {
								if (record.lbcmfzfs != undefined
										|| record.lbcmfzfs != "") {
									if (record.lbcmfzfs == "11"
											|| record.lbcmfzfs == "12"
											|| record.lbcmfzfs == "15") {
										e.cancel = false;
									} else {
										e.cancel = true;
									}
								}
							}
							if (field == "lbcmbdbl") {
								if (record.lbcmfzfs != undefined
										|| record.lbcmfzfs != "") {
									if (record.lbcmfzfs == "14") {
										e.cancel = false;
									} else {
										e.cancel = true;
									}
								}
							}
							if (field == "lbcmbdcebl") {
								if (record.lbcmfzfs != undefined
										|| record.lbcmfzfs != "") {
									if (record.lbcmfzfs == "13") {
										e.cancel = false;
									} else {
										e.cancel = true;
									}
								}
							}
							if (field == "lbcmismcjs") {
								if (record.cccode == undefined
										|| record.cccode == " ") {
									mini.alert("请先输入费用项目");
									e.cancel = true;
								}
							}
							if (field == "cbsum1" || field == "cbsum2"
									|| field == "cbsum3" || field == "cbrate1"
									|| field == "cbrate2" || field == "cbrate3") {
								if (record.lbcmfzfs != undefined
										|| record.lbcmfzfs != "") {
									if (record.lbcmfzfs == "12"
											|| record.lbcmfzfs == "15") {
										e.cancel = false;
									} else {
										e.cancel = true;
									}
								}
							}
						},
						selectUpdate: function(){
							if (!this.selectUpdatewin) {
								var check = [{
								  	type : "checkcolumn",
								  	headerAlign : "center",
								  	readOnly : true,
								  }];
								this.selectquerylist = {
											"type" : "gridbox",
											"resources" : OmdUrl.mall,
											"method" : "mss.work.report.query",
											"response" : "report",
											"searchParam" : {
												"queryid" : "select_lbcontmain",
												 "billmoduleid":"400203",
												 "order_field" : "contno desc",
											},
											"properties" : {
												"id" :  utils.createid('selectUpdate'),
												"columns" : [{
												  	type : "checkcolumn",
												  	headerAlign : "center",
												  	readOnly : true,
												  },{
													type : "indexcolumn",
													header : "行号",
													headerAlign : "center",
												},{
													field : "contno",
													header : "合同号",
													allowSort : true,
													headerAlign : "center",
													width : 120,
													visible : true
												}, {
													field : "contstatus",
													header : "合同状态",
													width : 120,
													allowSort : true,
													headerAlign : "center",
													renderer : "OcmControl.dictRendererWithCode",
													dictkey : 'CONTSTATUS',
												}, {
													field : "lbctype",
													header : "合同类型",
													width : 120,
													allowSort : true,
													headerAlign : "center",
													renderer : "OcmControl.dictRendererWithCode",
													dictkey : 'LBCTYPE',
												}, {
													field : "muid",
													headerAlign : "center",
													header : "门店",
													editor : OcmControl.newControl('fut_popselectgrid'),
													displayField : "muid_name",
													cdEdtCfg : {
														compnentType : 'fut_popselect',
														selectkey : "muid",
														textName : "muid_name",
														responseName : "muid"
													},
													width : 200,
												},  {
													field : "ownerid",
													type : "TextBox",
													displayField : "ownerid_name",
													headerAlign : "center",
													header : "业主",
													editor : OcmControl.newControl('fut_popselectgrid'),
													displayField : "ownerid_name",
													cdEdtCfg : {
														compnentType : 'fut_popselect',
														selectkey : "owner",
														textName : "ownerid_name",
														
													},
													width : 200,
												},  {
													field : "lbspid",
													displayField : "lbspid_name",
													type : "TextBox",
													headerAlign : "center",
													header : "租金池",
													editor : OcmControl.newControl('fut_popselectgrid'),
													displayField : "lbspid_name",
													cdEdtCfg : {
														compnentType : 'fut_popselect',
														selectkey : "lbspid",
														textName : "lbspid_name",
													},
													width : 200,
												},  {
													field : "ceffdate",
													header : "合同开始日期",
													type : "date",
													width : 100,
													allowSort : true,
													headerAlign : "center",
													align : "center",
													dataType : "date",
													dateFormat : "yyyy-MM-dd",
												}, {
													field : "clapdate",
													header : "合同结束日期",
													type : "date",
													width : 100,
													allowSort : true,
													headerAlign : "center",
													align : "center",
													dataType : "date",
													dateFormat : "yyyy-MM-dd",
												}, {
													field : "lbcsigndate",
													header : "合同终止日期",
													type : "date",
													width : 100,
													allowSort : true,
													headerAlign : "center",
													align : "center",
													dataType : "date",
													dateFormat : "yyyy-MM-dd",
												}]
											},
										};
								
								this.selectUpdatewin = new selectwindow({
									title: "合同选择",
									width: 700,
									height: 500,
									gridconfig: this.selectquerylist,
									singleSelect:true
								});
								this.selectUpdatewin.setCallback(this.selectUpdatecallback);
							}

							this.selectUpdatewin.cleandata();
							this.selectUpdatewin.show();
						},
						checkUpdate:function (contno,billmoduleid) {
							var isflag = false;
							var postdata = {};
						    postdata.billmoduleid = billmoduleid;
						    postdata.contno = contno;
								itemLoader.doRequest(OmdUrl.mall, "mss.work.lbbcontract.checkContno", postdata, null, null,
							            function(data) {
									if (data.flag != null && data.flag == "2" ) {
										mini.alert("合同号["+contno+"]存在未审核的"+data.msg+"["+data.billno+"]，请重新输入合同号");
										isflag = true;
									} else if (data.flag != null && data.flag == "3" ) {
										mini.alert("合同号["+contno+"]已失效或不存在，请重新输入合同号");
										isflag = true;
									}	
							    },null, null, false);
							return isflag;
						},
						selectUpdatecallback  : function(data) {
							if (!data || data.length == 0) {
								return;
							}
							if (this.checkUpdate(data[0].contno,app.modulecode)) {
								return;
							}
							
							var postdata = {};
							var that = this
						    postdata.billmoduleid = app.modulecode;
						    postdata.inputer = getUserCode();
						    postdata.inputer_name = getUserName();
						    postdata.contno = data[0].contno;
								itemLoader.doRequest(OmdUrl.mall, "mss.work.lbbcontract.addUpdate", postdata, null, null,
							            function(data) {
									if (data.flag != null && data.flag == "1" ) {
										mini.alert("合同号["+contno+"]不存在，请重新选择合同号");
									} else if (data.flag != null && data.flag == "2" ) {
										mini.alert("合同号["+contno+"]存在未审核的"+data.msg+"["+data.billno+"]，请重新选择合同号");
									} else if (data.flag != null && data.flag == "3" ) {
										mini.alert("合同号["+contno+"]已失效，请重新选择合同号");	
									} else {
										that.lb_bcontmain.getResources({
											ph_key : data.ph_key
										});
										that.systab.setActiveIndex(1);
										that.editData();
										setTimeout(" ", 300);
									}
									
							    },null, null, false);
							
						},
						updateData:function() {
							var row =this.billquerylist.getSelected()
							if (!row || !row.contno) {
								mini.alert("请先选中合同");
								return;
							}
							if (this.checkUpdate(row.contno,app.modulecode)) {
								return;
							}
							var token = getUrlParam("token");
							var postdata = {};
							var that = this
						    postdata.billmoduleid = "400202";
						    postdata.inputer = getUserCode();
						    postdata.inputer_name = getUserName();
						    postdata.contno = row.contno;
							itemLoader.doRequest(OmdUrl.mall, "mss.work.lbbcontract.addUpdate", postdata, null, null,
						            function(data) {
								if (data.flag != null && data.flag == "1" ) {
									mini.alert("合同号["+contno+"]不存在，请重新选择合同号");
								} else if (data.flag != null && data.flag == "2" ) {
									mini.alert("合同号["+contno+"]存在未审核的"+data.msg+"["+data.billno+"]，请重新选择合同号");
								} else if (data.flag != null && data.flag == "3" ) {
									mini.alert("合同号["+contno+"]已失效，请重新选择合同号");	
								} else {
									that.openUpdateBill(data.ph_key,token,"400202");
								}
								
						    },null, null, false);
						},
						openUpdateBill:function (ph_key,token,temp) {
							var _url = "/mall-business-ui/pages/leaseback/lbbcontractTest.html?ph_key="+ph_key+"&modulecode="+temp+"&token=" + token;
							if (app.srvkey && app.srvkey != "")
							{
								_url = _url + "&srvkey="+ app.srvkey;
							}
							mini.open({
								url : encodeURI(_url),
								title : "合同变更",
								width : $(window).width(),
								height : $(window).height(),
								onload: function () {
								}	
							});
						}
					});

})();