<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html />
<html>
<head>
<title>返租结算单</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<%
String viewdetail = request.getParameter("viewdetail");
String billno = request.getParameter("billno");
if (viewdetail == null || viewdetail.length() < 1) {
  viewdetail = "N";
}
if (billno == null || billno.length() < 1) {
	billno = "0";
}
%>

	<% if (viewdetail.equals("N")) { %>
	<div class="ocm-layout" config="config1" borderStyle="border:0px;"
		style="width: 100%; height: 100%;"></div>
	<% } else if (viewdetail.equals("Y")){ %>
	  <div class="ocm-details" config="details1" style="padding-top:5px"></div>
	<% } %>


<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
<script type="text/javascript">
var dictData = OcmControl.getDict("BILLFLAG","code,name,pro1,ddvalue") || {};

var toolbar1 = {
	rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消
		'billstatus' : {
			'Y' : [ 'addData', 'searchData','editData','commitData','cancelData'],
			'M' : [ 'addData', 'editData', 'auditData', 'submitData','delData','dellogData','copyData', 'searchData', 'printData','importgoods','import' ],
			'C' : [ 'addData', 'copyData', 'searchData', 'printData' ]
		}
	},
	status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
		'N' : [ 'addData', 'saveData', 'searchData'],
		'V' : [ 'addData', 'editData', 'auditData', 'delData','copyData', 'searchData'],
		'E' : [ 'addData', 'saveData', 'delData', 'copyData','searchData','editData'],
		'S' : [ 'addData', 'editData', 'auditData', 'delData','copyData', 'searchData'],
		'A' : [ 'addData', 'cancelData', 'copyData', 'searchData'],
		'C' : [ 'addData', 'copyData', 'searchData'],
		'D' : [ 'addData', 'searchData','editData'],
	},
	items : [ [ {
		'text' 		: '查询',
		'iconCls' 	: 'icon-search',
		'name' 		: 'searchData'
	}, {
		'text' 		: '删除',
		'iconCls' 	: 'icon-remove',
		'name' 		: 'dellogData',
	 	'onclick' 	: 'dellogData',
	 	"enabled" 	: true,
	}, {
		'text' 		: '审核',
		'iconCls' 	: 'icon-ok',
		'name' 		: 'auditData',
	}, {
		'text' 		: '作废',
		'iconCls' 	: 'icon-no',
		'name' 		: 'cancelData',
	}]]
};


//单据列表  
var gridbox1 = { 
	"type" : "gridbox",
	"resources" : OmdUrl.mall,
	"method" : "mss.work.lbsupsettle.search",
	"response" : "lb_supsettlehead",
	"manualLoad" : false,   //是否手动点击查询才显示
	"bindform" : "tabs1",   // 绑定切换的TabsBox.name
	"bindSearchParam" : [ "billno" ], // 明细页面查询条件字段
	"searchParam" : {
		"order_field" : "billno", //降序排列
		"order_direction" : "desc",
	},
	"properties" : {
		"id" : "gridbox1",
		"columns" : [ {
			type : "indexcolumn",
			header : "行号",
			width : 60,
		}, {
			field : "billstatus",
			header : "单据状态",
			width : 100,
			headerAlign : "center",
			allowSort : true,
			renderer : "OcmControl.dictRendererWithCode",
			data :  dictData.BILLFLAG,
		}, {
			field : "billno",
			header : "单据编号",
			width : 150,
			headerAlign : "center",
			allowSort : true,
			visible: true,
		}, {
			field: "ownerid",
			headerAlign: "center",
			header: "业主",
			editor:OcmControl.newControl('fut_popselectgrid'),
			displayField : "ownerid_name",
			cdEdtCfg:{compnentType:'fut_popselect',selectkey:"owner"},
			visible:false,
			enabledSearch : true,
		}, {
			field : "thisdate",         
			header : "结算月份",
			headerAlign : "center",
			dataType : "date",
			dateFormat : "yyyy-MM",
			width : 100,
		}, {
			field: "ownerid_name",
			type: "TextBox",
			headerAlign: "center",
			header: "业主",
			enabledSearch : false,
			width: 180,
		},{
			field : "contno",
			headerAlign : "center",
			header : "合同号",
			allowSort : true,
			headerAlign : "center",
			width : 100,
		}, {
			field: "muid",
			headerAlign: "center",
			header: "门店",
			editor:OcmControl.newControl('fut_popselectgrid'),
			displayField : "muid_name",
			cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
			visible:false,
			enabledSearch : true,
		}, {
			field: "muid_name",
			type: "TextBox",
			headerAlign: "center",
			header: "门店",
			enabledSearch : false,
			width: 180,
		},{
			field : "inputer",
			header : "录入人",
			width : 100,
			allowSort : true,
			headerAlign : "center",	
			editor:OcmControl.newControl('fut_popselectgrid'),
			displayField : "inputer_name",
			cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
			visible:false,
			enabledSearch : true,
		},{
			field : "inputer_name",
			header : "录入人",
			allowSort : true,
			headerAlign : "center",	
			enabledSearch : false,
			width : 180,
		}, {
			field : "inputdate",
			type : "date",
			dataType : "date",
			format : "yyyy-MM-dd",
			header : "录入日期",
			width : 150,
			allowSort : true,
			headerAlign : "center",
			align : "center",
		}, {
			field : "auditor",
			header : "审核人",
			width : 100,
			allowSort : true,
			headerAlign : "center",
			editor:OcmControl.newControl('fut_popselectgrid'),
			displayField : "auditor_name",
			cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
			visible:false,
			enabledSearch : true,
		}, {
			field : "auditor_name",
			header : "审核人",
			width : 180,
			allowSort : true,
			headerAlign : "center",
			enabledSearch : false,
		}, {
			field : "auditdate",
			type : "date",
			format : "yyyy-MM-dd",
			header : "审核日期",
			width : 150,
			dataType : "date",
			allowSort : true,
			headerAlign : "center",
			align : "center",
		} ]
	},
};




var formheader1 = { 
		"type" : "formgrid",
	"properties": {
			"id": "formheader1",
	},
	items : [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
			}, {
				"lable": "billmoduleid",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": app.modulecode,
				"visible": false,
			}, {
				"label" : "结算月份：",
				"name" : "thisdate",
				"type" : "MonthPicker",
				"format" : "yyyy-MM",
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				data :  dictData.BILLFLAG,
				"readOnly": true,
			}, {
				"label" : "门店：",
				"name" : "muid_name",
				"type": "TextBox",
			}, {
				"label": "业主：",
				"name": "ownerid_name",
				"type": "TextBox",
			}, {
				"label": "合同号：",
				"name": "contno",
				"type": "TextBox",
			},{
				"label" : "返租金额：",
				"name" : "fzje",
				"type" : "NumButtonEdit",
				"format" : "c2",
				"defaultValue":0,
				"readOnly": true,
			},{
				"label" : "调整金额：",
				"name" : "qstz",
				"type" : "NumButtonEdit",
				"format" : "c2",
				"defaultValue":0,
				"readOnly": true,
			},{
				"label" : "费用金额：",
				"name" : "fyje",
				"type" : "NumButtonEdit",
				"format" : "c2",
				"defaultValue":0,
				"readOnly": true,
			},{
				"label" : "税金合计：",
				"name" : "tottaxje",
				"type" : "NumButtonEdit",
				"format" : "c2",
				"defaultValue":0,
				"readOnly": true,
			},{
				"label" : "税金大写：",
				"type": "TextBox",
				"name": "tottaxjedx",
				"readOnly": true,
			},{
				"label" : "应付金额：",
				"name" : "fkje",
				"type" : "NumButtonEdit",
				"format" : "c2",
				"defaultValue":0,
				"readOnly": true,
			}, {
				"label": "开户银行：",
				"type": "TextBox",
				"name": "bank",
				"readOnly": true,
			}, {
				"label": "收款人：",
				"type": "TextBox",
				"name": "skr",
				"readOnly": true,
			}, {
				"label": "银行账号：",
				"type": "TextBox",
				"name": "accntno",
				"readOnly": true,
			}, {
				"label": "备注：",
				"name": "memo",
				"type": "TextBox",
				"visible": false,
				"style": "width:90%",
			},{
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
			}, {
				"label": "作废人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "作废日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}
		]
	}



//费用合计
var lb_supsettledet = {
	"type" : "gridbox",
	"properties": {
				"id": 'lb_supsettledet',
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu":true,
				"showSummaryRow":true,
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"oncellendedit" : 'OcmControl.datetimeFormate',
				"columns": [{
					type: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
					width: 30,
				}, {
					field: "browno",
					type : "indexcolumn",
					header: "行号",
					headerAlign: "center",
				  	readOnly : true,
				}, {
					field : "cccode",
					name : "cccode",
					header : "费用项目",
					headerAlign : "center",
					allowSort : true,
					editor : OcmControl.newControl('fut_popselectgrid'),
					displayField : "cccode_name",
					width : 160,
					editorSet : {
						selectkey : 'lbcccode',
					},
					readOnly : true,
				}, {
					field : "edate",
					header : "核算月",
					width : 100,
					allowSort : true,
					headerAlign : "center",
					align : "center",
					editor : OcmControl.newControl('MonthPicker'),
					dataType : "date",
					dateFormat : "yyyy-MM",
					editorSet : {
						format : "yyyy-MM",
					},
					readOnly : true,
					width : 160,
				}, {
					field : "amount",
					header : "参考金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
					visible: false,
				}, {
					field : "tzje",
					header : "调整金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
					visible: false,
				}, {
					field : "ye",
					header : "应付金额",
					headerAlign : "center",
					width : 160,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				}, {
					field : "memo",
					header : "备注信息",
					allowSort : false,
					width : 400,
		} ]
	},
};




	 




var tabs2 = {
	properties : {
		id : "details1tabs",
	},
	items : [ {
		"title" : "销售收入",
		"name" : "lb_supsettledet",
		"control" : lb_supsettledet
	} ]
};



var details1 = {
	"type" : "formgrid",
	"resources" : OmdUrl.mall,
	"method" : "mss.work.lbsupsettle.get",
	"response" : "lb_supsettlehead",
	<% if (!billno.equals("0")) {%>
	"searchParam": {"billno": "<%= billno %>"},
	<% } %>
	"properties" : {
		"id" : "details1",
	},
	"items" : formheader1.items,
	"tabs" : tabs2,
};

var tabs1 = {
	properties : {
		"id" : "tabs1"
	},
	items : [ {
		"title" : "单据列表",
		"name" : "list",
		"control" : gridbox1,
	}, {
		"title" : "单据明细",
		"name" : "details1",
		"control" : details1,
	} ]
};


var config1 = {
	properties : {
		"id" : "config1",
		"name" : "config1",
	},
	toolbar : toolbar1,
	tabs : tabs1,
};


mini.parse();

</script>
<script src="lbsettlement.js" type="text/javascript"></script>
</style>
</body>
</html>