/**
 *  页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('lbsupsetpay.view');
	// 定义一个对象用来配置界面
	var bill = {};
	var billtype = getBilltype(app.modulecode);
	
	// 把定义对象放到命名空间下
	ns.bill = bill;
	utils.billtype = billtype;
	//查询列表
	bill.lbsupsetpaylist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.work.lbsupsettlepay.search",
		"response": "lb_supsettlepayhead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段		
		"searchParam": {
			"billtype" : billtype,
			"order_field": "billno",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('lbsupsetpaylist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 160,
			}, {
				field : "billstatus",
				header : "单据状态",
				allowSort : true,
				headerAlign : "center",
				renderer : "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
			}, {
				field: "muid",
				displayField : "muid_name",
				headerAlign: "center",
				header: "门店",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "muid",
					textName : "muid_name",
					responseName : "muid"
				},
				width: 160,
			}, {
				field: "ownerid",
				displayField : "ownerid_name",
				headerAlign: "center",
				header: "业主",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "owner",
					textName : "ownerid_name",
				},
				width: 200,
			}, {
				field: "money",
				type: "TextBox",
				headerAlign: "center",
				header: "本次付款",
				width: 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				enabledSearch : false,
			}, {
				field: "paydate",
				header: "实际付款日期",
				type: "DatePicker",
				headerAlign: "center",
				dataType: "date",
				dateFormat: "yyyy-MM-dd",
				width: 150,
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer_name",
				header : "录入人",
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
				width : 180,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 180,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "memo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
			}]
		}
	};
	
	//单据主表
	bill.lbsupsetpayhead = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'lb_supsettlepayhead',
		"method": "mss.work.lbsupsettlepay.get",
		"response": "lb_supsettlepayhead",
		"properties": {
			"id": utils.createid('lb_supsettlepayhead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "ComboBox",
				"defaultValue": billtype,
				dictkey: 'BILLTYPE',
				"visible": false,
				"readOnly": true,
			}, {
				"lable": "billmoduleid",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": app.modulecode,
				"visible": false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, {
				"label" : "门店：",
				"name" : "muid",
				"defaultValue" : "",
				"required" : "true",
				type : "fut_popselect",//类型
				selectkey:"muid",//弹框类型
				textName :"muid_name", //文本显示字段
				"enabled" : true,
				beforefunc : "page.head_beforefunc",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label" : "业主：",
				"name" : "ownerid",
				"defaultValue" : "",
				"required" : "true",
				type : "fut_popselect",//类型
				selectkey:"owner",//弹框类型
				textName :"ownerid_name", //文本显示字段
				"enabled" : true,
				beforefunc : "page.head_beforefunc",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": "业主类型：",
				"name": "ownertype",
				"type": "ComboBox",
				dictkey: 'OWNERTYPE',
				"readOnly": "true",
			}, {
				"label" : "实际付款日期：",
				"type" : "DatePicker",
				"name" : "paydate",
				"format" : "yyyy-MM-dd",
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
		        "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"enabled" : true,
			},{
				"label" : "本次付款：",
				"name" : "money",
				"type" : "NumButtonEdit",
				"format" : "c2",
				"defaultValue":0,
				"readOnly": true,
			}, {
				"label": "付款大写：",
				"type": "TextBox",
				"name": "moneyupper",
				"readOnly": true,
			}, {
				"label": "银行账号：",
				"type": "TextBox",
				"name": "accntno",
				"readOnly": "true",
			}, {
				"label": "收款人：",
				"type": "TextBox",
				"name": "skr",
				"readOnly": "true",
			}, {	
				"label": "开户银行：",
				"type": "TextBox",
				"name": "bank",
				"readOnly": "true",
			}, {
				"label": "备注：",
				"name": "memo",
				"type": "TextBox",
				"visible": true,
				"style": "width:90%",
			},{
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
			}, {
				"label": "作废人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "作废日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}
		]
	}
	bill.lbsupsetpaydet= {
			title: '单据明细',
			"type": "gridbox",
			name: 'lb_supsettlepaydet',
			"properties": {
				"id": utils.createid('lb_supsettlepaydet'),
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu":true,
				"showSummaryRow":true,
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"oncellendedit" : 'OcmControl.datetimeFormate',
				"ondrawsummarycell" : onDrawSummaryCell,
				"columns": [{
					type: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
					width: 30,
				}, {
					field: "browno",
					type : "indexcolumn",
					header: "行号",
					headerAlign: "center",
				  	readOnly : true,
				}, {
					field: "rowno",
					header: "行号",
					headerAlign: "center",
					visible : false,
				}, {
					field : "jsbillno",
					header : "结算单号",
					headerAlign : "center",
					width : 150,
					renderer:"page.onJsbillno",
					readOnly : true,
				}, {
					field : "contno",
					header : "合同号",
					headerAlign : "center",
					allowSort : true,
					readOnly : true,
					width : "160",
				}, {
					field : "thisdate",
					header : "结算月份",
					width : 100,
					allowSort : true,
					headerAlign : "center",
					align : "center",
					editor : OcmControl.newControl('MonthPicker'),
					dataType : "date",
					dateFormat : "yyyy-MM",
					editorSet : {
						format : "yyyy-MM",
					},
					readOnly : true,
				}, {
					field : "fzje",
					header : "返租金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true
				}, {
					field : "qstz",
					header : "调整金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true
				}, {
					field : "tottaxje",
					name : "tottaxje",
					header : "税金",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true
				}, {
					field : "yfje",
					header : "应付金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true
				
				}, {
					field : "ysje",
					header : "费用金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true
				
				}, {
					field : "yfamount",
					header : "已结金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true
				}, {
					field : "amount",
					header : "未结金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true
				}, {
					field : "ye",
					name : "ye",
					header : "本次付款",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				}]
			},
		};
	
	function onDrawSummaryCell(e) {
    	var rows = e.data;
		var amount = 0.00;var yfje = 0.00; 
		var yfamount = 0.00;var ysje = 0.00;
		var tottaxje = 0.00;var ye = 0.00;
		var fzje = 0.00;var qstz = 0.00;
		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.tottaxje) == false) {
					tottaxje += parseFloat(row.tottaxje);
				}
				if (isNaN(row.amount) == false) {
					amount += parseFloat(row.amount);
				}
				if (isNaN(row.yfamount) == false) {
					yfamount += parseFloat(row.yfamount);
				}
				if (isNaN(row.yfje) == false) {
					yfje += parseFloat(row.yfje);
				}
				if (isNaN(row.ysje) == false) {
					ysje += parseFloat(row.ysje);
				}
				if (isNaN(row.ye) == false) {
					ye += parseFloat(row.ye);
				}
				if (isNaN(row.fzje) == false) {
					fzje += parseFloat(row.fzje);
				}
				if (isNaN(row.qstz) == false) {
					qstz += parseFloat(row.qstz);
				}
			}
		}

		if (e.field == "lbspid") {
			e.cellHtml = "<b>"+"合计: "+"</b>";
		}
		if (e.field == "yfamount") {
			e.cellHtml ="<b>"+ yfamount.toFixed(2)+"</b>";
		}
		if (e.field == "amount") {
			e.cellHtml = "<b>"+amount.toFixed(2)+"</b>";
		}
		if (e.field == "tottaxje") {
			e.cellHtml ="<b>"+ tottaxje.toFixed(2)+"</b>";
		}
		if (e.field == "yfje") {
			e.cellHtml ="<b>"+ yfje.toFixed(2)+"</b>";
		}
		if (e.field == "ysje") {
			e.cellHtml = "<b>"+ysje.toFixed(2)+"</b>";
		}
		if (e.field == "ye") {
			e.cellHtml ="<b>"+ ye.toFixed(2)+"</b>";
		}
		if (e.field == "fzje") {
			e.cellHtml ="<b>"+ fzje.toFixed(2)+"</b>";
		}
		if (e.field == "qstz") {
			e.cellHtml ="<b>"+ qstz.toFixed(2)+"</b>";
		}
		e.cellStyle = "text-align:right";
    }
	
	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData,btn.editData, btn.saveData, btn.delData,btn.separator,btn.auditData,btn.cancelData,btn.searchData]
	}
	// 单据配置
	bill.billconfig = {
		billhead: bill.lbsupsetpayhead, // 单据主表
		billdetail: [bill.lbsupsetpaydet], // 单据明细表
		billquerylist: bill.lbsupsetpaylist, // 查询列表
		dettabpages: [bill.lbsupsetpaydet], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
