
(function () {
    // 命名空间
    /** @namespace Future.lbsupsetpay.out */
    var ns = Future.ns('lbsupsetpay.out'); 
    var utils = Future.ns('utils');
    var validate = Future.ns('validate'); 
    var billtype =utils.billtype;
    var Lbsupsetpay = function () {
    	Lbsupsetpay.superclass.constructor.call(this);
        this.servicekey = 'mss';
        this.head_beforefunc = this.head_beforefunc.bind(this);
        this.head_itemchangedfunc = this.head_itemchangedfunc.bind(this);
        this.onJsbillno = this.onJsbillno.bind(this);
        this.onCellclick = this.onCellclick.bind(this);
        
    }
    ns.Lbsupsetpay = Lbsupsetpay;
    
    Future.extend(ns.Lbsupsetpay, Future.pub.Basebill, {
    	_initview: function () {
    		Lbsupsetpay.superclass._initview.call(this);
        },
        initevent : function() {
        	Lbsupsetpay.superclass.initevent.call(this);
        	this.lb_supsettlepaydet.on('cellcommitedit', this.detcellcommitedit, this);
		},
        changeView: function (colname) {
        },
        head_beforefunc : function(e) {
        	var colname = e.sender.name;
        	var muid = this.lb_supsettlepayhead.form.getField('muid').value;
        	var ownerid = this.lb_supsettlepayhead.form.getField('ownerid').value;
			if (!e.searchParam) {
				e.searchParam = {};
			}
			if (this.lb_supsettlepaydet.data.length > 0) {
				mini.alert("明细已存在数据,请先删除后再修改门店");
				return -1;
			}
			if (colname == "ownerid") {
				if (!muid) {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = " Ownermkt.muid ='" + muid + "'";
			}
		},
		head_itemchangedfunc: function(e, data) {
			 var colname = e.sender.name;
	         if(colname=='muid'){
	        	 this.billhead.setValueText('ownerid', "","");
		         this.billhead.setValue('skr', "");
		         this.billhead.setValue('bank', "");
		         this.billhead.setValue('accntno', "");
		         this.billhead.setValue('ownertype', "");
	         }
	         if(colname=='ownerid'){
		         this.billhead.setValue('skr', data[0].ownerskr);
		         this.billhead.setValue('bank', data[0].ownercbank);
		         this.billhead.setValue('accntno', data[0].owneraccno);
		         this.billhead.setValue('ownertype', data[0].ownertype);
	         }
	         return 1;
		},
        initcontrol: function () {
        	Lbsupsetpay.superclass.initcontrol.call(this);
        },
        addTabsGridRowBefore : function() {
        	var muid = this.lb_supsettlepayhead.form.getField('muid').value;
        	var ownerid = this.lb_supsettlepayhead.form.getField('ownerid').value;
        	var lb_supsettlepaydet = this.lb_supsettlepaydet.getData();
        	var that = this;
        	var url = "/mall-business-ui/pages/wizard/gridbox_ws-view.jsp?key=lbsupsetpay"
			if (app.token && app.token != "")
			{
				url = url + "&token="+ app.token;
			}
			if (app.srvkey && app.srvkey != "")
			{
				url = url + "&srvkey="+ app.srvkey;
			}
        	mini.open({
    			url : encodeURI(url),
    			title : "结算明细选择",
    			width : $(window).width()*0.8,
    			height : 400,
    			onload : function() {
    				var iframe = this.getIFrameEl();
    				var data = {};
    				data.searchParam = {};
    				data.searchParam.muid = muid;
    				data.searchParam.ownerid = ownerid;
    				iframe.contentWindow.SetData(data);
    			},
    			ondestroy : function(data) {
    				if(data != "close"){
                		if(data.length > 0){
                			var flag = true;
                			var list = []
                			var cur = lb_supsettlepaydet.length;
                			for (var j = 0; j < data.length; j++) {
                				flag =false;
	     		        		for (var i = 0; i < lb_supsettlepaydet.length; i++) {
	     		        			if (lb_supsettlepaydet[i].jsbillno == data[j].jsbillno) {
	     		        				flag = true;
	     		        				break;
	     							}
	     		        		}
	     		        		if (!flag) {
	     		        			cur++;
	     		        			data[j].rowno = cur;
	     		        			data[j].ye	= '0';
	     		        			list.push(data[j]);
	     		        		}
	     					}
                			if (list.length > 0) {
                				that.lb_supsettlepaydet.addRows(list);
                			}
                		}
                	}
    			}
    		});
		},
		onJsbillno : function(e){
			var s = '<a class="New_Button" href="javascript:void(0)" onclick="page.onCellclick()"><u>' +e.cellHtml + '</u></a>';
			 return s;
		},
		onCellclick : function(e){
				var row = this.lb_supsettlepaydet.getSelecteds();
				var billno = row[0].jsbillno;
				var url = "/mall-business-ui/pages/leaseback/lbsettlement-view.jsp?viewdetail=Y&billno="+billno+"&billmoduleid=400108&token="+getUrlParam("token");
			if (app.srvkey && app.srvkey != "")
			{
				url = url + "&srvkey="+ app.srvkey;
			}
				mini.open({
					url : encodeURI(url),
					title : "结算单明细",
					width : $(window).width()*0.7,
					height : $(window).height(),
					onload: function () {
						var iframe = this.getIFrameEl();
						var data = {};
						iframe.contentWindow.initSetData(iframe.contentWindow.page);
					}	
				});
		},
        addDataAfter:function(){
        	 this.billhead.setValue('inputer', getUserCode());
	         this.billhead.setValue('inputer_name', getUserName());
	         this.billhead.setValue('inputdate', new Date());
        },
        delTabsGridRowBefore: function (e) {
			 var row = this.lb_supsettlepaydet.getSelecteds();
			 this.getCommitedit(row,"1");
			 return 0;
		},
        detcellcommitedit : function(e) {
        	if(parseFloat(e.row.amount) > 0){
        		if(parseFloat(e.value) <= 0 ){
        			mini.alert("本次付款金额必须大于0!");
            		e.cancel = true;
    				return -1;
        		}
        		if(parseFloat(e.value) > parseFloat(e.row.amount)){
        			mini.alert("本次付款金额不能超过未结金额!");
            		e.cancel = true;
    				return -1;
        		}
        	}else{
        		if(parseFloat(e.value) >= 0 ){
        			mini.alert("本次付款金额必须小于0!");
            		e.cancel = true;
    				return -1;
        		}
        		if(parseFloat(e.value) < parseFloat(e.row.amount)){
        			mini.alert("本次付款金额不能超过未结金额!");
            		e.cancel = true;
    				return -1;
        		}
        	}
        		
        	this.getCommitedit(accSub(e.value,e.oldValue),"2")
        },
        getCommitedit : function(data,type){
        	var money    = this.billhead.form.getField("money").value;
        	if (type == '2') {
        		money = accAdd(money,data);
			}else {
				for (var i = 0; i < data.length; i++) {
					money = accSub(money,data[i].ye);
				}
				this.billhead.setValue('money', money);
			}
        	
        	var moneyupper = changeMoneyToChinese(money);
			this.billhead.setValue('money', money);
			this.billhead.setValue('moneyupper', moneyupper);
        },
        checkValidate: function () {
            var isValid = Lbsupsetpay.superclass.checkValidate.call(this);
            if (isValid == false) {
                return isValid;
            }
        	if (this.lb_supsettlepaydet.data.length < 1) {
				mini.alert("明细无数据,不能保存");
				return false;
			} else {
				var data = this.lb_supsettlepaydet.getData();
				for (var i=0;i<data.length;i++) {
					var cur = i+1;
					var row = {};
					if (!data[i].rowno) {
						row.rowno = cur;
						this.lb_supsettlepaydet.updateRow(data[i], row);
					} else if (Number(data[i].rowno) != cur) {
						row.rowno = cur;
						this.lb_supsettlepaydet.updateRow(data[i], row);
					}
				}
			}
            return true;
        }
    });
})()