<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>房态图分析维度定义</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-layout" config="fmdimlayout"
		beforeload="beforeload" borderStyle="border:0px;"
		style="width: 100%; height: 100%;"></div>

	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mss-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	<script type="text/javascript">
		// 字典数据初始化
		 function getDictData() {
		 var dictData = {};
		   var searchParam = {"dict_group_code":"BILLMODULEID,BILLFLAG"};
					  itemLoader.doRequest(OmdUrl.master, "omp.work.dict.getbydictgroupcode",
							 searchParam, null, null, function(data) {
						 dictData = data;
			}, null, null, false);
		  return dictData;
		}
	    
	    var dicData = getDictData(); 
	 
		var billmoduleid = "400407";
		var corpvalue;
		if (dicData.corp) {
			corpvalue = dicData.corp[0].code;
		}
		dicData["DIMTYPE"] = [{code:"1",name:"文本"},{code:"2",name:"背景色"},{code:"3",name:"图标"}];
		
		// 页面布局配置
		var toolbar1 = {
			rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消
				'billstatus' : {
					'Y' : [ 'addData', 'searchData' ],
					'N' : [ 'addData', 'editData', 'delData', 'searchData' ],
					'C' : [ 'addData', 'searchData' ]
				}
			},
			status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
				'N' : [ 'addData', 'saveData', 'searchData' ],
				'V' : [ 'addData', 'editData', 'delData', 'searchData' ],
				'E' : [ 'addData', 'saveData', 'delData', 'searchData' ],
				'S' : [ 'addData', 'editData', 'delData', 'searchData' ],
				'A' : [ 'addData', 'searchData' ],
				'C' : [ 'addData', 'searchData' ],
				'D' : [ 'addData', 'searchData' ],
			},
			items : [ [ {
				'text' : '新增',
				'iconCls' : 'icon-add',
				'name' : 'addData'
			}, {
				'text' : '修改',
				'iconCls' : 'icon-edit',
				'name' : 'editData'
			}, {
				'text' : '保存',
				'iconCls' : 'icon-save',
				'name' : 'saveData'
			} ], [ {
				'text' : '删除',
				'iconCls' : 'icon-remove',
				'name' : 'delData'
			}, {
				'text' : '查询',
				'iconCls' : 'icon-search',
				'name' : 'searchData'
			} ] ]
		};
		
		//单据列表
		var fmdimlist = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.fmdim.search",
			"response" : "fmdimhd",
			/* "manualLoad" : false, */
			"bindform" : "layouttabs", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段 
			"searchParam" : {
				"billmoduleid" : "400407",
				"order_field" : "billno",
				"order_direction" : "desc",
			},
			"properties" : {
				"id" : "fmdimlist",
				"columns" : [ {
					type : "indexcolumn",
					headerAlign : "center",
					header : "行号",
					width:80,
				}, {
					field : "billno",
					headerAlign : "center",
					header : "单据编码",
					allowSort : true,
					width:160,
				},{
					field : "billsgno",
					headerAlign : "center",
					header : "手工编码",	
					allowSort : true,
					width:160,
				},{
					field : "billstatus",
					headerAlign : "center",
					header : "单据状态",	
					width : 150,
					allowSort : true,
					renderer: "OcmControl.dictRendererWithCode",
				    data: dicData.BILLFLAG,
				},{
					field : "dimname",
					header : "维度名称",
					width : 150,
					allowSort : true,
					headerAlign : "center",
					visible : false,
				},{
					field : "dimtype",
					header : "维度类型",
					width : 150,
					allowSort : true,
					headerAlign : "center",
				},{
					field : "dimfieldname",
					header : "维度判断字段",
					width : 150,
					allowSort : true,
					headerAlign : "center",
				}],
			},
		};

		//单据头
		var fmdimformheader = {
			"type" : "formgrid",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.fmdim.search",
			"response" : "fmdimhd",
			"properties" : {
				"id" : "fmdimformheader",
			},
			items : [ {
				"label" : "ph_key：",
				"type" : "TextBox",
				"name" : "ph_key",
				"readOnly" : "true",
				"visible" : false,
			}, {
				"label" : "单据编码：",
				"id" : "billno",
				"name" : "billno",
				"type" : "TextBox",
				"required" : "true",
				"readOnly" : true,
			},{
				"label" : "单据类别：",
				"name" : "billmoduleid",
				"type" : "ComboBox",
				"data" : dicData.BILLMODULEID,
				"defaultValue" : billmoduleid,
				"readOnly" : true,
			}, {
				"label" : "维度名称：",
				"name" : "dimname",
				"type" : "TextBox",
				"required" : true,
			}, {
				"label" : "手工编码：",
				"name" : "billsgno",
				"type" : "TextBox",
				"defaultValue" : "",
			}, {
				"label" : "单据状态：",
				"name" : "billstatus",
				"type" : "ComboBox",
				"data" : dicData.BILLFLAG,
				"defaultValue" : "N",
				"readOnly" : true,
			}, {
				"label" : "维度类型：",
				"name" : "dimtype",
				"type" : "ComboBox",
				"data" : dicData.DIMTYPE,
				"defaultValue" : "1",
				"onvaluechanged": "typechanged"
			}, {
				"label" : "维度SQL：",
				"name" : "dimsql",
				"type" : "TextArea",
				"style" : "width:90%;height:300px;",
			}, {
				"label" : "维度判断字段：",
				"name" : "dimfieldname",
				"type" : "TextBox",
				"required" : true,
			}, {
				"label" : "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
			}, 	{
				"label" : "录入人编码：",
				"type" : "TextBox",
				"name" : "inputer",
				"visible":false,
			}, {
				"label" : "录入日期：",
				"name" : "inputdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
			}  ]
		};

		 //------------------以下为单据明细的tab页面----------------------
		//条件grid
		var fmdimdet = {
			"type" : "gridbox",
			"properties" : {
				"id" : "fmdimdet",
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu":true,
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"columns" : [ {
					type : "checkcolumn",
					headerAlign : "center",
					readOnly : true,
					width:60,
				}, {
					type : "indexcolumn",
					headerAlign : "center",
					header : "行号",
					readOnly : true,
					width:60,
				}, {
					field : "dimfieldvalue",
					name : "dimfieldvalue",
					headerAlign : "center",
					header : "维度判断字段值",
					width:100,
					allowSort : true,
					required : true,
				}, {
					field : "dimvalue",
					name : "dimvalue",
					headerAlign : "center",
					header : "维度值",
					width:160,
					allowSort : true,
					required : true,
					editor : OcmControl.newControl('TextBox'),
					editorSet: {onfocus: "onDimValueFocus"}
				} ]
			}
		};
		 
		//单据明细
		var detailtabs = {
			properties : {
				id : "detailtabs",
			},
			items : [ {
				"title" : "维度明细",
				"name" : "fmdimdet",
				"control" : fmdimdet
			} ]
		};

		//单据明细组成：单据头+单据明细tab
		var formdetail = {
			"type" : "formgrid",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.fmdim.get",
			"response" : "fmdimhd",
			"properties" : {
				"id" : "formdetail",
			},   
			 "items" : fmdimformheader.items,  //绑定到具体的项
			 "tabs" : detailtabs,  //直接绑定tab

		}; 

		//单据列表和单据明细
		var layouttabs = {
			properties : {
				"id" : "layouttabs"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "fmdimlist",
				"control" : fmdimlist,
			} , {
				"title" : "单据明细",
				"name" : "formDetail",
				"control" : formdetail,
			}  ]
		};

		var fmdimlayout = {
			"properties" : {
				"id" : "fmdimlayout",
			},
			"toolbar":toolbar1,
			"tabs" : layouttabs,

		};
		/* mini.parse();  */
	</script>
	<script src="fmdim.js" type="text/javascript"></script>
	<style type="text/css">


/* .mini-labelfield-label,body .mini-checkbox label {
    width: 138px!important;
  }
.ocm-formheader .mini-labelfield > span, .ocm-details .mini-labelfield > span {
  margin-left: 138px!important;
}
body .mini-labelfield-checkboxlist table, .mini-checkbox-check {
  margin-left: 138px!important;
} */
</style>
</body>
</html>