<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>楼层平面图</title>
<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
<script src="pixi.min.js"></script>
<style type="text/css">
	html, body {
		margin: 0;
	}
</style>
</head>
<body>
	<div id="layout1" class="mini-layout" style="width: 100%; height: 100%;" borderStyle="border:solid 1px #aaa;">
	    <div title="楼层" showProxyText="true" region="west" width="200" expanded="true" showSplitIcon="true">
	        <ul id="tree" class="mini-tree" style="width:300px;padding:5px;" 
                showTreeIcon="true" textField="text" idField="id" value="base" expandOnNodeClick="true">        
            </ul>
	    </div>
	    <div title="center" region="center"  >
	    	<iframe id="mapframe" style="width:100%;height:100%;" frameborder="no" border="0" marginwidth="0" marginheight="0" scrolling="auto" allowtransparency="yes"></iframe>
	    </div>
	</div>
</body>
<script type="text/javascript">

	var renderer = null;
	var stage = null;
	var img = null;
	var ratio = null;
	var areas = null;
	var bg = null;
	var tree = null;

	$(document).ready(function() {

	    $("#layout1").height(window.innerHeight);
	    $("#content").height(window.innerHeight - 38);
	    
	    tree = mini.get("tree");
	    itemLoader.doRequest(OmdUrl.mss, "mss.work.floormap.searchtree", {}, null, null, function (data) {
	    	var json = {};
	    	$.each(data, function(inx, item) {
	    		if(json[item.muid] == null) {
		    		json[item.muid] = {
	    				id: item.muid,
	    				text: "[" + item.mmfcode + "]" + item.mucname,
	    				iconCls: "icon-folder",
	    				children: [{
	    					id: item.muid + item.mmfid,
	    					text: "[" + item.mmfcode + "]" + item.mmfcname,
	    					mktid: item.muid,
	    					floorid: item.mmfid
	    				}]
		    		};
	    		} else {
	    			json[item.muid].children.push({
	    				id: item.muid + item.mmfid,
    					text: "[" + item.mmfcode + "]" + item.mmfcname,
    					mktid: item.muid,
    					floorid: item.mmfid
    				});
	    		}
	    	});
	    	var treedata = [];
	    	$.each(json, function(inx, obj) {
	    		treedata.push(obj);
	    	});
	    	tree.loadData(treedata);
	   	},null, null, false);
	    
	    tree.on("nodeclick", function(e) {
	    	if(e.isLeaf) {
	    		$("#mapframe").attr("src", "map.jsp?mktid=" + e.record.mktid + "&floorid=" + e.record.floorid + "&showuploadbtn=true");
	    	} else {
	    		$("#mapframe").attr("src", "");
	    	}
	    });
	});

</script>
</html>