<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>楼层平面图</title>
<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
<script src="pixi.min.js"></script>
<script src="pixi-display.js"></script>
<style type="text/css">
	html, body {
		margin: 0;
	}
</style>
</head>
<body>
	<div id="layout1" class="mini-layout" style="width: 100%; height: 100%;" borderStyle="border:solid 1px #aaa;">
	    <div title="center" region="center"  >
			<div id="toolbar" class="mini-toolbar" style="height: 26px;">
				<a name="uploadImgBtn" class="mini-button" iconCls="icon-add" enabled="false" onClick="openUploadImg()">上传房态图</a>
				<input id="uploadImg" name="uploadImg" type="file" style="display: none;" onchange="uploadImg()"/>
				<a name="uploadDataBtn" class="mini-button" iconCls="icon-add" enabled="false" onClick="openUploadXml()">上传房态图数据</a>
				<input id="uploadXml" name="uploadXml" type="file" style="display: none;" onchange="uploadXml()"/>
				<label style="font-family:Verdana;">缩放: </label>
				<input type="range" id="scalebar" style=" position: relative; top: 3px; " min="1" max="5" step="1" value="1" oninput="onScale()" disabled="disabled" />
			</div>
			<div id="content" style="overflow: auto;">
				<div id="pixicanvas"></div>
			</div>
	    </div>
	</div>
</body>
<script type="text/javascript">

	var renderer = null;
	var stage = null;
	var img = null;
	var ratio = null;
	var scale = null;
	var areas = [];
	var bg = null;
	var tree = null;
	
	var mktid = getUrlParam("mktid");
	var floorid = getUrlParam("floorid");
	var showuploadbtn = (getUrlParam("showuploadbtn") == null || getUrlParam("showuploadbtn") == "") ? false : getUrlParam("showuploadbtn");
	var imgkey = "";
	var xmlkey = "";
	var dims = [];

	var bgLayer = new PIXI.DisplayGroup(0, true);
	bgLayer.on('add', function (sprite) {
	    sprite.zOrder = 0;
	});
	var textLayer = new PIXI.DisplayGroup(1, true);
	textLayer.on('add', function (sprite) {
	    sprite.zOrder = 1;
	});
	var iconLayer = new PIXI.DisplayGroup(2, true);
	iconLayer.on('add', function (sprite) {
	    sprite.zOrder = 2;
	});

	$(document).ready(function() {
		var _url = "/mall-business-ui/pages/map/fmplanselect.jsp";
		if (app.token && app.token != "")
		{
			_url = _url + "?token="+ app.token;
		}
		if (app.srvkey && app.srvkey != "")
		{
			_url = _url + "&srvkey="+ app.srvkey;
		}
		mini.open({
			url: encodeURI(_url),
			title: "选择方案", 
			width: 600, 
			height: 450,
			allowResize: false,
			onload: function () {
			},
			ondestroy: function (data) {
				if(data != "close") {
					if(data != null) {
						// 加载方案
						itemLoader.doRequest(OmdUrl.mss, "mss.work.floormap.searchfromplan", {
							billno: data.billno
						}, null, null, function (data) {
							// 文字维度
							dims.push(data.dim1);
							// 背景色维度
							dims.push(data.dim2);
							// 图标维度
							dims.push(data.dim3);
					   	},null, null, false);
						
						// 加载img和xml
						itemLoader.doRequest(OmdUrl.mss, "mss.work.floormap.search", {
							floorid: mktid + floorid
						}, null, null, function (data) {
							if(data != null && data.floormap.length > 0) {
								imgkey = data.floormap[0].imgkey;
								xmlkey = data.floormap[0].xmlkey;
								if(imgkey != null && imgkey != "") {
									img = new Image();
									img.src = "/mall-fileservice/xload/download/mongo/image/1/" + imgkey;
									img.onload = function() {
										if(xmlkey != null && xmlkey != "") {
											areas = loadXml(xmlkey);
										} else {
											mini.alert("无房态图数据");
										}
										initMap(img, 1);
								    };
								}
							}
					   	},null, null, false);
					    
					    $("#content").height(window.innerHeight - 38);
					}
				}
			}
		});
	    
	    if(mktid == null || mktid == "" || floorid == null || floorid == "") {
	    	disableToolbar();
	    } else {
	    	enableToolbar();
	    }
	});
	
	function enableToolbar() {
		var uploadImgBtn = mini.getbyName("uploadImgBtn");
		var uploadDataBtn = mini.getbyName("uploadDataBtn");
		uploadImgBtn.setEnabled(true);
		uploadDataBtn.setEnabled(true);
		if(showuploadbtn == true || showuploadbtn == "true") {
			uploadImgBtn.show();
			uploadDataBtn.show();
		} else {
			uploadImgBtn.hide();
			uploadDataBtn.hide();
		}
		$("#scalebar").prop("disabled", "");
	}

	function disableToolbar() {
		var uploadImgBtn = mini.getbyName("uploadImgBtn");
		var uploadDataBtn = mini.getbyName("uploadDataBtn");
		uploadImgBtn.setEnabled(false);
		uploadDataBtn.setEnabled(false);
		if(showuploadbtn == true || showuploadbtn == "true") {
			uploadImgBtn.show();
			uploadDataBtn.show();
		} else {
			uploadImgBtn.hide();
			uploadDataBtn.hide();
		}
		$("#scalebar").prop("disabled", "disabled");
	}
	
	/* function initMap(img, zoom) {
		
		Object.keys(PIXI.utils.TextureCache).forEach(function(texture) {  PIXI.utils.TextureCache[texture].destroy(true);});
		
		delete renderer;
		delete stage;
		//$("#pixicanvas").html("");
		//document.getElementById("pixicanvas").innerHtml = "";

		ratio = img.width / img.height;
		var scale = window.innerWidth / img.width;
		// create the root of the scene graph
		if(stage == null) {
			renderer = PIXI.autoDetectRenderer(window.innerWidth * zoom - 25, window.innerWidth / ratio * zoom, { antialias: true });
			document.getElementById("pixicanvas").appendChild(renderer.view);
			stage = new PIXI.Container();
		} else {
			$.each(stage.children, function(inx, child) {
				stage.removeChild(child);
			});
		}
		stage.interactive = true;

		// 添加楼层图
		bg = PIXI.Sprite.fromImage(img.src);
		bg.scale.set(window.innerWidth / img.width * zoom, window.innerWidth / ratio / img.height * zoom);
		bg.position.x = 0;
		bg.position.y = 0;
		stage.addChild(bg);

		for(var i = 0; i < areas.length; i++) {
			var id = areas[i].id;
			var title = areas[i].title;
			var arealine = areas[i].arealine;
			var ary = arealine.split(",");

			var leftTop = {x: 0, y: 0};
			var rightBot = {x: 0, y: 0};
			
			var graphics = new PIXI.Graphics();
			graphics.beginFill(0xFF3300);
			for(var j = 0; j < ary.length / 2; j++) {
				var x = parseFloat(ary[j * 2]);
				var y = parseFloat(ary[j * 2 + 1]);
				if(j == 0) {
					leftTop = {x: x, y: y};
					rightBot = {x: x, y: y};
					graphics.moveTo(x * scale * zoom, y * scale * zoom);
					continue;
				}
				graphics.lineTo(x * scale * zoom, y * scale * zoom);

				// 左上
				if(x <= leftTop.x) {
					if(x + y <= leftTop.x + leftTop.y) {
						leftTop.x = x;
						leftTop.y = y;
					}
				}
				
				// 右下
				if(y >= rightBot.y) {
					if(x + y >= rightBot.x + rightBot.y) {
						rightBot.x = x;
						rightBot.y = y;
					}
				}
			}
			graphics.endFill();

			// 添加点击事件
			graphics.interactive = true;
			graphics.on('mousedown', onClick.bind(this, id));
			stage.addChild(graphics);
			
			// 添加标题
			var titleText = new PIXI.Text(title, {
				fontSize: '2px'
			});
			titleText.x = (parseFloat(leftTop.x) + 20)  * scale * zoom;
			titleText.y = (parseFloat(leftTop.y) + ((rightBot.y - leftTop.y) / 2) - 30) * scale * zoom;
			stage.addChild(titleText);
			
			delete graphics;
		}

		animate();
	} */
	
	function initMap(img) {
		
		Object.keys(PIXI.utils.TextureCache).forEach(function(texture) {  PIXI.utils.TextureCache[texture].destroy(true);});
		
		delete renderer;
		delete stage;

		ratio = img.width / img.height;
		scale = window.innerWidth / img.width;
		// create the root of the scene graph
		if(stage == null) {
			renderer = PIXI.autoDetectRenderer(img.width - 25, img.height, { antialias: true });
			document.getElementById("pixicanvas").appendChild(renderer.view);
			stage = new PIXI.Container();
			stage.displayList = new PIXI.DisplayList();
		} else {
			$.each(stage.children, function(inx, child) {
				stage.removeChild(child);
			});
		}
		stage.interactive = true;

		// 添加楼层图
		bg = PIXI.Sprite.fromImage(img.src);
		//bg.scale.set(window.innerWidth / img.width * zoom, window.innerWidth / ratio / img.height * zoom);
		bg.position.x = 0;
		bg.position.y = 0;
		stage.addChild(bg);

		for(var i = 0; i < areas.length; i++) {
			var id = areas[i].id;
			var title = areas[i].title;
			var arealine = areas[i].arealine;
			var ary = arealine.split(",");

			var leftTop = {x: 0, y: 0};
			var rightBot = {x: 0, y: 0};
			for(var j = 0; j < ary.length / 2; j++) {
				var x = parseFloat(ary[j * 2]);
				var y = parseFloat(ary[j * 2 + 1]);
				if(j == 0) {
					leftTop = {x: x, y: y};
					rightBot = {x: x, y: y};
					continue;
				}
				// 左上
				if(x <= leftTop.x) {
					if(x + y <= leftTop.x + leftTop.y) {
						leftTop.x = x;
						leftTop.y = y;
					}
				}
				// 右下
				if(y >= rightBot.y) {
					if(x + y >= rightBot.x + rightBot.y) {
						rightBot.x = x;
						rightBot.y = y;
					}
				}
			}
			
			for(var j = 0; j < dims.length; j++) {
				var dim = dims[j];
				if(dim != null) {
					var dimdatas = dim.data;
					var data = null;
					for(var n = 0; n < dimdatas.length; n++) {
						if(dimdatas[n].spcode == id) {
							data = dimdatas[n];
						}
					}
					if(data != null) {
						// 文字维度
						if(dim.dimtype == 1) {
							drawText(data[dim.dimfieldname.toLowerCase()], leftTop, rightBot);
						} else if(dim.dimtype == 2) {
							drawBgColor(data, dim.dimfieldname, dim.dimdet, ary, id);
						} else if(dim.dimtype == 3) {
							drawIcon(data, dim.dimfieldname, dim.dimdet, ary, leftTop, rightBot);
						}
					}
				}
			}
			
			renderer.view.style.width = window.innerWidth - 25 + "px";
			renderer.view.style.height = window.innerWidth / ratio + "px";
			
		}

		animate();
	}
	
	function drawText(text, leftTop, rightBot) {
		// 添加标题
		var titleText = new PIXI.Text(text, {
			fontSize: '2px'
		});
		titleText.x = (parseFloat(leftTop.x) + ((rightBot.x - leftTop.x) / 2));
		titleText.y = (parseFloat(leftTop.y) + ((rightBot.y - leftTop.y) / 2));
		titleText.displayGroup = textLayer;
		stage.addChild(titleText);
	}
	
	function drawBgColor(data, dimfieldname, dimdet, ary, id) {
		var color = dimdet[data[dimfieldname.toLowerCase()]];
		color = "0x" + color.substring(1, color.length);
		var graphics = new PIXI.Graphics();
		graphics.beginFill(color);
		for(var j = 0; j < ary.length / 2; j++) {
			var x = parseFloat(ary[j * 2]);
			var y = parseFloat(ary[j * 2 + 1]);
			if(j == 0) {
				graphics.moveTo(x, y);
				continue;
			}
			graphics.lineTo(x, y);
		}
		graphics.endFill();

		// 添加点击事件
		graphics.interactive = true;
		graphics.on('mousedown', onClick.bind(this, id));
		graphics.displayGroup = bgLayer;
		stage.addChild(graphics);
	}
	
	function drawIcon(data, dimfieldname, dimdet, ary, leftTop, rightBot) {
		var iconkey = dimdet[data[dimfieldname.toLowerCase()]];
		var src = "/mall-fileservice/xload/download/mongo/image/1/" + iconkey;
		var iconimg = new Image();
		iconimg.src = src;
		iconimg.onload = function() {
			var icon = PIXI.Sprite.fromImage(src);
			//icon.scale.set(24, 24);
			icon.position.x = (parseFloat(leftTop.x) + ((rightBot.x - leftTop.x) / 2)) - iconimg.width;
			icon.position.y = (parseFloat(leftTop.y) + ((rightBot.y - leftTop.y) / 2)) - (iconimg.height / 2);
			icon.displayGroup = iconLayer;
			stage.addChild(icon);
		}
	}
	
	function openUploadImg() {
		$("#uploadImg").click();
	}
	
	function openUploadXml() {
		$("#uploadXml").click();
	}
	
	function uploadImg() {
		var billno = mktid + floorid;
		var billmoduleid = "400406";

		var formData = new FormData();
		formData.append("file", $("#uploadImg")[0].files[0]);
		formData.append("billno", billno);
        formData.append("billmoduleid", billmoduleid);
		$.ajax({
            url : "/mall-fileservice/xload/upload/mongo/bill/MALL",
            type : 'POST',
            data : formData,
            processData : false,
            contentType : false,
            success : function(responseStr) {
            	var json = $.parseJSON(responseStr);
            	if(json != null && json.returncode == "0") {
            		var filekey = json.data[0].fileKey;
        			itemLoader.doRequest(OmdUrl.mss, "mss.work.floormap.updatefloormapinfo", {
        				floorid: billno,
        				imgkey: filekey
        			}, null, null, function (data) {
        				if(data != null) {
        					var oldimgkey = data.oldimgkey;
        					if(oldimgkey != null && oldimgkey != "") {
        						// 删除方法
        						/* $.ajax({
        				            url : "/mall-fileservice/xload/delete/mongo/1/" + oldimgkey,
        				            type : 'POST',
        				            processData : false,
        				            contentType : false,
        				            success : function(responseStr) {
        				            	console.log(responseStr);
        				            },
        				            error : function(responseStr) {
        				                mini.alert("删除失败");
        				            }
        				        }); */
        				        mini.alert("上传成功");
        					}
    						img = new Image();
    						img.src = "/mall-fileservice/xload/download/mongo/image/1/" + data.imgkey;
    						img.onload = function() {
    							initMap(img, 1);
    					    };
        				}
        		   	},null, null, false);
            	} else {
                    mini.alert("上传失败");
            	}
            },
            error : function(responseStr) {
                mini.alert("上传失败");
            }
        });
	}
	
	function uploadXml() {
		var billno = mktid + floorid;
		var billmoduleid = "400406";

		var formData = new FormData();
		formData.append("file", $("#uploadXml")[0].files[0]);
		formData.append("billno", billno);
        formData.append("billmoduleid", billmoduleid);
		$.ajax({
            url : "/mall-fileservice/xload/upload/mongo/bill/MALL",
            type : 'POST',
            data : formData,
            processData : false,
            contentType : false,
            success : function(responseStr) {
            	var json = $.parseJSON(responseStr);
            	if(json != null && json.returncode == "0") {
            		var filekey = json.data[0].fileKey;
        			itemLoader.doRequest(OmdUrl.mss, "mss.work.floormap.updatefloormapinfo", {
        				floorid: billno,
        				xmlkey: filekey
        			}, null, null, function (data) {
        				if(data != null) {
        					var oldxmlkey = data.oldxmlkey;
        					if(oldxmlkey != null && oldxmlkey != "") {
        						// 删除方法
        						/* $.ajax({
        				            url : "/mall-fileservice/xload/delete/mongo/1/" + oldxmlkey,
        				            type : 'POST',
        				            processData : false,
        				            contentType : false,
        				            success : function(responseStr) {
        				            	console.log(responseStr);
        				            },
        				            error : function(responseStr) {
        				                mini.alert("删除失败");
        				            }
        				        }); */
        				        mini.alert("上传成功");
        					}
        					areas = loadXml(data.xmlkey);
        					initMap(img, 1);
        				}
        		   	},null, null, false);
            	} else {
                    mini.alert("上传失败");
            	}
            },
            error : function(responseStr) {
                mini.alert("上传失败");
            }
        });
	}
	
	function loadXml(xmlkey) {
		var areas = [];
		$.ajax({
            type: "GET",
            url: encodeURI("/mall-fileservice/xload/download/mongo/image/1/" + xmlkey),
            dataType: "xml",
            async: false,
            success: function(xml) {
                $(xml).find('area').each(function(){
                	var area = {
                		id: $(this).attr('id'),
                		title: $(this).attr('title'),
                		arealine: $(this).attr('arealine')
                	}
                	areas.push(area);
                });
            }
        });
		return areas;
	}
	
	function onClick(eventData, x, y) {
		console.log(eventData);
		console.log(x);
		mini.open({
			url: "about:blank",
			title: "商铺信息", 
			width: 600, 
			height: 450,
			allowResize: false,
			onload: function () {
			},
			ondestroy: function (data) {
			}
		});
	}
	
	function onScale() {
		var value = document.getElementById('scalebar').value;
		if(renderer != null && renderer.view != null) {
			renderer.view.style.width = window.innerWidth * value - 25 + "px";
			renderer.view.style.height = window.innerWidth / ratio * value + "px";
		}
		//renderer.resize(window.innerWidth * value - 20, window.innerWidth / ratio * value);
		//bg.scale.set(window.innerWidth / img.width * value, window.innerWidth / ratio / img.height * value);
		//initMap(img, value);
		//console.log(value);
	}
	
	function animate() {
	
	    renderer.render(stage);
	    requestAnimationFrame( animate );
	}

</script>
</html>