/**
 * 招商规划 --- 界面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');

	// 商铺修改命名空间
	var ns = Future.ns('invest.view');

	// 定义一个对象用来配置界面
	var investmentplan = {};
	
	var billtype=getBilltype(app.modulecode);

	// 把定义对象放到命名空间下
	ns.investmentplan = investmentplan;
	// 表头 自定义名称
	investmentplan.investhead = {
		"title" : '单据详情',
		"name" : 'investhead',
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mss.work.investmentplan.get",
		"response" : "investmenthead",
		"properties" : {
			"id" : utils.createid('investhead'),
		},
		items :[ {
			"label" : "ph_key：",
			"type" : "TextBox",
			"name" : "ph_key",
			"readOnly" : "true",
			"visible" : false,
		}, {
			"label" : "单据编号：",
			"name" : "billno",
			"type" : "TextBox",
			"required" : "true",
			"readOnly" : true,
			"visible" : true,
		},{
			"label": "单据类型：",
			"name": "billtype",
			"type": "ComboBox",
			"defaultValue": billtype,
			dictkey: 'BILLTYPE',
			"visible": true,
			"readOnly": true,
		},{
			"lable": "billmoduleid",
			"name": "billmoduleid",
			"type": "TextBox",
			"defaultValue": app.modulecode,
			"visible": false,
		}, {
			"label" : "单据状态：",
			"name" : "billstatus",
			"type" : "ComboBox",
			dictkey : 'BILLFLAG',
			"defaultValue" : "N",
			"readOnly" : true,
			"visible" : true
		}, {
			"label" : "门店：",
			"name" : "muid",
			type : "fut_popselect",
			selectkey : "muid",
			textName : "muid_name",
			"required" : "true",
			beforefunc : "page.head_btnClickbefore",
			"allowInput" : true
		}, {
			"label" : "门店名称：",
			"name" : "muid_name",
			"type" : "TextBox",
			"required" : "true",
			"defaultValue" : "",
			visible : false,
		},
		/*
		 * { "type" : "Separator", "style" : "clear: both;display: inline-block;width:
		 * 90%;margin: 0.2em 0 0.6em;" },
		 */
		{
			"label" : "录入人：",
			"name" : "inputer_name",
			"type" : "TextBox",
			"readOnly" : true,
			"visible" : true,
			"defaultValue" : app.username
		}, {
			"label" : "录入人编码：",
			"type" : "TextBox",
			"name" : "inputer",
			"visible" : false,
			"defaultValue" : app.usercode
		}, {
			"label" : "审核人：",
			"name" : "auditor_name",
			"type" : "TextBox",
			"readOnly" : true,
			"visible" : true,
			"style" : "display:block;float:none",
		}, {
			"label" : "录入日期：",
			"name" : "inputdate",
			"type" : "DatePicker",
			"readOnly" : true,
			"format" : "yyyy-MM-dd HH:mm:ss",
			"visible" : true,
			"defaultValue" : new Date()
		},
		/*
		 * { "type" : "Separator", "style" : "clear: both;display: inline-block;width:
		 * 90%;margin: 0.2em 0 0.6em;" },
		 */{
			"label" : "审核日期：",
			"name" : "auditdate",
			"type" : "DatePicker",
			"readOnly" : true,
			"format" : "yyyy-MM-dd HH:mm:ss",
			"visible" : true
		} ]
	};
 	
	// 明细 自定义名称
	investmentplan.investdetail = {
		"title" : '招商明细',// tab页面标题
		"name" : 'investmentdet',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('investdetail'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
				field : "browno",
				name : "browno",
				headerAlign : "center",
				header : "行号",
				allowSort : false,
				width : 120,
				visible : false
			}, {
				field : "spid",
				name : "spid",
				headerAlign : "center",
				header : "商铺",
				width:120,
				required : true,
				allowSort : true,
				displayField : "spid_name", 
				editor:OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					selectkey:"spid",
					beforefunc : "page.spid_beforefunc",
					itemchangedfunc:"page.head_itemchanged_spid"
						},
			}, {
				field : "spcode",
				headerAlign : "center",
				header : "商铺编码",
				width:120,
				visible : false,
			}, {
				field : "spcname",
				headerAlign : "center",
				header : "商铺中文名称",
				width:120,
				visible : false,
			},{
				field : "muid",
				name : "muid",
				header : "门店",
				headerAlign : "center",
				visible : false,
			},{
				field : "muid_name",
				name : "muid_name",
				header : "门店名称",
				width : 150,
				visible : false,
			},{
				field : "mid",
				name: "mid",
				header : "经营种类",
				headerAlign : "center",
				allowSort : true,
				displayField : "mid_name", 
				editor:OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					selectkey:"yzid",
					itemchangedfunc:"page.head_itemchanged_middet"
						},
			},{
				field : "sptype",
				name : "sptype",
				headerAlign : "center",
				header : "商铺类型",
				vtype : "required:true",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				dictkey : 'SPTYPE',
				allowSort : false,
				width : 120,
				renderer : "OcmControl.dictRendererWithCode",
				// editorSet:{onValuechanged : "page.onsptypechange"}
			}, {
				field : "spmode",
				name : "spmode",
				headerAlign : "center",
				header : "商铺属性",
				vtype : "required:true",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				dictkey : 'SPMODE',
				allowSort : false,
				width : 120,
				renderer : "OcmControl.dictRendererWithCode",
			},{
				field : "spbuildarea",
				name : "spbuildarea",
				headerAlign : "center",
				header : "建筑面积",
				allowSort : false,
				vtype : "required:true,double",
				numberFormat : "#,##0.00",
				width : 100,
				editor : OcmControl.newControl('Spinner'),
				editorSet : {
					"minValue" : "0",
					"maxValue" : "100000000000",
					"defaultValue" : "0",
				}
			}, {
				field : "incrate",
				name : "incrate",
				headerAlign : "center",
				header : "递增率",
				allowSort : false,
				visible : true,
				vtype : "double",
				numberFormat : "p0",
				width : 100,
				editor : OcmControl.newControl('Spinner'),
				editorSet : {
					"minValue" : "0",
					"maxValue" : "100000000000",
					"defaultValue" : "0",
				}
			}, {
				field : "splettarea",
				name : "splettarea",
				headerAlign : "center",
				header : "套内面积",
				allowSort : false,
				/*visible : true,*/
				vtype : "required:true,double",
				numberFormat : "#,##0.00",
				width : 100,
				editor : OcmControl.newControl('Spinner'),
				editorSet : {
					"minValue" : "0",
					"maxValue" : "100000000000",
					"defaultValue" : "0",
				}
			}, {
				header : "面价",
				name : "faceprice",
				field : "faceprice",
				vtype : "required:true,double",
				numberFormat : "#,##0.00",
				width : 100,
				editor : OcmControl.newControl('Spinner'),
				editorSet : {
					"minValue" : "0",
					"maxValue" : "100000000000",
					"defaultValue" : "0.00",
				}
			}, {
				header : "底价",
				name : "lowprice",
				field : "lowprice",
				vtype : "required:true,double",
				numberFormat : "#,##0.00",
				width : 100,
				editor : OcmControl.newControl('Spinner'),
				editorSet : {
					"minValue" : "0",
					"maxValue" : "100000000000",
					"defaultValue" : "0.00",
				},
			},{
				field : "monrent",
				header : "月租金",
				numberFormat : "#,##0.00",
				width : 100,
				editor : OcmControl.newControl('Spinner'),
				editorSet : {
					"minValue" : "0",
					"maxValue" : "100000000000",
					"defaultValue" : "0.00",
				}
			},{
				field : "freerentsdate", //免租期开始日期
				header : "免租期开始日期",
				headerAlign : "center",
				align : "center",
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width : 100,
			},{
				field : "freerentedate", //免租期结束日期
				header : "免租期结束日期",
				headerAlign : "center",
				align : "center",
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width : 100,
			},{
				field : "rentsdate", //租期开始日期
				header : "租期开始日期",
				headerAlign : "center",
				align : "center",
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width : 100,
			},{
				field : "rentedate", //租期结束日期
				header : "租期结束日期",
				headerAlign : "center",
				align : "center",
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width : 100,
			}]
		}
	};
	
	// 查询 自定义名称
	investmentplan.investquerylist = {
			"title" : '单据列表',
			"name" : 'investquerylist',
			"type" : "gridbox",
			"resources" : OmdUrl.mall,
			"method" : "mss.work.investmentplan.search",
			"response" : "investmenthead",
			"canquery" : true,
			/* "manualLoad" : true, */
			"bindform" : "layouttabs", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
			"searchParam" : {
				"billmoduleid" : app.modulecode,
				"order_field" : "billno",
				"order_direction" : "desc"
			},
			"properties": {
				"id": utils.createid('investquerylist'),
				"columns": [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "billno",
					header : "单号",
					allowSort : true,
					headerAlign : "center",
					width : 80,
					visible : true
				}, {
					field : "billstatus",
					header : "单据状态",
					allowSort : true,
					headerAlign : "center",
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'BILLFLAG',
					width : 60,
					visible : true
				}, {
					field : "muid",
					header : "门店",
					width : 100,
					visible : false,
					enabledSearch : true,
					allowSort : true,
				}, {
					field : "muid_name",
					header : "门店名称",
					width : 100,
					allowSort : true,
					enabledSearch : false,
					visible : true
				}, {
					field : "inputer_name",
					header : "录入人",
					width : 100,
					allowSort : true,
					headerAlign : "center",
				}, {
					field : "inputdate",
					type : "date",
					dataType : "date",
					format : "yyyy-MM-dd",
					header : "录入日期",
					width : 100,
					allowSort : true,
					headerAlign : "center",
					align : "center",
				}, {
					field : "auditor_name",
					header : "审核人",
					width : 100,
					allowSort : true,
					headerAlign : "center",
				}, {
					field : "auditdate",
					type : "date",
					format : "yyyy-MM-dd",
					header : "审核日期",
					width : 100,
					dataType : "date",
					allowSort : true,
					headerAlign : "center",
					align : "center",
				} ]
			}
		};
	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	investmentplan.toolbarconfig = {
		id : utils.createid('systoolbar'),
		// items : Future.pub.Basebill.default_toolsbar
		items : [ btn.addData, btn.editData, btn.delData, btn.saveData,
				btn.separator, btn.auditData, btn.separator, btn.searchData,
				btn.billImport, /*btn.upTemplate,*/ btn.downTemplate ]
	}
	var item = {'text': '提交','iconCls': 'icon-ok','name': 'submitData',
			billstatus: 'N',ibediting: 'N',tabindex: '1'}
	investmentplan.toolbarconfig.items.push(item);
	// 单据配置
	investmentplan.billconfig = {
		billhead : investmentplan.investhead, // 单据主表
		billdetail : [ investmentplan.investdetail], // 单据明细表
		billquerylist : investmentplan.investquerylist,// 查询列表
		dettabpages : [ investmentplan.investdetail ],// 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode,// 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(investmentplan);

})();
