/**
 * 招商规划
 */
(function() {
	// 商铺录入命名空间
	/** @namespace Future.invest.ment */
	var ns = Future.ns('invest.ment');
	var utils = Future.ns('Future.utils');
	
	var investmentdet = mini.get("investmentdet");
	var investhead = mini.get("investhead");
	var investquerylist = mini.get("investquerylist");
	/**
	 * 招商规划
	 * 
	 * @constructor
	 */
	var InvestmentPlan = function() {
		InvestmentPlan.superclass.constructor.call(this);
		this.servicekey = 'mss';
		this.spid_beforefunc = this.spid_beforefunc.bind(this);
		this.head_itemchanged_spid = this.head_itemchanged_spid.bind(this);
		this.head_btnClickbefore = this.head_btnClickbefore.bind(this);
		this.head_itemchanged_middet = this.head_itemchanged_middet.bind(this);

	}

	ns.InvestmentPlan = InvestmentPlan;
	Future.extend(ns.InvestmentPlan, Future.pub.Basebill,
			{
				initdict:function(){
					var fitlsptypedata=[];
					var sptypedictdata = Future.Pub.DictSrv.data.SPTYPE;
					for(var i=0;i<sptypedictdata.length;i++ ){
						if(sptypedictdata[i].pro1=="Y" ){
							fitlsptypedata.push(sptypedictdata[i]);
						}
					}
					Future.Pub.DictSrv.data.SPTYPE = fitlsptypedata;
				},
				detailsaveDataBefore : function() {
					var obj = {};
					var detData = investmentdet.getData();
					for (var i = 0; i < detData.length; i++) {
						var spcode = detData[i].spcode;
						var spstartdate = detData[i].spstartdate;
						if (spcode == null || spcode == "") {
							mini.alert("第" + (i + 1) + "行商铺为空，请检查");
							return;
						}
						if (spstartdate == null || spstartdate == "") {
							mini.alert("第" + (i + 1) + "行生效日期为空，请检查");
							return;
						}					
					}
					return obj;
				},
				spid_beforefunc : function(e){
					var muid = this.investhead.form.getField('muid').value;
					if (!e.searchParam) {
						e.searchParam = {};
					}
					var buttonEdit = e.sender;

					if (e.value != "undefined" && e.value != "") {
						e.searchParam.code = e.value;
					}
					if(buttonEdit.name == "spid"){
						if (!muid) {
							mini.alert("请先输入门店");
							return -1;
						}
						e.searchParam.wherestr = " muid ='" + muid  + "'";
					}

					return 0;
				},
				head_itemchanged_spid : function(e,data){
				     var row = this.investmentdet.getSelected();
				     if(data.length > 0){
				    	 var newrow = {
									spid_name : "[" + data[0].code + "]" + data[0].name,
									spid : data[0].oid,
									spcname : data[0].name, 
									spcode : data[0].code, 
									sptype : data[0].sptype,
									spmode : data[0].spmode,
									spbuildarea : data[0].spbuildarea,
									splettarea : data[0].splettarea,
								};
						     this.investmentdet.updateRow(row, newrow);
				     }
				     return 0;
				},
				head_btnClickbefore : function(e) {
					// console.log(e);
					// 判断明细是否有数据,如果有数据，必须先删除了，再才能修改
					if (this.investmentdet.data.length > 0) {
						mini.alert("明细已存在数据,请先删除后再修改门店");
						e.cancel = true;
						return -1;
					}
				},
				head_itemchanged_middet : function(e,data){
					var row = this.investmentdet.getSelected();
					if(data.length > 0){
						var newrow = {
								mid_name : "[" + data[0].code + "]" + data[0].name,
								mid : data[0].mid,
							};
					     this.investmentdet.updateRow(row, newrow);
					}
					return 0;
				},
				submitData : function(){
					var billstatus = this.investhead.form.getField('billstatus').value;
					var list = this.investquerylist;
					var head = this.investhead;
					var billno = this.investhead.form.getField('billno').value;
					var submit_name = getUserName();
					var text = "是否提交数据！";
					mini.confirm(text, "提示", function(action) {
						if (action == "ok"){
							if(billstatus != 'N'){
								mini.alert("单据不是未审核状态无法提交!");
								return;
							}else{
								if(billno == null || billno == ''){
									mini.alert("单据编号为空，提交失败!");
									return;
								}
								var searchParam = {
										"billno":billno,
										"submit_name" : submit_name
										};
								var method = "mss.work.investmentplan.submitat";
								itemLoader.doRequest(OmdUrl.mall, method,searchParam, null, null, function(data) {
									var count = data;
									if(data > 0){
										list.load();
										head.form.getField('billstatus').setValue('S');
										mini.alert("提交成功!");
									}
								},null,null,false);
							}
						}
					})
				},
				initevent : function() {
					InvestmentPlan.superclass.initevent.call(this);
					this.investmentdet.on('cellcommitedit',
							this.detcellcommitedit, this);
					
					this.investmentdet.addNewRowBefore = function(){
						var data  = this.getData();
						var num = data.length + 1;
						var obj ={};
						obj.browno = num;
						return obj
					}

				},
				/**
				 * 明细窗口修改 参数说明 cancel:false column:Object editor:ol1OO0
				 * field:"spcode" oldValue:undefined record:Object row:Object
				 * rowIndex:0 sender:OcmControl.GridBox
				 * source:OcmControl.GridBox text:"" type:"cellcommitedit"
				 * value:"1221"
				 */
				detcellcommitedit : function(e) {

					var muid = this.investhead.form.getField('muid').value;
					if (!muid) {
						mini.alert("请先输入门店");
						e.cancel = true;
						return;
					}
					var ns = Future.ns('shop.pub');
					if (e.field == 'spcode') {
						// 页面判断商铺编号是否重复
						var exitDatas = this.investmentdet.getData();
						for (var i = 0; i < exitDatas.length; i++) {
							if (exitDatas[i].spcode == e.value) {
								mini.alert("商铺[" + e.value + "]编号已存在!");
								e.cancel = true;
								return;
							}
						}

						if (ns.checkspexist(e.value, muid)) {
							e.cancel = true;
							return;
						}
					}
				},
				getImportParam : function() {
					var that = this;
					return {
						billmoduleid : that.billmoduleid,
						billno : that.investhead.getValue('billno'),
						muid : that.investhead.getValue('muid'),
						muid_name : that.investhead.getValue('muid_name')
					}
				},
			},
			//保存按钮前事件
			OcmControl.toolbarFn.saveDataBefore = function() {
				
			});

})();

function getBilltype (billmoduleid) {
	 var billtype = "";
	 var searchParam = {"modeid":billmoduleid};
	 var method = "mss.base.billmain.search";
	 itemLoader.doRequest(OmdUrl.mall, method,searchParam, null, null, function(data) {
		 	var data = data.billmain;
			if(data.length >0){
				billtype =data[0].billtype;
			}
	 },null,null,false);
	 return billtype;
}