mini.parse();

var pgdetailList = mini.get("pgdetailList"); //项目明细
var pgresourList = mini.get("pgresourList"); //参考值明细
var tabs1 = mini.get("layouttabs"); // 获取tabs1
var details1 = mini.get("formdetail");// 单据明细


//明细不可增行，可删行
details1.tabsToolbar.btn_tabs2_addRow.setVisible(false);
details1.tabsToolbar.btn_tabs2_delRow.setVisible(false);

//tab页面切换的时候，需要绑定自定义控件的数据集
if (tabs1) {
	tabs1.on('activechanged', function(e) {
		setBillData();
	});
}

//自定义页面数据回填
function setBillData(){
  var _details = mini.get("formdetail");
  var _datas = {};
  if (_details) {
    _datas = _details.config.data;
  }
  if(_datas && jQuery.isEmptyObject(_datas) == false){

		      var pgdetailListData= _datas["pgdetail"].sort(getSort('asc', 'dcode'));
			  pgdetailList.setData(pgdetailListData);
			  pgresourList.setClientData(_datas["pgresour"]);
			  pgresourList.clearRows();
	          pgdetailList.setEnabled(false);
		      pgresourList.setEnabled(false);
  }
}

//明细排序	
function getSort(order, sortBy) {
	  var ordAlpah = (order == 'asc') ? '>' : '<';
	  var sortFun = new Function('a', 'b', 'return a.' + sortBy + ordAlpah + 'b.' + sortBy + '?1:-1');
	  return sortFun;
	}

//新增按钮前事件
OcmControl.toolbarFn.addDataBefore = function(){
//	var pcode= mini.getbyName("pcode").getValue();
//	var pname = mini.getbyName("pname").getValue();
//	var pgdetailListData = pgdetailList.getData();
//	var pgresourListData = pgresourList.getData();
//	if(pcode !="" || pname !="" || pgdetailListData.length !=0 ||pgresourListData.length !=0){
//		var _result = window.confirm("单据有修改未保存，是否放弃修改？");
//		if(_result){
//			mini.getbyName("pcode").setValue("");
//			mini.getbyName("pname").setValue("");
//        	pgdetailList.clearRows();
//        	pgresourList.clearRows();
//        	return true;
//		}else {
//	        return false;
//	    }
//	}
//	return true;
	var pcode= mini.getbyName("pcode").getValue();
	var pname = mini.getbyName("pname").getValue();
	var pgdetailListData = pgdetailList.getChanges();
	var pgresourListData = pgresourList.getChanges();
	if((pcode !="" || pname !="") && ( pgdetailListData.length > 0 ||pgresourListData.length > 0)){
		mini.confirm("单据有修改未保存，是否放弃修改？", "提示信息", function(ok) {
			if(ok == "ok") {
				mini.getbyName("pcode").setValue("");
				mini.getbyName("pname").setValue("");
	        	pgdetailList.clearRows();
	        	pgresourList.clearRows();
	        	return true;
			}
		});
	}else {
		mini.getbyName("pcode").setValue("");
		mini.getbyName("pname").setValue("");
    	pgdetailList.clearRows();
    	pgresourList.clearRows();
    	return true;
	}
};

//新增按钮后事件
OcmControl.toolbarFn.addDataAfter = function() {
	var form = details1.form;
	form.getField("inputer").setValue(getUserCode());
	form.getField("inputer_name").setValue(getUserName());// 录入人
	form.getField("inputdate").setValue(new Date());// 录入日期
	
	form.getField("lastmodby").setValue(getUserCode());// 最后修改人
	form.getField("lastmodby_name").setValue(getUserName());// 最后修改人
	form.getField("lastmodbydate").setValue(new Date());// 最后修改日期
	 
	mini.getbyName("pcode").set({"readOnly":false, "enabled":true});
	pgdetailList.setEnabled(true);
    pgresourList.setEnabled(true);
	pgdetailList.clearRows();
	pgresourList.clearRows();
	
};
//保存按钮前事件
OcmControl.toolbarFn.saveDataBefore = function() {
	
	var pcode = mini.getbyName("pcode").getValue();
	var detailData =pgdetailList.getData();
	
	if(detailData.length==0){
		mini.alert("评估明细不能为空！");
		return;
	}
	var row = pgdetailList.getSelected();
	var resourData;
	if(row){
		resourData =pgresourList.getData();
		if(resourData.length ==0){
			mini.alert("评分标准明细不能为空！");
			return;
		}
	}
	if(detailData.length!=0){             //验证评估明细上的值是否有未填值
			for(var i=0;i<detailData.length;i++){
				var dcode = detailData[i].dcode;
				var dname = detailData[i].dname;
				if(dcode =="" ||dname=="" ){
					mini.alert("保存前请将评估明细里的值填写完整！");
					return;
				}
			}
	}
	if(resourData && resourData.length !=0){           //验证评估标准明细上的值是否有未填值
		for(var i=0;i<resourData.length;i++){
			var scode = resourData[i].scode;
			var sname = resourData[i].sname;
			var sscore = resourData[i].sscore;
			if(scode==undefined ||scode == "" || sname ==undefined ||sname=="" || sscore ==undefined ||sscore ==""){
				mini.alert("保存前请将评分标准明细里的值填写完整！");
				return;
			}
		}
	}

	
	var obj = {};
    // 评估值明细
	var pgdetailListData = pgdetailList.getChanges();
	obj.pgdetail = pgdetailListData;
	//评分标准明细
    var pgresourListData = pgresourList.getChanges();
    obj.pgresour = pgresourListData;

	for(var i=0;i<obj.pgdetail.length;i++){
		obj.pgdetail[i].pcode = pcode;  
		var dcode =obj.pgdetail[i].dcode;
		if(dcode==undefined ||dcode == ""){
    		//pgresourList.removeRow(obj.pgresour[i]);
    		mini.alert("评估明细行评估明细编码不能为空！");
    		return;
    	}
	}
    setGridData(obj.pgdetail);

    for(var i=0;i<obj.pgresour.length;i++){
    	obj.pgresour[i].pcode = pcode; 
    	var scode=obj.pgresour[i].scode;
    	if(scode==undefined ||scode == ""){
    		//pgresourList.removeRow(obj.pgresour[i]);
    		mini.alert("评分标准明细行评分编码不能为空！");
    		return;
    	}
	}
    setGridData(obj.pgresour);
	return obj;
};

//保存按钮后事件
OcmControl.toolbarFn.saveDataAfter = function()
{
	//pgresourList.clearRows();
    setBillData();
};

//修改按钮后事件
OcmControl.toolbarFn.editDataAfter = function() {
	var details1 = mini.get("formdetail");// 单据明细
	var form = details1.form;
	
	pgdetailList.setEnabled(true);
	pgresourList.setEnabled(true);
//	mini.getbyName("pcode").set({"readOnly":true, "enabled":false});
//	mini.getbyName("lastmodbydate").setValue(new Date());
	form.getField("lastmodby").setValue(getUserCode());// 最后修改人
	form.getField("lastmodby_name").setValue(getUserName());// 最后修改人
	form.getField("lastmodbydate").setValue(new Date());// 最后修改日期
	pgdetailList.on("cellclick", pgdetailListCellclick(pgdetailList)); 
	pgresourList.on("cellclick", pgresourListCellclick(pgresourList)); 
//	pgresourList.clearRows();
};

function  pgdetailListCellclick(e){
	var columns=e.columns;
	for(var i=0;i<columns.length;i++){
		if(columns[i].field=="dcode"){
			columns[i].enabled=false;
			columns[i].readOnly = true;
		}
	}
} 

function  pgresourListCellclick(e){
	var columns=e.columns;
	for(var i=0;i<columns.length;i++){
		if(columns[i].field=="scode"){
			columns[i].enabled=false;
			columns[i].readOnly = true;
		}
	}
} 
//删除按钮后事件
OcmControl.toolbarFn.delDataBefore = function()
{
	var pcode = mini.getbyName("pcode").getValue();
	var searchParam = {
			"queryid" : "select_project_in_assem",
			"pcode": pcode,
	 };
	var flag = true;
	itemLoader.doRequest(OmdUrl.mall,
			"mss.work.report.query", searchParam, null,
			null, function(data) {
		var data = data.report;
		if(data.length>0){
			mini.alert("该项目已存在商户评审评估表中，不能删除！");
			flag = false;
			return;
		}
	}, null, null, false);
	return flag;
};
//删除按钮后事件
OcmControl.toolbarFn.delDataAfter = function()
{
	pgdetailList.clearRows();
	pgresourList.clearRows();
};

//项目序号值改变事件
function onPsortChange(e){
	var value=e.value;
	var searchParam = {
			"queryid" : "select_ProjectPsort",
			"psort": value,
	 };
	var newRow;
	itemLoader.doRequest(OmdUrl.mall,
			"mss.work.report.query", searchParam, null,
			null, function(data) {
		var data = data.report;
		if(data.length>0){
			mini.alert("项目序号已存在，不能重复！");
			mini.getbyName("psort").setValue("");
			return;
		}
	}, null, null, false);
}

//项目编码值改变事件
function onPcodeChange(e){
	var value=e.value;
	var searchParam = {
			"queryid" : "select_ProjectCode",
			"pcode": value,
	 };
	itemLoader.doRequest(OmdUrl.mall,
			"mss.work.report.query", searchParam, null,
			null, function(data) {
		var data = data.report;
		if(data.length>0){
			mini.alert("项目编码已存在，不能重复！");
			mini.getbyName("pcode").setValue("");
			return;
		}
	}, null, null, false);
}

//项目名称值改变事件
function onPnameChange(e){
	var value=e.value;
	var searchParam = {
			"queryid" : "select_ProjectName",
			"pname": value,
	 };
	itemLoader.doRequest(OmdUrl.mall,
			"mss.work.report.query", searchParam, null,
			null, function(data) {
		var data = data.report;
		if(data.length>0){
			mini.alert("项目名称已存在，不能重复！");
			mini.getbyName("pname").setValue("");
			return;
		}
	}, null, null, false);
}

//明细编码值改变事件
function onDcodeChange(e){
	var pcode = mini.getbyName("pcode").getValue();
	var buttonEdit = e.sender;
	var value=e.value;
	
	var searchParam = {
			"queryid" : "select_PgdetailCode",
			"pcode" :pcode,
			"dcode": value,
	 };
	itemLoader.doRequest(OmdUrl.mall,
			"mss.work.report.query", searchParam, null,
			null, function(data) {
		var data = data.report;
		if(data.length>0){
			mini.alert("评估明细编码已存在，不能重复！");
			buttonEdit.setValue("");
			return;
		}
	}, null, null, false);
}

//明细名称值改变事件
function onDnameChange(e){
	var pcode = mini.getbyName("pcode").getValue();
	var row = pgdetailList.getSelected();
	var dcode = row.dcode;
	var buttonEdit = e.sender;
	var value=e.value;
	var searchParam = {
			"queryid" : "select_PgdetailName",
			"pcode" :pcode,
			"dcode": dcode,
			"dname" :value
	 };
	itemLoader.doRequest(OmdUrl.mall,
			"mss.work.report.query", searchParam, null,
			null, function(data) {
		var data = data.report;
		if(data.length>0){
			mini.alert("评分明细名称已存在，不能重复！");
			buttonEdit.setValue("");
			return;
		}
	}, null, null, false);
}

//参考明细序号值改变事件
function onSsortChange(e){
	var pcode = mini.getbyName("pcode").getValue();
	var buttonEdit = e.sender;
	var value=e.value;
	var row = pgdetailList.getSelected();
	if(!row) {
		mini.alert("请选择项目明细上的某一行");
		return;
	}else{
		var dcode =row.dcode;
		var searchParam = {
				"queryid" : "select_PgsoureSsort",
				"ssort": value,
				"pcode":pcode,
				"dcode" : dcode
		 };
		itemLoader.doRequest(OmdUrl.mall,
				"mss.work.report.query", searchParam, null,
				null, function(data) {
			var data = data.report;
			if(data.length>0){
				mini.alert("参考明细序号值已存在，不能重复！");
				buttonEdit.setValue("");
				return;
			}
		}, null, null, false);
	}
}

//参考明细编码值改变事件
function onScodeChange(e){
	var pcode = mini.getbyName("pcode").getValue();
	var buttonEdit = e.sender;
	var value=e.value;
	var row = pgdetailList.getSelected();
	var resourRow=pgresourList.getSelected();
	var dcode = row.dcode;
	if(!row) {
		mini.alert("请选择项目明细上的某一行");
		return;
	}else{
    var newrow={dcode:dcode};
    pgresourList.updateRow(resourRow, newrow);
	var searchParam = {
			"queryid" : "select_PgsoureCode",
			"scode": value,
			"pcode":pcode,
			"dcode" : dcode
	 };
	itemLoader.doRequest(OmdUrl.mall,
			"mss.work.report.query", searchParam, null,
			null, function(data) {
		var data = data.report;
		if(data.length>0){
			mini.alert("评分标准编码已存在，不能重复！");
			buttonEdit.setValue("");
			return;
		}
	}, null, null, false);
  }
}

//参考明细名称值改变事件
function onSnameChange(e){
	var pcode = mini.getbyName("pcode").getValue();
	var buttonEdit = e.sender;
	var value=e.value;
	var row = pgdetailList.getSelected();
	var rowSou = pgresourList.getSelected();
	var dcode = row.dcode;
	var sname = rowSou.sname;
	if(!row) {
		mini.alert("请选择项目明细上的某一行");
		return;
	}else{
	var searchParam = {
			"queryid" : "select_PgsoureName",
			"sname": value,
			"pcode":pcode,
			"dcode" : dcode
	 };
	itemLoader.doRequest(OmdUrl.mall,
			"mss.work.report.query", searchParam, null,
			null, function(data) {
		var data = data.report;
		if(data.length>0){
			mini.alert("评分标准名称值已存在，不能重复！");
			buttonEdit.setValue("");
			return;
		}
	}, null, null, false);
 }
	if(pcode !="" && dcode !="" && sname !="" ){
		var searchParam = {
				"sname": sname,
				"pcode":pcode,
				"dcode" : dcode,
				"newsname" : value
		 };
		itemLoader.doRequest(OmdUrl.mall,
				"mss.work.pgproject.UpdateSname", searchParam, null,
				null, function(data) {
			if(data != "OK"){
				mini.alert("修改失败！");
				return;
			}
		}, null, null, false);
	}
	
}

//参考明细值状态改变事件
function onSstatusChange(e){
	var pcode = mini.getbyName("pcode").getValue();
	var buttonEdit = e.sender;
	var value=e.value;
	var row = pgdetailList.getSelected();
	var rowSou = pgresourList.getSelected();
	var dcode = row.dcode;
	var scode = rowSou.scode;
	if(pcode !="" && dcode !="" && scode !="" ){
		var searchParam = {
				"scode": scode,
				"pcode":pcode,
				"dcode" : dcode,
				"newsstatus" : value
		 };
		itemLoader.doRequest(OmdUrl.mall,
				"mss.work.pgproject.UpdateSstatus", searchParam, null,
				null, function(data) {
			if(data != "OK"){
				mini.alert("修改失败！");
				return;
			}
		}, null, null, false);
	}
}

//项目明细增行按钮点击事件
function addrowClick(){

	//pgresourList.clearRows();   //新增明细行时，清除参考评分里的数据

	var pgresourListData = pgresourList.getChanges();
	if(pgresourListData.length !=0){
		mini.alert("请先保存单据");
		return;
	}
	var pgdetailListData = pgdetailList.getData();
	for(var i=0;i<pgdetailListData.length;i++){
		var dcode = pgdetailListData[i].dcode;
		var dname = pgdetailListData[i].dname;
		if(dcode =="" ||dname==""){
			mini.alert("请将评估明细行里的值填写完整！");
			return;
		}
	}
	
	var pcode = mini.getbyName("pcode").getValue();
	var pname = mini.getbyName("pname").getValue();
	if(pcode =="" ||pcode==null){
		mini.alert("请先填写项目编码");
		return;
	}else if(pname == "" || pname==null){
		mini.alert("请先填写项目名称");
		return;
	}else{
		var _obj = {};
	    _obj['flag'] = 'I';
	    for (var i = 0; i < pgdetailList.config.properties.columns.length; i++) {
	    	if(pgdetailList.config.properties.columns[i].field=="dcode"){
	    		pgdetailList.config.properties.columns[i].enabled=true;
	    		pgdetailList.config.properties.columns[i].readOnly = false;
			}
//	   	 var _k = pgdetailList.config.properties.columns[i];
//	    	if (_k.required) {
//	            _obj[_k['field']] = '';
//	        }
//	        if (_k.value) {
//	            _obj[_k['field']] = _k.value;
//	        }
	    }
	    _obj['dstatus'] = 'Y';
	    pgdetailList.addRow(_obj);
	  }
}

//项目明细删行按钮点击事件
function delRowClick(){
	var pgresourListData =pgresourList.getData();
	var pcode = mini.getbyName("pcode").getValue();
	if(pgresourListData.length > 0){
		mini.alert("请先删除其对应的评分明细！");
		return;
	}
	mini.confirm("是否删除评估明细？", "提示", function (action) {
		var data;
        if (action == "ok") {
        	var row = pgdetailList.getSelected();
        	if(!row) {
        		mini.alert("请选择项目明细");
        		return;
        	}else{
        		var dcode = row.dcode;
        		var searchParam = {
        				"queryid" : "select_pjdetail_in_assem",
        				"dcode": dcode,
        				"pcode":pcode,
        		 };
        		itemLoader.doRequest(OmdUrl.mall,
        				"mss.work.report.query", searchParam, null,
        				null, function(data) {
        			data = data.report;
        			if(data && data.length>0){
        				mini.alert("该项目明细已存在商户评审评估表中，不能删除！");
        				return;
        			}
        			row["flag"] = "D";
        			pgdetailList.removeRow(row, false);
        			
        			for (var i = 0; i < pgdetailList.config.properties.columns.length; i++) {
        		    	if(pgdetailList.config.properties.columns[i].field=="dcode"){
        		    		pgdetailList.config.properties.columns[i].enabled=false;
        		    		pgdetailList.config.properties.columns[i].readOnly=true ;
        				}
        		    }
        		}, null, null, false);
    		}
        }
    });
}

//参考明细增行按钮点击事件
function addRow2Click(){
	var pgresourListData =pgresourList.getData();
	for(var i=0;i<pgresourListData.length;i++){
		var scode = pgresourListData[i].scode;
		var sname = pgresourListData[i].sname;
		var sscore = pgresourListData[i].sscore;
		if(scode =="" || sname=="" || sscore==""){
			mini.alert("请将评分标准明细上的值填写完整！");
			return;
		}
	}
	
	var row = pgdetailList.getSelected();
	if(!row){
		mini.alert("请先选择项目明细行");
		return ;
	}else{
	var _obj = {};
    _obj['flag'] = 'I';
    for (var i = 0; i < pgresourList.config.properties.columns.length; i++) {
   	 var _k = pgresourList.config.properties.columns[i];
   	for (var i = 0; i < pgresourList.config.properties.columns.length; i++) {
    	if(pgresourList.config.properties.columns[i].field=="scode"){
    		pgresourList.config.properties.columns[i].enabled= true;
    		pgresourList.config.properties.columns[i].readOnly=false ;
		}
    }
//    	if (_k.required) {
//            _obj[_k['field']] = '';
//        }
//        if (_k.value) {
//            _obj[_k['field']] = _k.value;
//        }
    }
    _obj['sstatus'] = 'Y';
    pgresourList.addRow(_obj);
   }
}

//参考明细删行按钮点击事件
function delRow2Click(){
	var pcode = mini.getbyName("pcode").getValue();
	var rowdetail = pgdetailList.getSelected();
	var row = pgresourList.getSelected();
	var data;
	mini.confirm("是否删除评分明细？", "提示", function (action) {
        if (action == "ok") {
        	if(!row) {
        		mini.alert("请选择参考评分明细");
        		return;
        	}else{
        		var scode = row.scode;
        		var searchParam = {
        				"queryid" : "select_pjresour_in_assem",
        				"scode": scode,
        				"pcode": pcode,
        				"dcode": rowdetail.dcode,
        		 };
        		itemLoader.doRequest(OmdUrl.mall,
        				"mss.work.report.query", searchParam, null,
        				null, function(data) {
        			data = data.report;
        			if(data && data.length>0){
        				mini.alert("该评分明细已存在商户评审评估表中，不能删除！");
        				return;
        			}
        			pgresourList.removeRow(row, false);
        			row["flag"] = "D";
        			for (var i = 0; i < pgresourList.config.properties.columns.length; i++) {
        		    	if(pgresourList.config.properties.columns[i].field=="scode"){
        		    		pgresourList.config.properties.columns[i].enabled=false;
        		    		pgresourList.config.properties.columns[i].readOnly=true ;
        				}
        		    }
        		}, null, null, false);
        		
        		
//    		 var dcode=rowdetail.dcode;
//    		 var scode = row.scode;
//    		 if(pcode !=""&& dcode!="" && scode!=""){
//    			var url = OmdUrl.mall;
//     			var searchParam = {
//     				"pcode" : pcode,
//     				"dcode" : dcode,
//     				"scode" : scode
//     			};
//     			itemLoader.doRequest(url, "mss.work.pgproject.delSoure", searchParam, null, null, function(
//     					data) {
//     				if(data == "OK"){
//     					pgresourList.removeRow(row, false);
// 					}
//     			}, null, null, false); 
//    		 }
    		}
        }
    });
}

if(pgdetailList){
	pgdetailList.on("beforeselect", function(e) {
		//评分标准明细
	    var pgresourListData = pgresourList.getChanges();
	    if(pgresourListData && pgresourListData.length > 0)
	    {
	    	e.cancel = true;
	    	mini.alert("请先保存数据！");
	    	return;
	    }
	});
	pgdetailList.on("selectionchanged", pgdetailListRowclick);   //行点击事件
	
	pgdetailList.on("cellendedit", pgdetailListCellendedit);  //编辑结束时发生
}

if(pgresourList){
	pgresourList.on("cellendedit", pgresourListCellendedit);  //编辑结束时发生
}

function pgdetailListRowclick(e){
	
	pgresourList.clearRows();   //新增明细行时，清除参考评分里的数据
	
	var form = details1.form;
	var row = e.records;
	
	var pcode = row[0].pcode;
	var dcode = row[0].dcode;
	var dname =row[0].dname;
	
	if(pcode!=undefined && dcode!=undefined && dname!=undefined){
		var url = OmdUrl.mall;
		var searchParam = {
		    "queryid" : "select_PgsoureDetail",
			"pcode" : pcode,
			"dcode" : dcode,
		};
		itemLoader.doRequest(url, "mss.work.report.query", searchParam, null, null, function(
				data) {
			var resultdata =data.report;
			if(resultdata !=null || resultdata!= undefined){
//				pgresourList.clearRows();
//				for(var i=0; i<resultdata.length;i++){
//					pgresourList.addRow(resultdata[i]);
//				}
				pgresourList.setData(resultdata);
			}
		}, null, null, false);
	}
}

function pgdetailListCellendedit(e){
	var row = e.record;
	var date = pgdetailList.getData();
	for (var i = 0; i < date.length; i++) {
		if (date[i].dcode == row.dcode && row._id != date[i]._id && (row.dcode != "" && row.dcode != null)) {
			mini.alert("评估明细编码已存在，不能重复！");
			pgdetailList.updateRow(row,{"dcode":""});
		    return;
		}
	}
}

function pgresourListCellendedit(e){
	var row = e.record;
	var date = pgresourList.getData();
	for (var i = 0; i < date.length; i++) {
		if (date[i].scode == row.scode && row._id != date[i]._id && (row.scode != "" && row.scode != null)) {
			mini.alert("评分标准编码已存在，不能重复！");
			pgresourList.updateRow(row,{"scode":""});
		    return;
		}
	}
}

//状态值改变事件
function onPstatusChange(e){
	var value = e.value;
	var newrow = {"dstatus" : value};
	if(value =="N"){
		var pcode = mini.getbyName("pcode").getValue();
		var billno = mini.getbyName("billno").getValue();
	 if(pcode !="" && billno !=""){
			var searchParam = {
					"pcode" :pcode ,
					"billno" :billno ,
				};
				itemLoader.doRequest(OmdUrl.mall, "mss.work.pgproject.ChangeDstatus", searchParam, null, null, function(
						_data) {
					if(_data == "OK"){
						var pgdetailListData = pgdetailList.getData();
						for(var i=0;i<pgdetailListData.length;i++){
							var row = pgdetailListData[i];
							pgdetailList.updateColumn(row,newrow);
						}
					}
				}, null, null, false); 
	 }
  }
}