<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<!DOCTYPE html />
<html>
<head>
<title>商户投诉申请单</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-layout" config="completeLayout" borderStyle="border:0px;"
		style="width: 100%; height: 100%;"></div>
	<!-- 引用基类 -->
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script> 

	<script type="text/javascript">
	
		var billmoduleid =getUrlParam("billmoduleid");
		 if (billmoduleid == "" || billmoduleid == null) {
			 billmoduleid = getUrlParam("modulecode"); 
		 }
	 	var dictData = OcmControl.getDict("BILLMODULEID,BILLSOURCE,COMPLAINTLEVEL,COMPLAINTTYPE","code,name,ddvalue") || {};
	 	
		var isaccept = [{code:"0",name:"满意"},{code:"1",name:"不满意"}];
		var BILLFLAG = [{code:"N",name:"未审核"},{code:"Y",name:"已审核"},{code:"S",name:"已提交"}];
		var tsmb = [{code:"1",name:"商户"},{code:"2",name:"商场"}];  
		var billtype = [{code:"1",name:"顾客投诉"},{code:"2",name:"商户投诉"}];
		// 页面布局配置
		var toolbar1 = {
			rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消
				'billstatus' : {
					'Y' : [ 'addData', 'cancelData', 'copyData', 'searchData','printData' ,'showPic'],
					'N' : [ 'addData', 'editData', 'auditData', 'delData','copyData', 'searchData', 'printData','submitData','showPic' ],
					'C' : [ 'addData', 'copyData', 'searchData', 'printData' ]
				}
			},
			status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
				'N' : [ 'addData', 'saveData', 'searchData','uploadData','showPic' ],
				'V' : [ 'addData', 'editData', 'auditData', 'delData','copyData', 'searchData', 'printData'],
				'E' : [ 'addData', 'saveData', 'delData', 'copyData','searchData', 'printData', 'selectbatch','uploadData','showPic' ],
				'S' : [ 'addData', 'editData', 'auditData', 'delData','copyData', 'searchData', 'printData','showPic'],
				'A' : [ 'addData', 'cancelData', 'copyData', 'searchData','printData','showPic' ],
				'C' : [ 'addData', 'copyData', 'searchData', 'printData','showPic'],
				'D' : [ 'addData', 'searchData'],
			},
			items : [ [ {
				'text' : '新增',
				'iconCls' : 'icon-add',
				'name' : 'addData'
			}, {
				'text' : '修改',
				'iconCls' : 'icon-edit',
				'name' : 'editData'
			}, {
				'text' : '保存',
				'iconCls' : 'icon-save',
				'name' : 'saveData'
			} ,{
				'text' : '审核',
				'iconCls' : 'icon-ok',
				'name' : 'auditData'
			} ], [ {
				'text' : '删除',
				'iconCls' : 'icon-remove',
				'name' : 'delData'
			}, {
				'text' : '查询',
				'iconCls' : 'icon-search',
				'name' : 'searchData'
			} ], [ {
				'text' : '上传附件',
				'iconCls' : 'icon-upload',
				'name' : 'uploadData',
				'onclick' : 'uploadData',
			}, {
				'text' : '下载附件',
				'iconCls' : 'icon-search',
				'name' : 'showPic',
				'onclick' : 'showPic',
			} ,{
				'text' : '打印',
				'iconCls' : 'icon-print',
				'name' : 'printData'
			} ]]
		};
		
		//单据列表
		var formList = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.compmana.search",
			"response" : "complainhead",
			"bindform" : "layoutForm", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段 
			"searchParam":{
				"order_field":"billno",
				"order_direction":"desc",
				"billmoduleid": billmoduleid,
			},
			"properties" : {
				"id" : "formList",
				"columns" : [ {
					type : "indexcolumn",
					headerAlign : "center",
					width : 60,
					header : "行号",
				}, {
					field : "billno",
					headerAlign : "center",
					header : "单据编号",
					allowSort : true,
					width : 150,
				}, {
					field : "billsgno",
					headerAlign : "center",
					header : "手工单号",
					allowSort : true,
					visible:true,
					width : 150,
				},{
					field : "billstatus",
					headerAlign : "center",
					header : "单据状态",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : BILLFLAG,
				},{
					field : "muid",
					displayField : "muid_name",
					header : "门店",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "muid",
						textName : "muid_name",
						responseName : "muid"
					},
					readOnly : true,
					width : 200,
				},{
		          	field: "complainant",
		          	header: "投诉人",
		          	headerAlign : "center",
		          	allowSort: true,
		          	enabledSearch: false,
		          	visible : true,
				} ,{
					field : "contact",
					headerAlign : "center",
					header : "联系方式",
					allowSort : true,
				},{
					field : "compdate",
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "投诉日期",
					allowSort : true,
					align:"center",
				},{
					field : "tsmb",
					headerAlign : "center",
					header : "投诉目标",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : tsmb,
				},{
					field : "presolvedate",
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "要求解决日期",
					allowSort : true,
					align:"center",
				},{
		          	field: "solver",
		          	header: "门店处理人",
		          	headerAlign : "center",
		          	allowSort: true,
		          	enabledSearch: false,
		          	visible:true,
		          	displayField : "solver_name",//文本字段
					editor:OcmControl.newControl('fut_popselect'),
					editorSet: {
					selectkey:"user",//查询key
					},
				} ,{
					field : "solver_name",
					headerAlign : "center",
					header : "门店处理人名称",
					allowSort : false,
					visible:false,
				},{
					field : "isaccept",
					headerAlign : "center",
					header : billmoduleid == '100411'? "顾客是否满意：":"商户是否满意：",
					allowSort : false,
					visible:true,
					data : isaccept,
					renderer : "OcmControl.dictRendererWithCode",
				},{
					field : "solvedate",
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "实际解决日期",
					allowSort : true,
					align:"center",
				} ,{
					field : "billsource",
					headerAlign : "center",
					header : "单据来源",
					type : "comboboxcolumn",  
					headerAlign : "center",
		        	textField:"name",
	        	    valueField:"code" , 
					data: dictData.BILLSOURCE,
					renderer: "OcmControl.dictRendererWithCode",
					allowSort : true,
				},{
		          	field: "inputer",
		          	header: "录入人",
		          	headerAlign : "center",
		          	allowSort: true,
		          	enabledSearch: false,
		          	displayField : "inputer_name",//文本字段
					editor:OcmControl.newControl('fut_popselect'),
					editorSet: {
					selectkey:"investigator",},
				} ,{
					field : "inputer_name",
					headerAlign : "center",
					header : "录入人名称",
					allowSort : false,
					visible:false,
				}, {
		          field: "inputdate",
		          dataType: "date",
		          dateFormat: "yyyy-MM-dd HH:mm:ss",
		          header: "录入日期",
		          width: 150,
		          allowSort: true,
		        }, {
		          field: "auditor",
		          header: "审核人",
		          headerAlign : "center",
		          allowSort: true,
		          enabledSearch: false,
		          displayField : "auditor_name",//文本字段
					editor:OcmControl.newControl('fut_popselect'),
					editorSet: {
					selectkey:"investigator",//查询key
					},
				} ,{
					field : "auditor_name",
					headerAlign : "center",
					header : "审核人名称",
					allowSort : false,
					visible:false,
				}, {
		          field: "auditdate",
		          dataType: "date",
		          dateFormat: "yyyy-MM-dd HH:mm:ss",
		          header: "审核日期",
		          width: 150,
		          allowSort: true,
		        } ,{
					field : "tsnr",
					headerAlign : "center",
					width : 280,
					header : "投诉内容",
					visible:false,
				},{
					field : "clyj",
					headerAlign : "center",
					width : 280,
					header : "门店处理意见",
					visible:false,
				},{
					field : "hf",
					headerAlign : "center",
					width : 280,
					header : "顾客回访描述",
					visible:false,
				},{
					field : "memo",
					headerAlign : "center",
					width : 280,
					header : "备注",
					visible:false,
				}]
			},
	
		};
	
		//单头
		var formHead = {
			"type" : "formgrid",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.compmana.get",
			"response" : "complainhead",
			"properties" : {
				"id" : "formHead",
			},
			
			items : [ {
				"label" : "phkey",
				"id" : "ph_keyvalue",
				"name" : "ph_key",
				"type" : "TextBox",
				"visible" : false
			}, {
				"label": "单据编号：",
	          	"type": "TextBox",
	          	"id" : "billno",
	          	"name": "billno",
	          	"readOnly" : true,
			},{
				"label" : "单据类别：",
				"name" : "billmoduleid",
				"type" : "ComboBox",
				"data" : dictData.BILLMODULEID,
				"defaultValue" : billmoduleid,
				"readOnly" : true,
			},{
	          	"label": "单据状态：",
	          	"type": "ComboBox",
	          	"name": "billstatus",
	          	"defaultValue": "N",
	          	"readOnly": "true",
	          	"data": BILLFLAG,
			} , {
				"label" : "手工单号：",
				"id" : "billsgno",
				"name" : "billsgno",
				"type" : "TextBox",
				"readOnly" : false,
			}, {
				"label" : "门店：",
				"name" : "muid",
				"type" : "ButtonEdit",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"muid",//弹框类型
				textName :"muid_name", //文本显示字段
			},{
				"label" : "门店：",
				"name" : "muid_name",
				"type" : "TextBox",
				"visible" : false,
			} ,{
				"label" : "单据来源：",
				"type" : "ComboBox",
				"name" : "billsource",
				"readOnly": "true",
				"data" : dictData.BILLSOURCE,
				"defaultValue" : '02',
			}, {
				"label" : "主题：",
				"name" : "theme",
				"type" : "TextBox",
				"defaultValue" : "",
				"visible":true,
			},{
				"label" : "商户：",
				"name" : "sbid",
				"type" : "ButtonEdit",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"sbid",
				textName :"sbid_name",
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_sbid", 
				"style": "display:block;float:none",
			},{
				"label" : "商户：",
				"name" : "sbid_name",
				"type" : "TextBox",
				"visible" : false,
			},{
				"label" : "合同号：",
				"name" : "contno",
				"required" : "true",
				"defaultValue" : "",
				"visible":true,
				type : "fut_popselect",
				selectkey:"contno",
				textName : "contno",
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_contno",
			},{
				"label" : "商铺：",
				"name" : "spid",
				"type" : "ButtonEdit",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey : "spid",
				textName : "spid_name",
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_spid",
				allowSort : true,
			}, {
				"label" : "商铺：",
				"name" : "spid_name",
				"type" : "TextBox",
				"visible" : false,
			}, {
				"label" : "商铺面积：",
				"name" : "spbuildarea",
				"type" : "TextBox",
				"readOnly" : true,
			},{
				"label" : "月租金：",
				"name" : "monrent",
				"type" : "Spinner",
				"format" : "#,0.00",
				"vtype" : "float",
				"maxValue" : "100000000000",
				"inputStyle" : "text-align:right;",
			}, {
				"label" : "投诉等级：",
				"name" : "complaintlevel",
				"type" : "ComboBox",
				"data" : dictData.COMPLAINTLEVEL, 
			}, {
				"label" : "投诉/申请类型：",
				"name" : "complainttype",
				"type" : "ComboBox",
				"data" : dictData.COMPLAINTTYPE, 
			}, {
				"label" : "投诉人：",
				"name" : "complainant",
				"type" : "TextBox",
				"required" : "true",
				"defaultValue" : "",
				"visible":true,
			},{
				"label" : "投诉日期：",
				"name" : "compdate",
				"required" : "true",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
			},{
	          	"label": "投诉目标：",
	          	"type": "ComboBox",
	          	"name": "tsmb",
	          	"required" : true,
	          	"readOnly": true,
	          	"data": tsmb,
	          	"defaultValue" : "2",	
			},{
				"label" : "联系方式：",
				"name" : "contact",
				"type" : "TextBox",
				"required" : "true",
				"visible" : true,
			},{
				"label" : "要求解决日期：",
				"name" : "presolvedate",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
				"onvaluechanged" : "onPresolvedateChanged",
				"style": "display:block;float:none",
			 } ,{
					"label" : "投诉内容：",
					"name" : "tsnr",
					"type" : "TextArea",
					"width" : "90%",
					"required" : "true",
			}, {
				"label" : "门店处理人：",
				"name" : "solver",
				"type" : "TextBox",
				"readOnly" : false,
				"visible":true,
				type : "fut_popselect",
				selectkey:"user",
				textName :"solver_name",
				allowSort : true,
			} ,{
				"label" : "门店处理人：",
				"name" : "solver_name",
				"type" : "TextBox",
				"visible":false,
		 	}, {
				"label" : "投诉类型：",
				"name" : "billtype",
				"type" : "ComboBox",
				"defaultValue" : "2", 
				"data" : billtype, 
				"visible":false,
			},{
				"label" : "实际解决日期：",
				"name" : "solvedate",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
				"onvaluechanged" : "onSolvedateChanged",
			},{
				"label" : "商户是否满意：",
				"name" : "isaccept",
				"type" : "ComboBox",
				"visible" : true,
				"data": isaccept,
			} ,{
				"label" : "处理意见：",
				"name" : "clyj",
				"type" : "TextArea",
				"width" : "90%",
			} ,{
				"label" : "顾客回访描述：",
				"name" : "hf",
				"type" : "TextArea",
				"width" : "90%",
			} ,{
				"label" : "备注：",
				"name" : "memo",
				"type" : "TextBox",
				"width" : "90%",
			},{
				"label" : "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
			}, {
				"label" : "录入人",
				"name" : "inputer",
				"type" : "TextBox",
				"readOnly" : true,
				"visible":false,
			}, {
				"label" : "审核人：",
				"name" : "auditor_name",
				"type" : "TextBox",
				"readOnly" : true,
				"style": "display:block;float:none",
			}, {
				"label" : "审核人姓名",
				"name" : "auditor",
				"type" : "TextBox",
				"readOnly" : true,
				"visible":false,
			} , {
		        "label" : "录入时间：",
		        "type" : "DatePicker",
		        "name" : "inputdate",
		        "format" : "yyyy-MM-dd HH:mm:ss",
		        "defaultValue" : new Date(),
		        "readOnly" : "true",
		    } ,  {
	            "label": "审核时间：",
	            "type": "DatePicker",
	            "name": "auditdate",
	            "format": "yyyy-MM-dd HH:mm:ss",
	            "readOnly": "true",
			
			}  ]
		};
		
	 
		//有单头的表单和明细的tab页组成
		var formSub = {
			"type" : "formgrid",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.compmana.get",
			"response" : "complainhead",
			"properties" : {
				"id" : "formSub",
			},
			"items" : formHead.items,
		};
		
		
		
		
		//单据模板中的组成方式:一个列表，一个单据主题(一个单头+N个单据明细)
		var layoutForm = {
			properties : {
				"id" : "layoutForm"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "formList",
				"control" : formList,
			}, {
				"title" : "单据明细",
				"name" : "formSub",
				"control" : formSub,
			} ]
		};
	
		//单据模板
		var completeLayout = {
			"properties" : {
				"id" : "completeLayout",
				"name" : "completeLayout",
			},
			"toolbar":toolbar1,
			"tabs" : layoutForm,
		};
	
		//mini.parse();
	</script>
	
	<script src="compmana.js" type="text/javascript"></script>

	<style>
	
	body {
		margin: 0;
		padding: 0;
	}
	
	.left {
		float: left;
		width: 43%;
		height: 100%;
	}
	
	.right {
		float: right;
		width: 51%;
		height: 100%;
	}
	
	.buttonlist {
		margin-left: 44%;
		height: 100%;
	}
	
	.Content {
		height: 85%;
		/* min-width: 700px;
		_width: expression((   document.documentElement.clientWidth || 
			 document.body.clientWidth)>700?"700px":"" ); */
	}
	
	#left_a {
		float: left;
		width: 40%;
		margin-left: 0px
	}
	
	#right_a {
		float: right;
		margin-right: 60px;
		width: 50%;
	}
	
	#left_b {
		float: left;
		width: 30%;
		margin-left: 0px
	}
	
	#right_b {
		float: right;
		margin-right: 620px;
	}
	</style>

</body>
</html>
