mini.parse();

var gridbox1 = mini.get("gridbox1");// 单据列表
var details1 = mini.get("formdetail");// 单据明细
var shoplistlayout = mini.get("shoplistlayout");
var assessmentdet = mini.get("assessmentdet"); // 明细列表
var total;
var pgfzck = [];

var token = getUrlParam("token");// token值
var tabs1 = mini.get("layouttabs"); // 获取tabs1
var ppcode = mini.getbyName("ppcode");
var ppcode_name = mini.getbyName("ppcode_name");

// 明细不可增行，可删行
details1.tabsToolbar.btn_tabs2_addRow.setVisible(false);
details1.tabsToolbar.btn_tabs2_delRow.setVisible(false);

// tab页面切换的时候，需要绑定自定义控件的数据集
if (tabs1) {
	tabs1.on('activechanged', function(e) {
		setBillData();
	});
}

// 自定义页面数据回填
function setBillData() {
	var _details = mini.get("formdetail");
	var _datas = {};
	if (_details) {
		_datas = _details.config.data;
	}
	if (_datas && jQuery.isEmptyObject(_datas) == false) {
		if (_datas["assessmentdet"]) {
			var assessmentdetData = _datas["assessmentdet"].sort(getSort('asc',
					'asort'));
			assessmentdet.setClientData(assessmentdetData);
		}
		if (mini.getbyName("ppcode") && _datas["ppcode"]) {
			ppcode.setText(_datas["ppcode_name"]);
		}
		
		if (_details.autoflag) {
			_details.autoflag =false;
		}
	}
}

// 明细排序
function getSort(order, sortBy) {
	var ordAlpah = (order == 'asc') ? '>' : '<';
	var sortFun = new Function('a', 'b', 'return a.' + sortBy + ordAlpah + 'b.'
			+ sortBy + '?1:-1');
	return sortFun;
}

// 保存按钮前事件
OcmControl.toolbarFn.saveDataBefore = function() {

	var obj = {};
	mini.getbyName("ratersdate").setValue(new Date());
	// 单据明细
	obj.assessmentdet = assessmentdet.getChanges();

	var sum = 0;
	for (var i = 0; i < obj.assessmentdet.length; i++) {
		var project = obj.assessmentdet[i].project;
		var pgmx = obj.assessmentdet[i].pgmx;
		var pgfzck = obj.assessmentdet[i].pgfzck;
		obj.assessmentdet[i].scode = pgfzck;
		var pgfz = parseInt(obj.assessmentdet[i].pgfz);

		var searchParam = {
			"queryid" : "select_project",
			"pname" : project,
			"dname" : pgmx,
			"scode" : pgfzck
		};
		var newrow;
		itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query", searchParam,
				null, null, function(data) {
					var data = data.report;
					var code = data[0].code;
					var name = data[0].name;
					newrow = "[" + code + "]" + name;

				}, null, null, false);
		obj.assessmentdet[i].pgfzck = newrow;
	}
	setGridData(obj.assessmentdet);

	return obj;
};

// 保存按钮后事件
OcmControl.toolbarFn.saveDataAfter = function() {

	setBillData();
};

// 修改按钮后事件
OcmControl.toolbarFn.editDataAfter = function() {

	// 当前TabsBox
	var _obj = _tabs.tabs[_tabs.activeIndex].control.properties;
	setBillData();
};

// 审核按钮后事件
OcmControl.toolbarFn.auditDataBefore = function() {
	mini.getbyName("ratersdate").setValue(new Date());

	var assessmentdetData = assessmentdet.getData();
	for (var i = 0; i < assessmentdetData.length; i++) {
		var project = assessmentdetData[i].project;
		var pgmx = assessmentdetData[i].pgmx;
		var pgfzck = assessmentdetData[i].pgfzck;
		var pgfz = parseInt(assessmentdetData[i].pgfz);
		if (pgfz == "NaN" || pgfzck == undefined) {
			mini.alert("评估明细为[" + pgmx + "]的实际得分不能为空");
			return;
		}
	}
	return true;
};

// 审核按钮后事件
OcmControl.toolbarFn.auditDataAfter = function() {
	// 自动审批
	var param = {};
	var sbcode = mini.getbyName("sbid").value;
	var billstatus = mini.getbyName("billstatus").value;
	if (sbcode != undefined && sbcode != "" ) {
		param.sbcode = sbcode;
	         if (details1.autoflag == undefined) {
	         	itemLoader.doRequest(OmdUrl.mall, "mss.work.assessmenthead.autoReview",
			param, null, null, function(data) {
					details1.autoflag = true;
			}, null, null, false);
	         }
			
	}
	setBillData();
};

// 经营品牌点击事件
function onPpcodeClick(e) {
	var form = details1.form;
	var buttonEdit = e.sender;

	mini
			.open({
				url : encodeURI("/mall-business-ui/pages/common/gridbox-view.jsp?key=brand"
						+ "&token=" + token),
				title : "经营品牌",
				width : 600,
				height : $(window).height() * 0.8,
				onload : function() {
					var iframe = this.getIFrameEl();
					var data = {
						multiSelect : false,
						"searchParam" : {
							order_field : "code"
						}
					};
					iframe.contentWindow.SetData(data);
				},
				ondestroy : function(data) {
					if (data != "close") {
						if (data.length > 0) {
							buttonEdit.setValue(data[0].code);
							buttonEdit.setText("[" + data[0].code + "]"
									+ data[0].name);
							mini.getbyName("ppcode").setValue(data[0].code);
							mini.getbyName("ppcode_name").setValue(
									"[" + data[0].code + "]" + data[0].name);
							buttonEdit.setIsValid(true);
						}
					}
				}
			});
}

// 经营品牌值改变事件
function onPpcodeChange(e) {
	var form = details1.form;
	var buttonEdit = e.sender;
	var text = buttonEdit.getText();

	if (text == null || text == "") {
		buttonEdit.setValue("");
	} else {
		var searchParam = {
			"code" : text
		};
		var method = "ocm.mdm.brand.search";
		itemLoader.doRequest(OmdUrl.mdm, method, searchParam, null, null,
				function(data) {
					var data = data.brand;
					if (data.length > 0) {
						buttonEdit.setValue(data[0].code);
						buttonEdit.setText("[" + data[0].code + "]"
								+ data[0].name);
						mini.getbyName("ppcode").setValue(data[0].code);
						mini.getbyName("ppcode_name").setValue(
								"[" + data[0].code + "]" + data[0].name);
						buttonEdit.setIsValid(true);
					} else {
						alert("经营品牌[" + text + "]不存在");
						buttonEdit.setValue("");
						buttonEdit.setText("");
						mini.getbyName("ppcode").setValue("");
						mini.getbyName("ppcode_name").setValue("");
					}
				}, null, null, false);
	}
}

// 评价值改变事件
function onPgfzckChange(e) {
	var form = details1.form;
	var row = assessmentdet.getSelected();
	var buttonEdit = e.sender;
	var value = e.value;

	if (value != null && value != "") {
		var project = row.project;
		var pgmx = row.pgmx;

		var searchParam = {
			"queryid" : "select_project",
			"pname" : project,
			"dname" : pgmx,
			"scode" : value
		};
		itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query", searchParam,
				null, null, function(data) {
					var data = data.report;
					var scoreData = data[0].score;
					var newrow = {
						pgfz : scoreData,
						pgfzck : value
					};
					assessmentdet.updateRow(row, newrow);
				}, null, null, false);
	}
	var sum = 0;
	for (var i = 0; i < assessmentdet.getData().length; i++) {
		var pgfz = parseInt(assessmentdet.getData()[i].pgfz);
		if (pgfz && pgfz != "NaN") {
			sum += pgfz;
		} else {
			pgfz = 0;
			sum += pgfz;
		}

	}
	mini.getbyName("score").setValue(sum);
	mini.getbyName("scode").setValue(value);
}

assessmentdet.on("cellbeginedit", assessmentdetRowclick);

function assessmentdetRowclick(e) {
	if (e.field != 'pgfzck')
		return;
	var form = details1.form;
	var row = e.record;
	var project = row.project;
	var pgmx = row.pgmx;

	var url = OmdUrl.mall;
	var method = "mss.work.pgproject.getSoure";
	var searchParam = {
		"pname" : project,
		"dname" : pgmx
	};
	var resultdata;
	itemLoader.doRequest(url, method, searchParam, null, null, function(_data) {
		resultdata = _data;
		if (resultdata.length == 0) {
			mini.alert("没有找到相应的项目明细");
			return;
		}
	}, null, null, false);
	e.column.editor.setData(resultdata);
	pgfzck.push(resultdata);
}

function renderPgfzck(e) {
	if (e.field != 'pgfzck')
		return;

	var grid = e.sender;
	var _default = {
		value : "code",
		text : "name",
	};
	if (e.value === undefined) {
		e.value = "";
	}
	;
	e._value = e.value.toString() || e.column.defaultValue;
	if (e.column.textField) {
		_default.text = e.column.textField;
	}
	;
	if (e.column.valueField) {
		_default.value = e.column.valueField;
	}
	;

	var dict = e.column.editor.data;
	if (dict) {
		for (var i = 0, l = dict.length; i < l; i++) {
			var g = dict[i];
			// houzq 2016.10.20 增加g[_default.text]!=undefined判断
			if (g[_default.text] != undefined && g[_default.value].toString()
					&& (g[_default.value].toString() == e._value)) {
				if (g[_default.text].toString().indexOf("[") != 0) {
					return '[' + g[_default.value] + ']' + g[_default.text];
				} else {
					return g[_default.text];
				}
			}
		}
		return e.value.toString();
	} else {
		return e.value.toString();
	}
}

// 带入条件查询
function head_beforefunc(e) {
	if (!e.searchParam) {
		e.searchParam = {};
	}
	var buttonEdit = e.sender;

	if (e.value != "undefined" && e.value != "") {
		e.searchParam.code = e.value;
	}
	return 0;
}

// 单头意向商铺回填值
function head_itemchanged_spid(e, data) {
	if (data != null) {
		// 查询出原单明细
	}
	return 0;
}

// 商户回填值
function head_itemchanged_sbid03(e, data) {
	if (data != null) {
		// 查询出原单明细
	}
	return 0;
}