<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<!DOCTYPE html />
<html>
<head>
<title>装修进场申请单</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-layout" config="completeLayout" borderStyle="border:0px;"
		style="width: 100%; height: 100%;"></div>
	<!-- 引用基类 -->
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/method.js" type="text/javascript"></script>
	<script type="text/javascript">
	
		var dictData  = OcmControl.getDict("BILLMODULEID,BILLSOURCE","code,name,pro1,ddvalue") || {};
		var billstatus = [{code:"N",name:"未审核"},{code:"Y",name:"已审核"},{code:"S",name:"已提交"}];
		var billmoduleid = "100414";
	
		// 页面布局配置
		var toolbar1 = {
			rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消
				'billstatus' : {
					'Y' : [ 'addData', 'cancelData', 'copyData', 'searchData','printData','showPic' ],
					'N' : [ 'addData', 'editData', 'auditData', 'delData','copyData', 'searchData', 'printData','submitData','uploadData','showPic' ],
					'C' : [ 'addData', 'copyData', 'searchData', 'printData' ]
				}
			},
			status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
				'N' : [ 'addData', 'saveData', 'searchData','uploadData','showPic'],
				'V' : [ 'addData', 'editData', 'auditData', 'delData','copyData', 'searchData', 'printData'],
				'E' : [ 'addData', 'saveData', 'delData', 'copyData','searchData', 'printData', 'selectbatch','showPic' ],
				'S' : [ 'addData', 'editData', 'auditData', 'delData','copyData', 'searchData', 'printData'],
				'A' : [ 'addData', 'cancelData', 'copyData', 'searchData','printData' ,'showPic'],
				'C' : [ 'addData', 'copyData', 'searchData', 'printData','showPic'],
				'D' : [ 'addData', 'searchData'],
			},
			items : [ [ {
				'text' : '新增',
				'iconCls' : 'icon-add',
				'name' : 'addData'
			}, {
				'text' : '修改',
				'iconCls' : 'icon-edit',
				'name' : 'editData'
			}, {
				'text' : '保存',
				'iconCls' : 'icon-save',
				'name' : 'saveData'
			},{
				'text' : '审核',
				'iconCls' : 'icon-ok',
				'name' : 'auditData'
			} ], [ {
				'text' : '删除',
				'iconCls' : 'icon-remove',
				'name' : 'delData'
			}, {
				'text' : '查询',
				'iconCls' : 'icon-search',
				'name' : 'searchData'
			} ], [ {
				'text' : '上传附件',
				'iconCls' : 'icon-upload',
				'name' : 'uploadData',
				'onclick' : 'uploadData',
			}, {
				'text' : '下载附件',
				'iconCls' : 'icon-search',
				'name' : 'showPic',
				'onclick' : 'showPic',
			} ,{
				'text' : '打印',
				'iconCls' : 'icon-print',
				'name' : 'printData'
			} ]]
		};
		
		//单据列表
		var formList = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.shopinhead.search",
			"response" : "shopinhead",
			"bindform" : "layoutForm", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段 
			"searchParam":{
				"order_field":"billno",
				"order_direction":"desc",
			},
			"properties" : {
				"id" : "formList",
				"columns" : [ {
					type : "indexcolumn",
					headerAlign : "center",
					width : 60,
					header : "行号",
				}, {
					field : "billno",
					headerAlign : "center",
					header : "单据编号",
					allowSort : true,
					width : 150,
				}, {
					field : "billsgno",
					headerAlign : "center",
					header : "手工单号",
					allowSort : true,
					visible : true,
					width : 150,
				},{
					field : "billstatus",
					headerAlign : "center",
					header : "单据状态",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : billstatus,
				},{
					field : "muid",
					displayField : "muid_name",
					header : "门店",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "muid",
						textName : "muid_name",
						responseName : "muid"
					},
					readOnly : true,
					width : 200,
				},{
					field : "sbid",
					headerAlign : "center",
					header : "商户",
					allowSort : true,
					displayField : "sbid_name",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "sbid03",
						textName : "sbid_name",
						responseName : "sbid"
					},
					readOnly : true,
					width : 200,
				},{
		          	field: "contno",
		          	header: "合同号",
		          	headerAlign : "center",
		          	allowSort: true,
		          	enabledSearch: false,
		          	visible : true,
		          	width : 150,
				} ,{
					field : "spid",
					headerAlign : "center",
					header : "商铺",
					allowSort : true,
					displayField : "spcode",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "spid",
						textName : "spcode",
						responseName : "spid"
					},
					readOnly : true,
					width : 200,
				} ,{
					field : "preindate",
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "预计进场日期",
					allowSort : true,
					align:"center",
				},{
					field : "indate",
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "实际进场日期",
					allowSort : true,
					align:"center",
				} ,{
					field : "billsource",
					headerAlign : "center",
					header : "单据来源",
					type : "comboboxcolumn",  
					headerAlign : "center",
		        	textField:"name",
	        	    valueField:"code" , 
					data: dictData.BILLSOURCE,
					renderer: "OcmControl.dictRendererWithCode",
					allowSort : true,
				},{
		          	field: "inputer",
		          	header: "录入人",
		          	headerAlign : "center",
		          	allowSort: true,
		          	//enabledSearch: false,
		          	width: 150,
		          	displayField : "inputer_name",//文本字段
					editor:OcmControl.newControl('fut_popselect'),
					editorSet: {
					selectkey:"user",//查询key
					beforefunc:"head_beforefunc",
					},
				}, {
		          field: "inputdate",
		          dataType: "date",
		          dateFormat: "yyyy-MM-dd HH:mm:ss",
		          header: "录入日期",
		          width: 150,
		          allowSort: true,
		        }, {
		          field: "auditor",
		          header: "审核人",
		          headerAlign : "center",
		          allowSort: true,
		        //enabledSearch: false,
		          width: 150,
		          displayField : "auditor_name",//文本字段
					editor:OcmControl.newControl('fut_popselect'),
					editorSet: {
					selectkey:"user",//查询key
					beforefunc:"head_beforefunc",},
				}, {
		          field: "auditdate",
		          dataType: "date",
		          dateFormat: "yyyy-MM-dd HH:mm:ss",
		          header: "审核日期",
		          width: 150,
		          allowSort: true,
				}]
			},
	
		};
	
		//单头
		var formHead = {
			"type" : "formgrid",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.shopinhead.get",
			"response" : "shopinhead",
			"properties" : {
				"id" : "formHead",
			},
			
			items : [ {
				"label" : "phkey",
				"id" : "ph_keyvalue",
				"name" : "ph_key",
				"type" : "TextBox",
				"visible" : false
			}, {
				"label": "单据编号：",
	          	"type": "TextBox",
	          	"id" : "billno",
	          	"name": "billno",
	          	"readOnly" : true,
			} , {
				"label" : "单据类别：",
				"name" : "billmoduleid",
				"type" : "ComboBox",
				"data" : dictData.BILLMODULEID,
				"defaultValue" : billmoduleid,
				"readOnly" : true,
			}, {
	          	"label": "单据状态：",
	          	"type": "ComboBox",
	          	"name": "billstatus",
	          	"defaultValue": "N",
	          	"readOnly": "true",
	          	"data": billstatus,
			} , {
				"label" : "手工单号：",
				"id" : "billsgno",
				"name" : "billsgno",
				"type" : "TextBox",
				"readOnly" : false,
				"visible":true,
			}, {
				"label" : "门店：",
				"name" : "muid",
				"type" : "ButtonEdit",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"muid",
				textName :"muid_name",
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_muid", 
			},{
				"label" : "门店：",
				"name" : "muid_name",
				"type" : "TextBox",
				"visible" : false,
			 } ,{
					"label" : "单据来源：",
					"type" : "ComboBox",
					"name" : "billsource",
					"readOnly": "true",
					"data" : dictData.BILLSOURCE,
					"defaultValue" : '02',
			},{
				"label" : "合同：",
				"name" : "contno",
				"required" : "true",
				"visible":true,
				type : "fut_popselect",
				selectkey:"contno",
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_contno",
			
			},{
				"label" : "商户：",
				"name" : "sbid",
				"type" : "ButtonEdit",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"sbid",
				textName :"sbid_name",
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_sbid", 
			},{
				"label" : "商户：",
				"name" : "sbid_name",
				"type" : "TextBox",
				"visible" : false,
			},  {
				"label" : "商铺：",
				"name" : "spid",
				"type" : "ButtonEdit",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"contspid02",
				textName :"spcode",
				beforefunc:"head_beforefunc",
				allowSort : true,
			},{
				"label" : "商铺：",
				"name" : "spcode",
				"type" : "TextBox",
				"visible" : false,
			},{
				"label" : "预计进场日期：",
				"name" : "preindate",
				"required" : "true",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
			},{
				"label" : "实际进场日期：",
				"name" : "indate",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
				//"onvaluechanged" : "onIndateChanged",
				"style": "display:block;float:none",
			} ,{
					"label" : "商户进场说明：",
					"name" : "caption",
					"type" : "TextArea",
					"width" : "90%",
					"required" : "true",
			} ,{
					"label" : "招商部意见：",
					"name" : "yj",
					"type" : "TextArea",
					"width" : "90%",
			} ,{
					"label" : "备注：",
					"name" : "memo",
					"type" : "TextArea",
					"width" : "90%",
			},{
				"label" : "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
			}, {
				"label" : "录入人",
				"name" : "inputer",
				"type" : "TextBox",
				"readOnly" : true,
				"visible":false,
			} ,{
				"label" : "审核人：",
				"name" : "auditor_name",
				"type" : "TextBox",
				"readOnly" : true,
				"style": "display:block;float:none",
			}, {
				"label" : "审核人姓名",
				"name" : "auditor",
				"type" : "TextBox",
				"readOnly" : true,
				"visible":false,
			} , {
		        "label" : "录入时间：",
		        "type" : "DatePicker",
		        "name" : "inputdate",
		        "format" : "yyyy-MM-dd HH:mm:ss",
		        "defaultValue" : new Date(),
		        "readOnly" : "true",
		    } ,  {
	            "label": "审核时间：",
	            "type": "DatePicker",
	            "name": "auditdate",
	            "format": "yyyy-MM-dd HH:mm:ss",
	            "readOnly": "true",
			}  ]
		};
		
		
	 
		//有单头的表单和明细的tab页组成
		var formSub = {
			"type" : "formgrid",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.shopinhead.get",
			"response" : "shopinhead",
			"properties" : {
				"id" : "formSub",
			},
			"items" : formHead.items,
		};
		
		
		
		
		//单据模板中的组成方式:一个列表，一个单据主题(一个单头+N个单据明细)
		var layoutForm = {
			properties : {
				"id" : "layoutForm"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "formList",
				"control" : formList,
			}, {
				"title" : "单据明细",
				"name" : "formSub",
				"control" : formSub,
			} ]
		};
	
		//单据模板
		var completeLayout = {
			"properties" : {
				"id" : "completeLayout",
				"name" : "completeLayout",
			},
			"toolbar":toolbar1,
			"tabs" : layoutForm,
		};
	
	</script>
	
	<script src="shopin.js" type="text/javascript"></script>

	<style>
	
	body {
		margin: 0;
		padding: 0;
	}
	
	.left {
		float: left;
		width: 43%;
		height: 100%;
	}
	
	.right {
		float: right;
		width: 51%;
		height: 100%;
	}
	
	.buttonlist {
		margin-left: 44%;
		height: 100%;
	}
	
	.Content {
		height: 85%;
		/* min-width: 700px;
		_width: expression((   document.documentElement.clientWidth || 
			 document.body.clientWidth)>700?"700px":"" ); */
	}
	
	#left_a {
		float: left;
		width: 40%;
		margin-left: 0px
	}
	
	#right_a {
		float: right;
		margin-right: 60px;
		width: 50%;
	}
	
	#left_b {
		float: left;
		width: 30%;
		margin-left: 0px
	}
	
	#right_b {
		float: right;
		margin-right: 620px;
	}
	</style>

</body>
</html>
