<%@ page language="java" contentType="text/html; charset=utf-8"	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>商铺撤场申请单</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-layout" config="cardLayout"	beforeload="beforeload" borderStyle="border:0px;" style="width: 100%; height: 100%;"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/method.js" type="text/javascript"></script>
	<script type="text/javascript">
		// 字典数据初始化
		var dicData = getDict("SYSTEM_BILLSTATUS,SYSTEM_BILLSOURCE,CONTRACT_CCREASON,CONTRACT_CONTSTYLE,CONTRACT_WMID","dcode,dname,pro1,ddvalue") || {};
		 var billmoduleid =getUrlParam("billmoduleid");
    	 if (billmoduleid == "" || billmoduleid == null) {
    		 billmoduleid = getUrlParam("modulecode"); 
    	 }
    	 var billtype = getBilltype(billmoduleid);
		dicData.Tssstatus = [{code:"Y", name:"已提交"},{code:"R",name:"已驳回"}];

		// 页面布局配置
		var toolbar1 = {
			rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消
				'billstatus' : {
					'N' : [ 'addData', 'editData', 'delData', 'auditData', 'searchData','uploadData', 'showPic','reloadData'],
					'Y' : [ 'addData', 'searchData', 'submitData', 'showPic', 'reloadData', 'reviseData' ],
					'S' : [ 'addData', 'searchData', 'showPic'],
					'C' : [ 'addData', 'searchData' ],
					'P' : [ 'addData', 'searchData' ]
				}
			},
			status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
				'N' : [ 'addData', 'saveData', 'searchData', 'auditData' ],
				'V' : [ 'addData', 'editData', 'delData', 'searchData', 'auditData', 'uploadData' ],
				'E' : [ 'addData', 'searchData','delData', 'saveData' ],
				'S' : [ 'addData', 'searchData', 'uploadData', 'correctData' ],
				'A' : [ 'addData', 'editData', 'searchData', 'correctData' ],
				'C' : [ 'addData', 'searchData' ],
				'D' : [ 'addData', 'searchData' ]
			},
			items : [ [ {
				'text' : '新增',
				'iconCls' : 'icon-add',
				'name' : 'addData'
			}, {
				'text' : '修改',
				'iconCls' : 'icon-edit',
				'name' : 'editData'
			}, {
				'text' : '保存',
				'iconCls' : 'icon-save',
				'name' : 'saveData'
			}, {
				'text' : '审核',
				'iconCls' : 'icon-ok',
				'name' : 'auditData'
			}], [ {
				'text' : '删除',
				'iconCls' : 'icon-remove',
				'name' : 'delData'
			}, {
				'text' : '查询',
				'iconCls' : 'icon-search',
				'name' : 'searchData'
			}] ]
		};
		
		//单据列表
		var shoprecallapplylist = {
			"type" : "gridbox",
			"resources" : OmdUrl.mall,
			"method" : "mall.work.shoprecallapply.search",
			"response" : "shoprecallapply",
			"bindform" : "layouttabs", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段 
			"searchParam" : {
				"$or": [{"tssstatus": {"==": "R"}}, {"tssstatus": {"==": "Y"}}],
				"order_field" : "billno",
				"order_direction" : "desc",
			},
			"properties" : {
				"id" : "shoprecallapplylist",
				"columns" : [ {
					type : "indexcolumn",
					headerAlign : "center",
					header : "行号",
					width:80,
				},{
					field : "billno",
					headerAlign : "center",
					header : "单据号",
					width:160,
				},{
					field : "billstatus",
					headerAlign : "center",
					header : "单据状态",
					width:120,
					renderer: "OcmControl.dictRendererWithCode",
				    data: dicData.SYSTEM_BILLSTATUS,
				},{
					field : "tssstatus",
					headerAlign : "center",
					header : "申请进度",
					width:160,
					renderer: "OcmControl.dictRendererWithCode",
					data: dicData.Tssstatus,
					enabledSearch : false,
					visible : false,
				},{
					field : "billsource",
					headerAlign : "center",
					header : "单据来源",
					type : "comboboxcolumn",  
					headerAlign : "center",
					textField:"name",
				    valueField:"code" , 
				    data:dicData.SYSTEM_BILLSOURCE,
					renderer: "OcmControl.dictRendererWithCode",
					enabledSearch : false,
					readOnly : true,
				}, {
					field: "muid",
					displayField : "muid_name",
					headerAlign: "center",
					header: "门店",
					editor:OcmControl.newControl('fut_popselectgrid'),
					cdEdtCfg:{compnentType:'fut_popselect',
						      selectkey:"muid",
						      textName:"muid_name",
						      responseName : "muid"},
					readOnly : true,
					width : 200,
				},  {
					field: "contno",
					headerAlign: "center",
					header: "合同",
					editor:OcmControl.newControl('fut_popselectgrid'),
					displayField : "contno",
					cdEdtCfg:{compnentType:'fut_popselect',selectkey:"contno"},
					width : 100
				},  {
					field : "sbid",
					displayField : "sbid_name",
					header : "商户",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "sbid",
						textName : "sbid_name",
						responseName : "sbid"
					},
					readOnly : true,
					width : 200,
				},  {
					field : "spid",
					displayField : "spid_name",
					header : "商铺",
					width : 200,
					allowSort : true,
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "spid",
						textName :"spid_name"
					},
					readOnly : true,
				},{
					field : "inputer",
					header : "录入人",
					headerAlign : "center",
					readOnly : true,
					enabledSearch : true,
					visible:false,
					width : 100,
				},{
					field : "inputer_name",
					header : "录入人",
					headerAlign : "center",
					readOnly : true,
					enabledSearch : false,
					width : 100,
				},{
					field : "inputdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd HH:mm:ss", 
					header : "录入日期",
					width : 160,
					headerAlign : "center",
				}, {
					field : "auditor",
					header : "审核人",
					width : 100,
					headerAlign : "center",
					enabledSearch : true,
					visible:false,
				}, {
					field : "auditor_name",
					header : "审核人",
					width : 100,
					headerAlign : "center",
					enabledSearch : false,
				}, {
					field : "auditdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd HH:mm:ss",
					header : "审核日期",
					headerAlign : "center",
					width : 160,
				} ]
			},
		};

		//单据头
		var shoprecallapply = {
			"type" : "formgrid",
			"properties" : {
				"id" : "shoprecallapply",
			},
			items : [{
				"label" : "ph_key：",
				"type" : "TextBox",
				"name" : "ph_key",
				"readOnly" : "true",
				"visible" : false,
			},  {
				"label" : "单据号：",
				"type" : "TextBox",
				"name" : "billno",
				"readOnly" : "true",
			},{
				"label" : "单据状态：",
				"type" : "ComboBox",
				"name" : "billstatus",
				"readOnly" : "true",
				"defaultValue" : "N",
				"data" : dicData.SYSTEM_BILLSTATUS,
			},{
				"label" : "单据类别：",
				"type" : "ComboBox",
				"name" : "billmoduleid",
				"defaultValue" : billmoduleid,
				"readOnly" : true,
				"visible" : false,
			},{
				"label" : "单据类别：",
				"type" : "ComboBox",
				"name" : "billtype",
				"defaultValue" : billtype,
				"readOnly" : true,
				"visible" : false,
			},{
				"label" : "TSS单据状态：",
				"name" : "tssstatus",
				"type" : "TextBox",
				"defaultValue" : "Y",
				"visible" : false,
			},{
				"label" : "单据来源：",
				"type" : "ComboBox",
				"name" : "billsource",
				"readOnly": "true",
				"data" : dicData.SYSTEM_BILLSOURCE,
				"defaultValue" : "02",
			},{
				"label" : "门店：",
				"name" : "muid",
				displayField :"muid_name",
				"type" : "ButtonEdit",
				"required" : "true",
				type : "fut_popselect",//类型
				selectkey:"muid",//弹框类型
				textName :"muid_name", //文本显示字段
				itemchangedfunc : "head_itemchanged_muid"
			}, {
				"label" : "合同号：",
				"name" : "contno",
				displayField :"contno",
				"type" : "ButtonEdit",
				"required" : "true",
				type : "fut_popselect",//类型
				selectkey:"contno",//弹框类型
				textName :"contno", //文本显示字段
				beforefunc : "head_beforefunc_contno",
				itemchangedfunc:"head_itemchanged_contno"
			}, {
				"label" : "商户：",
				"name" : "sbid",
				displayField :"sbid_name",
				"type" : "ButtonEdit",
				"required" : "true",
				type : "fut_popselect",//类型
				selectkey:"sbid",//弹框类型
				textName :"sbid_name", //文本显示字段
				beforefunc : "head_beforefunc_sbid",
				itemchangedfunc:"head_itemchanged_sbid"
			},{
				"label" : "商铺：",
				"name" : "spid",
				displayField :"spid_name",
				"type" : "ButtonEdit",
				"required" : "true",
				type : "fut_popselect",//类型
				selectkey:"spid",//弹框类型
				textName :"spid_name", //文本显示字段
				beforefunc : "head_beforefunc_spid",
			}, {
				"label" : "经营方式：",
				"type" : "ComboBox",
				"name" : "wmid",
				"readOnly" : true,
				"data" : dicData.CONTRACT_WMID,
				"style" : "width:30%",
				"defaultValue" : "5",
			},{
				"label" : "品牌：",
				"type" : "ButtonEdit",
				"name" : "ppcode",
				displayField : "ppcode_name",
				type : "fut_popselect",
				selectkey : "ppcode",
				textName : "ppcode_name",
				"readOnly" : true,
			},{
				"label" : "合同生效日期：",
				"type" : "DatePicker",
				"name" : "cmeffdate",
				"format" : "yyyy-MM-dd",
				"readOnly" : true,
			},{
				"label" : "合同失效日期：",
				"type" : "DatePicker",
				"name" : "cmlapdate",
				"format" : "yyyy-MM-dd",
				"readOnly" : true,
			},{
				"label" : "当前有效期：",
				"type" : "TextBox",
				"name" : "expirydate",
				"style" : "width:30%",
				"readOnly" : true,
			},{
				"label" : "店招：",
				"type" : "TextBox",
				"name" : "sbdz",
				"style" : "width:30%",
				"visible" : false,
			},{
				"label" : "经营种类：",
				"type" : "ButtonEdit",
				"name" : "mid",
				displayField : "mname",
				type : "fut_popselect",
				selectkey : "cat",
				textName : "mname",
				responseName : "mid",
				"style" : "width:30%;",
				"visible" : false,
			},{
				"label" : "合同主体：",
				"type" : "TextBox",
				"name" : "cmtitle",
				"visible" : false,
			},{
				"label" : "合同样式：",
				"type" : "ComboBox",
				"name" : "contstyle",
				"data" : dicData.CONTRACT_CONTSTYLE,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "01",
				"style" : "width:30%",
				"readOnly" : true,
				"visible" : false,
			},{
				"label" : "撤场原因：",
				"type" : "ComboBox",
				"name" : "ccreason",
				"required" : "true",
				"data" : dicData.CONTRACT_CCREASON,
				"style" : "width:30%"
			},{
				"label" : "撤场日期：",
				"type" : "DatePicker",
				"name" : "ccdate",
				"format" : "yyyy-MM-dd",
				"required" : "true",
				"onValuechanged" : "onCcdateChange",
			},{
				"label" : "备注：",
				"name" : "memo",
				"type" : "TextBox",
				"style": "width:90%",
			},{
				"label" : "驳回原因：",
				"name" : "rejectmemo",
				"type" : "TextBox",
				"style": "width:90%",
				"readOnly" : true,
			},{
				"label" : "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
			}, {
				"label" : "录入人编码：",
				"type" : "TextBox",
				"name" : "inputer",
				"visible":false,
			}, {
				"label" : "审核人：",
				"type" : "TextBox",
				"name" : "auditor_name",
				"readOnly" : "true",
			}, {
				"label" : "驳回人：",
				"type" : "TextBox",
				"name" : "rejecter_name",
				"readOnly" : "true",
			}, {
				"label" : "录入日期：",
				"name" : "inputdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
			}, {
				"label" : "审核日期：",
				"type" : "DatePicker",
				"name" : "auditdate",
				"format" : "yyyy-MM-dd HH:mm:ss",
				"readOnly" : "true",
			}, {
				"label" : "驳回日期：",
				"type" : "DatePicker",
				"name" : "rejecterdate",
				"format" : "yyyy-MM-dd HH:mm:ss",
				"readOnly" : "true",
			}]
		};
		
		//单据明细组成：单据头+单据明细tab
		var formdetail = {
			"type" : "formgrid",
			"resources" : OmdUrl.mall,
			"method" : "mall.work.shoprecallapply.get",
			"response" : "shoprecallapply",
			"properties" : {
				"id" : "formdetail",
			},   
			 "items" : shoprecallapply.items,  //绑定到具体的项
		};
		
		//单据列表和单据明细
		var layouttabs = {
			properties : {
				"id" : "layouttabs"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "shoprecallapplylist",
				"control" : shoprecallapplylist,
			} , {
				"title" : "单据明细",
				"name" : "formDetail",
				"control" : formdetail,
			} ]
		};

		var cardLayout = {
			"properties" : {
				"id" : "cardLayout",
			},
			"toolbar":toolbar1,
			"tabs" : layouttabs,
		};
	</script>
	<script src="shoprecallapply.js" type="text/javascript"></script>
</body>
<style>
.mini-labelfield-label,body .mini-checkbox label {
    width: 145px!important;
    white-space: normal;
  }
.ocm-formheader .mini-labelfield > span, .ocm-details .mini-labelfield > span {
  margin-left: 145px!important;
}
body .mini-labelfield-checkboxlist table, .mini-checkbox-check {
  margin-left: 145px!important;
}
body .mini-labelfield .mini-textbox-input {
	white-space: normal;
}
body .mini-labelfield .mini-labelfield-label {
	white-space: normal;
}
.Content {
	height: 90%;
}
.left {
	float: left;
	width: 40%;
	height: 100%;
	margin-top: 5px;
}
.right {
	float: right;
	width: 60%;
	height: 100%;
	margin-top: 5px;
}
</style>
</html>