<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>真实毛利报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "501910";

  var toolbar1 = {
    items : [ [ {
      "text" : "查询",
      "iconCls" : "icon-search",
      "name" : "searchData",
      "onclick" : "searchData",
      "enabled" : true,
    }, {
      "text" : "清除",
      "iconCls" : "icon-remove",
      "name" : "clearData",
      "onclick" : "clearData",
      "enabled" : true,
    } , {
		"text" : "导出",
		"iconCls" : "icon-upload",
		"name" : "exportData",
		"onclick" : "exportData",
		"enabled" : true,
    } ] ]
  };

  var formheader1 = {
    "type" : "formgrid",
    "properties" : {
      "id" : "formheader1",
    },
    items : [{
     	 "label" : "开始日期：",
         "type" : "DatePicker",
         "name" : "sdate",
         "format" : "yyyy-MM-dd",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
         "label" : "结束日期：",
         "type" : "DatePicker",
         "name" : "edate",
         "format" : "yyyy-MM-dd",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      },  {
          "label" : "门店：",
          "type" : "ButtonEdit",
          "name" : "mktid",
          "enabled" : true,
          "onbuttonclick" : "onMktidClick",
          "onValuechanged" : "onMktidChange",
          "style" : "width:30%"
      }, {
			"label" : "商户：",
			"type" : "ButtonEdit",
			"name" : "sbid",
			"enabled" : true,
			"onbuttonclick" : "onSupcodeClick",
			"onValuechanged" : "onSupcodeChange",
			"style" : "width:30%"
      }, { 
			"label" : "商铺：",
			"type" : "ButtonEdit",
			"name" : "spid",
			"enabled" : true,
			"onbuttonclick" : "onShoplistClick",
			"onValuechanged" : "onShoplistChange",
			"style" : "width:30%"
     } ]};

     

  var gridbox1 = {
    "type" : "gridbox",
    "resources" : OmdUrl.mall,
    "method" : "mss.work.report.query",
    "response" : "report",
    "manualLoad" : true,
    "searchParam" : {
      "queryid":"select_realgprofit",
    },
    "properties" : {
      "id" : "gridbox1",
      "showSummaryRow" : true,
	  "ondrawsummarycell" : "onDrawSummaryCell",
      "columns" :[ {
        type : "indexcolumn",
        header : "行号",
        headerAlign : "center",
      }, {                             
        field : "mkt",
        header : "门店",
        allowSort : true,
        headerAlign : "center",
        width : 160,
      }, {                             
          field : "spid",
          header : "商铺",
          allowSort : true,
          headerAlign : "center",
          width : 180,
      }, {                             
          field : "sbid",
          header : "商户",
          allowSort : true,
          headerAlign : "center",
          width : 180,
      }, {
        field : "xssr",
        header : "销售额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype :"float",
        align: "right",
        width : 80,
      }, {
          field : "qxssr",
          header : "参加活动销售额",
          allowSort : true,
          headerAlign : "center",
          numberFormat : "#,0.00",
          vtype :"float",
          align: "right",
          width : 80,
      }, {
          field : "fqje",
          header : "总发券额",
          allowSort : true,
          headerAlign : "center",
          numberFormat : "#,0.00",
          vtype :"float",
          align: "right",
          width : 80,
      }, {
          field : "sqje",
          header : "总收券额",
          allowSort : true,
          headerAlign : "center",
          numberFormat : "#,0.00",
          vtype :"float",
          align: "right",
          width : 80,
      }, {
        field : "qft",
        header : "供应商承担总额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype :"float",
        align: "right",
        width : 100,
      }, {
          field : "sglsupzk",
          header : "供应商折扣承担",
          allowSort : true,
          headerAlign : "center",
          numberFormat : "#,0.00",
          vtype :"float",
          align: "right",
          width : 100,
      }, {
          field : "cqmle",
          header : "去券净毛利额",
          allowSort : true,
          headerAlign : "center",
          numberFormat : "#,0.00",
          vtype :"float",
          align: "right",
          width : 80,
      }, {
          field : "cqmll",
          header : "去券净毛利率",
          headerAlign : "center",
		  numberFormat : "p0",
		  vtype :"float;range:0,1",
		  dataType:"float",
		  align: "right",
		  allowSort : true,
		  editorSet: {onValuechanged : "setdoublevalue"},
          width : 80,
      }, {
        field: "xscb",
        header: "销售成本",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype :"float",
        align: "right",
        width : 80,
      } ]
    },
  };

  mini.parse();
  
  function onDrawSummaryCell(e) {
		var rows = e.data;
		var xssr = 0.00;var qxssr = 0.00;
		var xscb = 0.00;var fqje = 0.00;
		var sqje = 0.00;var qft = 0.00;
		var cqmle = 0.00;var sglsupzk = 0.00;
		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.xssr) == false) {
					xssr += parseFloat(row.xssr);
				}
				if (isNaN(row.qxssr) == false) {
					qxssr += parseFloat(row.qxssr);
				}
				if (isNaN(row.xscb) == false) {
					xscb += parseFloat(row.xscb);
				}
				if (isNaN(row.fqje) == false) {
					fqje += parseFloat(row.fqje);
				}
				if (isNaN(row.sqje) == false) {
					sqje += parseFloat(row.sqje);
				}
				if (isNaN(row.qft) == false) {
					qft += parseFloat(row.qft);
				}
				if (isNaN(row.cqmle) == false) {
					cqmle += parseFloat(row.cqmle);
				}
				if (isNaN(row.sglsupzk) == false) {
					sglsupzk += parseFloat(row.sglsupzk);
				}
			}
		}

		if (e.field == "sbid") {
			e.cellHtml = "<b>"+"合计: "+"</b>";
		}
		if (e.field == "sglsupzk") {
			e.cellHtml ="<b>"+ sglsupzk.toFixed(2)+"</b>";
		}
		if (e.field == "cqmle") {
			e.cellHtml ="<b>"+ cqmle.toFixed(2) +"</b>";
		}
		if (e.field == "qft") {
			e.cellHtml = "<b>"+ qft.toFixed(2) +"</b>";
		}
		if (e.field == "xssr") {
			e.cellHtml = "<b>"+ xssr.toFixed(2) +"</b>";
		}
		if (e.field == "qxssr") {
			e.cellHtml = "<b>"+ qxssr.toFixed(2) +"</b>";
		}
		if (e.field == "xscb") {
			e.cellHtml = "<b>"+ xscb.toFixed(2) +"</b>";
		}
		if (e.field == "fqje") {
			e.cellHtml = "<b>"+ fqje.toFixed(2) +"</b>";
		}
		if (e.field == "sqje") {
			e.cellHtml = "<b>"+ sqje.toFixed(2) +"</b>";
		}
		
		
		e.cellStyle = "text-align:right";
	}
  </script>

  <script src="report.js" type="text/javascript"></script>
  
</body>
</html>