<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>合同到期查询</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1"
		style="margin-bottom: 10px"></div>
	<div class="ocm-formheader" config="formheader1"
		style="margin-top: 5px;"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/commonfunc.js"
		type="text/javascript"></script>
	<script type="text/javascript">
		//字典数据初始化
		var moduleid = '200210'
		
		// 字典数据初始化
		var dicData = OcmControl.getDict("CONTTYPE,CONTSTATUS,WMID","code,name,ddvalue") || {};


		var isstatus = [ {
			code : "Y",
			name : "即将过期"
		}, {
			code : "N",
			name : "已过期"
		} ];
		var cnwmid = [ {
			code : "5",
			name : "租赁"
		}, {
			code : "4",
			name : "联营"
		} ];

		//初始默认即将过期状态，日期为当前日期往后退三个月
		var date = new Date();
		date.setMonth(date.getMonth() + 3);
		var day = parseInt((date - new Date()) / (1000 * 60 * 60 * 24))

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "查询条件",
				"type" : "fieldset",
				"items" : [ {
					"label" : "开始日期：",
					"type" : "DatePicker",
					"name" : "sdate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"visible" : false,
				}, {
					"label" : "结束日期：",
					"type" : "DatePicker",
					"name" : "edate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"visible" : false,
				}, {
					"label" : "门店：",
					"name" : "muid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					"required" : true,
					selectkey : "muid",//弹框类型
					textName : "muid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_muid",
					"enabled" : true,
					"style" : "width:22%"
				}, {
					"label" : "状态：",
					"type" : "ComboBox",
					"name" : "isstatus",
					"enabled" : true,
					"required" : true,
					"data" : isstatus,
					"value" : 'Y',
					"onvaluechanged" : "onisstatusChanged",
					"style" : "width:22%"
				}, {
					"label" : "当前日期：",
					"type" : "DatePicker",
					"name" : "today",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"visible" : false,
					"style" : "width:22%"
				}, {
					"label" : "过期日期：",
					"type" : "DatePicker",
					"name" : "expireddate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(date, "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(date, "yyyy-MM-dd"),
					"onvaluechanged" : "onExpiredChanged",
					"style" : "width:22%"
				}, {
					"label" : "到期天数 ：",
					"type" : "TextBox",
					"name" : "days",
					"value" : day,
					"enabled" : true,
					"required" : true,
					"onvaluechanged" : "onDaysChanged",
					"style" : "width:22%"
				},{
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : cnwmid,
					"style" : "width:22%"
				} ]
			} ]
		};

		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_200210",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"allowSortColumn" : false,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "muid_name",
					header : "门店",
					headerAlign : "center",
					width : 150,
				}, {
					field : "contno",
					header : "合同",
					headerAlign : "center",
					width : 100,
				}, {
					field : "wmid",
					header : "经营方式",
					headerAlign : "center",
					editor : OcmControl.newControl('ComboBox'),
					textField:"name",
	        	    valueField:"code" , 
	        	    renderer: "OcmControl.dictRendererWithCode",
					data: dicData.WMID,
					width : 100,
				}, {
					field : "sbid_name",
					header : "商户",
					headerAlign : "center",
					width : 220,
				}, {
					field : "contstatus",
					header : "合同状态",
					headerAlign : "center",
					editor : OcmControl.newControl('ComboBox'),
					textField:"name",
	        	    valueField:"code" , 
	        	    renderer: "OcmControl.dictRendererWithCode",
					data: dicData.CONTSTATUS,
					width : 100,
				}, {
					field : "conttype",
					header : "合同类型",
					headerAlign : "center",
					editor : OcmControl.newControl('ComboBox'),
					textField:"name",
	        	    valueField:"code" , 
	        	    renderer: "OcmControl.dictRendererWithCode",
					data: dicData.CONTTYPE,
					width : 100,
				}, {
					field : "cmeffdate",
					header : "生效日期",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align : "center",
					width : 100,
				}, {
					field : "cmlapdate",
					header : "失效日期",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align : "center",
					width : 100,
				}, {
					field : "ppcode_name",
					header : "品牌",
					headerAlign : "center",
					width : 150,
				}, {
					field : "mid_name",
					header : "经营种类",
					headerAlign : "center",
					width : 150,
				}, {
					field : "cmtitle",
					header : "合同主体",
					headerAlign : "center",
					width : 200,
				},{
					field : "days",
					header : "到期天数",
					headerAlign : "center",
					width : 250,
				} , {
					field : "memo",
					header : "备注",
					headerAlign : "center",
					width : 250,
				}]
			},
		};
		mini.parse();
		function head_beforefunc(e) {
			var colname = e.sender.name;
			if (!e.searchParam) {
				e.searchParam = {};
			}
			if (e.value != "undefined" && e.value != "") {
				e.searchParam.ctcode = e.value;
			}
		}

		function head_itemchanged_muid(e, data) {
			return 0;
		}
		
		function onisstatusChanged(e) {
			var value = e.value;
			var date = new Date();
			if (value == "Y"){
				date.setMonth(date.getMonth() + 3);
				mini.getbyName("expireddate").setValue(mini.formatDate(date, "yyyy-MM-dd"));
				var nowDay = parseInt((date - new Date()) / (1000 * 60 * 60 * 24))
				mini.getbyName("days").setValue(nowDay);
			} else {
				date.setMonth(date.getMonth() - 3);
				mini.getbyName("expireddate").setValue(mini.formatDate(date, "yyyy-MM-dd"));
				var nowDay = parseInt((date - new Date()) / (1000 * 60 * 60 * 24))
				mini.getbyName("days").setValue(nowDay);
				
			};
		}
		
		function onExpiredChanged(e){
			var value = e.value;
			var date = new Date();
			var nowDay = parseInt((value - date) / (1000 * 60 * 60 * 24))
			mini.getbyName("days").setValue(nowDay);
			
		}
		
		function onDaysChanged(e){
			var value = parseInt(e.value);
			var nowdate = new Date();
			nowdate.setDate(nowdate.getDate() + value);
			mini.getbyName("expireddate").setValue(nowdate);
		}
		
		//日期计算
	     function addDate(date,days){ 
	         var d=new Date(date); 
	         d.setDate(d.getDate()+days); 
	         var m=d.getMonth()+1; 
	         return d.getFullYear()+'-'+m+'-'+d.getDate(); 
	       } 

		function onDrawSummaryCell(e) {
			
		}
	</script>

	<script src="report.js" type="text/javascript"></script>

</body>
</html>