<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>客单价报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500923";
 
 var cnwmid = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];
 var tempflag = [ {  code : "2",  name : "会员客单价"}, {  code : "3",  name : "非会员客单价"}, {  code : "1",  name : "客单价"} ];
  var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    } ] ]
		  };


		var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [ {
			       	 "label" : "记账开始日期：",
			         "type" : "DatePicker",
			         "name" : "jzsdate",
			         "format" : "yyyy-MM-dd",
			         "required" : "true",
			         "enabled" : true,
			         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "style" : "width:30%"
			      }, {
			         "label" : "记账结束日期：",
			         "type" : "DatePicker",
			         "name" : "jzedate",
			         "format" : "yyyy-MM-dd",
			         "required" : "true",
			         "enabled" : true,
			         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "style" : "width:30%"
			      },{
						"label" : "销售门店：",
						"type" : "ButtonEdit",
						"name" : "scdmkt",
						"enabled" : true,
						"onbuttonclick" : "onMktidClick",
						"onValuechanged" : "onMktidChange",
						"style" : "width:30%"
					},{
			    	  "label" : "发生开始日期：",
			          "type" : "DatePicker",
			          "name" : "fssdate",
			          "format" : "yyyy-MM-dd",
			          //"required" : "true",
			          "enabled" : true,
			          "style" : "width:30%",
			        	  "visible":false,
			       }, {
			          "label" : "发生结束日期：",
			          "type" : "DatePicker",
			          "name" : "fsedate",
			          "format" : "yyyy-MM-dd",
			          //"required" : "true",
			          "enabled" : true,
			          "style" : "width:30%",
			    	  "visible":false,
			       },  {
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : cnwmid,
					"style" : "width:30%"
				}]
			};


		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_500923",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "scdmkt",
						header : "销售门店",
						headerAlign : "center",
						allowSort : false,
						width : 160,
					},{
						field : "tempflag",       
						header : "状态",
						allowSort : false,
						headerAlign : "center",
						renderer: "OcmControl.dictRendererWithCode",
					    data: tempflag,
						width : 150,
					},{
						header : "客单价（元）",
						allowSort : false,
						headerAlign : "center",
						"columns" : [ {
							field : "dj",
							header : "本期",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
						}, {
							field : "odj",
							header : "同期",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
						}, {
							field : "tdj",
							header : "同比±%",
							headerAlign : "center",
							align : "right",
							allowSort : false,
							renderer:"OnTbvalue",
						}, {
							field : "edj",
							header : "同比±额",
							allowSort : false,
							headerAlign : "center",
							dataType : "float",
							align : "right",
							width : 100,
						} ]
					},{
						header : "连单率",
						allowSort : false,
						headerAlign : "center",
						"columns" : [ {
							field : "ldl",
							header : "本期",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							numberFormat : "p2",
							align : "right",
						}, {
							field : "oldl",
							header : "同期",
							headerAlign : "center",
							width : 100,
							numberFormat : "p2",
							align : "right",
						}, {
							field : "tldl",
							header : "同比±%",
							headerAlign : "center",
							align : "right",
							allowSort : false,
							renderer:"OnTbvalue",
						}, {
							field : "eldl",
							header : "同比±额",
							allowSort : false,
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							width : 100,
						}]
					}]
				},
			};
			mini.parse();
			
			function onDrawSummaryCell(e) {
			 	var rows = e.data;
				var xssr = 0;
				var oldxssr = 0; 
				var delxssr = 0;
				var list = [];
		
				if (rows.length > 0) {
					var flag = false;
					for (var i = 0; i < rows.length; i++) {
						flag = false;
						var para= {};
						if (rows[i].tempflag == "1") {
							para.key = "客单价";
						} else if (rows[i].tempflag == "2") {
							para.key = "会员客单价";
						} else {
							para.key = "非会员客单价";
						}
						para.dj = rows[i].dj;
						para.odj =rows[i].odj;
						para.ldl = rows[i].ldl;
						para.oldl =rows[i].oldl;
						for(var j=0;j<list.length; j++) {
							if (list[j].key == para.key) {
								list[j].dj =  accAdd(list[j].dj,para.dj);
								list[j].odj = accAdd(list[j].odj,para.odj);
								list[j].ldl = accAdd(list[j].ldl,para.ldl);
								list[j].oldl = accAdd(list[j].oldl,para.oldl);
								flag = true;
								break;
							}
						}
						if (!flag) {
							if (!flag) {
								list.push(para);
							}
						}
					}
				}

				if (e.field == "scdmkt") {
					var str="";
					str = str + "<b>" + "合计: " + "</b>";
					e.cellHtml = str;
				}
				if (e.field == "tempflag") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var key = list[i].key;
						str=str + "<b>"+key+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "dj") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempdj = list[i].dj;
						str=str + "<b>"+tempdj+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "odj") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempodj = list[i].odj;
						str=str + "<b>"+tempodj+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "edj") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempedj = accSub(list[i].dj ,list[i].odj);
						str=str + "<b>"+tempedj+"</b><br>";
					}
					e.cellHtml = str;
				}
				
				if (e.field == "tdj") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var temptdj = accDiv(accSub(list[i].dj ,list[i].odj),list[i].dj);
						temptdj = accMul(temptdj,100) ;
						str=str + "<b>"+temptdj.toFixed(2)+"%</b><br>";
					}
					e.cellHtml = str;
				}
				
				if (e.field == "ldl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var templdl = list[i].ldl;
						
						str=str + "<b>"+Number(templdl).toFixed(4)+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "oldl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempoldl = list[i].oldl;
						str=str + "<b>"+Number(tempoldl).toFixed(4)+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "eldl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempeldl = accSub(list[i].ldl ,list[i].oldl);
						str=str + "<b>"+Number(tempeldl).toFixed(4)+"</b><br>";
					}
					e.cellHtml = str;
				}
				
				if (e.field == "tldl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var temptldl = accDiv(accSub(list[i].ldl ,list[i].oldl),list[i].ldl);
						temptldl = accMul(temptldl,100) ;
						str = str + "<b>" + temptldl.toFixed(2) + "%</b><br>";
					}
					e.cellHtml = str;
				}
				
				e.cellStyle = "text-align:right";  
			}
			// 浮点型相加
			function accAdd(arg1, arg2) {
				var r1, r2, m;
				try {
					r1 = arg1.toString().split(".")[1].length;
				} catch (e) {
					r1 = 0;
				}
				;
				try {
					r2 = arg2.toString().split(".")[1].length;
				} catch (e) {
					r2 = 0;
				}
				;
				m = Math.pow(10, Math.max(r1, r2));
				return (arg1 * m + arg2 * m) / m;
			};
			// 浮点型相除
			function accDiv(arg1, arg2) {
				var t1 = 0, t2 = 0, r1, r2;
				try {
					t1 = arg1.toString().split(".")[1].length
				} catch (e) {
				}
				try {
					t2 = arg2.toString().split(".")[1].length
				} catch (e) {
					}
				with (Math) {
				r1 = Number(arg1.toString().replace(".", ""))
				r2 = Number(arg2.toString().replace(".", ""))
				return (r1 / r2) * pow(10, t2 - t1);
				}
			}
			// 浮点型相乘
			function accMul(arg1, arg2) {
				var m = 0, s1 = arg1.toString(), s2 = arg2.toString();
				try {
					m += s1.split(".")[1].length
				} catch (e) {
				}
				try {
					m += s2.split(".")[1].length
				} catch (e) {
				}
				return Number(s1.replace(".", "")) * Number(s2.replace(".", ""))
						/ Math.pow(10, m)
			}
			
			// 浮点型相减
			function accSub(arg1, arg2) {
				var r1, r2, m, n;
				try {
					r1 = arg1.toString().split(".")[1].length;
				} catch (e) {
					r1 = 0;
				}
				;
				try {
					r2 = arg2.toString().split(".")[1].length;
				} catch (e) {
					r2 = 0;
				}
				;
				m = Math.pow(10, Math.max(r1, r2));
				n = (r1 >= r2) ? r1 : r2;
				return ((arg1 * m - arg2 * m) / m).toFixed(n);
			};
		</script>

  <script src="report.js" type="text/javascript"></script>
</body>
</html>