<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>交易笔数报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500924";
 
 var cnwmid = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];
 var tempflag = [ {  code : "2",  name : "会员交易笔数"}, {  code : "3",  name : "非会员交易笔数"}, {  code : "1",  name : "交易笔数"} ];
  var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    } ] ]
		  };


		var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [ {
			       	 "label" : "记账开始日期：",
			         "type" : "DatePicker",
			         "name" : "jzsdate",
			         "format" : "yyyy-MM-dd",
			         "required" : "true",
			         "enabled" : true,
			         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "style" : "width:30%"
			      }, {
			         "label" : "记账结束日期：",
			         "type" : "DatePicker",
			         "name" : "jzedate",
			         "format" : "yyyy-MM-dd",
			         "required" : "true",
			         "enabled" : true,
			         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "style" : "width:30%"
			      },{
						"label" : "销售门店：",
						"type" : "ButtonEdit",
						"name" : "scdmkt",
						"enabled" : true,
						"onbuttonclick" : "onMktidClick",
						"onValuechanged" : "onMktidChange",
						"style" : "width:30%"
					},{
			    	  "label" : "发生开始日期：",
			          "type" : "DatePicker",
			          "name" : "fssdate",
			          "format" : "yyyy-MM-dd",
			          //"required" : "true",
			          "enabled" : true,
			          "style" : "width:30%",
			    	  "visible":false,
			       }, {
			          "label" : "发生结束日期：",
			          "type" : "DatePicker",
			          "name" : "fsedate",
			          "format" : "yyyy-MM-dd",
			          //"required" : "true",
			          "enabled" : true,
			          "style" : "width:30%",
			    	  "visible":false,
			       },  {
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : cnwmid,
					"style" : "width:30%"
				}]
			};


		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_500924",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "scdmkt",
						header : "销售门店",
						headerAlign : "center",
						allowSort : false,
						width : 160,
					},{
						field : "tempflag",       
						header : "状态",
						allowSort : false,
						headerAlign : "center",
						renderer: "OcmControl.dictRendererWithCode",
					    data: tempflag,
						width : 150,
					},{
						header : "交易笔数（次）",
						allowSort : false,
						headerAlign : "center",
						"columns" : [ {
							field : "jl",
							header : "本期",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "int",
							align : "right",
						}, {
							field : "ojl",
							header : "同期",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "int",
							align : "right",
						}, {
							field : "tjl",
							header : "同比±%",
							headerAlign : "center",
							align : "right",
							allowSort : false,
							renderer:"OnTbvalue",
						}, {
							field : "ejl",
							header : "同比±额",
							allowSort : false,
							headerAlign : "center",
							dataType : "int",
							align : "right",
							width : 100,
						} ]
					},{
						header : "结构情况（%）",
						allowSort : false,
						headerAlign : "center",
						"columns" : [ {
							field : "sjl",
							header : "本期",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							numberFormat : "p2",
							align : "right",
						}, {
							field : "osjl",
							header : "同期",
							headerAlign : "center",
							width : 100,
							numberFormat : "p2",
							align : "right",
						}, {
							field : "tsjl",
							header : "同比±%",
							headerAlign : "center",
							align : "right",
							allowSort : false,
							renderer:"OnTbvalue",
						}]
					}]
				},
			};
			mini.parse();
			
			function onDrawSummaryCell(e) {
			 	var rows = e.data;
				var sumjl = 0; 
				var sumojl = 0;
				var list = [];
				
		
				if (rows.length > 0) {
					var flag = false;
					for (var i = 0; i < rows.length; i++) {
						flag = false;
						var para= {};
						if (rows[i].tempflag == "1") {
							para.key = "交易笔数";
						} else if (rows[i].tempflag == "2") {
							para.key = "会员交易笔数";
						} else {
							para.key = "非会员交易笔数";
						}
						sumjl =accAdd(sumjl,rows[i].jl);
						sumojl =accAdd(sumojl,rows[i].ojl);
						para.jl = rows[i].jl;
						para.ojl =rows[i].ojl;
						para.ejl =rows[i].ejl;
						for(var j=0;j<list.length; j++) {
							if (list[j].key == para.key) {
								list[j].jl =  accAdd(list[j].jl,para.jl);
								list[j].ojl = accAdd(list[j].ojl,para.ojl);
								list[j].ejl = accAdd(list[j].ejl,para.ejl);
								flag = true;
								break;
							}
						}
						if (!flag) {
							if (!flag) {
								list.push(para);
							}
						}
					}
				}

				sumjl = accDiv(sumjl,2);
				sumojl = accDiv(sumojl,2);
				if (e.field == "scdmkt") {
					var str="";
					str = str + "<b>" + "合计: " + "</b>";
					e.cellHtml = str;
				}
				if (e.field == "tempflag") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var key = list[i].key;
						str=str + "<b>"+key+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "jl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempjl = list[i].jl;
						str=str + "<b>"+tempjl+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "ojl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempojl = list[i].ojl;
						str=str + "<b>"+tempojl+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "ejl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempejl = accSub(list[i].ejl ,list[i].ejl);
						str=str + "<b>"+tempejl+"</b><br>";
					}
					e.cellHtml = str;
				}
				
				if (e.field == "tjl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var temptjl = accDiv(accSub(list[i].jl ,list[i].ojl),list[i].jl);
						temptjl = accMul(temptjl,100) ;
						str=str + "<b>"+temptjl.toFixed(2)+"%</b><br>";
					}
					e.cellHtml = str;
				}
				
				if (e.field == "sjl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempsjl = accDiv(list[i].jl, sumjl);
						tempsjl = accMul(tempsjl,100) ;
						str=str + "<b>"+tempsjl.toFixed(2)+"%</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "osjl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var temposjl = accDiv(list[i].osjl, sumojl);
						str=str + "<b>"+temposjl.toFixed(2)+"%</b><br>";
					}
					e.cellHtml = str;
				}
				
				if (e.field == "tsjl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempsjl = accDiv(list[i].jl, sumjl);
						var temposjl = accDiv(list[i].osjl, sumojl);
						var temptsjl = accDiv(accSub(tempsjl ,temposjl),tempsjl);
						temptsjl = accMul(temptsjl,100) ;
						str = str + "<b>" + temptsjl.toFixed(2) + "%</b><br>";
					}
					e.cellHtml = str;
				}
				
				e.cellStyle = "text-align:right";  
			}
			// 浮点型相加
			function accAdd(arg1, arg2) {
				var r1, r2, m;
				try {
					r1 = arg1.toString().split(".")[1].length;
				} catch (e) {
					r1 = 0;
				}
				;
				try {
					r2 = arg2.toString().split(".")[1].length;
				} catch (e) {
					r2 = 0;
				}
				;
				m = Math.pow(10, Math.max(r1, r2));
				return (arg1 * m + arg2 * m) / m;
			};
			// 浮点型相除
			function accDiv(arg1, arg2) {
				if (Number(arg2) == 0) return 0;
				var t1 = 0, t2 = 0, r1, r2;
				try {
					t1 = arg1.toString().split(".")[1].length
				} catch (e) {
				}
				try {
					t2 = arg2.toString().split(".")[1].length
				} catch (e) {
					}
				with (Math) {
				r1 = Number(arg1.toString().replace(".", ""))
				r2 = Number(arg2.toString().replace(".", ""))
				return (r1 / r2) * pow(10, t2 - t1);
				}
			}
			// 浮点型相乘
			function accMul(arg1, arg2) {
				var m = 0, s1 = arg1.toString(), s2 = arg2.toString();
				try {
					m += s1.split(".")[1].length
				} catch (e) {
				}
				try {
					m += s2.split(".")[1].length
				} catch (e) {
				}
				return Number(s1.replace(".", "")) * Number(s2.replace(".", ""))
						/ Math.pow(10, m)
			}
			
			// 浮点型相减
			function accSub(arg1, arg2) {
				var r1, r2, m, n;
				try {
					r1 = arg1.toString().split(".")[1].length;
				} catch (e) {
					r1 = 0;
				}
				;
				try {
					r2 = arg2.toString().split(".")[1].length;
				} catch (e) {
					r2 = 0;
				}
				;
				m = Math.pow(10, Math.max(r1, r2));
				n = (r1 >= r2) ? r1 : r2;
				return ((arg1 * m - arg2 * m) / m).toFixed(n);
			};
		</script>

  <script src="report.js" type="text/javascript"></script>
</body>
</html>