<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>租金销售月坪效报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500927";
 
  var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    },{
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			}] ]
		  };


		var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [  {
					  "label" : "租金起始月份：",
			          "name" : "zjsmonth",
			          "type" : "MonthPicker",
						"format" : "yyyy-MM",
						"enabled" : true,
						"required" : true,
						"value" : mini.formatDate(new Date(), "yyyy-MM"),
						"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
			         "style" : "width:30%"
				},{
					  "label" : "租金结束月份：",
			          "name" : "zjemonth",
			          "type" : "MonthPicker",
						"format" : "yyyy-MM",
						"enabled" : true,
						"required" : true,
						"value" : mini.formatDate(new Date(), "yyyy-MM"),
						"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
			         "style" : "width:30%"
				},{
					"label" : "品牌：",
					"type" : "ButtonEdit",
					"name" : "ppcode",
					"enabled" : true,
					"onbuttonclick" : "onPpcodeClick",
					"onValuechanged" : "onPpcodeChange",
					"style" : "width:30%"
				},{
					"label" : "合同号：",
					"type" : "TextBox",
					"name" : "contno",
					"enabled" : true,
					"style" : "width:30%"
				},{
					"label" : "商户：",
					"type" : "ButtonEdit",
					"name" : "sbid",
					"enabled" : true,
					"onbuttonclick" : "onSupcodeClick",
					"onValuechanged" : "onSupcodeChange",
					"style" : "width:30%"
				},{
					"label" : "铺位号：",
					"name" : "spid",
					"type" : "ButtonEdit",
					"readOnly" : false,
					visible : false,
					"enabled": "true",
					"onbuttonclick" : "onShoplistClick",
					"onvaluechanged":"onShoplistChanged",
				}]
			};
		
		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_500927",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [{
							type : "indexcolumn",
							header : "序号",
							headerAlign : "center",
						},  {
							field : "ppcode",
							header : "品牌名称",
							headerAlign : "center",
							allowSort : false,
							width : 160,
						},{
							field : "contno",
							header : "合同号",
							headerAlign : "center",
							allowSort : false,
							width : 160,
						},{
							field : "sbid",
							header : "商户",
							headerAlign : "center",
							allowSort : false,
							width : 160,
						},{
							field : "spid",
							header : "铺位号",
							headerAlign : "center",
							allowSort : false,
							width : 160,
						}, {
							field : "mj",
							header : "合同面积",
							headerAlign : "center",
							align : "right",
							allowSort : false,
							width : 160,
						},{
							field : "firstyt",
							header : "一级业态",
							headerAlign : "center",
							allowSort : false,
							width : 160,
						},{
							field : "secondyt",
							header : "二级业态",
							headerAlign : "center",
							allowSort : false,
							width : 160,
						},{
						field : "zj",
						header : "月租金",
						headerAlign : "center",
						numberFormat : "#,0.00",
						align : "right",
						allowSort : false,
						width : 160,
					},{
						field : "wgf",
						header : "月物管费",
						headerAlign : "center",
						numberFormat : "#,0.00",
						align : "right",
						allowSort : false,
						width : 160,
					},{
						field : "zjhj",
						header : "月租费合计",
						headerAlign : "center",
						numberFormat : "#,0.00",
						align : "right",
						allowSort : false,
						width : 160,
					},{
						field : "xshj",
						header : "月销售合计",
						headerAlign : "center",
						numberFormat : "#,0.00",
						align : "right",
						allowSort : false,
						width : 160,
					},{
						field : "xspx",
						header : "月销售坪效",
						headerAlign : "center",
						align : "right",
						allowSort : false,
						width : 160,
					},{
						field : "zjpx",
						header : "租金坪效",
						headerAlign : "center",
						align : "right",
						allowSort : false,
						width : 160,
					},{
						field : "zfpx",
						header : "租费坪效",
						headerAlign : "center",
						align : "right",
						allowSort : false,
						width : 160,
					},{
						field : "zsb",
						header : "租售比",
						headerAlign : "center",
						numberFormat : "0.00%",
						align : "right",
						allowSort : false,
						width : 160,
					}]
				}
			};
			mini.parse();
			
			function onDrawSummaryCell(e) {
			 	var rows = e.data;
			 	var summj = 0;
			 	var sumzj = 0;
			 	var sumwgf = 0;
			 	var sumzjhj = 0;
			 	var sumxshj = 0;
				var list = [];
				
		
				if (rows.length > 0) {
					var flag = false;
					for (var i = 0; i < rows.length; i++) {
						flag = false;
						var para= {};
						summj =accAdd(summj,rows[i].mj);
						sumzj =accAdd(sumzj,rows[i].zj);
						sumwgf =accAdd(sumwgf,rows[i].wgf);
						sumzjhj =accAdd(sumzjhj,rows[i].zjhj);
						sumxshj =accAdd(sumxshj,rows[i].xshj);
						para.mj = rows[i].mj;
						para.zj = rows[i].zj;
						para.wgf = rows[i].wgf;
						para.zjhj = rows[i].zjhj;
						para.xshj = rows[i].xshj;
						for(var j=0;j<list.length; j++) {
							if (list[j].key == para.key) {
								list[j].mj =  accAdd(list[j].mj,para.mj);
								list[j].zj =  accAdd(list[j].zj,para.zj);
								list[j].wgf =  accAdd(list[j].wgf,para.wgf);
								list[j].zjhj =  accAdd(list[j].zjhj,para.zjhj);
								list[j].xshj =  accAdd(list[j].xshj,para.xshj);
								flag = true;
								break;
							}
						}
						if (!flag) {
							if (!flag) {
								list.push(para);
							}
						}
					}
				}

				if (e.field == "spid") {
					var str="";
					str = str + "<b>" + "售卖类合计: " + "</b>";
					e.cellHtml = str;
				}
				if (e.field == "mj") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempmj = list[i].mj;
						str=str + "<b>"+tempmj+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "zj") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempzj = list[i].zj;
						str=str + "<b>"+tempzj+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "wgf") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempwgf = list[i].wgf;
						str=str + "<b>"+tempwgf+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "zjhj") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempzjhj = list[i].zjhj;
						str=str + "<b>"+tempzjhj+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "xshj") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempxshj = list[i].xshj;
						str=str + "<b>"+tempxshj+"</b><br>";
					}
					e.cellHtml = str;
				}if (e.field == "zjpx") {
					var str="";
					var tempzjpx = 0;
					for (var i=0;i<list.length; i++) {
						var tempzjhj = list[i].zjhj;
						var tempmj = list[i].mj;
						if(tempmj == 0){
							str=str + "<b>"+"--"+"</b><br>";
						}else{
							tempzjpx = (tempzjhj/tempmj).toFixed(2);
							str=str + "<b>"+tempzjpx+"</b><br>";
						}
					}
					e.cellHtml = str;
				}
				if (e.field == "xspx") {
					var str="";
					var tempxspx = 0;
					for (var i=0;i<list.length; i++) {
						var tempxshj = list[i].xshj;
						var tempmj = list[i].mj;
						if(tempmj == 0){
							str=str + "<b>"+"--"+"</b><br>";
						}else{
							tempxspx = (tempxshj/tempmj).toFixed(2);
							str=str + "<b>"+tempxspx+"</b><br>";
						}
					}
					e.cellHtml = str;
				}
				if (e.field == "zfpx") {
					var str="";
					var tempzfpx = 0;
					for (var i=0;i<list.length; i++) {
						var tempzjhj = list[i].zjhj;
						var tempmj = list[i].mj;
						if(tempmj == 0){
							str=str + "<b>"+tempzfpx+"</b><br>";
						}else{
							tempzfpx = (tempzjhj/tempmj).toFixed(2);
							str=str + "<b>"+tempzfpx+"</b><br>";
						}
					}
					e.cellHtml = str;
				}
				if (e.field == "zsb") {
					var str="";
					var tempzsb = 0;
					for (var i=0;i<list.length; i++) {
						var tempzjhj = list[i].zjhj;
						var tempxshj = list[i].xshj;
						if(tempxshj == 0){
							str=str + "<b>"+tempzsb+"</b><br>";
						}else{
							tempzsb = (tempzjhj/tempxshj).toFixed(2);
							str=str + "<b>"+tempzsb+"</b><br>";
						}
					}
					e.cellHtml = str;
				}
				
				e.cellStyle = "text-align:right";  
			}
			// 浮点型相加
			function accAdd(arg1, arg2) {
				var r1, r2, m;
				try {
					r1 = arg1.toString().split(".")[1].length;
				} catch (e) {
					r1 = 0;
				}
				try {
					r2 = arg2.toString().split(".")[1].length;
				} catch (e) {
					r2 = 0;
				}
				m = Math.pow(10, Math.max(r1, r2));
				return ((arg1 * m + arg2 * m) / m).toFixed(2);
			};
		</script>

  <script src="report.js" type="text/javascript"></script>
</body>
</html>