<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>费用到期预警报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1"
		style="margin-bottom: 10px"></div>

	<div class="ocm-formheader" config="formheader1"></div>

	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid = "500928";

		var conttype = [ {
			code : "01",
			name : "正柜"
		}, {
			code : "02",
			name : "特卖"
		}, {
			code : "A",
			name : "其他"
		}, {
			code : "03",
			name : "批发"
		} ];
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [{
				"label" : "预警天数：",
				"type" : "TextBox",
				"name" : "days",
				"enabled" : true,
				"required" : true,
				"value" : 10,
				"style" : "width:30%"
			}, {
				"label" : "结算月：",
				"type" : "MonthPicker",
				"name" : "sdate",
				"format" : "yyyy-MM",
				"enabled" : true,
				/* "required" : true, */
				/* "value" : mini.formatDate(new Date(), "yyyy-MM"), */
				/* "defaultValue" : mini.formatDate(new Date(), "yyyy-MM"), */
				"style" : "width:30%"
			}, {
				"label" : "——  ：",
				"type" : "MonthPicker",
				"name" : "edate",
				"format" : "yyyy-MM",
				"enabled" : true,
				/* "required" : true, */
				/* "value" : mini.formatDate(new Date(), "yyyy-MM"), */
				/* "defaultValue" : mini.formatDate(new Date(), "yyyy-MM"), */
				"style" : "width:30%"
			}, /* {
				"label" : "合同号：",
				"type" : "TextBox",
				"name" : "contno",
				"enabled" : true,
				"style" : "width:30%"
			}, */ {
				"label" : "门店：",
				"name" : "muid",
				"type" : "ButtonEdit",
				"enabled" : true,
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey : "muid",
				textName : "muid_name",
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_muid",
			}, {
				"label" : "商户：",
				"name" : "sbid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				"enabled" : true,
				type : "fut_popselect",
				selectkey : "sbid",
				textName : "sbid_name",
				beforefunc : "head_beforefunc",
			},{
				"label" : "合同：",
				"type" : "ButtonEdit",
				"name" : "contno",
				"enabled" : true,
				displayField : "contno",
				type : "fut_popselect",
				selectkey : "contno",
				textName : "contno",
				responseName : "contno",
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged_contno",
			}, {
				"label" : "合同类型：",
				"type" : "ComboBox",
				"name" : "conttype",
				"enabled" : true,
				"data" : conttype,
				"style" : "width:30%"
			}, {
				"label" : "费用项目：",
				"name" : "cccode",
				"enabled" : true,
				"type" : "fut_popselect",
				"selectkey":"cccode",
				"textName" :"cctcode_name",	 
			} ]
		};

		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mall,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_500928",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "jkr",
					header : "缴款日",
					allowSort : false,
					headerAlign : "center",
					width : 100,
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
				}, {
					field : "muid",
					header : "门店",
					allowSort : false,
					headerAlign : "center",
					width : 160,
				}, {
					field : "conttype",
					header : "合同类型",
					allowSort : false,
					headerAlign : "center",
					width : 100,
				}, {
					field : "sbid",
					header : "商户",
					allowSort : false,
					headerAlign : "center",
					width : 160,
				}, {
					field : "sbdz",
					header : "店招",
					allowSort : false,
					headerAlign : "center",
					width : 100,
				}, {
					field : "contno",
					header : "合同号",
					allowSort : false,
					headerAlign : "center",
					width : 100,
				}, {
					field : "cccode",
					header : "费用项目",
					allowSort : false,
					headerAlign : "center",
					width : 100,
				}, {
					field : "spid",
					header : "商铺",
					allowSort : false,
					headerAlign : "center",
					width : 100,
				}, {
					field : "feesdate",
					header : "费用开始日期",
					allowSort : false,
					headerAlign : "center",
					width : 100,
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
				}, {
					field : "feeedate",
					header : "费用结束日期",
					allowSort : false,
					headerAlign : "center",
					width : 100,
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
				}, {
					field : "accmon",
					header : "结算月",
					allowSort : false,
					headerAlign : "center",
					width : 100,
				}, {
					field : "ysbalance",
					header : "金额",
					allowSort : false,
					headerAlign : "center",
					align : "right",
					visible : true,
					vtype : "double",
					numberFormat : "#,##0.00",
					width : 100,
				} ]
			},
		};
		mini.parse();

		var muid = mini.getbyName("muid");
		var sbid = mini.getbyName("sbid");
		var contno = mini.getbyName("contno");
		//弹框条件过滤
		function head_beforefunc(e, data) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;

			if (e.value != "undefined" && e.value != "") {
				e.searchParam.code = e.value;
			}
			//过滤商户
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					return 0;
				}
				e.searchParam.wherestr = " sbid in (select sbid from supmkt where muid ='"
						+ muid.getValue() + "')";
			}
			//过滤合同
			if (buttonEdit.name == "contno") {
				if (muid.getValue() == "") {
					return 0;
				}
				e.searchParam.wherestr = "muid ='" + muid.getValue()  + "'";
				if (sbid.getValue() != undefined && sbid.getValue() != "") {
					e.searchParam.wherestr += "and sbid ='" + sbid.getValue() + "'";
				}
			}
			return 0;
		}
		
		function head_itemchanged_contno(e,data){
			mini.getbyName("sbid").setValue(data[0].sbid);
			mini.getbyName("sbid").setText(data[0].sbid_name);
			return 0;
		}
		function head_itemchanged_muid(e,data){
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("contno").setValue("");
			mini.getbyName("contno").setText("");
			return 0;
		}
		
	</script>

	<script src="report.js" type="text/javascript"></script>
</body>
</html>