<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>租金销售日坪效报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1"
		style="margin-bottom: 10px"></div>

	<div class="ocm-formheader" config="formheader1"></div>

	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	<script type="text/javascript">
		//字典数据初始化
		var moduleid = "500929";
		var SBIDJYSTATUS = [{code:"Y",name:"健康"},{code:"N",name:"不健康"}];
		var CONTNOSTATUS = [{code:"Y",name:"已到期"},{code:"J",name:"即将到期"},{code:"O",name:"有效期内"}];

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "租金月份：",
				"name" : "zjsmonth",
				"type" : "MonthPicker",
				"format" : "yyyy-MM",
				"enabled" : true,
				"required" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
				"style" : "width:30%"
			},{
				"label" : "门店：",
				"name" : "muid",
				"type" : "ButtonEdit",
				"enabled" : true,
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"muid",
				textName :"muid_name",
				beforefunc:"head_beforefunc",
			},{
				"label" : "门店：",
				"name" : "muid_name",
				"type" : "TextBox",
				"visible" : false,
			},{
	            "label" : "楼层：",
	            "type" : "ButtonEdit",
	            "name" : "lc",
	            "enabled" : true,
	            "onbuttonclick" : "onMktmanaframeClick",
	            "onValuechanged" : "onMktmanaframeChange",
	            "style" : "width:30%"
	         },{
				"label" : "合同号：",
				"type" : "TextBox",
				"name" : "contno",
				"enabled" : true,
				"style" : "width:30%"
			},{
				"label" : "商户：",
				"name" : "sbid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				"enabled" : true,
				type : "fut_popselect",
				selectkey : "sbid",
				textName : "sbid_name",
			},{
				"label" : "铺位号：",
				"name" : "spid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				"enabled" : true,
				type : "fut_popselect",//类型
				selectkey : "spid",//弹框类型
				textName : "spid_name", //文本显示字段
			} ]
		};

		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mall,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_500929",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "序号",
					headerAlign : "center",
				},{
					field : "muid",
					header : "门店",
					headerAlign : "center",
					allowSort : false,
					width : 160,
				},{
					field : "louc",
					header : "楼层",
					headerAlign : "center",
					allowSort : false,
					width : 160,
				},{
					field : "qy",
					header : "区域",
					headerAlign : "center",
					allowSort : false,
					width : 160,
				},{
					field : "spid",
					header : "铺位号",
					headerAlign : "center",
					allowSort : false,
					width : 160,
				}, {
					field : "sbid",
					header : "商户",
					headerAlign : "center",
					allowSort : false,
					width : 160,
				}, {
					field : "contno",
					header : "合同号",
					headerAlign : "center",
					allowSort : false,
					width : 160,
				}, {
					field : "yt",
					header : "业态",
					headerAlign : "center",
					allowSort : false,
					width : 160,
				}, {
					field : "mj",
					header : "合同面积",
					headerAlign : "center",
					align : "right",
					allowSort : false,
					width : 160,
				},{
					field : "ts",
					header : "天数",
					headerAlign : "center",
					align : "right",
					visible : false,
					allowSort : false,
					width : 160,
				}, {
					field : "xshj",
					header : "销售额",
					headerAlign : "center",
					numberFormat : "#,0.00",
					align : "right",
					allowSort : false,
					width : 160,
				}, {
					field : "tqxshj",
					header : "同期销售额",
					headerAlign : "center",
					numberFormat : "#,0.00",
					align : "right",
					allowSort : false,
					width : 160,
				}, {
					field : "mjpx",
					header : "面积坪效",
					headerAlign : "center",
					align : "right",
					allowSort : false,
					width : 160,
				}, {
					field : "zj",
					header : "月租金",
					headerAlign : "center",
					numberFormat : "#,0.00",
					align : "right",
					allowSort : false,
					width : 160,
				}, {
					field : "zsb",
					header : "租售比",
					headerAlign : "center",
					numberFormat : "0.00%",
					align : "right",
					allowSort : false,
					width : 160,
				}, {
					field : "sbidjystatus",
					header : "商户经营状态",
					headerAlign : "center",
					type : "comboboxcolumn",
					renderer : "OcmControl.dictRendererWithCode",
					valueField : "code",
					textField : "name",
					data : SBIDJYSTATUS,
					allowSort : false,
					width : 160,
				}, {
					field : "contnostatus",
					header : "合同执行情况",
					headerAlign : "center",
					type : "comboboxcolumn",
					renderer : "OcmControl.dictRendererWithCode",
					valueField : "code",
					textField : "name",
					data : CONTNOSTATUS,
					allowSort : false,
					width : 160,
				} ]
			}
		};
		mini.parse();

		function onDrawSummaryCell(e) {
			var rows = e.data;
			var summj = 0;
			var sumzj = 0;
			var sumxshj = 0;
			var sumtqxshj = 0;
			var list = [];
			var ts = 0;

			if (rows.length > 0) {
				var flag = false;
				ts = rows[0].ts;
				for (var i = 0; i < rows.length; i++) {
					flag = false;
					var para = {};
					summj = accAdd(summj, rows[i].mj);
					sumzj = accAdd(sumzj, rows[i].zj);
					sumxshj = accAdd(sumxshj, rows[i].xshj);
					sumtqxshj = accAdd(sumtqxshj, rows[i].tqxshj);
					para.mj = rows[i].mj;
					para.zj = rows[i].zj;
					para.xshj = rows[i].xshj;
					para.tqxshj = rows[i].tqxshj;
					for (var j = 0; j < list.length; j++) {
						if (list[j].key == para.key) {
							list[j].mj = accAdd(list[j].mj, para.mj);
							list[j].zj = accAdd(list[j].zj, para.zj);
							list[j].xshj = accAdd(list[j].xshj, para.xshj);
							list[j].tqxshj = accAdd(list[j].tqxshj, para.tqxshj);
							flag = true;
							break;
						}
					}
					if (!flag) {
						if (!flag) {
							list.push(para);
						}
					}
				}
			}

			if (e.field == "spid") {
				var str = "";
				str = str + "<b>" + "合计: " + "</b>";
				e.cellHtml = str;
			}
			if (e.field == "mj") {
				var str = "";
				for (var i = 0; i < list.length; i++) {
					var tempmj = list[i].mj;
					str = str + "<b>" + tempmj + "</b><br>";
				}
				e.cellHtml = str;
			}
			if (e.field == "zj") {
				var str = "";
				for (var i = 0; i < list.length; i++) {
					var tempzj = list[i].zj;
					str = str + "<b>" + tempzj + "</b><br>";
				}
				e.cellHtml = str;
			}
			if (e.field == "xshj") {
				var str = "";
				for (var i = 0; i < list.length; i++) {
					var tempxshj = list[i].xshj;
					str = str + "<b>" + tempxshj + "</b><br>";
				}
				e.cellHtml = str;
			}
			if (e.field == "tqxshj") {
				var str = "";
				for (var i = 0; i < list.length; i++) {
					var temptqxshj = list[i].tqxshj;
					str = str + "<b>" + temptqxshj + "</b><br>";
				}
				e.cellHtml = str;
			}
			if (e.field == "mjpx") {
				var str = "";
				var tempmjpx = 0;
				for (var i = 0; i < list.length; i++) {
					var tempxshj = list[i].xshj;
					var tempmj = list[i].mj;
					if(tempmj == 0 || ts == 0){
						str = str + "<b>" + tempmjpx + "</b><br>";
					}else{
						tempmjpx = (tempxshj/tempmj/ts).toFixed(2);
						str = str + "<b>" + tempmjpx + "</b><br>";
					}
				}
				e.cellHtml = str;
			}
			if (e.field == "zsb") {
				var str = "";
				var tempzsb = 0;
				for (var i = 0; i < list.length; i++) {
					var tempzj = list[i].zj;
					var tempxshj = list[i].xshj;
					if(tempxshj == 0){
						str = str + "<b>" + tempzsb + "</b><br>";
					}else{
						tempzsb = (tempzj/tempxshj).toFixed(2);
						str = str + "<b>" + tempzsb + "</b><br>";
					}
				}
				e.cellHtml = str;
			}

			e.cellStyle = "text-align:right";
		}
		// 浮点型相加
		function accAdd(arg1, arg2) {
			var r1, r2, m;
			try {
				r1 = arg1.toString().split(".")[1].length;
			} catch (e) {
				r1 = 0;
			}
			try {
				r2 = arg2.toString().split(".")[1].length;
			} catch (e) {
				r2 = 0;
			}
			m = Math.pow(10, Math.max(r1, r2));
			return ((arg1 * m + arg2 * m) / m).toFixed(2);
		};
	</script>

	<script src="report.js" type="text/javascript"></script>
</body>
</html>