<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>异常结算单汇总报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='500937';

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"initHeight":100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
	            	"items" :[{
			     	 "label" : "货款所属期间：",
			         "name" : "fkmon",
			         "type" : "MonthPicker",
					 "format" : "yyyy-MM",
					 "enabled" : true,
					 "required" : true,
					 "value" : mini.formatDate(new Date(), "yyyyMM"),
					 "defaultValue" : mini.formatDate(new Date(), "yyyyMM"),
			         "style" : "width:22.5%",
			      }, {
			       	 "label" : "生成日期(起)：",
			         "type" : "DatePicker",
			         "name" : "jssdate",
			         "format" : "yyyy-MM-dd",
			         /*  "required" : "true", */
			         "enabled" : true,
			          /* "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),   */
			         "style" : "width:22.5%",
			      }, {
			         "label" : "生成日期(止)：",
			         "type" : "DatePicker",
			         "name" : "jsedate",
			         "format" : "yyyy-MM-dd",
			         /*  "required" : "true",  */
			         "enabled" : true,
			         /* "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),   */
			         "style" : "width:22.5%",
			      }, {
					"label" : "门店：",
					"name" : "muid",
					"type" : "ButtonEdit",
					type : "fut_popselect",
					selectkey:"muid",
					textName :"muid_name", 
					"enabled" : true,
					"style" : "width:22.5%",
				}]}
			]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_500937",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "contno", 
					header : "合同号",
					headerAlign : "center",
					width : 100,
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 150,
				},{
					field : "sbid_name", 
					header : "供应商",
					headerAlign : "center",
					width : 200,
				},{
					field : "wmid_name", 
					header : "经营方式",
					headerAlign : "center",
					width : 90,
				},{
					field : "taxtype", 
					header : "税种",
					headerAlign : "center",
					width : 90,
				},{
					field : "kjmon",
					header : "会计期间",
					allowSort : false,
					headerAlign : "center",
					width : 100,
				}, {
					field: "xscb",
					header: "销售成本" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 120,
					align:"right",
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				}, {
					field: "xsje",
					header: "销售金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 120,
					align:"right",
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				}, {
					field : "jsdate",
					header : "结算单生成日期",
					allowSort : false,
					headerAlign : "center",
					width : 100,
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
				}]			
			},
		}; 
	       
		mini.parse();
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var xscb = 0;   var xsje = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.xscb) == false) {
						xscb += parseFloat(row.xscb);
					}
					if (isNaN(row.xsje) == false) {
						xsje += parseFloat(row.xsje);
					}
				}
			}

			if (e.field == "muid_name") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "xscb") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(xscb),"#,0.00")+"</b>";
			}
			if (e.field == "xsje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(xsje),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>    
</body>
</html>