<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>代销损溢情况跟踪</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='500939';
		
		//字典数据初始化
		var dictData = OcmControl.getDict("TAXLEVEL","code,name,ddvalue") || {};
		var wmid = [{code: '1',name: '经销',ddvalue: '[1]经销'},{code: '2',name: '成本代销',ddvalue: '[2]成本代销'},{code: '3',name: '扣率代销',ddvalue: '[3]扣率代销'}];
		var jsflag = [{code: 'Y',name: '已结算',ddvalue: '[Y]已结算'},{code: 'N',name: '未结算',ddvalue: '[N]未结算'}];
		
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"initHeight":100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[ {
			       	 "label" : "开始日期：",
			         "type" : "DatePicker",
			         "name" : "sdate",
			         "format" : "yyyy-MM-dd",
			          "required" : "true",
			         "enabled" : true,
			          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
			         "style" : "width:22.5%",
			      }, {
			         "label" : "结束日期：",
			         "type" : "DatePicker",
			         "name" : "edate",
			         "format" : "yyyy-MM-dd",
			          "required" : "true", 
			         "enabled" : true,
			          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
			         "style" : "width:22.5%",
			      }, {
					"label" : "门店：",
					"name" : "muid",
					"type" : "ButtonEdit",
					type : "fut_popselect",
					selectkey:"muid",
					textName :"muid_name", 
					"enabled" : true,
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_muid",
					"style" : "width:22.5%",
				}, {
					"label" : "供应商：",
					"name" : "sbid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "selfxlsbid",//弹框类型
					textName : "sbid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%",
			     }, {
					 "label" : "柜组：",
					 "name" : "spid",
					 "type" : "ButtonEdit",
					 "defaultValue" : "",
					 type : "fut_popselect",//类型
					 selectkey : "selfspid",//弹框类型
					 textName : "spid_name", //文本显示字段
					 beforefunc : "head_beforefunc",
					 "enabled" : true,
					 "style" : "width:22.5%",
				  }, {
					 "label" : "结算单号：",
					 "type" : "TextBox",
					 "name" : "jsdh",
					 "enabled" : true,
					 "style" : "width:22.5%"
				 },{
					 "label" : "是否结算：",
					 "type" : "ComboBox",
					 "name" : "jsflag",
					 "enabled" : true,
					 "data" : jsflag,
					 "style" : "width:22.5%",
				}]}
			]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_500939",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 170,
				},{
					field : "ld_name", 
					header : "商场",
					headerAlign : "center",
					width : 140,
				},{
					field : "sbid_name", 
					header : "供应商",
					headerAlign : "center",
					width : 180,
				},{
					field : "spid_name", 
					header : "柜组",
					headerAlign : "center",
					width : 180,
				},{
					field : "jgltran_name", 
					header : "摘要",
					headerAlign : "center",
					width : 60,
				},{
					field : "jglbillno", 
					header : "损溢单号",
					headerAlign : "center",
					width : 140,
				},{
					field : "jglgdid", 
					header : "商品编码",
					headerAlign : "center",
					width : 120,
				},{
					field : "jgljjtax", 
					header : "税率",
					headerAlign : "center",	
					width : 100,
					numberFormat : "p2",
					align: "right",
					excel:{
						  type:"n",
						  format:"0.00%",
						  align:"right"
						},
				},{
					field: "jglsl",
					header: "损溢数量" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 110,
					align:"right",
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "jglhsjjje",
					header: "含税金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 110,
					align:"right",
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "jglbhsjjje",
					header: "不含税金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					width : 110,
					align:"right",
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
				},{
					field : "jglsupjsdh", 
					header : "结算单号",
					headerAlign : "center",
					width : 130,
				},{
					field : "jsflag_name", 
					header : "是否已结算",
					headerAlign : "center",
					width : 80,
				},]
			},
		}; 
	       
		mini.parse();
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			var sbid = mini.getbyName("sbid").getValue();
			if (buttonEdit.name == "sbid") {
				if (muid != "undefined" && muid != ""){
				   e.searchParam.wherestr  = "sbid in(select sbid from supmkt where muid = '"+ muid +"') or sbid = '0000' ";
				}
			}
			if (buttonEdit.name == "spid") {
				e.searchParam.wherestr  = " sylx = '01' ";
				if (muid != "undefined" && muid != ""){
				   e.searchParam.wherestr  += "and muid = '"+ muid +"'";
				}
				if (sbid != "undefined" && sbid != "" && sbid != "0000"){
					e.searchParam.wherestr  += "and oid in(select cm.spid from contmain c,contmanaframe cm where c.contno = cm.contno and c.sbid = '"+ sbid +"')";
				}
			}
			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var jglsl = 0;      var jglhsjjje = 0;	  var jglbhsjjje = 0; 	  
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.jglsl) == false) {
						jglsl += parseFloat(row.jglsl);
					}
					if (isNaN(row.jglhsjjje) == false) {
						jglhsjjje += parseFloat(row.jglhsjjje);
					}	
					if (isNaN(row.jglbhsjjje) == false) {
						jglbhsjjje += parseFloat(row.jglbhsjjje);
					}
				}
			}

			if (e.field == "ld") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "jglsl") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jglsl),"#,0.00")+"</b>";
			}
			if (e.field == "jglhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(jglhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "jglbhsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jglbhsjjje),"#,0.0000")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>