<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>损溢对账报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='500940';
		
		//字典数据初始化
		var dictData = OcmControl.getDict("STOCKMD","code,name,ddvalue") || {};
		
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"initHeight":100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[ {
			       	 "label" : "记账开始日期：",
			         "type" : "DatePicker",
			         "name" : "sdate",
			         "format" : "yyyy-MM-dd",
			          "required" : "true",
			          "enabled" : true,
			          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
			         "style" : "width:30%",
			      }, {
			         "label" : "记账结束日期：",
			         "type" : "DatePicker",
			         "name" : "edate",
			         "format" : "yyyy-MM-dd",
			          "required" : "true", 
			          "enabled" : true,
			          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
			         "style" : "width:30%",
			      }, {
					"label" : "门店：",
					"name" : "muid",
					"enabled" : true,
					type : "fut_popselect",
					selectkey:"muid",
					textName :"muid_name", 
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_muid",
					"style" : "width:30%",
				}, {
					"label" : "柜组：",
					"name" : "spid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "selfspid",//弹框类型
					textName : "spid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
				}, {
					"label" : "子库存：",
					"type" : "ComboBox",
					"name" : "md",
					"data" : dictData.STOCKMD,
					"showNullItem" : true,
					"enabled" : true,
				}]}
			]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_500940",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "jglbillno", 
					header : "单据编号",
					headerAlign : "center",
					width : 150,
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 200,
				},{
					field : "spid_name", 
					header : "柜组",
					headerAlign : "center",
					width : 200,
				},{
					field : "jglmd", 
					header : "子库存",
					headerAlign : "center",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.STOCKMD,
					width : 100,
				},{
					field : "jgldate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "记账日期",
					headerAlign : "center",
					width : 140,
				},{
					field : "sumhsjjje",
					header : "含税进价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "sumbhsjjje",
					header : "不含税进价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				}]
			},
		}; 
		mini.parse();
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			if (e.sender.name == 'spid') {
				e.searchParam.wherestr = "Nvl(Sylx,'02')='01'  and spflag = 'Y' ";
				if(muid){
					e.searchParam.wherestr += " and muid = '" + muid + "' ";
				}
				return 0;
			}		
			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var totsumhsjjje = 0;  
			var totsumbhsjjje = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.sumhsjjje) == false) {
						totsumhsjjje += parseFloat(row.sumhsjjje);
					}
					if (isNaN(row.sumbhsjjje) == false) {
						totsumbhsjjje += parseFloat(row.sumbhsjjje);
					}	
				}
			}

			if (e.field == "jgldate") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "sumhsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(totsumhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "sumbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(totsumbhsjjje),"#,0.0000")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>