<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>商品类别进销存汇总报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1"
		style="margin-bottom: 10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid = '500941';

		//字典数据初始化
		var dictData = OcmControl.getDict("STOCKMD", "code,name,ddvalue") || {};

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"initHeight" : 100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "查询条件",
				"type" : "fieldset",
				"items" : [ {
					"label" : "记账开始日期：",
					"type" : "DatePicker",
					"name" : "sdate",
					"format" : "yyyy-MM-dd",
					"required" : "true",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"style" : "width:22.5%",
				}, {
					"label" : "记账结束日期：",
					"type" : "DatePicker",
					"name" : "edate",
					"format" : "yyyy-MM-dd",
					"required" : "true",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"style" : "width:22.5%",
				}, {
					"label" : "门店：",
					"name" : "muid",
					"enabled" : true,
					type : "fut_popselect",
					selectkey : "muid",
					textName : "muid_name",
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_muid",
					"style" : "width:22.5%",
				}, {
					"label" : "商品类别：",
					"name" : "gbcatcode",
					"enabled" : true,
					displayField : "catcode_name",
					type : "fut_popselect",
					selectkey : "treeSelfGbcatcode",
					textName : "catcode_name",
					beforefunc : "head_beforefunc",
					"style" : "width:22.5%"
				} ]
			} ]
		};

		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_500941",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "muid_name",
					header : "门店",
					headerAlign : "center",
					width : 200,
				}, {
					field : "catname",
					header : "商品类别",
					headerAlign : "center",
					width : 200,
				}, {
					header : "期初结存",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "zrjchsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "zrjcbhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				}, {
					header : "本期进货",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "jhhsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "jhbhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				}, {
					header : "本期退厂",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "tchsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "tcbhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				}, {
					header : "本期进货调整",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "jhhsjjjetz",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "jhbhsjjjetz",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				}, {
					header : "本期门店调拨",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "dbhsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "dbbhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				}, {
					header : "本期配送",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "pshsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "psbhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				}, {
					header : "本期手工损溢",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "syhsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "sybhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				},{
					header : "本期盘点",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "pdhsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "pdbhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				},{
					header : "本期其他",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "qthsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "qtbhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				},{
					header : "本期销售成本",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "xshsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "xsbhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				},{
					header : "本期销售调整",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "xshsjjjetz",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "xsbhsjjjetz",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				},{
					header : "本期批发",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "pfhsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "pfbhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				},{
					header : "本期批发调整",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "pfhsjjjetz",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "pfbhsjjjetz",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				},{
					header : "期末结存",
					allowSort : true,
					headerAlign : "center",
					"columns" : [ {
						field : "jchsjjje",
						header : "含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n2",
						},
						numberFormat : "n2",
						width : 120,
						align : "right",
						excel : {
							type : "n",
							format : "0.00",
							align : "right"
						},
					}, {
						field : "jcbhsjjje",
						header : "不含税",
						headerAlign : "center",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "n4",
						},
						numberFormat : "n4",
						align : "right",
						excel : {
							type : "n",
							format : "0.0000",
							align : "right"
						},
						width : 120,
					} ]
				},{
					field : "xssr",
					header : "本期销售收入",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n2",
					},
					numberFormat : "n2",
					width : 120,
					align : "right",
					excel : {
						type : "n",
						format : "0.00",
						align : "right"
					},
				},{
					field : "xstotzk",
					header : "本期销售折扣",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n2",
					},
					numberFormat : "n2",
					width : 120,
					align : "right",
					excel : {
						type : "n",
						format : "0.00",
						align : "right"
					},
				},{
					field : "xsgystotzk",
					header : "供应商折扣",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n2",
					},
					numberFormat : "n2",
					width : 120,
					align : "right",
					excel : {
						type : "n",
						format : "0.00",
						align : "right"
					},
				}  ]
			},
		};
		mini.parse();

		function head_beforefunc(e) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != "") {
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			return 0;
		}

		function head_itemchanged_muid(e, data) {
			return 0;
		}

		function onDrawSummaryCell(e) {
			var rows = e.data
			var zrjchsjjje = 0;
			var zrjcbhsjjje = 0;
			var jhhsjjje = 0;
			var jhbhsjjje = 0;
			var tchsjjje = 0;
			var tcbhsjjje = 0;
			var jhhsjjjetz = 0;
			var jhbhsjjjetz = 0;
			var dbhsjjje = 0;
			var dbbhsjjje = 0;
			var pshsjjje = 0;
			var psbhsjjje = 0;
	        var syhsjjje = 0;
	        var sybhsjjje = 0;	 
	        var pdhsjjje = 0;
	        var pdbhsjjje = 0;
	        var qthsjjje = 0;
	        var qtbhsjjje = 0;	
	        var xshsjjje = 0;
	        var xsbhsjjje = 0;
	        var xshsjjjetz = 0;
	        var xsbhsjjjetz = 0;
	        var pfhsjjje = 0;
	        var pfbhsjjje = 0;
	        var pfhsjjjetz = 0;
	        var pfbhsjjjetz = 0;   
	        var jchsjjje = 0;
	        var jcbhsjjje = 0;
			var xssr = 0;
			var xstotzk = 0;
			var xsgystotzk = 0;
			if (rows.length > 0) {
				for (var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.zrjchsjjje) == false) {
						zrjchsjjje += parseFloat(row.zrjchsjjje);
					}
					if (isNaN(row.zrjcbhsjjje) == false) {
						zrjcbhsjjje += parseFloat(row.zrjcbhsjjje);
					}	
					if (isNaN(row.jhhsjjje) == false) {
						jhhsjjje += parseFloat(row.jhhsjjje);
					}
					if (isNaN(row.jhbhsjjje) == false) {
						jhbhsjjje += parseFloat(row.jhbhsjjje);
					}
					if (isNaN(row.tchsjjje) == false) {
						tchsjjje += parseFloat(row.tchsjjje);
					}
					if (isNaN(row.tcbhsjjje) == false) {
						tcbhsjjje += parseFloat(row.tcbhsjjje);
					}
					if (isNaN(row.jhhsjjjetz) == false) {
						jhhsjjjetz += parseFloat(row.jhhsjjjetz);
					}
					if (isNaN(row.jhbhsjjjetz) == false) {
						jhbhsjjjetz += parseFloat(row.jhbhsjjjetz);
					}
					if (isNaN(row.dbhsjjje) == false) {
						dbhsjjje += parseFloat(row.dbhsjjje);
					}
					if (isNaN(row.dbbhsjjje) == false) {
						dbbhsjjje += parseFloat(row.dbbhsjjje);
					}	
					if (isNaN(row.pshsjjje) == false) {
						pshsjjje += parseFloat(row.pshsjjje);
					}
					if (isNaN(row.psbhsjjje) == false) {
						psbhsjjje += parseFloat(row.psbhsjjje);
					}
					if (isNaN(row.syhsjjje) == false) {
						syhsjjje += parseFloat(row.syhsjjje);
					}
					if (isNaN(row.sybhsjjje) == false) {
						sybhsjjje += parseFloat(row.sybhsjjje);
					}
					if (isNaN(row.pdhsjjje) == false) {
						pdhsjjje += parseFloat(row.pdhsjjje);
					}
					if (isNaN(row.pdbhsjjje) == false) {
						pdbhsjjje += parseFloat(row.pdbhsjjje);
					}	
					if (isNaN(row.qthsjjje) == false) {
						qthsjjje += parseFloat(row.qthsjjje);
					}
					if (isNaN(row.qtbhsjjje) == false) {
						qtbhsjjje += parseFloat(row.qtbhsjjje);
					}
					if (isNaN(row.xshsjjje) == false) {
						xshsjjje += parseFloat(row.xshsjjje);
					}
					if (isNaN(row.xsbhsjjje) == false) {
						xsbhsjjje += parseFloat(row.xsbhsjjje);
					}
					if (isNaN(row.xshsjjjetz) == false) {
						xshsjjjetz += parseFloat(row.xshsjjjetz);
					}
					if (isNaN(row.xsbhsjjjetz) == false) {
						xsbhsjjjetz += parseFloat(row.xsbhsjjjetz);
					}
					if (isNaN(row.pfhsjjje) == false) {
						pfhsjjje += parseFloat(row.pfhsjjje);
					}
					if (isNaN(row.pfbhsjjje) == false) {
						pfbhsjjje += parseFloat(row.pfbhsjjje);
					}	
					if (isNaN(row.pfhsjjjetz) == false) {
						pfhsjjjetz += parseFloat(row.pfhsjjjetz);
					}
					if (isNaN(row.pfbhsjjjetz) == false) {
						pfbhsjjjetz += parseFloat(row.pfbhsjjjetz);
					}
					if (isNaN(row.jchsjjje) == false) {
						jchsjjje += parseFloat(row.jchsjjje);
					}
					if (isNaN(row.jcbhsjjje) == false) {
						jcbhsjjje += parseFloat(row.jcbhsjjje);
					}
					if (isNaN(row.xssr) == false) {
						xssr += parseFloat(row.xssr);
					}
					if (isNaN(row.xstotzk) == false) {
						xstotzk += parseFloat(row.xstotzk);
					}
					if (isNaN(row.xsgystotzk) == false) {
						xsgystotzk += parseFloat(row.xsgystotzk);
					}
				}
			}

			if (e.field == "catname") {
				e.cellHtml = "<b>" + "合计: " + "</b>";
			}
			if (e.field == "zrjchsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(zrjchsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "zrjcbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(zrjcbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "jhhsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jhhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "jhbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(jhbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "tchsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(tchsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "tcbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(tcbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "jhhsjjjetz") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jhhsjjjetz),"#,0.00")+"</b>";
			}
			if (e.field == "jhbhsjjjetz") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(jhbhsjjjetz),"#,0.0000")+"</b>";
			}
			if (e.field == "dbhsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(dbhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "dbbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(dbbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "pshsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(pshsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "psbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(psbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "syhsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(syhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "sybhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sybhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "pdhsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(pdhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "pdbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(pdbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "qthsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(qthsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "qtbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(qtbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "xshsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(xshsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "xsbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(xsbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "xshsjjjetz") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(xshsjjjetz),"#,0.00")+"</b>";
			}
			if (e.field == "xsbhsjjjetz") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(xsbhsjjjetz),"#,0.0000")+"</b>";
			}
			if (e.field == "pfhsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(pfhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "pfbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(pfbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "pfhsjjjetz") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(pfhsjjjetz),"#,0.00")+"</b>";
			}
			if (e.field == "pfbhsjjjetz") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(pfbhsjjjetz),"#,0.0000")+"</b>";
			}
			if (e.field == "jchsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jchsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "jcbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(jcbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "xssr") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(xssr),"#,0.00")+"</b>";
			}
			if (e.field == "xstotzk") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(xstotzk),"#,0.00")+"</b>";
			}
			if (e.field == "xsgystotzk") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(xsgystotzk),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	</script>

	<script src="report.js" type="text/javascript"></script>

</body>
</html>