<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>税率销售收入明细报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='500942';
		
		//字典数据初始化
		var dictData = OcmControl.getDict("JXTAXRATE","code,name,ddvalue") || {};
		
		dictData.SGLTAXTYPE = [{code : '1' , name : '增值税'}, {code : '2', name : '营业税'}];
		
		var tpday = {};
		 var searchParam = {queryid : "select_tpday"};
		  itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query",
		      searchParam, null, null, function(data) {
			  tpday = data.report;       
		 }, null, null, false);

		
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"initHeight":100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[ {
			       	 "label" : "发生开始日期：",
			         "type" : "DatePicker",
			         "name" : "sdate",
			         "format" : "yyyy-MM-dd",
			          "required" : "true",
			          "enabled" : true,
			          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
			      }, {
			         "label" : "发生结束日期：",
			         "type" : "DatePicker",
			         "name" : "edate",
			         "format" : "yyyy-MM-dd",
			          "required" : "true", 
			          "enabled" : true,
			          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
			      }, {
					"label" : "门店：",
					"name" : "muid",
					"enabled" : true,
					type : "fut_popselect",
					selectkey:"muid",
					textName :"muid_name", 
					beforefunc : "head_beforefunc",
				}, {
			       	 "label" : "开始时段：",
			         "type" : "DatePicker",
			         "name" : "stpday",
			         "type": "ComboBox",
					 "enabled" : true,
					 "data" : tpday,
			      }, {
			         "label" : "结束时段：",
			         "name" : "etpday",
			         "type": "ComboBox",
					 "enabled" : true,
					 "data" : tpday,
			      }, {
					"label" : "销项税率：",
					"name": "xstax",
					"type": "ComboBox",
					"enabled" : true,
					"data" : dictData.JXTAXRATE,
				}]}
			]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_500942",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 200,
				},{
					field : "sglxstax",
					header : "销项税率",
					headerAlign : "center",				    
				    width : 100,
				    align : "right",
				    type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.JXTAXRATE,
				}, {
					field : "sglxftax",
					header : "消费税率",
					headerAlign : "center",				    
				    width : 100,
				    align : "right",
				    type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.JXTAXRATE,
				}, {
					field : "sglgdid", 
					header : "商品编码",
					headerAlign : "center",
					width : 150,
				},{
					field : "ppcode_name", 
					header : "品牌",
					headerAlign : "center",
					width : 200,
				},{
					field : "ppname", 
					header : "中文品名",
					headerAlign : "center",
					width : 150,
				},{
					field : "gbspec", 
					header : "规格",
					headerAlign : "center",
					width : 150,
				},{
					field : "sglsjje",
					header : "销售金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "sglxssr",
					header : "销售收入",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "sglbhsxssr",
					header : "不含税销售收入",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c4",
					},
					numberFormat : "c4",
					defaultValue : "0",
					align : "right",
				},{
					field : "sglqtsr",
					header : "其他收入",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "sglsysy",
					header : "收银损溢",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "sglxsse",
					header : "销售税额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "sglxfse",
					header : "消费税额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "sgltotzk",
					header : "总折扣",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "sglsupzk",
					header : "供应商折扣",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				}]
			},
		}; 
		mini.parse();
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			return 0;
		}
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var sglsjje = 0;  
			var sglxssr = 0;
			var sglbhsxssr = 0;  
			var sglqtsr = 0;
			var sglsysy = 0;  
			var sglxsse = 0;
			var sglxfse = 0;  
			var sgltotzk = 0;
			var sglsupzk = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.sglsjje) == false) {
						sglsjje += parseFloat(row.sglsjje);
					}
					if (isNaN(row.sglxssr) == false) {
						sglxssr += parseFloat(row.sglxssr);
					}
					if (isNaN(row.sglbhsxssr) == false) {
						sglbhsxssr += parseFloat(row.sglbhsxssr);
					}
					if (isNaN(row.sglqtsr) == false) {
						sglqtsr += parseFloat(row.sglqtsr);
					}
					if (isNaN(row.sglsysy) == false) {
						sglsysy += parseFloat(row.sglsysy);
					}
					if (isNaN(row.sglxsse) == false) {
						sglxsse += parseFloat(row.sglxsse);
					}
					if (isNaN(row.sglxfse) == false) {
						sglxfse += parseFloat(row.sglxfse);
					}
					if (isNaN(row.sgltotzk) == false) {
						sgltotzk += parseFloat(row.sgltotzk);
					}
					if (isNaN(row.sglsupzk) == false) {
						sglsupzk += parseFloat(row.sglsupzk);
					}
				}
			}

			if (e.field == "gbspec") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "sglsjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(sglsjje),"#,0.00")+"</b>";
			}
			if (e.field == "sglxssr") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(sglxssr),"#,0.00")+"</b>";
			}
			if (e.field == "sglbhsxssr") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sglbhsxssr),"#,0.0000")+"</b>";
			}
			if (e.field == "sglqtsr") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(sglqtsr),"#,0.00")+"</b>";
			}
			if (e.field == "sglsysy") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(sglsysy),"#,0.00")+"</b>";
			}
			if (e.field == "sglxsse") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(sglxsse),"#,0.00")+"</b>";
			}
			if (e.field == "sglxfse") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(sglxfse),"#,0.00")+"</b>";
			}
			if (e.field == "sgltotzk") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(sgltotzk),"#,0.00")+"</b>";
			}
			if (e.field == "sglsupzk") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(sglsupzk),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>