<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>财务调整商品明细报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='500943';
		
		//字典数据初始化
		var dicData = OcmControl.getDict("JXTAXRATE,WMID","code,name,ddvalue") || {};
		
	  	var tempwmid = [];
		for(var i = 0;i < dicData.WMID.length;i++){
			if(dicData.WMID[i].code == '1' || dicData.WMID[i].code == '2' || dicData.WMID[i].code == '3'){
				tempwmid.push(dicData.WMID[i]);
			}
		}
		dicData.WMID = tempwmid;
		
		dicData.SAMPLE = [{code : 'N', name : '非样品'}, {code : 'Y', name : '样品'}];

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"initHeight":100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[ {
			       	 "label" : "发生开始日期：",
			         "type" : "DatePicker",
			         "name" : "sdate",
			         "format" : "yyyy-MM-dd",
			          "required" : "true",
			          "enabled" : true,
			          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
			      }, {
			         "label" : "发生结束日期：",
			         "type" : "DatePicker",
			         "name" : "edate",
			         "format" : "yyyy-MM-dd",
			          "required" : "true", 
			          "enabled" : true,
			          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
			      }, {
					"label" : "门店：",
					"name" : "muid",
					"required" : "true",
					"enabled" : true,
					type : "fut_popselect",
					selectkey:"muid",
					textName :"muid_name", 
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_muid",
				}, {
					"label" : "收货柜组：",
					"name" : "spid",
					"defaultValue" : "",
					"enabled" : true,
					type : "fut_popselect",
					selectkey:"selfspid",
					beforefunc:"head_beforefunc",
				},{
					"label" : "单号：",
					"name" : "billno",
					"type" : "TextBox",
					"enabled" : true,
					"defaultValue" : "",
				} ,{
					"label" : "原始入库单号：",
					"name" : "jadinstrno",
					"type" : "TextBox",
					"enabled" : true,
					"defaultValue" : "",
				} ,{
					"label" : "经营方式：",
					"name" : "wmid",
					"enabled" : true,
					"type" : "ComboBox",
					"data" : dicData.WMID,
					"defaultValue" : "",
				},{
					"label" : "供应商：",
					"name" : "sbid",
					"enabled" : true,
					"defaultValue" : "",
					type : "fut_popselect",
					selectkey:"selfsbid",
					beforefunc:"head_beforefunc",
				} ,{
					"label" : "商品编码：",
					"name" : "gbid",
					"defaultValue" : "",
					"enabled" : true,
					type : "fut_popselect",
					selectkey:"selfgbase",
					beforefunc:"head_beforefunc",
				}]}
			]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_500943",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "jadbillid", 
					header : "单据类别",
					headerAlign : "center",
					width : 180,
				},{
					field : "jadbillno", 
					header : "单据编号",
					headerAlign : "center",
					width : 180,
				},{
					field : "spid_name", 
					header : "柜组",
					headerAlign : "center",
					width : 200,
				},{
					field : "catname", 
					header : "商品类别",
					headerAlign : "center",
					width : 200,
				},{
					field : "jadtran", 
					header : "调整",
					headerAlign : "center",
					width : 200,
				},{
					field : "jadwmid", 
					header : "经营方式",
					headerAlign : "center",
					width : 150,
					renderer: "OcmControl.dictRendererWithCode",
				    data: dicData.WMID,
				},{
					field : "jadgdid", 
					header : "商品编码",
					headerAlign : "center",
					width : 200,
				},{
					field : "gbcname", 
					header : "商品名称",
					headerAlign : "center",
					width : 200,
				},{
					field : "jadoldjxtax",
					header : "原税率",
					headerAlign : "center",				    
				    width : 100,
				    align : "right",
				    type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.JXTAXRATE,
				}, {
					field : "jadoldhsjj",
					header : "原进价",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "jadjxtax",
					header : "新税率",
					headerAlign : "center",				    
				    width : 100,
				    align : "right",
				    type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.JXTAXRATE,
				}, {
					field : "jadhsjj",
					header : "新进价",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "jadsl",
					header : "数量",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "jadhsjjje",
					header : "含税金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "jadbhsjjje",
					header : "不含税金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c4",
					},
					numberFormat : "c4",
					defaultValue : "0",
					align : "right",
				},{
					field : "jadsj",
					header : "售价",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "jadbatchseq", 
					header : "批次",
					headerAlign : "center",
					width : 150,
				},{
					field : "jadinstrno", 
					header : "原始入库单号",
					headerAlign : "center",
					width : 200,
				},{
					field : "sbid_name", 
					header : "供应商",
					headerAlign : "center",
					width : 200,
				},{
					field : "jadsample", 
					header : "样品",
					headerAlign : "center",
					width : 150,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.SAMPLE,
				}]
			},
		}; 
		mini.parse();
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			var wmid = mini.getbyName("wmid").getValue();
			var sbid = mini.getbyName("sbid").getValue();
			var spid = mini.getbyName("spid").getValue();
			var jadinstrno = mini.getbyName("jadinstrno").getValue();
			if (buttonEdit.name == "spid") {
				if (muid == "") {
					mini.alert("请先选择门店");
					return -1;
				}else{
					e.searchParam.muid = muid;
					e.searchParam.wherestr = " spflag = 'Y' and sylx = 01 ";
				}
			}
			if (buttonEdit.name == "sbid") {
				if (muid == "") {
					mini.alert("请先选择门店");
					return -1;
				}else{
					e.searchParam.muid = muid;
					if(!wmid){
						e.searchParam.wherestr = " (a.SBWMID1 = 'Y' or a.SBWMID2 = 'Y' or a.SBWMID3 = 'Y') ";
					}else if(wmid === "1"){
						e.searchParam.wherestr = " (a.SBWMID1 = 'Y') ";
					}else if(wmid === "2"){
						e.searchParam.wherestr = " (a.SBWMID2 = 'Y') ";
					}else if(wmid === "3"){
						e.searchParam.wherestr = " (a.SBWMID3 = 'Y') ";
					}
				}
			}
			if (buttonEdit.name == "gbid") {
				if (muid == "") {
					mini.alert("请先选择门店");
					return -1;
				}else{
					if(jadinstrno){
						e.searchParam.wherestr = " gb.gbbarcode in (select barcode from binstrdetail where billno = '" + jadinstrno + "' and iszp = 'N' and sample = 'N') ";
					}else{
						e.searchParam.wherestr = " 1=1 "
						if(wmid){
							e.searchParam.wherestr += " and gm.gmfwmid = '" + wmid + "' ";
						}
						if(muid){
							e.searchParam.wherestr += " and gm.gmfmarket In (Select Mucode From Manaunit Where Muid = '" + muid + "')";
						}
						if(spid){
							e.searchParam.wherestr += " and gm.gmfmfid In (Select spcode From shoplist Where spid = '" + spid + "')";
						}
						if(sbid){
							e.searchParam.wherestr += " and exists ( select 1 from suppliergoods sg where sg.sgsgdid = gb.gbid and sg.sgssupid In (Select sbcode From supplierbase Where sbid = '"+ sbid +"'))";
						}
					}
				}
			}
			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var jadoldhsjj = 0;  
			var jadhsjj = 0;
			var jadsl = 0;  
			var jadhsjjje = 0;
			var jadbhsjjje = 0;  
			var jadsj = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.jadoldhsjj) == false) {
						jadoldhsjj += parseFloat(row.jadoldhsjj);
					}
					if (isNaN(row.jadhsjj) == false) {
						jadhsjj += parseFloat(row.jadhsjj);
					}
					if (isNaN(row.jadsl) == false) {
						jadsl += parseFloat(row.jadsl);
					}
					if (isNaN(row.jadhsjjje) == false) {
						jadhsjjje += parseFloat(row.jadhsjjje);
					}
					if (isNaN(row.jadbhsjjje) == false) {
						jadbhsjjje += parseFloat(row.jadbhsjjje);
					}
					if (isNaN(row.jadsj) == false) {
						jadsj += parseFloat(row.jadsj);
					}
				}
			}

			if (e.field == "gbcname") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "jadoldhsjj") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jadoldhsjj),"#,0.00")+"</b>";
			}
			if (e.field == "jadhsjj") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jadhsjj),"#,0.00")+"</b>";
			}
			if (e.field == "jadsl") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(jadsl),"#,0.0000")+"</b>";
			}
			if (e.field == "jadhsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jadhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "jadbhsjjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jadbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "jadsj") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jadsj),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>