<%@ page language="java" contentType="text/html; charset=utf-8"
  pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>维修服务工时汇总</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">


  <div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
  
  <div class="ocm-formheader" config="formheader1"></div>
  <div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
  
  <script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
  <script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

  <script type="text/javascript">
    //字典数据初始化
	var moduleid = "700221";
	
    var toolbar1 = {
      items : [ [ {
        "text" : "查询",
        "iconCls" : "icon-search",
        "name" : "searchData",
        "onclick" : "searchData",
        "enabled" : true,
      }, {
        "text" : "清除",
        "iconCls" : "icon-remove",
        "name" : "clearData",
        "onclick" : "clearData",
        "enabled" : true,
      }, {
			"text" : "导出",
			"iconCls" : "icon-upload",
			"name" : "exportData",
			"onclick" : "exportData",
			"enabled" : true,
		} ] ]
    };

    var formheader1 = {
      "type" : "formgrid",
      "properties" : {
        "id" : "formheader1",
      },
      items : [{
     	 "label" : "服务申请开始日期：",
         "type" : "DatePicker",
         "name" : "sahsdate",
         "format" : "yyyy-MM-dd",
         "required" : "true",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
         "label" : "服务申请结束日期：",
         "type" : "DatePicker",
         "name" : "sahedate",
         "format" : "yyyy-MM-dd",
         "required" : "true",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
    	  	"label" : "门店：",
			"name" : "muid",
			"enabled" : true,
			"defaultValue" : "",
			type : "fut_popselect",//类型
			selectkey:"muid",//弹框类型
			textName :"muid_name",
			"style" : "width:30%"
		}]};

    var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_700221",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name",
					header : "门店",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				}, {
					field : "sumn", 
					header : "待派单工单",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "sums", 
					header : "维修中工单",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "sumy", 
					header : "已完成工单",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "sumsat", 
					header : "已完成工单满意数量",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field: "sumc",
					header:"终止工单数",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field: "sumh",
					header:"已完成工单耗时",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					allowSort : true,
					width : 180,
				},{
					field : "satratio",
					header : "服务满意工单量占比",
					allowSort : false,
					width : 180,
					headerAlign : "center",
					numberFormat : "p2",
					allowSort : true,
					align : "right",
				} ]
			},
		}; 

    mini.parse();

    function onDrawSummaryCell(e) {
		var rows = e.data;
		
		var sum = 0;

		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.sumn) == false) {
					sum += parseFloat(row.sumn);
				}
				if (isNaN(row.sums) == false) {
					sum += parseFloat(row.sums);
				}
				if (isNaN(row.sumy) == false) {
					sum += parseFloat(row.sumy);
				}
				if (isNaN(row.sumc) == false) {
					sum += parseFloat(row.sumc);
				}
			}
		}
		
		if (e.field == "sumn") {
			e.cellHtml = "<b>" + "合计工单总数：" + "</b>";
		}
		if (e.field == "sumc") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(sum),"#,0")+"</b>";
		}

		e.cellStyle = "text-align:right";  
	}
    
  </script>

  <script src="report.js" type="text/javascript"></script>
  
</body>
</html>