<%@ page language="java" contentType="text/html; charset=utf-8"
  pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>维修人员服务工时与服务满意度分析</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">


  <div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
  
  <div class="ocm-formheader" config="formheader1"></div>
  <div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
  
  <script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
  <script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

  <script type="text/javascript">
    //字典数据初始化
	var moduleid = "700222";
	
    var toolbar1 = {
      items : [ [ {
        "text" : "查询",
        "iconCls" : "icon-search",
        "name" : "searchData",
        "onclick" : "searchData",
        "enabled" : true,
      }, {
        "text" : "清除",
        "iconCls" : "icon-remove",
        "name" : "clearData",
        "onclick" : "clearData",
        "enabled" : true,
      }, {
			"text" : "导出",
			"iconCls" : "icon-upload",
			"name" : "exportData",
			"onclick" : "exportData",
			"enabled" : true,
		} ] ]
    };

    var formheader1 = {
      "type" : "formgrid",
      "properties" : {
        "id" : "formheader1",
      },
      items : [{
     	 "label" : "服务申请开始日期：",
         "type" : "DatePicker",
         "name" : "sahsdate",
         "format" : "yyyy-MM-dd",
         "required" : "true",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
         "label" : "服务申请结束日期：",
         "type" : "DatePicker",
         "name" : "sahedate",
         "format" : "yyyy-MM-dd",
         "required" : "true",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
    	  	"label" : "门店：",
			"name" : "muid",
			"enabled" : true,
			"defaultValue" : "",
			type : "fut_popselect",//类型
			selectkey:"muid",//弹框类型
			textName :"muid_name",
			"required" : "true",
			beforefunc:"head_beforefunc",
			itemchangedfunc:"head_itemchanged_muid",
			"style" : "width:30%"
	  }, {
	  	  	"label" : "维修负责人：",
			"name" : "usercode",
			"enabled" : true,
			"defaultValue" : "",
			type : "fut_popselect",//类型
			selectkey:"prouserinfo",//弹框类型
			textName :"servuser_name",
			beforefunc:"head_beforefunc",
			"style" : "width:30%"
		}]};

    var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_700222",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name",
					header : "门店",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				}, {
					field : "servuser_name",
					header : "维修负责人",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				}, {
					field : "sumy", 
					header : "已完成工单",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "sumhy", 
					header : "已完成工单耗时",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					allowSort : true,
					width : 180,
				},{
					field : "sumsc", 
					header : "维修中止工单数",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "sumhsc", 
					header : "维修中止工单耗时",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					allowSort : true,
					width : 180,
				},{
					field: "sumtoth",
					header:"工单累计耗时",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					allowSort : true,
					width : 180,
				},{
					field : "wksat",
					header : "工作饱和度",
					allowSort : false,
					width : 180,
					headerAlign : "center",
					numberFormat : "p2",
					allowSort : true,
					align : "right",
				},{
					field: "sumsat",
					header:"满意工单（评价满意与非常满意）",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "satratio",
					header : "满意占完成工单占比",
					allowSort : false,
					width : 180,
					headerAlign : "center",
					numberFormat : "p2",
					allowSort : true,
					align : "right",
				},{
					field: "sumunsat",
					header:"不满意工单（评价为不满意与非常不满意）",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "unsatratio",
					header : "不满意工单占比",
					allowSort : false,
					width : 180,
					headerAlign : "center",
					numberFormat : "p2",
					allowSort : true,
					align : "right",
				} ]
			},
		}; 

    mini.parse();
    
    function head_beforefunc(e){
		if(!e.searchParam){
			e.searchParam = {};
		}
		var buttonEdit = e.sender;
		if (e.value != "undefined" && e.value != ""){
			e.searchParam.code = e.value;
		}
		var muid = mini.getbyName("muid");
		
		if (buttonEdit.name == "usercode") {
			if (muid.getValue() == "") {
				mini.alert("请先选择门店");
				return -1;
			}
			e.searchParam.wherestr = " pui.muid = '" + muid.getValue() + "' ";
		}
		
		
		return 0;
	}
    
    function head_itemchanged_muid(e,data){
		mini.getbyName("usercode").setValue("");
		mini.getbyName("usercode").setText("");
		return 0;
	}


    function onDrawSummaryCell(e) {
		var rows = e.data;
		
		var sum = 0;
		var totsumy = 0;
		var totsumhy = 0;
		var totsumsc = 0;
		var totsumhsc = 0;
		var totsumtoth = 0;
		var totsumsat = 0;
		var totsumunsat = 0;
		var totwksat = 0;
		var totsatratio = 0;
		var totunsatratio = 0;

		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.sumy) == false) {
					totsumy += parseFloat(row.sumy);
				}
				if (isNaN(row.sumhy) == false) {
					totsumhy += parseFloat(row.sumhy);
				}
				if (isNaN(row.sumsc) == false) {
					totsumsc += parseFloat(row.sumsc);
				}
				if (isNaN(row.sumhsc) == false) {
					totsumhsc += parseFloat(row.sumhsc);
				}
				if (isNaN(row.sumtoth) == false) {
					totsumtoth += parseFloat(row.sumtoth);
				}
				if (isNaN(row.wksat) == false) {
					totwksat += parseFloat(row.wksat);
				}
				if (isNaN(row.sumsat) == false) {
					totsumsat += parseFloat(row.sumsat);
				}
				if (isNaN(row.sumunsat) == false) {
					totsumunsat += parseFloat(row.sumunsat);
				}
			}
		}
		
		if (e.field == "servuser_name") {
			e.cellHtml = "<b>" + "合计：" + "</b>";
		}
		if (e.field == "sumy") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(totsumy),"#,0")+"</b>";
		}
		if (e.field == "sumhy") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(totsumhy),"#,0.00")+"</b>";
		}
		if (e.field == "sumsc") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(totsumsc),"#,0")+"</b>";
		}
		if (e.field == "sumhsc") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(totsumhsc),"#,0.00")+"</b>";
		}
		if (e.field == "sumtoth") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(totsumtoth),"#,0.00")+"</b>";
		}
		if (e.field == "wksat") {
			e.cellHtml ="<b>"+ mini.formatNumber(totwksat,"#0.00%")+"</b>";
		}
		if (e.field == "sumsat") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(totsumsat),"#,0")+"</b>";
		}
		if (e.field == "satratio") {
			if(totsumy == 0){
				e.cellHtml ="<b>"+ mini.formatNumber(totsatratio,"#0.00%")+"</b>";
			}else{
				totsatratio = totsumsat/totsumy;
				e.cellHtml ="<b>"+ mini.formatNumber(totsatratio,"#0.00%")+"</b>";
			}
		}
		if (e.field == "sumunsat") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(totsumunsat),"#,0")+"</b>";
		}
		if (e.field == "unsatratio") {
			if(totsumy == 0){
				e.cellHtml ="<b>"+ mini.formatNumber(totunsatratio,"#0.00%")+"</b>";
			}else{
				totunsatratio = totsumunsat/totsumy;
				e.cellHtml ="<b>"+ mini.formatNumber(totunsatratio,"#0.00%")+"</b>";
			}
		}

		e.cellStyle = "text-align:right";  
	}
    
  </script>

  <script src="report.js" type="text/javascript"></script>
  
</body>
</html>