<%@ page language="java" contentType="text/html; charset=utf-8"
  pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>工单历时分析</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">


  <div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
  
  <div class="ocm-formheader" config="formheader1"></div>
  <div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
  
  <script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
  <script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

  <script type="text/javascript">
    //字典数据初始化
	var moduleid = "700223";
	
    var toolbar1 = {
      items : [ [ {
        "text" : "查询",
        "iconCls" : "icon-search",
        "name" : "searchData",
        "onclick" : "searchData",
        "enabled" : true,
      }, {
        "text" : "清除",
        "iconCls" : "icon-remove",
        "name" : "clearData",
        "onclick" : "clearData",
        "enabled" : true,
      }, {
			"text" : "导出",
			"iconCls" : "icon-upload",
			"name" : "exportData",
			"onclick" : "exportData",
			"enabled" : true,
		} ] ]
    };

    var formheader1 = {
      "type" : "formgrid",
      "properties" : {
        "id" : "formheader1",
      },
      items : [{
     	 "label" : "服务申请开始日期：",
         "type" : "DatePicker",
         "name" : "sahsdate",
         "format" : "yyyy-MM-dd",
         "required" : "true",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
         "label" : "服务申请结束日期：",
         "type" : "DatePicker",
         "name" : "sahedate",
         "format" : "yyyy-MM-dd",
         "required" : "true",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
    	  	"label" : "门店：",
			"name" : "muid",
			"enabled" : true,
			"defaultValue" : "",
			type : "fut_popselect",//类型
			selectkey:"muid",//弹框类型
			textName :"muid_name",
			"required" : "true",
			beforefunc:"head_beforefunc",
			itemchangedfunc:"head_itemchanged_muid",
			"style" : "width:30%"
	  }, {
	  	  	"label" : "维修负责人：",
			"name" : "usercode",
			"enabled" : true,
			"defaultValue" : "",
			type : "fut_popselect",//类型
			selectkey:"prouserinfo",//弹框类型
			textName :"servuser_name",
			beforefunc:"head_beforefunc",
			"style" : "width:30%"
		}]};

    var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_700223",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name",
					header : "门店",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				}, {
					field : "servuser_name",
					header : "维修负责人",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				}, {
					field : "tmfds", 
					header : "24（含）小时以内",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "tmsds", 
					header : "24-48（含）小时",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "tmtds", 
					header : "48-72（含）小时",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "tmmds", 
					header : "72小时以上",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field: "totno",
					header:"合计",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "tmfdsprate",
					header : "24小时内维修及时率",
					allowSort : false,
					width : 180,
					headerAlign : "center",
					numberFormat : "p2",
					allowSort : true,
					align : "right",
				},{
					field: "cq",
					header:"超期完成工单数",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					allowSort : true,
					width : 180,
				},{
					field : "cqrate",
					header : "超期完成占比",
					allowSort : false,
					width : 180,
					headerAlign : "center",
					numberFormat : "p2",
					allowSort : true,
					align : "right",
				} ]
			},
		}; 

    mini.parse();
    
    function head_beforefunc(e){
		if(!e.searchParam){
			e.searchParam = {};
		}
		var buttonEdit = e.sender;
		if (e.value != "undefined" && e.value != ""){
			e.searchParam.code = e.value;
		}
		var muid = mini.getbyName("muid");
		
		if (buttonEdit.name == "usercode") {
			if (muid.getValue() == "") {
				mini.alert("请先选择门店");
				return -1;
			}
			e.searchParam.wherestr = " pui.muid = '" + muid.getValue() + "' ";
		}
		
		
		return 0;
	}
    
    function head_itemchanged_muid(e,data){
		mini.getbyName("usercode").setValue("");
		mini.getbyName("usercode").setText("");
		return 0;
	}


    function onDrawSummaryCell(e) {
		var rows = e.data;
		
		var sum = 0;
		var tottmfds = 0;
		var tottmsds = 0;
		var tottmtds = 0;
		var tottmmds = 0;
		var tottotno = 0;
		var totcq = 0;
		var tottmfdsprate = 0;
		var totcqrate = 0;

		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.tmfds) == false) {
					tottmfds += parseFloat(row.tmfds);
				}
				if (isNaN(row.tmsds) == false) {
					tottmsds += parseFloat(row.tmsds);
				}
				if (isNaN(row.tmtds) == false) {
					tottmtds += parseFloat(row.tmtds);
				}
				if (isNaN(row.tmmds) == false) {
					tottmmds += parseFloat(row.tmmds);
				}
				if (isNaN(row.totno) == false) {
					tottotno += parseFloat(row.totno);
				}
				if (isNaN(row.cq) == false) {
					totcq += parseFloat(row.cq);
				}
			}
		}
		
		if (e.field == "servuser_name") {
			e.cellHtml = "<b>" + "合计：" + "</b>";
		}
		if (e.field == "tmfds") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(tottmfds),"#,0")+"</b>";
		}
		if (e.field == "tmsds") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(tottmsds),"#,0")+"</b>";
		}
		if (e.field == "tmtds") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(tottmtds),"#,0")+"</b>";
		}
		if (e.field == "tmmds") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(tottmmds),"#,0")+"</b>";
		}
		if (e.field == "totno") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(tottotno),"#,0")+"</b>";
		}
		if (e.field == "cq") {
			e.cellHtml ="<b>"+ mini.formatNumber(Number(totcq),"#,0")+"</b>";
		}
		if (e.field == "tmfdsprate") {
			if(tottotno == 0){
				e.cellHtml ="<b>"+ mini.formatNumber(tottmfdsprate,"#0.00%")+"</b>";
			}else{
				tottmfdsprate = tottmfds/tottotno;
				e.cellHtml ="<b>"+ mini.formatNumber(tottmfdsprate,"#0.00%")+"</b>";
			}
		}
		if (e.field == "cqrate") {
			if(tottotno == 0){
				e.cellHtml ="<b>"+ mini.formatNumber(totcqrate,"#0.00%")+"</b>";
			}else{
				totcqrate = totcq/tottotno;
				e.cellHtml ="<b>"+ mini.formatNumber(totcqrate,"#0.00%")+"</b>";
			}
		}

		e.cellStyle = "text-align:right";  
	}
    
  </script>

  <script src="report.js" type="text/javascript"></script>
  
</body>
</html>