<%@ page language="java" contentType="text/html; charset=utf-8"
  pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>维修服务费用统计</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">


  <div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
  
  <div class="ocm-formheader" config="formheader1"></div>
  <div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
  
  <script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
  <script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

  <script type="text/javascript">
  var dictData = OcmControl.getDict("WORKSTATUS","code,name,pro1,ddvalue")
    //字典数据初始化
	var moduleid = "700225";
	
    var toolbar1 = {
      items : [ [ {
        "text" : "查询",
        "iconCls" : "icon-search",
        "name" : "searchData",
        "onclick" : "searchData",
        "enabled" : true,
      }, {
        "text" : "清除",
        "iconCls" : "icon-remove",
        "name" : "clearData",
        "onclick" : "clearData",
        "enabled" : true,
      }, {
			"text" : "导出",
			"iconCls" : "icon-upload",
			"name" : "exportData",
			"onclick" : "exportData",
			"enabled" : true,
		} ] ]
    };

    var formheader1 = {
      "type" : "formgrid",
      "properties" : {
        "id" : "formheader1",
      },
      items : [{
     	 "label" : "服务申请开始日期：",
         "type" : "DatePicker",
         "name" : "sahsdate",
         "format" : "yyyy-MM-dd",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
         "label" : "服务申请结束日期：",
         "type" : "DatePicker",
         "name" : "sahedate",
         "format" : "yyyy-MM-dd",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
    	  	"label" : "门店：",
			"name" : "muid",
			"enabled" : true,
			"defaultValue" : "",
			type : "fut_popselect",//类型
			selectkey:"muid",//弹框类型
			textName :"muid_name",
			beforefunc:"head_beforefunc",
			itemchangedfunc:"head_itemchanged_muid",
			"style" : "width:30%"
	  }, {
			"label" : "服务申请单号：",
			"type" : "TextBox",
			"name" : "serbillno",
			"enabled" : true,
			"width" : "30%",
		}, {
	  	  	"label" : "服务分类：",
			"name" : "sccode",
			"enabled" : true,
			"defaultValue" : "",
			type : "fut_popselect",//类型
			selectkey:"treeSccode",//弹框类型
			textName :"scname",
			beforefunc:"head_beforefunc",
			"style" : "width:30%"
		},{
			"label" : "工单号：",
			"type" : "TextBox",
			"name" : "billno",
			"enabled" : true,
			"width" : "30%",
		},{
			"label": "合同号：",
			"name": "contno",
			"enabled" : true,
			"defaultValue" : "",
			type : "fut_popselect",//类型
			selectkey:"leasecontno",//弹框类型
			textName :"contno",
			beforefunc:"head_beforefunc",
			"style" : "width:30%"
		},{
			"label": "商户：",
			"name": "sbid",
			"enabled" : true,
			"defaultValue" : "",
			type : "fut_popselect",//类型
			selectkey:"sbid",//弹框类型
			textName :"sbid_name",
			beforefunc:"head_beforefunc",
			"style" : "width:30%"
		}]};

    var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_700225",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name",
					header : "门店",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				}, {
					field : "serbillno",
					header : "服务申请单号",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				}, {
					field : "billno",
					header : "工单号",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				}, {
					field : "billname",
					header : "工单状态",
					width : 180,
					allowSort : true,
					headerAlign : "center",
				}, {
					field : "stype",
					header : "申请类型",
					width : 180,
					allowSort : true,
					headerAlign : "center",
				},{
					field : "servaddr",
					header : "维修地点",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				},{
					field : "sbid_name",
					header : "商户",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				},{
					field : "contno",
					header : "合同号",
					allowSort : true,
					headerAlign : "center",
					align : "right",
				},{
					field : "linkman",
					header : "申请人",
					allowSort : true,
					headerAlign : "center",
				},{
					field : "ctype",
					header : "紧急等级",
					allowSort : true,
					headerAlign : "center",
				},{
					field : "servusername",
					header : "维护负责人",
					allowSort : true,
					headerAlign : "center",
				},{
					field : "servamemo",
					header : "维修内容",
					allowSort : true,
					headerAlign : "center",
					width : 150,
				},{
					field : "auditdate", 
					header : "工单完成时间",
					allowSort : true,
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					width : 180,
				},{
					field : "sccode", 
					header : "服务分类",
					headerAlign : "center",
					width : 180,
				},{
					field : "cccode", 
					header : "服务费用项目",
					headerAlign : "center",
					width : 180,
				},{
					field : "scje", 
					header : "服务参考金额",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					allowSort : true,
					width : 180,
				},{
					field : "sumser", 
					header : "服务实际金额",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					allowSort : true,
					width : 180,
				},{
					field : "summd", 
					header : "本单物料费用汇总",
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					allowSort : true,
					width : 180,
				} ]
			},
		}; 

    mini.parse();
    
    function head_beforefunc(e){
		if(!e.searchParam){
			e.searchParam = {};
		}
		var buttonEdit = e.sender;
		if (e.value != "undefined" && e.value != ""){
			e.searchParam.code = e.value;
		}
		var muid = mini.getbyName("muid");
					
		return 0;
	}
    
    function head_itemchanged_muid(e,data){
		return 0;
	}


    function onDrawSummaryCell(e) {
		var rows = e.data;
		
		var totsummd = 0;
		var totsumser = 0;

		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.summd) == false) {
					totsummd += parseFloat(row.summd);
				}
				if (isNaN(row.sumser) == false) {
					totsumser += parseFloat(row.sumser);
				}
			}
		}
		
		if (e.field == "muid_name") {
			e.cellHtml = "<b>" + "合计：" + "</b>";
		}
		if (e.field == "summd") {
			e.cellHtml ="<b>￥"+ mini.formatNumber(Number(totsummd),"#,0.00")+"</b>";
		}
		if (e.field == "sumser") {
			e.cellHtml ="<b>￥"+ mini.formatNumber(Number(totsumser),"#,0.00")+"</b>";
		}
		e.cellStyle = "text-align:right";  
	}
    
  </script>

  <script src="report.js" type="text/javascript"></script>
  
</body>
</html>