<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>滞纳金报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1"
		style="margin-bottom: 10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<!-- =  =P~ 2018.06.07 改用新框架
	  <div class="mini-fit" style="border: 1px solid #000;">
	    <iframe id="mainframe" frameborder="0" name="mainframe" style="width:100%;height:100%;" border="0"></iframe>
	  </div>
	  -->
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>

	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/commonfunc.js"
		type="text/javascript"></script>

	<script type="text/javascript">
		//经营主体
		var manatype = {};
		var searchParam = {
			queryid : "select_company",
			order_field : "cocode"
		};
		itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query", searchParam,
				null, null, function(data) {
					manatype = data.report;
				}, null, null, false);
		//字典数据初始化
		var moduleid = '800307'
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "开始日期：",
				"type" : "DatePicker",
				"name" : "sdate",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"required" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"style" : "width:22.5%"
			}, {
				"label" : "结束日期：",
				"type" : "DatePicker",
				"name" : "edate",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"required" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"style" : "width:22.5%"
			}, {
				"label" : "门店：",
				"name" : "muid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "muid",//弹框类型
				textName : "muid_name", //文本显示字段
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged_muid",
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "商户：",
				"name" : "sbid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "sbid",//弹框类型
				textName : "sbid_name", //文本显示字段
				beforefunc : "head_beforefunc",
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "合同：",
				"name" : "contno",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "contno",//弹框类型
				textName : "contno", //文本显示字段
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged_contno",
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "商铺：",
				"name" : "spid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "spid",//弹框类型
				textName : "spid_name", //文本显示字段
				beforefunc : "head_beforefunc",
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "品牌：",
				"name" : "ppcode",
				"enabled" : true,
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey : "ppcode",
				textName : "ppcode_name",
				"style" : "width:22.5%"
			}, {
				"label" : "合同文本号：",
				"type" : "TextBox",
				"name" : "contsgbh",
				"enabled" : true,
				"style" : "width:22.5%",
			}, {
				"label" : "经营主体：",
				"type" : "ComboBox",
				"name" : "manatype",
				"enabled" : true,
				"data" : manatype,
				"valueField" : "cocode",
				"textField" : "coname",
				"defaultValue" : "0",
				"showNullItem" : true,
				"style" : "width:22.5%"
			} ]
		};

		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_800307",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, /*{
					field : "muid_name",
					header : "门店",
					headerAlign : "center",
					width : 180,
				}, {
					field : "contno",
					header : "合同",
					headerAlign : "center",
					width : 120,
				}, {
					field : "spid_name",
					header : "商位",
					headerAlign : "center",
					width : 120,
				}, {
					field : "sbid_name",
					header : "商户",
					headerAlign : "center",
					width : 200,
				}, {
					field : "ppcode_name",
					header : "品牌",
					headerAlign : "center",
					width : 120,
				}, {
					field : "cccode_name",
					header : "原费用",
					headerAlign : "center",
					width : 150,
				}, {
					field : "jsbillno",
					header : "结算单",
					headerAlign : "center",
					width : 150,
				}, {
					field : "firstdate",
					header : "滞纳金起征日",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align : "center",
					width : 100,
				}, {
					field : "lastdate",
					header : "实缴日期",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align : "center",
					width : 100,
				}, {
					field : "days",
					header : "逾期天数",
					headerAlign : "center",
					align : "right",
					width : 150,
				}, {
					field : "znjcccode_name", 
					header : "滞纳金费用",
					headerAlign : "center",
					width : 150,
				},{
					field : "setamount",
					header : "结算金额",
					headerAlign : "center",
					numberFormat : "c2",
					align : "right",
					width : 150,
				}, {
					field : "amount",
					header : "计算模式",
					headerAlign : "center",
					numberFormat : "c2",
					align : "right",
					width : 150,
				}, {
					field : "overrate",
					header : "滞纳金率",
					headerAlign : "center",
					numberFormat : "p2",
					align : "right",
					width : 150,
				},{
					field : "rdbccanje",
					header : "减免金额",
					headerAlign : "center",
					numberFormat : "c2",
					align : "right",
					width : 150,
				}, {
					field : "ysze",
					header : "应收总额",
					headerAlign : "center",
					numberFormat : "c2",
					align : "right",
					width : 150,
				}, {
					field : "ysamount",
					header : "实际应收",
					headerAlign : "center",
					numberFormat : "c2",
					align : "right",
					width : 150,
				}, {
					field : "recamount",
					header : "实收",
					headerAlign : "center",
					numberFormat : "c2",
					align : "right",
					width : 150,
				}, {
					field : "wsje",
					header : "未收金额",
					headerAlign : "center",
					numberFormat : "c2",
					align : "right",
					width : 150,
				},*/{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 180,
				},{
					field : "contno", 
					header : "合同",
					headerAlign : "center",
					width : 120,
				},{
					field : "spid_name", 
					header : "商铺",
					headerAlign : "center",
					width : 200,
				},{
					field : "sbid_name", 
					header : "商户",
					headerAlign : "center",
					width : 200,
				},{
					field : "ppcode_name", 
					header : "品牌",
					headerAlign : "center",
					width : 120,
				},{
					field : "cccode_name", 
					header : "原费用",
					headerAlign : "center",
					width : 150,
				},{
					field : "setamount", 
					header : "结算金额",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "znjcccode_name", 
					header : "滞纳金费用",
					headerAlign : "center",
					width : 150,
				},{
					field : "jsbillno", 
					header : "结算单",
					headerAlign : "center",
					width : 150,
				},{
					field : "firstdate", 
					header : "滞纳金起征日",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				},{
					field : "lastdate", 
					header : "实缴日期",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				},{
					field : "days", 
					header : "逾期天数",
					headerAlign : "center",
					align: "right",
					width : 150,
				},{
					field : "amount", 
					header : "计算模式",
					headerAlign : "center",
					align: "right",
					width : 150,
				},{
					field : "overrate", 
					header : "滞纳金率",
					headerAlign : "center",
					numberFormat : "p2",
					align: "right",
					width : 150,
				},/*{
					field : "paydate_name", 
					header : "滞纳金缴款日",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 150,
				},*/{
					field : "ysze", 
					header : "应收金额",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "rdbccanje", 
					header : "减免金额",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "ysamount", 
					header : "实际应收",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "recamount", 
					header : "实收金额",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "wsje", 
					header : "应收余额",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				}, ]
			},
		};

		function onDrawSummaryCell(e) {
			var rows = e.data;
			var setamount = 0;
			var ysamount = 0;
			var recamount = 0;
			if (rows.length > 0) {
				for (var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.setamount) == false) {
						setamount += parseFloat(row.setamount);
					}
					if (isNaN(row.ysamount) == false) {
						ysamount += parseFloat(row.ysamount);
					}
					if (isNaN(row.recamount) == false) {
						recamount += parseFloat(row.recamount);
					}
				}
			}

			if (e.field == "setamount") {
				e.cellHtml = "<b>" + "结算金额合计: ￥"
						+ mini.formatNumber(Number(setamount), "#,0.00")
						+ "</b>";
			}
			if (e.field == "ysamount") {
				e.cellHtml = "<b>" + "滞纳金合计: ￥"
						+ mini.formatNumber(Number(ysamount), "#,0.00")
						+ "</b>";
			}
			if (e.field == "recamount") {
				e.cellHtml = "<b>" + "实收合计: ￥"
						+ mini.formatNumber(Number(recamount), "#,0.00")
						+ "</b>";
			}

			e.cellStyle = "text-align:right";
		}

		mini.parse();
		function head_beforefunc(e) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != "") {
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			var sbid = mini.getbyName("sbid");
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "sbid in (select sbid from supmkt where muid ='"
						+ muid.getValue() + "')";
			}
			if (buttonEdit.name == "contno") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "muid ='" + muid.getValue() + "'";
				if (sbid.getValue() != undefined && sbid.getValue() != "") {
					e.searchParam.wherestr += "and sbid ='" + sbid.getValue()
							+ "'";
				}
			}
			if (buttonEdit.name == "spid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = " muid ='" + muid.getValue() + "'";
				if (sbid.getValue() != undefined && sbid.getValue() != "") {
					e.searchParam.wherestr += " and oid in (SELECT b.spid FROM contmain a,contmanaframe b WHERE a.contno = b.contno and contstatus = 'Y' and a.sbid = '"
							+ sbid.getValue() + "')";
				}
			}
			return 0;
		};
		function head_itemchanged_muid(e, data) {
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		};
		function head_itemchanged_contno(e, data) {
			mini.getbyName("sbid").setValue(data[0].sbid);
			mini.getbyName("sbid").setText(data[0].sbid_name);
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		};
	</script>
	<script src="report.js" type="text/javascript"></script>
</body>
</html>