<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>费用开票跟踪表(应收)</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1"
		style="margin-bottom: 10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/commonfunc.js" type="text/javascript"></script>
	<script type="text/javascript">
		//字典数据初始化

		var dictData = OcmControl.getDict("INVOICETYPE,FYKPTYPE,CONTTYPE,BILLSTATUS",
				"code,name,pro1,ddvalue")
				|| {};

		var iskp = [ {
			code : "Y",
			name : "开票"
		}, {
			code : "N",
			name : "不开票"
		} ];

		var moduleid = "800322";

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "门店：",
				"name" : "muid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				"required" : true,
				type : "fut_popselect",//类型
				selectkey : "muid",//弹框类型
				textName : "muid_name", //文本显示字段
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged_muid",
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "合同号：",
				"type" : "ButtonEdit",
				"name" : "contno",
				"enabled" : true,
				displayField : "contno",
				type : "fut_popselect",
				selectkey : "contno",
				textName : "contno",
				responseName : "contno",
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged_contno",
				"style" : "width:22.5%"
			}, {
				"label" : "商户：",
				"name" : "sbid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "sbid",//弹框类型
				textName : "sbid_name", //文本显示字段
				beforefunc : "head_beforefunc",
				//itemchangedfunc:"head_itemchanged_sbid",
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "合同类型：",
				"type" : "ComboBox",
				"name" : "conttype",
				"enabled" : true,
				"data" : dictData.CONTTYPE,
				"style" : "width:22.5%"
			}, {
				"label" : "结算开始日期：",
				"name" : "sdate",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"required" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"style" : "width:22.5%"
			}, {
				"label" : "结算结束日期：",
				"name" : "edate",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"required" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"style" : "width:22.5%"
			}, {
				"label" : "结算单号：",
				"type" : "TextBox",
				"name" : "billno",
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "是否开票：",
				"name" : "iskp",
				"type" : "ComboBox",
				"enabled" : true,
				"data" : iskp,
				"style" : "width:22.5%"
			}, {
				"label" : "发票类型：",
				"name" : "fptype",
				"type" : "ComboBox",
				"data" : dictData.INVOICETYPE,
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "开票科目：",
				"name" : "kptype",
				"type" : "ComboBox",
				"data" : dictData.FYKPTYPE,
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "开票单号：",
				"type" : "TextBox",
				"name" : "kpbillno",
				"enabled" : true,
				"style" : "width:22.5%"
			}]
		};

		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_800322",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 180,
				},{
					field : "contno", 
					header : "合同",
					headerAlign : "center",
					width : 120,
				},{
					field : "sbid_name", 
					header : "商户",
					headerAlign : "center",
					width : 200,
				},{
					field : "conttype_name", 
					header : "合同类型",
					headerAlign : "center",
					width : 150,
				},{
					field : "cccode_name", 
					header : "费用项目",
					headerAlign : "center",
					width : 150,
				},{
					field : "setbillno", 
					header : "结算单号",
					headerAlign : "center",
					width : 150,
				},{
					field : "setdate", 
					header : "结算日期",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				},{
					field : "cciskp", 
					header : "是否开票",
					headerAlign : "center",
					width : 150,
					type : "comboboxcolumn",
					renderer : "OcmControl.dictRendererWithCode",
					valueField : "code",
					textField : "name",
					data : iskp,
					allowSort : false,
				},{
					field : "kpbillno", 
					header : "开票单号",
					headerAlign : "center",
					width : 150,
				},{
					field : "fptype", 
					header : "发票类型",
					headerAlign : "center",
					width : 150,
					"type" : "ComboBox",
					"data" : dictData.INVOICETYPE,
					renderer : "OcmControl.dictRendererWithCode",
					"enabled" : true,
				},{
					field : "fpcode", 
					header : "发票编号",
					headerAlign : "center",
					width : 150,
				},{
					field : "auditdate", 
					header : "开票时间",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 150,
				},{
					field : "fpmin", 
					header : "发票开始序号",
					headerAlign : "center",
					width : 150,
				},{
					field : "fpmax", 
					header : "发票结束序号",
					headerAlign : "center",
					width : 150,
				},{
					field : "kptype", 
					header : "开票科目",
					headerAlign : "center",
					width : 150,
					"type" : "ComboBox",
					"data" : dictData.FYKPTYPE,
					renderer : "OcmControl.dictRendererWithCode",
					"enabled" : true,
				},{
					field : "hl", 
					header : "税率",
					headerAlign : "center",
					numberFormat : "p2",
					align: "right",
					width : 150,
				},{
					field : "bhsje", 
					header : "不含税金额",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "hsje", 
					header : "含税金额",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "se", 
					header : "税额",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},]
			},
		}; 
		
		mini.parse();

		function head_beforefunc(e) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != "") {
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			var sbid = mini.getbyName("sbid");
			var spid = mini.getbyName("spid");
			var contno = mini.getbyName("contno");
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "sbid in (select sbid from supmkt where muid ='"
						+ muid.getValue() + "')";
				if (contno.getValue() != "") {
					e.searchParam.wherestr += "and sbid = (select sbid from contmain where contno = '"
							+ contno.getValue() + "')";
				}
			}
			if (buttonEdit.name == "contno") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "muid ='" + muid.getValue() + "'";
				/* if (sbid.getValue() != "undefined" && sbid.getValue() != "") {
					e.searchParam.wherestr += "and sbid ='" + sbid.getValue()
							+ "'";
				} */
			}
			return 0;
		}

		function head_itemchanged_contno(e, data) {
			mini.getbyName("sbid").setValue(data[0].sbid);
			mini.getbyName("sbid").setText(data[0].sbid_name);
			return 0;
		}
		function head_itemchanged_muid(e, data) {
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("contno").setValue("");
			mini.getbyName("contno").setText("");
			return 0;
		}
		
		function onDrawSummaryCell(e) {
			var rows = e.data;
			var bhsje = 0;
			var hsje = 0;
			var se = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.bhsje) == false) {
						bhsje += parseFloat(row.bhsje);
					}
					if (isNaN(row.hsje) == false) {
						hsje += parseFloat(row.hsje);
					}
					if (isNaN(row.se) == false) {
						se += parseFloat(row.se);
					}
				}
			}
			
			if (e.field == "bhsje") {
				e.cellHtml ="<b>"+ "不含税金额合计: ￥" + mini.formatNumber(Number(bhsje),"#,0.00")+"</b>";
			}
			if (e.field == "hsje") {
				e.cellHtml ="<b>"+ "含税金额合计: ￥" + mini.formatNumber(Number(hsje),"#,0.00")+"</b>";
			}
			if (e.field == "se") {
				e.cellHtml ="<b>"+ "税额合计: ￥" + mini.formatNumber(Number(se),"#,0.00")+"</b>";
			}

			e.cellStyle = "text-align:right";  
		}
	</script>

	<script src="report.js" type="text/javascript"></script>

</body>
</html>