<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>租赁销售汇总表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='800508'
		var Type  = [{  code : "00",  name : "全部"}, {  code : "01",  name : "POS销售"}, {  code : "02",  name : "销售录入"} ];
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[{
					"label" : "发生日期：",
					"type" : "DatePicker",
					"name" : "sdate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
					"style" : "width:22.5%"
				}, {
					"label" : "结束日期：",
					"type" : "DatePicker",
					"name" : "edate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
					"style" : "width:22.5%"
				}, {
					"label" : "门店：",
					"name" : "muid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"muid",//弹框类型
					textName :"muid_name", //文本显示字段
					beforefunc:"head_beforefunc",
					itemchangedfunc:"head_itemchanged_muid",
					"enabled" : true,
					"style" : "width:22.5%"
				},{
					"label" : "商户：",
					"name" : "sbid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"sbid",//弹框类型
					textName :"sbid_name", //文本显示字段
					beforefunc:"head_beforefunc",
					itemchangedfunc : "head_itemchanged_sbid",
					"enabled" : true,
					"style" : "width:22.5%"
				}, {
					"label" : "合同号：",
					"name" : "contno",
					"enabled" : true,
					displayField : "contno",
					type : "fut_popselect",
					selectkey : "contno",
					textName : "contno",
					responseName : "contno",
					beforefunc : "head_beforefunc",
					"style" : "width:22.5%"
				},{
					"label" : "品牌：",
					"name" : "ppcode",
					"enabled" : true,
					"defaultValue" : "",
					type : "fut_popselect",
					selectkey:"ppcode",
					textName :"ppcode_name",
					"style" : "width:22.5%"
				}, {
					"label" : "来源：",
					"type" : "ComboBox",
					"name" : "type",
					"enabled" : true,
					"data" : Type,
					"style" : "width:22.5%"
				} ]}
			]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_800508",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 150,
				} ,{
					field : "sgldate",
					header : "销售日期",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				},{
					field : "contno", 
					header : "合同",
					headerAlign : "center",
					width : 100,
				},{
					field : "ppcode_name", 
					header : "品牌",
					headerAlign : "center",
					width : 100,
				},{
					field : "sbid_name", 
					header : "商户",
					headerAlign : "center",
					width : 180,
				},{
					field : "spid_name", 
					header : "商铺",
					headerAlign : "center",
					width : 230,
				}, {
					field: "hjmj",
					header: "面积" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 90,
				}, {
					field: "sglxssr",
					header: "销售额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
				} ]
			},
		}; 
		 var tabs = {
	    			properties : {
						"id" : "tabs",
					},
					items : [{
						"title" : "明细",
						"name" : "gridbox1",
	 					"control" : gridbox1,
					}]
	       }
		   formheader1.tabs=tabs;
	       formheader1.tabsToolbar = false;
		mini.parse();
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			var sbid = mini.getbyName("sbid");
			var contno = mini.getbyName("contno");
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "sbid in (select sbid from supmkt where muid ='" + muid.getValue() + "')";
			}
			if (buttonEdit.name == "contno") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "muid ='" + muid.getValue()  + "'";
				if (sbid.getValue() != undefined && sbid.getValue() != "") {
					e.searchParam.wherestr += "and sbid ='" + sbid.getValue() + "'";
				}
			}
			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("contno").setValue("");
			mini.getbyName("contno").setText("");
			return 0;
		}
		function head_itemchanged_sbid(e,data){
			mini.getbyName("contno").setValue("");
			mini.getbyName("contno").setText("");
			return 0;
		}
		function onDrawSummaryCell(e){
			var rows = e.data
			var sglxssr = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.sglxssr) == false) {
						sglxssr += parseFloat(row.sglxssr);
					}
				}
			}
			if (e.field == "muid_name") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "sglxssr") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sglxssr),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>