<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>服务商品销售明细查询</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='800604'
		var dicData ={};
	function getPaycode() {
        var temp = "";
		itemLoader.doRequest(OmdUrl.mall, "mss.base.pay.search", {
			order_field : "pmcode",
			pmflag:"Y",
			pmstatus:"Y",
			page_no : 1,
			page_size : 9999
		}, null, null, function(data) {
			temp = data.paymode;
			for ( var i = 0; i < temp.length; i++) {
				temp[i].code = temp[i].pmcode;
				temp[i].name = temp[i].pmcname;

			}	
		}, null, null, false);
		return temp;
	}

	dicData.pay_mode = getPaycode();

	dicData.invtype = [{code:"1",name:"销售"},{code:"4",name:"退货"}];
				
		
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [  
			  {
				"label" : "发生日期：",
				"type" : "DatePicker",
				"name" : "sdate",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			}, {
				"label" : "结束日期：",
				"type" : "DatePicker",
				"name" : "edate",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			}, {
				"label" : "门店：",
				"name" : "muid",
				"enabled" : true,
				"required" : true,
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"muid",
				textName :"muid_name",
			}, {
				"label" : "商品编码：",
				"name" : "sdgdid",
				"type" : "TextBox",
				"enabled" : true,
			} ]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_800604",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				} , {
					field : "muid",
					headerAlign : "center",
					header : "门店",
					width : 150,
				},{
		          	field: "payname",
		          	header: "付款方式",
		          	headerAlign : "center",
		          	width : 100,
				},{
		          	field: "billno",
		          	header: "订单号",
		          	headerAlign : "center",
		          	width : 100,
				} ,{
					field : "spdate",
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "销售日期",
					align:"center",
					width : 100,
				},{
					field : "sdgdid",
					headerAlign : "center",
					header : "商品编码",
					width : 100,
				} , {
					field : "shsyjid",
					headerAlign : "center",
					header : "收银机号",
					width : 80,
				} , {
					field : "shinvno",
					headerAlign : "center",
					header : "小票号",
					width : 80,
				},{
					field : "shdjlb", 
					header : "订单类别",
					headerAlign : "center",
					align : "center",
					renderer : "OcmControl.dictRendererWithCode",
					data :  dicData.invtype,
					width : 100,
				},{
					field : "sdsl", 
					header : "销售数量",
					headerAlign : "center",
					numberFormat : "#,0.00",
					width : 100,
					vtype : "float",
					align : "right",
				},{
					field : "sdsjje",
					header : "应付金额",
					numberFormat : "#,0.00",
					vtype : "float",
					align : "right",
					width : 100,
				},{
					field : "sdcjje",
					header : "实收金额",
					numberFormat : "#,0.00",
					vtype : "float",
					align : "right",
					width : 100,
				},{
					field : "sdtotzk",
					header : "折扣金额",
					headerAlign : "center",
					width : 150,
					numberFormat : "#,0.00",
					vtype : "float",
					align : "right",
					width : 100,
				} ]
			},
		}; 

		mini.parse();
		
		function onDrawSummaryCell(e) {
			var rows = e.data;
			var sdsl = 0;var sdsjje = 0.00;
			var sdcjje = 0.00;var sdtotzk = 0.00;
			
			if (rows.length > 0) {
				for (var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.sdsl) == false) {
						sdsl += parseFloat(row.sdsl);
					}
					if (isNaN(row.sdsjje) == false) {
						sdsjje += parseFloat(row.sdsjje);
					}
					if (isNaN(row.syxssr) == false) {
						syxssr += parseFloat(row.syxssr);
					}
					if (isNaN(row.sdcjje) == false) {
						sdcjje += parseFloat(row.sdcjje);
					}
					if (isNaN(row.sdtotzk) == false) {
						sdtotzk += parseFloat(row.sdtotzk);
					}
				}
			}

			if (e.field == "billno") {
				e.cellHtml = "<b>" + "合计: " + "</b>";
			}
			if (e.field == "sdsl") {
				e.cellHtml = "<b>" + sdsl.toFixed(2) + "</b>";
			}
			if (e.field == "sdsjje") {
				e.cellHtml = "<b>" + sdsjje.toFixed(2) + "</b>";
			}
			if (e.field == "syxssr") {
				e.cellHtml = "<b>" + syxssr.toFixed(2) + "</b>";
			}
			if (e.field == "sdcjje") {
				e.cellHtml = "<b>" + sdcjje.toFixed(2) + "</b>";
			}
			if (e.field == "sdtotzk") {
				e.cellHtml = "<b>" + sdtotzk.toFixed(2) + "</b>";
			}
			e.cellStyle = "text-align:right";
		} 
		
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>