<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>日销售报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='800628'
		var cnwmid = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[{
					"label" : "销售日期：",
					"type" : "DatePicker",
					"name" : "thisdate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
					"style" : "width:22.5%"
				}, {
					"label" : "门店：",
					"name" : "muid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"muid",//弹框类型
					textName :"muid_name", //文本显示字段
					beforefunc:"head_beforefunc",
					itemchangedfunc:"head_itemchanged_muid",
					"enabled" : true,
					"style" : "width:22.5%"
				},{
					"label" : "商户：",
					"name" : "sbid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"sbid",//弹框类型
					textName :"sbid_name", //文本显示字段
					beforefunc:"head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%"
				},{
					"label" : "商铺：",
					"name" : "spid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"spid",//弹框类型
					textName :"spid_name", //文本显示字段
					beforefunc:"head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%"	
					
				}, {
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "sglwmid",
					"enabled" : true,
					"data" : cnwmid,
					"style" : "width:22.5%"
				}, {
					"label" : "品牌：",
					"name" : "ppcode",
					"enabled" : true,
					"defaultValue" : "",
					type : "fut_popselect",
					selectkey:"ppcode",
					textName :"ppcode_name",
					"style" : "width:22.5%"
				}, {
					"label" : "品类：",
					"name" : "catcode",
					"enabled" : true,
					"defaultValue" : "",
					type : "fut_popselect",
					selectkey:"goodscat",
					textName :"catid_name",
					"style" : "width:22.5%"
				} ]
			} ]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_daysale",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 150,
				},{
					field : "spid_name", 
					header : "商铺",
					headerAlign : "center",
					width : 180,
				}, {
					field: "rentalarea",
					header: "面积" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
				},{
					field : "ppname", 
					header : "品牌",
					headerAlign : "center",
					width : 180,
				},{
					field : "mid_name", 
					header : "品类",
					headerAlign : "center",
					width : 180,
				}, {
					field: "totalsale",
					header: "总销售数量" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 120,
				}, {
					field: "totalsaleamont",
					header: "总销售金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 120,
				}, {
					field: "custsalenum",
					header: "会员销售数量" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 120,
				}, {
					field: "custsaleamt",
					header: "会员销售金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 120,
				}, {
					field: "custsalerate",
					header: "会员销售占比" ,
					headerAlign : "center",
					align : "right",
					allowSort : true,
					renderer:"OnTbvalue",
					width : 120,
				}, {
					field: "tplsalecate",
					header: "同品类销售排名" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					width : 120,
				}, {
					field: "totalsalerank",
					header: "总销售排名" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					width : 120,
				}, {
					field: "salesflat",
					header: "租售比" ,
					headerAlign : "center",
					align : "right",
					allowSort : true,
					renderer:"OnTbvalue",
					width : 90,
				}, {
					field: "salesflatrank",
					header: "租售比排名" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					width : 90,
				}, {
					field: "saleseffect",
					header: "销售坪效" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					allowSort : true,
					width : 90,
				}, {
					field: "pingrank",
					header: "坪效排名" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					width : 90,
				} ]
			},
		}; 
		 var tabs = {
	    			properties : {
						"id" : "tabs",
					},
					items : [{
						"title" : "明细",
						"name" : "gridbox1",
	 					"control" : gridbox1,
					}]
	       }
		   formheader1.tabs=tabs;
	       formheader1.tabsToolbar = false;
		mini.parse();
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			var sbid = mini.getbyName("sbid");
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "sbid in (select sbid from supmkt where muid ='" + muid.getValue() + "')";
			}
			if (buttonEdit.name == "spid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = " muid ='" + muid.getValue()+ "'";
				if (sbid.getValue() != undefined && sbid.getValue() != "") {
					e.searchParam.wherestr += " and oid in (SELECT b.spid FROM contmain a,contmanaframe b WHERE a.contno = b.contno and contstatus = 'Y' and a.sbid = '" + sbid.getValue() + "')";
				}
			}
			return 0;
		}
		function head_itemchanged_muid(e,data){
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
		function onDrawSummaryCell(e){
			var rows = e.data
			var totalsale = 0; var totalsaleamont = 0;
			var custsalenum = 0; var custsaleamt = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.totalsale) == false) {
						totalsale += parseFloat(row.totalsale);
					}
					if (isNaN(row.totalsaleamont) == false) {
						totalsaleamont += parseFloat(row.totalsaleamont);
					}
					if (isNaN(row.custsalenum) == false) {
						custsalenum += parseFloat(row.custsalenum);
					}
					if (isNaN(row.custsaleamt) == false) {
						custsaleamt += parseFloat(row.custsaleamt);
					}
				}
			}

			if (e.field == "spid_name") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "totalsale") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(totalsale),"#,0.00")+"</b>";
			}
			if (e.field == "totalsaleamont") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(totalsaleamont),"#,0.00")+"</b>";
			}
			if (e.field == "custsalenum") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(custsalenum),"#,0.00")+"</b>";
			}
			if (e.field == "custsaleamt") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(custsaleamt),"#,0.00")+"</b>";
			}
			
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>