<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>合同台账</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"
				style="margin-top: 5px;"></div>
	<div style="color: blue; margin-left: 100px; margin-bottom: 8px; width: 90%;">
		<!-- 报表字段说明:&nbsp;&nbsp; [备注] 合同主体基本信息备注;&nbsp;&nbsp;[首期租金]生成首期账单的租金;&nbsp;&nbsp; [保证金] 提取方式为押金的费用;&nbsp;&nbsp; [物业费] 费用编码为39;&nbsp;&nbsp; [收银机租金] 费用编码为37; -->
		<span id="text800629"></span>
	</div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='800629'
		var dictData = OcmControl.getDict("SETMODE,CONTTYPE,CONTSTATUS,WMID","code,name,pro1,ddvalue") || {};
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[{
					"label" : "查询日期：",
					"type" : "DatePicker",
					"name" : "thisdate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
					"style" : "width:22.5%"
				}, {
					"label" : "门店：",
					"name" : "muid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"muid",//弹框类型
					textName :"muid_name", //文本显示字段
					beforefunc:"head_beforefunc",
					itemchangedfunc:"head_itemchanged_muid",
					"enabled" : true,
					"style" : "width:22.5%"
				},{
					"label" : "商户：",
					"name" : "sbid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"sbid",//弹框类型
					textName :"sbid_name", //文本显示字段
					beforefunc:"head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%"
				},{
					"label" : "合同：",
					"name" : "contno",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"contno",//弹框类型
					textName :"contno", //文本显示字段
					beforefunc:"head_beforefunc",
					itemchangedfunc : "head_itemchanged_contno",
					"enabled" : true,
					"style" : "width:22.5%"	
				},{
					"label" : "商铺：",
					"name" : "spid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"spid",//弹框类型
					textName :"spid_name", //文本显示字段
					beforefunc:"head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%"	
				}, {
					"label" : "品牌：",
					"name" : "ppcode",
					"enabled" : true,
					"defaultValue" : "",
					type : "fut_popselect",
					selectkey:"ppcode",
					textName :"ppcode_name",
					"style" : "width:22.5%"
				}, {
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : dictData.WMID,
					"style" : "width:22.5%"
				}, {
					"label" : "合同状态：",
					"type" : "ComboBox",
					"name" : "contstatus",
					"enabled" : true,
					"data" : dictData.CONTSTATUS,
					"style" : "width:22.5%"
				},{
	    			"label" : "合同类型：",
	    			"type" : "ComboBox",
	    			"name" : "conttype",
	    			"enabled" : true,
	    			"data": dictData.CONTTYPE,
	    			"style" : "width:22.5%",
	    		} ]
			} ]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_800609",
			},
			"properties" : {
				"id" : "gridbox1",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 150,
				},{
					field : "contno", 
					header : "合同",
					headerAlign : "center",
					width : 100,
				},{
					field : "sbid_name", 
					header : "商户名称",
					headerAlign : "center",
					width : 300,
				},{
		        	field : "contsgbh",
		        	header : "合同文本号",
		        	headerAlign : "center",
		        	readOnly : true,
		        	width : 150,
		        } ,{
					field : "contstatus", 
					header : "合同状态",
					headerAlign : "center",
					renderer: "OcmControl.dictRendererWithCode",
					data: dictData.CONTSTATUS,
					width : 100,
				},{
					field : "conttype", 
					header : "合同类型",
					headerAlign : "center",
					renderer: "OcmControl.dictRendererWithCode",
					data: dictData.CONTTYPE,
					width : 100,
				}, {
					field: "zmj",
					header: "合同面积" ,
					headerAlign : "center",	
					width : 100,
				},{
					field : "spcode", 
					header : "商铺",
					headerAlign : "center",
					width : 180,
				}, {
					field: "mj",
					header: "面积" ,
					headerAlign : "center",	
					width : 100,
				},{
					field : "ppcode_name", 
					header : "品牌",
					headerAlign : "center",
					width : 180,
				},{
					field : "mid_name", 
					header : "品类",
					headerAlign : "center",
					width : 180,
				} ,{
					field : "cmeffdate",
					header : "合同生效时间",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				} ,{
					field : "cmlapdate",
					header : "合同失效时间",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				},{
					field : "setmode",       
					header : "结算方式",
					allowSort : false,
					headerAlign : "center",
					renderer: "OcmControl.dictRendererWithCode",
				    data: dictData.SETMODE,
					width : 100,
				},{
					field : "bzj", 
					header : "保证金(元)",
					headerAlign : "center",	
					width : 100,
				},{
					header : "租金(元/平米/月)",
					allowSort : false,
					headerAlign : "center",
					"columns" : [ {
						field : "zj", 
						header : "本期租金",
						headerAlign : "center",	
						width : 200,
					},{
						field : "sqzj", 
						header : "首期租金",
						headerAlign : "center",	
						width : 200,
					}]
				},{
					header : "物业费(元/月)",
					allowSort : false,
					headerAlign : "center",
					"columns" : [ {
						field : "feesdate",
						header : "费用开始",
						headerAlign : "center",
						dateFormat : "yyyy-MM-dd",
						dataType : "date",
						align:"center",
						width : 100,
					} ,{
						field : "feeedate",
						header : "费用结束",
						headerAlign : "center",
						dateFormat : "yyyy-MM-dd",
						dataType : "date",
						align:"center",
						width : 100,
					},{
						field : "wyf", 
						header : "本期物业费",
						headerAlign : "center",	
						width : 100,
					},{
						field : "sqwyf", 
						header : "首期物业费",
						headerAlign : "center",	
						width : 100,
					}]
				},{
					field : "syf", 
					header : "收银机租金(元)",
					headerAlign : "center",	
					width : 100,
				} ,{
					field : "deliverydate",
					header : "进场时间",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				} ,{
					field : "opendate",
					header : "开业时间",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				},{
					header : "招商信息",
					allowSort : false,
					headerAlign : "center",
					"columns" : [ {
						field : "sigcontname", 
						header : "签约名称",
						headerAlign : "center",
						width : 100,
					},{
						field : "signman", 
						header : "签约人",
						headerAlign : "center",
						width : 100,
					},{
						field : "signdate",
						header : "签约时间",
						headerAlign : "center",
						dateFormat : "yyyy-MM-dd",
						dataType : "date",
						align:"center",
						width: 100,
					},{
						field : "signfs", 
						header : "联系方式",
						headerAlign : "center",
						width : 100,
					}]
				},{
					field : "memo", 
					header : "备注",
					headerAlign : "center",
					width : 200,
				} ]
			},
		}; 
		mini.parse();
		
		function filltext(){
			var v_text;
			var v_fee;

			v_text = "报表字段说明:  [备注] 合同主体基本信息备注;  [首期租金] 生成首期账单的租金;  [保证金] 提取方式为押金的费用;  "
			
			itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query", {
				queryid 	 : "select_800629fee",
			}, null, null, function(data) {
				var source = data.report;
				for ( var i = 0; i < source.length; i++) {
					v_text = v_text + '  ['+source[i].cfdfeename+']'+' 费用编码为'+source[i].cfdvalue+';';
				}
			}, null, null, false);
			
			$("#text800629").text(v_text);
		}
		
		filltext()
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			var sbid = mini.getbyName("sbid");
			var contno = mini.getbyName("contno");
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "sbid in (select sbid from supmkt where muid ='" + muid.getValue() + "')";
			}
			if (buttonEdit.name == "contno") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "muid ='" + muid.getValue()  + "'";
				if (sbid.getValue() != undefined && sbid.getValue() != "") {
					e.searchParam.wherestr += "and sbid ='" + sbid.getValue() + "'";
				}
			}
			if (buttonEdit.name == "spid") {
				if (contno.getValue() == "") {
					mini.alert("请先选择合同");
					return -1;
				}
				e.searchParam.wherestr = " muid ='" + muid.getValue() + "' and spstatus = 'Y' and  oid in (SELECT spid FROM contmanaframe where contno = '"+ contno.getValue()+ "')";
			}
			return 0;
		}
		
		function head_itemchanged_contno(e,data){
			mini.getbyName("sbid").setValue(data[0].sbid);
			mini.getbyName("sbid").setText(data[0].sbid_name);
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
		function head_itemchanged_muid(e,data){
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("contno").setValue("");
			mini.getbyName("contno").setText("");
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>